/****************************************************************************/
/*                                                                          */
/*                    ****  COPYRIGHT NOTICE ****                           */
/*                                                                          */
/*                                                                          */
/*  Copyright (c) Digital Equipment Corporation, 1992                       */
/*                                                                          */
/*  All Rights Reserved.  Unpublished rights reserved under the             */
/*  copyright laws of the United States.                                    */
/*                                                                          */
/*  The software contained on this media is proprietary to and              */
/*  embodies the confidential technology of  Digital Equipment              */
/*  Corporation.  Possession, use, duplication or dissemination             */
/*  of the software and media is authorized only pursuant to a              */
/*  valid written license from Digital Equipment Corporation.               */
/*                                                                          */
/*                                                                          */
/*  The information in this software is subject to change  without  notice  */
/*  and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT  */
/*  CORPORATION.                                                            */
/*                                                                          */
/*  DIGITAL assumes no responsibility for the use or  reliability  of  its  */
/*  software on equipment which is not supplied by DIGITAL.                 */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/************************************************************************
 **
 **
 **   FACILITY:          
 **
 **   ENVIRONMENT:       OSF/1 V3.0
 **
 **   MODULE NAME:       ss7_is41_test_tools.h
 **
 **   DESCRIPTION:       Prototype of common procedures/functions
 **                      
 **   AUTHORS:           Denis Berger
 **
 **   CREATION DATE:    
 **
 **   MODIFICATION HISTORY:
 **       Name       (UserID)        Date        Comments
 **
 ************************************************************************/

/* defines */
#define IS41R_PC 1
#define IS41S_PC 2
#define IS41R_SSN 9
#define IS41S_SSN 8
#define MAX_VALUE 255

/* global flag for indications received */ 
extern ss7_boolean_t ope_dlg_rec,
                          acc_dlg_rec,
                          clo_dlg_rec,
                          sms_rec,
                          sms_rsp_rec,
                          lst_ope_rec;
extern unsigned long cur_dlg_id;

/* common functions */
extern char *get_message (unsigned int);

#define $check(status) \
if (status != SS7_NORMAL) \
{ \
    printf ("\nUnhandled error condition:\n%s\n", get_message (status)); \
    exit(-1);\
}
 
/* received indication from indication queue */
extern unsigned int ss7_is41_open_dlg_ind(
				   unsigned long,
				   ss7_is41_open_param_t *,
				   unsigned long *,
				   unsigned long
				   );

extern unsigned int ss7_is41_accept_dlg_ind(
				     unsigned long,
				     ss7_is41_open_param_t *,
				     unsigned long
				     );

extern unsigned int ss7_is41_close_dlg_ind(
				    unsigned long,
				    ss7_is41_close_param_t *,
				    unsigned long
				    );

extern unsigned int ss7_is41_sms_ind(
			      unsigned long,
			      ss7_invoke_id_t *,
			      ss7_is41_sms_param_t *,
			      unsigned long,
			      unsigned long
			      );

extern unsigned int ss7_is41_sms_rsp_ind(
				  unsigned long,
				  ss7_invoke_id_t *,
				  ss7_is41_sms_param_t *,       
				  unsigned long,
				  ss7_is41_opr_err_t *,
				  unsigned long
				  );

extern unsigned int ss7_is41_last_operation_ind(
						unsigned long      dialogue_id,
						unsigned long      user_param
						);
