$ if f$extract(2,2,f$getsyi("DECNET_VERSION")) .eqs. "04"
$ then
$	write sys$Output "You must install DECnet-Plus for OpenVMS to use this tool"
$	exit
$ endif
$ release = 'f$extract(4,2,f$getsyi("DECNET_VERSION"))
$ copy 'f$environment("PROCEDURE")' -
		SYS$COMMON:[SYSUPD]CREATE_NCL_KEYPAD_SCRIPTS.COM/replace
$ if p1 .eqs. "SCRIPTS" then goto make_scripts
$ copy sys$input: sys$output:

	This Command file creates Keypad definitions files for NCL
	to be used with the DECnet-Plus for OpenVMS products.  It creates
	files in SYS$MANAGER: and SYS$HELP:.  All files begin with 
	NCL$KEYDEF.  A copy of this file will be made in SYS$UPDATE:

	In a cluster environment, NCL scripts are created in SYS$SPECIFIC:
	directories for each node on this system disk.

	This file may be copied to any system running DECnet-Plus for OpenVMS.

Note:  Please Add "$ Define/SYSTEM NCL$KEYDEF SYS$MANAGER:NCL$KEYDEF.INIT"
to your VMS startup procedure.

$ inquire Continue "Continue? [Y/N Def: Y]"
$ if continue .eqs. "" then continue = "Y"
$ if .not. continue then exit
$ write sys$output "Creating NCL Key Definition Init File..."
$ create sys$common:[sysmgr]ncl$keydef.init
define/key pf1/set_state=gold ""
define/key pf2/term/noecho "Spawn Type SYS$HELP:NCL$KEYDEF_HELP.TXT"
define/key pf2/if_state=gold/term/noecho "Spawn Type SYS$HELP:NCL$KEYDEF_GOLD_HELP.TXT"
define/key pf2/if_state=red/term/noecho "Spawn Type SYS$HELP:NCL$KEYDEF_RED_HELP.TXT"
define/key pf3/set_state=red ""
define/key pf4/term/noecho "Spawn Type SYS$HELP:NCL$KEYDEF_INTRO.TXT"
define/key kp0/term "Show Name"
define/key Period/term "Show Address"
!	Transport
!
define/key kp4/term "Show OSI Transport Local NSAP * NSAP Address"
define/key kp4/If_state=red/term "Show OSI Transport Port * All"
define/key kp4/If_state=gold/term "Show OSI Transport Template * All"
define/key kp5/term "Do SYS$MANAGER:NCL$KEYDEF_OSI_Known_Nodes"
define/key kp5/if_state=red/term "Do SYS$MANAGER:NCL$KEYDEF_OSI_Retrans_Nodes"
define/key kp5/If_state=gold/term "Show OSI Transport Template Default All"
define/key kp6/term "Show NSP Local NSAP * NSAP Address"
define/key kp6/if_state=red/term "Show NSP Port * All"
define/key comma/term "Do SYS$MANAGER:NCL$KEYDEF_NSP_Known_Nodes"
define/key comma/if_state=red/term "Do SYS$MANAGER:NCL$KEYDEF_NSP_Retrans_Nodes"
!
!	Routing
!
define/key kp7/term "Do SYS$MANAGER:NCL$KEYDEF_Circuits"
define/key kp7/if_state=red/term "Do SYS$MANAGER:NCL$KEYDEF_Snap_Circuits"
define/key kp8/term "Do SYS$MANAGER:NCL$KEYDEF_Adjacencies"
define/key kp9/term "Show Mop Circuit * All Counters"
define/key kp9/if_state=red/term "Snap Mop Circuit * All Counters"
define/key Minus/term "Show Alias Port * Name, State, Selection Weight"
!
define/key pf1/if_state=gold/term "Show Implementation"
define/key pf3/if_state=gold/term/noecho "Spawn Write SYS$OUTPUT F$GETSYI(""DECNET_VERSION"")"
define/key pf4/if_state=gold/term/noecho "Spawn Write SYS$OUTPUT ""NCL$KEYDEF Environment X0.3-2"
define/key kp7/if_state=gold/term/noecho "DO SYS$MANAGER:NCL$KEYDEF_LOGGING"
define/key kp8/if_state=gold/term        "Disable NCL Logging"
!
!	Session Control Things
!-
define/key ENTER/term "Show Session Control Application * Address,Image Name,User Name"

$ if release .ge. 3 
$ then 
$	copy/concat sys$common:[sysmgr]ncl$keydef.init,sys$input sys$common:[sysmgr]ncl$keydef.init
define/key kp1/term "Show Session Control Port * Direction, Remote End User Address, Process Identifier"
define/key kp2/term "Show Session Control Port * Remote End User Address, Process Identifier, With Direction = Outgoing
define/key kp3/term "Show Session Control Port * Local End User Address, Remote End User Address, Process Identifier, Node Name Sent, With Direction = Incoming
$ else
$	copy/concat sys$common:[sysmgr]ncl$keydef.init,sys$input sys$common:[sysmgr]ncl$keydef.init
define/key kp1/term "Show Session Control Port * Direction, Remote End User Address"
define/key kp2/term "Show Session Control Port * Remote End User Address, With Direction = Outgoing"
define/key kp3/term "Show Session Control Port * Local End User Address, Remote End User Address, Node Name Sent, With Direction = Incoming
$ endif
$ purge sys$common:[sysmgr]ncl$keydef.init
$ set prot=(W:RE) sys$common:[sysmgr]ncl$keydef.init
$ create sys$common:[sysmgr]ncl$keydef_logging.NCL
set ncl logfile SYS$LOGIN:NCL.TXT
enable ncl logging
spawn write sys$output "NCL LogFile set to SYS$LOGIN:NCL.TXT"
$ purge sys$common:[sysmgr]ncl$keydef_logging.ncl
$ set prot=(W:RE) sys$common:[sysmgr]ncl$keydef_logging.ncl
$ write sys$output "Creating NCL Key Definition Help Text Files..."
$ create sys$common:[syshlp]NCL$KEYDEF_HELP.TXT
    +----------------+----------------+----------------+----------------+
    !  GOLD          !                !     RED        !                !
    !                !   *Help        !                ! *Introduction  !
    !                !                !                !                !
    +----------------+----------------+----------------+----------------+
    !  Show          ! Routing Circ * !  Show Mop      !  Show          !
    !   Routing      !  Adjacency *   !    All Counter !   Alias Port * !
    !  (Network)     !(Adj Routers)   !                !                !
    +----------------+----------------+----------------+----------------+
    !                ! OSI Transport  !                ! NSP            !
    ! OSI Tranport   !  Remote NSAP * !  NSP           !  Remote NSAP * !
    !  Local NSAP *  !(Known Nodes)   !   Local NSAP * ! (Known Nodes)  !
    +----------------+----------------+----------------+----------------+
    ! Show Session   ! Show Session   ! Show Session   !                !
    !  Control Port *!  Control Port *!  Control Port *!   Show         !
    !(Known Links)   !   Outgoing     !   Incoming     !    Session     !
    +----------------+----------------+----------------!    Control     !
    !                                 !                !    Application !
    !         Show Name               !Show Addresss   !    *           !
    !                                 !                ! (Known Objects)!
    +---------------------------------+----------------+----------------+
$ set prot=(W:RE) sys$common:[syshlp]NCL$KEYDEF_HELP.TXT
$ purge sys$common:[syshlp]NCL$KEYDEF_HELP.TXT
$ create sys$common:[syshlp]NCL$KEYDEF_GOLD_HELP.TXT
GOLD...
    +----------------+----------------+----------------+----------------+
    !                !                !                !                !
    ! Show           ! *GOLD HELP     ! *SHOW DECNET   ! *NCL$KEYDEF    !
    !   Implemenation!                !     VERSION    !    Version     !
    +----------------+----------------+----------------+----------------+
    ! Set NCL Logging!                !                !                !
    ! SYS$LOGIN:     ! Disable        !                !                !
    !   NCL.TXT      !  NCL Logging   !                !                !
    !Enable NCL Logg !                !                !                !
    +----------------+----------------+----------------+----------------+
    !                !                !                !                !
    ! OSI Template   ! OSI Template   !                !                !
    !    * All       !  Default All   !                !                !
    +----------------+----------------+----------------+----------------+
    !                !                !                !                !
    !                !                !                !                !
    !                !                !                !                !
    +----------------+----------------+----------------+                !
    !                                 !                !                !
    !                                 !                !                !
    !                                 !                !                !
    +---------------------------------+----------------+----------------+
$ set prot=(W:RE) sys$common:[syshlp]NCL$KEYDEF_GOLD_HELP.TXT
$ purge sys$common:[syshlp]NCL$KEYDEF_GOLD_HELP.TXT
$ create sys$common:[syshlp]NCL$KEYDEF_RED_HELP.TXT
RED...
    +----------------+----------------+----------------+----------------+
    !                !                !                !                !
    !                ! *RED HELP      !                !                !
    !                !                !                !                !
    +----------------+----------------+----------------+----------------+
    !  Snap          !                !  Snap          !                !
    !   Routing Circ !                !    Mop Circ *  !                !
    !                !                !     All Counter!                !
    +----------------+----------------+----------------+----------------+
    ! Show           ! OSI Remote     !  Show          ! NSP Remote     !
    !   OSI Port *   !   NSAP * With  !   NSP Port *   !  NSAP * With   !
    !                ! Retrans PDU>0  !                ! Retrans PDU > 0!
    +----------------+----------------+----------------+----------------+
    !                !                !                !                !
    !                !                !                !                !
    !                !                !                !                !
    +----------------+----------------+----------------+                !
    !                                 !                !                !
    !                                 !                !                !
    !                                 !                !                !
    +---------------------------------+----------------+----------------+
$ set prot=(W:RE) sys$common:[syshlp]NCL$KEYDEF_RED_HELP.TXT
$ purge sys$common:[syshlp]NCL$KEYDEF_RED_HELP.TXT
$ create sys$common:[syshlp]NCL$KEYDEF_INTRO.TXT

	This set of key definitions is designed to introduce you to
	NCL, Digital Equipment Corporation's Network Control Language.

	Hit PF2 to get a keypad diagram of the definitions.
	<PF1><PF2> gives you the GOLD keypad and <PF3><PF2> gives you
	the RED keypad definitions.   Note that GOLD keypad definitions
	are more advanced commands while the RED keypad definitions are 
	for trouble shooting purposes, (designed to find those instances
	where errors are occurring.)

	The text in the parentheses is designed to help those unfamiliar
	with terminology new to DECnet-Plus.

	Text preceded by an * indicates output is not from an NCL command.

	Note that this is to serve as an example for how you might
	want to tailor your own keypad definitions.

	Please feel free to send me suggestions at system@help.enet.dec.com.

$ set prot=(W:RE) sys$common:[syshlp]NCL$KEYDEF_HELP.TXT
$ purge sys$common:[syshlp]NCL$KEYDEF_INTRO.TXT
$ if p1 .eqs. "NOSCRIPTS" 
$ then 
$	write sys$output "No Scripts Created"
$ 	exit
$ endif
$ if f$getsyi("VAXCLUSTER") .ne. 0 
$ then
$	write sys$output -
"Installing in a cluster environment.  Scripts created for each member..."
$	mcr sysman
set environment/cluster
do @sys$update:create_ncl_keypad_scripts SCRIPTS
do Define/SYSTEM NCL$KEYDEF SYS$MANAGER:NCL$KEYDEF.INIT
$ else
$ 	@sys$update:create_ncl_keypad_scripts SCRIPTS
$	Define/SYSTEM NCL$KEYDEF SYS$MANAGER:NCL$KEYDEF.INIT
$ endif
$exit
$ 
$make_scripts:
$ if release .ge. 3 then define/user ncl$environment quiet
$ mcr ncl 
set ncl logfile sys$manager:create_ncl_keypad_scripts
enable ncl logging
show nsp local nsap * 
$ open/read keypad_tmp sys$manager:create_ncl_keypad_scripts.ncl
$ local_nsaps=""
$10$:
$ read/end=20$ keypad_tmp record
$ record = f$edit(record,"COLLAPSE")
$ if f$element(0,"=",record) .nes. "!Name" then goto 10$
$ local_nsaps=local_nsaps+" " + f$element(1,"=",record)
$ goto 10$
$20$:
$ close keypad_tmp
$ open/write skn sys$specific:[sysmgr]NCL$KEYDEF_nsp_known_nodes.ncl
$ open/write sknr sys$specific:[sysmgr]NCL$KEYDEF_nsp_retrans_nodes.ncl
$ i = 0
$30$:
$ i = i + 1
$ nsap = f$element(i," ",local_nsaps) 
$ if nsap .eqs. " " then goto 40$
$ write skn f$fao -
("Show NSP Local NSAP !AS Remote NSAP * NSAP Address,PDUs Sent,PDUs Received,Retransmitted PDUs",-
	nsap)
$ write sknr f$fao -
("Show NSP Local NSAP !AS Remote NSAP * NSAP Address,PDUs Sent,PDUs Received,Retransmitted PDUs, With Retransmitted PDUS>0",-
	nsap)
$ goto 30$
$40$:
$ close skn
$ close sknr
$ purge sys$specific:[sysmgr]NCL$KEYDEF_nsp_known_nodes.ncl
$ purge sys$specific:[sysmgr]NCL$KEYDEF_nsp_retrans_nodes.ncl
$ set prot=(W:RE) sys$specific:[sysmgr]NCL$KEYDEF_nsp_known_nodes.ncl
$ set prot=(W:RE) sys$specific:[sysmgr]NCL$KEYDEF_nsp_retrans_nodes.ncl
$ delete sys$manager:create_ncl_keypad_scripts.ncl;*
$ write sys$output "NSP Show Nodes Complete..."
$ if release .ge. 3 then define/user ncl$environment quiet
$ mcr ncl 
set ncl logfile sys$manager:create_ncl_keypad_scripts
enable ncl logging
show osi transport local nsap * 
$ open/read keypad_tmp sys$manager:create_ncl_keypad_scripts.ncl
$ local_nsaps=""
$110$:
$ read/end=120$ keypad_tmp record
$ record = f$edit(record,"COLLAPSE")
$ if f$element(0,"=",record) .nes. "!Name" then goto 110$
$ local_nsaps=local_nsaps+" " + f$element(1,"=",record)
$ goto 110$
$120$:
$ close keypad_tmp
$ open/write skn sys$specific:[sysmgr]NCL$KEYDEF_osi_known_nodes.ncl
$ open/write sknr sys$specific:[sysmgr]NCL$KEYDEF_osi_retrans_nodes.ncl
$ i = 0
$130$:
$ i = i + 1
$ nsap = f$element(i," ",local_nsaps) 
$ if nsap .eqs. " " then goto 140$
$ write skn f$fao -
("Show Osi Transport Local NSAP !AS Remote NSAP * NSAP Address,PDUs Sent,PDUs Received,Retransmitted PDUs",-
	nsap)
$ write sknr f$fao -
("Show Osi Transport Local NSAP !AS Remote NSAP * NSAP Address,PDUs Sent,PDUs Received,Retransmitted PDUs,With Retransmit PDUS>0",-
	nsap)
$ goto 130$
$140$:
$ close skn
$ close sknr
$ purge sys$specific:[sysmgr]NCL$KEYDEF_osi_known_nodes.ncl
$ purge sys$specific:[sysmgr]NCL$KEYDEF_osi_retrans_nodes.ncl
$ set prot=(W:RE) sys$specific:[sysmgr]NCL$KEYDEF_osi_known_nodes.ncl
$ set prot=(W:RE) sys$specific:[sysmgr]NCL$KEYDEF_osi_retrans_nodes.ncl
$ delete sys$manager:create_ncl_keypad_scripts.ncl;*
$ write sys$output "OSI Show Nodes Complete..."
$ if release .ge. 3 then define/user ncl$environment quiet
$ mcr ncl 
set ncl logfile sys$manager:create_ncl_keypad_scripts
enable ncl logging
show routing circuit * 
$ open/read keypad_tmp sys$manager:create_ncl_keypad_scripts.ncl
$ routing_circuits=""
$210$:
$ read/end=220$ keypad_tmp record
$ record = f$edit(record,"COLLAPSE")
$ if f$element(0,"=",record) .nes. "!Name" then goto 210$
$ routing_circuits=routing_circuits+"%" + f$element(1,"=",record)
$ goto 210$
$220$:
$ close keypad_tmp
$ open/write show_adj sys$specific:[sysmgr]NCL$KEYDEF_adjacencies.ncl
$ open/write show_rou sys$specific:[sysmgr]NCL$KEYDEF_Circuits.ncl
$ open/write snap_rou sys$specific:[sysmgr]NCL$KEYDEF_Snap_Circuits.ncl
$ write show_rou "Show Routing Area Addresses, PhaseIV Prefix,PhaseIV Address"
$ i = 0
$230$:
$ i = i + 1
$ circuit = f$element(i,"%",routing_circuits) 
$ if circuit .eqs. "%" then goto 240$
$ write show_rou f$fao("Show Routing Circuit !AS All Counters",circuit)
$ write snap_rou f$fao("Snap Routing Circuit !AS All Counters",circuit)
$ write show_adj f$fao -
("Show Routing Circuit !AS Adjacency * Neighbor Node Type, Router NETs",-
	circuit)
$ goto 230$
$240$:
$ close show_rou
$ close snap_rou
$ close show_adj
$ set prot=(W:RE) sys$specific:[sysmgr]NCL$KEYDEF_adjacencies.ncl
$ set prot=(W:RE) sys$specific:[sysmgr]NCL$KEYDEF_Circuits.ncl
$ set prot=(W:RE)  sys$specific:[sysmgr]NCL$KEYDEF_Snap_Circuits.ncl
$ purge sys$specific:[sysmgr]NCL$KEYDEF_adjacencies.ncl
$ purge sys$specific:[sysmgr]NCL$KEYDEF_Circuits.ncl
$ purge sys$specific:[sysmgr]NCL$KEYDEF_Snap_Circuits.ncl
$ delete sys$manager:create_ncl_keypad_scripts.ncl;*
$ write sys$output "Show Routing Adjacencies Complete..."
$ exit
