$ SAVED_VFY = F$VERIFY("YES")
$ !+
$ ! RMSJNL_EXAMPLE.COM
$ ! This command procedure shows how to run the RMSJNL_EXAMPLE program that 
$ ! uses the transaction services.  This command file is also good for 
$ ! verifying the installation of VAX RMS Journaling.
$ ! 
$ ! NOTE: All file names have dollar signs in them to prevent any
$ ! possible conflict with user file names.  Of course, any valid
$ ! file name can be used instead.
$ !-
$ !
$ ! First, delete any old files that may be lying around.
$ ! Ignore error messages here.
$ !
$ ! 'F$VERIFY("NO")
$ !
$ IF F$SEARCH("RMSJNL$*.*") .NES. ""
$ THEN
$     SET NOON
$     SET FILE RMSJNL$*.*;*/NOAI_JOURNAL/NOBI_JOURNAL/NORU_JOURNAL-
			   /RU_FACILITY=RMS/NORU_ACTIVE/PROT=OWNER=RWED
$     DELETE RMSJNL$*.*;*
$ ENDIF
$ SET VERIFY
$ !
$ ON ERROR THEN $EXIT $STATUS
$ !
$ ! Initialize RMSJNL$CHECKING.IDX and RMSJNL$SAVINGS.IDX.
$ !
$ CREATE/FDL=SYS$INPUT RMSJNL$CHECKING.IDX
FILE
	ORGANIZATION		indexed
RECORD
	FORMAT			fixed
	SIZE			18
KEY 0
	PROLOG			3
	SEG0_LENGTH		9
	SEG0_POSITION		0
$ !
$ COPY RMSJNL$CHECKING.IDX RMSJNL$SAVINGS.IDX
$ !
$ ! Mark the files for all types of journaling.
$ !
$ ! NOTE: A warning will be issued that our AI journal is on the same
$ ! device as our data file.  Normally one should put the AI journal on a
$ ! different device in case the disk is wiped out, but for the purposes
$ ! of installation verification this is acceptable.
$ !
$ SET FILE RMSJNL$CHECKING.IDX -
		/RU_JOURNAL -
		/AI_JOURNAL=(FILE=RMSJNL$AI.RMS$JOURNAL,CREATE) -
		/BI_JOURNAL=(FILE=RMSJNL$BI.RMS$JOURNAL,CREATE)
$ !
$ SET FILE RMSJNL$SAVINGS.IDX -
		/RU_JOURNAL -
		/AI_JOURNAL=FILE=RMSJNL$AI.RMS$JOURNAL -
		/BI_JOURNAL=FILE=RMSJNL$BI.RMS$JOURNAL
$ !
$ ! Backup the files.  Note that this is done after marking them for journaling.
$ !
$ BACKUP/RECORD RMSJNL$CHECKING.IDX;0 RMSJNL$CHECKING.BCK
$ !
$ BACKUP/RECORD RMSJNL$SAVINGS.IDX;0  RMSJNL$SAVINGS.BCK
$ !
$ ! Test RU journaling by running the example program.  This program performs
$ ! two transactions.  The first initializes the checking and savings acounts
$ ! to $100.00 each.  The second transaction transfers $10.00 from the
$ ! savings account to the savings account.  During the second transaction
$ ! the program pauses for 5 seconds before committing the transaction.  If this
$ ! program is allowed to run to completion then the checking balance should
$ ! be $90.00 and the savings balance should be $110.00.  However, if this
$ ! procedure is interrupted by a Control-Y during the pause, then the
$ ! original $100.00 balances should be restored in both the savings and
$ ! checking accounts.
$ !
$ ON CONTROL_Y THEN $CONTINUE
$ !
$ RUN SYS$EXAMPLES:RMSJNL_EXAMPLE
$ !
$ ON CONTROL_Y THEN $EXIT
$ !
$ ! Test AI journaling.
$ ! Roll the RMSJNL$CHECKING backup file forward and check that it matches
$ ! the current state of the RMSJNL$CHECKING data file.  (There should be 0
$ ! differences encountered.  You must have the DIFFERENCES program installed
$ ! to be able to do this step.)
$ !
$ RECOVER/FORWARD RMSJNL$CHECKING.BCK
$ DIFFERENCES RMSJNL$CHECKING.BCK RMSJNL$CHECKING.IDX
$ !
$ ! Test BI journaling.
$ ! Roll the RMSJNL$SAVINGS data file backward and check that it matches the
$ ! original state of the RMSJNL$SAVINGS data file.  (There should be 0
$ ! differences encountered.  You must have the DIFFERENCES program installed
$ ! to be able to do this step.)
$ !
$ RECOVER/BACKWARD RMSJNL$SAVINGS.IDX
$ DIFFERENCES RMSJNL$SAVINGS.BCK RMSJNL$SAVINGS.IDX
$ !
$ ! Example completed.  Cleaning up files.  Ignore error messages here.
$ !
$ ! 'F$VERIFY("NO")
$ !
$ SET NOON
$ SET FILE RMSJNL$*.*;*/NOAI_JOURNAL/NOBI_JOURNAL/NORU_JOURNAL-
		       /RU_FACILITY=RMS/NORU_ACTIVE/PROT=OWNER=RWED
$ DELETE RMSJNL$*.*;*
$ !
$ EXIT 		! 'F$VERIFY(SAVED_VFY)
