! SMDS - Example NCL script
! =========================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up a DECNIS with SMDS access via a modem connect line 
! on a W622 Network Interface Card.
!
! The appropiate port on the W622 card should be connected with a suitable
! V35 cable to an SMDS DSU that supports the DXI protocol.
!
! The script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 
!
create smds
!
! Create the appropiate modem connect line, associated SMDS station, and the
! routing circuit that will use the SMDS connection.  
!
create modem connect line w622-9-0 communication port w622-9-0
create smds station w622-9-0
create routing circuit w622-9-0 type smds
!===============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 

! Set the attributes of the SMDS station.
! The lower layer entity is the name of the Modem Connect line that is to be
! used by this station.

set smds station w622-9-0 lower layer entity modem connect line w622-9-0

! Set the SMDS individual address for the CPE. This is the address
! assigned at subscription time and consists of a 10 digit number
! following the prefix "C1".

set smds station w622-9-0 local address C1-12-34-56-78-90

! Set the group address. This is address which this CPE will
! communicate with and consists of a 10 digit number follwing the prefix "E1".
! For point-to-point circuits this address can be an individual address (that 
! is, an address which starts with C1-)

set smds station w622-9-0 group address E1-12-34-56-78-90

! The heartbeat timer is the number of seconds between Heartbeat
! polls (Default =0). The heartbeat threshold is the number of heartbeat 
! polls 'missed' before the link is considered to be broken.

set smds station w622-9-0 -
   heartbeat timer 15, -
   heartbeat threshold 3

! The crc type controls the CRC type requested on the DXI HDLC frames on the
! connection to the DSU.

set smds station w622-9-0 crc type 32-bit

! Set some appropiate attributes on the routing circuit that is going to use
! the SMDS link.

! First associate it with the SMDS station

set routing circuit w622-9-0, -
    data link entity smds station w622-9-0

! Set up the appropiate protocols, address and mask

set routing circuit w622-9-0 -
    network protocols {ip,iso8473}, -
    subnet address {add=192.9.200.30, mask=255.255.255.0}

!  Inform routing of the maximum SMDS data unit size

set routing circuit w622-9-0 manual data link sdu size 4492

! SMDS stations do not currently support DECnet Phase IV, therefore
! set the Phase IV address to false.

set routing circuit w622-9-0 -
	enable phaseiv address false
!===============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

enable modem connect line w622-9-0
enable smds station w622-9-0
enable routing circuit w622-9-0
!===============================================================================
