! IP Packet Filtering - Example NCL Script
! ========================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE  WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up 9 packet filters on the DECNIS below, to allow the
! following types of access:
!	o Allow access to the FTP server (16.36.10.1) from the
!	  Internet. (Assumes default data port (20) is used.)
!	o Allow access to the World-Wide Web server (16.32.16.1) from
!	  the Internet and all internal departments.
!	o Allow access between the Internet Gateway (16.37.16.1)
!	  and the Internet.
!	o Allow Telnet access from the Programming department to the 
!	  engineering department.
!	o Allow SNMP responses from the DECNIS to the Engineering
!	  department. (Allows SNMP management of the DECNIS).
!
!
!				    Internet
!					|
!					| W622-6-1
!					|
!		     L601-3-0	  16.36.10.11     L602-4-1
!                               ---------------- 
!	FTP server ------------	|    DECNIS    | ------------- World-wide Web
!	(16.36.10.1)		----------------		 server
!	Programming 			|			(16.32.16.1)
!	department			| L602-5-0
!					|
!				   Internet Gateway
!				    (16.37.16.1)
!				   Engineering department
!
! This script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. 
! For more information about the user NCL script files, refer to 
! the DECNIS Management manual.  
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 

! Create the PRIORITY entity    

create priority

! Create an INTERFACE entity for every outgoing interface you want to
! filter packets on, and every inbound interface you want to specify
! as an Inbound Interface characteristic in a filter.

create priority interface l601-3-0 communication port l601-3-0
create priority interface w622-6-1 communication port w622-6-1
create priority interface l602-4-1 communication port l602-4-1
create priority interface l602-5-0 communication port l602-5-0


! Create the PRIORITY INTERFACE FILTER entities required on each interface.

create priority interface l601-3-0 filter pass_ftp_Inet type pass tcp
create priority interface w622-6-1 filter pass_ftp_Serv type pass tcp
create priority interface l602-4-1 filter pass_www_Inet type pass tcp

! Create a global PRIORITY FILTER entity for World-Wide Web traffic

create priority filter pass_www_glbl type pass tcp

! Create the remaining INTERFACE FILTER entities

create priority interface l602-5-0 filter pass_from_Inet type pass tcp
create priority interface w622-6-1 filter pass_from_Gway type pass tcp
create priority interface l602-5-0 filter pass_Tnet_dest type pass tcp
create priority interface l601-3-0 filter pass_Tnet_src type pass tcp
create priority interface l602-5-0 filter pass_snmp type pass udp


!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 

! Set the characteristics of each filter

! Pass packets from Internet to FTP server. Assumes that default data
! port (20) is used. Port Value 20 with mask 65534 will pass port numbers 
! 20 and 21.
!
set priority interface l601-3-0 filter pass_ftp_Inet -
inbound interface priority interface w622-6-1, -
destination address value 16.36.10.1, destination address -
mask 255.255.255.255, destination port value 20, destination -
port mask 65534

! Pass packets from FTP server to Internet. Assumes that default data
! port (20) is used. Port Value 20 with mask 65534 will pass port numbers 
! 20 and 21.
!
set priority interface w622-6-1 filter pass_ftp_Serv -
inbound interface priority interface l601-3-0, -
source address value 16.36.10.1, source address -
mask 255.255.255.255, source port value 20, source -
port mask 65534

!
! Pass World-Wide Web packets from all internal departments to the 
! World-Wide Web server
!
set priority interface l602-4-1 filter pass_www_Inet -
destination address value 16.32.16.1, destination address -
mask 255.255.255.255, destination port value 80, destination -
port mask 65535

! Set the characteristics of the global World-wide web interface
! Pass packets from the World-Wide Web server to all departments.
!
set priority filter pass_www_glbl inbound interface priority -
interface l602-4-1, source address value 16.32.16.1, source address -
mask 255.255.255.255, source port value 80, source port mask 65535

! Pass packets from the Internet to the Internet Gateway
!
set priority interface l602-5-0 filter pass_from_Inet -
inbound interface priority interface w622-6-1, -
destination address value 16.37.16.1, destination address -
mask 255.255.255.255

! Pass packets from the Internet Gateway to the Internet
! 
set priority interface w622-6-1 filter pass_from_Gway -
inbound interface priority interface l602-5-0, -
source address value 16.37.16.1, source address -
mask 255.255.255.255

! Pass Telnet packets from the Programming department to the
! Engineering department
!
set priority interface l602-5-0 filter pass_Tnet_dest -
inbound interface priority interface l601-3-0, -
destination address value 16.37.16.1, destination address -
mask 255.255.255.255, destination port value 23, destination port mask 65535

! Pass Telnet response packets from the Engineering department to the
! Programming department.
! 
set priority interface l601-3-0 filter pass_Tnet_src -
inbound interface priority interface l602-5-0, -
source address value 16.37.16.1, source address -
mask 255.255.255.255, source port value 23, source port mask 65535

! Pass SNMP packets from the DECNIS to the Engineering department
!
set priority interface l602-5-0 filter pass_snmp -
destination address value 16.37.0.0, destination address -
mask 255.255.0.0, source port value 161, source port mask 65535, -
source address value 16.36.10.11, source address mask 255.255.255.255

!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

! Enable all the entities

enable priority interface l601-3-0
enable priority interface w622-6-1
enable priority interface l602-4-1
enable priority interface l602-5-0

enable priority interface l601-3-0 filter pass_ftp_Inet
enable priority interface w622-6-1 filter pass_ftp_Serv
enable priority interface l602-4-1 filter pass_www_Inet

enable priority filter pass_www_glbl

enable priority interface l602-5-0 filter pass_from_Inet
enable priority interface w622-6-1 filter pass_from_Gway
enable priority interface l602-5-0 filter pass_Tnet_dest
enable priority interface l601-3-0 filter pass_Tnet_src
enable priority interface l602-5-0 filter pass_snmp


enable priority

