! OSPF Virtual Link Connections - Example NCL Script
! ==================================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script configures a Virtual Link.  A Virtual Link
! is used to connect two disjointed sections of the backbone area to make
! the backbone fully connected.  
! 
!   OSPF-Area-0  
!    --------        --------                         --------
!  | DECNIS A | ---| DECNIS B |---- OSPF-Area-2 ----| DECNIS G |---OSPF-Area-5
!    --------        --------                         -------- 
!     backbone            \_ _ _ _ Virtual link _ _ _ _ _/
                                                                    
!
! DECNIS 'G' (16.36.16.180) is an Area Border Router (ABR) of OSPF-Area-5.
! It is not directly connected to the rest of the backbone area. Instead,
! it uses a Virtual Link to make the connection, which uses OSPF-Area-2
! as the Transit Area.  The other end of the Virtual Link is 
! DECNIS 'B' (16.36.16.207), the ABR between OSPF-Area-2 and the main part of 
! OSPF-Area-0.
!
! The virtual link must be configured on both ABRs - DECNIS 'B' and
! DECNIS 'G'. The commands are the same, except that the Virtual Neighbor
! Router ID depends on which ABR you are configuring.
!
! The script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 

! Create the virtual circuit and call it "virtual-1"

CREATE ROUTING CONTROL PROTOCOL OSPF-Area-0 -
 LOGICAL CIRCUIT virtual-1 TYPE VIRTUAL
!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 

! Set the Virtual Neighbor's Router ID (The router ID of the DECNIS at the
! other end of the link) and set the Transit Area (OSPF-Area-2).

SET ROUTING CONTROL PROTOCOL OSPF-Area-0 LOGICAL CIRCUIT virtual-1 -
 OSPF VIRTUAL NEIGHBOR ROUTER ID 16.36.16.180, -
 OSPF TRANSIT AREA OSPF-Area-2
!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

! Enable the Logical Circuit 

ENABLE ROUTING CONTROL PROTOCOL OSPF-Area-0 LOGICAL CIRCUIT virtual-1
!==============================================================================

