! LAT Pattern Match Prioritization (VMS) - Example NCL Script 
! ===========================================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up pattern match prioritization on the DECNIS in order to:
! 	o Discard all LAT service advertisements except Group 4
!         advertisements
! 	o Assign a high priority to all other LAT packets
! The table below summarizes the prioritization set up.
!
!              Packet Type		 |    Group    |  Priority
! ---------------------------------------|-------------|-------------
!   LAT Service Group 4 Advertisements	 |  Broadcast  |     7
!   Any other LAT Service Advertisements |   Discard   |     8
!   All other LAT packets		 | Interactive |     1

!    PACKET - lat 
!  (bridge type %x6004) 
!	     \                
!       match \              
!            - - - - - - - - - - - - - - - - - - - - - - 	 	
!	    | PATTERN - lat service advertisement       |		
!	    | string = %x09002b00000f000000000000600428 |
!	    | mask   = %xffffffffffff000000000000fffffc |		
!	     - - - - - - - - - - - - - - - - - - - - - -		
!            match /   		       mismatch |		
!		  /             		|			
!       - - - - - - - - - - -   		|	
!      | PATTERN - group 4   |  		|
!      | string = %x10       |  		|	
!      | mask   = %x10       |  		|	
!       - - - - - - - - - - -   		|	
!     match /     mismatch |    		|	
!          /               |    		|	
!  - - - - - -         - - - - - - -          - - - - - - -
! |  GROUP    |        |    GROUP    |       |   GROUP     |
! | broadcast |        |   discard   |       | interactive |
!  - - - - - -         - - - - - - -          - - - - - - -
!
! The script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 

! Create the PRIORITY module 

create priority

! Create PACKET entities for LAT protocol type packets

create priority packet LAT_TYPE type bridge type , -
	bridge ethernet protocol type = %x6004 

! Create a PATTERN entity for LAT Service Advertisement multicast Address 
! (09-00-2B-00-00-0F) with LAT function code Service Advertisement 
! (%x28 = Service Advertisement)          

create priority pattern LAT_SERVICE_ADVERTISEMENT from=start, offset = 0, -
	  string = %x09002b00000f000000000000600428 , -
	    mask = %xffffffffffff000000000000FFFFFC

! Create a PATTERN entity for LAT service Group 4

create priority pattern LAT_SERVICE_GROUP_4 from=next ISO layer, offset = 13, -
	  string = %x10 , -
	    mask = %x10 

! Create GROUP entities

create priority group interactive 
create priority group broadcast   
create priority group discard     

! Create an INTERFACE entity for the port you want to apply prioritization to

create priority interface w622-5-0 communication port w622-5-0
!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 

! Set the match action of the each PACKET entity to point to a PATTERN or GROUP.

set priority packet LAT_TYPE -
	match action = priority pattern LAT_SERVICE_ADVERTISEMENT
 
! Set the match action and mismatch action for each pattern. Note,
! these must be specified in separate commands.

set priority pattern LAT_SERVICE_ADVERTISEMENT -
           match action = priority pattern LAT_SERVICE_GROUP_4
set priority pattern LAT_SERVICE_ADVERTISEMENT -
        mismatch action = priority group interactive

set priority pattern LAT_SERVICE_GROUP_4 -
           match action = priority group broadcast
set priority pattern LAT_SERVICE_GROUP_4 -
        mismatch action = priority group discard

! Set the assigned class for each GROUP

set priority group interactive assigned class 1
set priority group broadcast assigned class 7 
set priority group discard assigned class 8

! Set queue 8 to zero, so that packets on this queue are discarded. 

set priority interface w622-5-0 queue 8 maximum queue length = 0

! Set the default class priority for any other packets that the DECNIS
! receives.

set priority bridge sap default class 6
set priority bridge pid default class 6
set priority bridge type default class 6
set priority ip tcp default class 6
set priority ip udp default class 6
set priority ip protocol default class 6
set priority decnet phaseiv default class 6
set priority osi default class 6
set priority ipx default class 6

!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

! Enable Priority Interface and Priority Module

enable priority interface w622-5-0
enable priority
!==============================================================================

