! IP Standby - Example NCL Script
! ===============================	
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up DECNIS C as an IP Standby router for DECNIS B
! and monitors the W622-5-1 WAN circuit. You also need to configure
! DECNIS B as an IP standby router for DECNIS C.
!						       |	
!						     |\| W622-5-1
!			  			     |
!	 --------  MAC SEL   IP ADDR		  --------  MAC SEL  IP ADDR
!	|DECNIS B|    1     16.36.16.24		 |DECNIS C|    2    16.36.16.25
!	 --------           16.36.20.24	          --------          16.36.20.25
!           |				    	     |
! L601-3-0  |		      	  	   L602-4-0  |
! 	-------------------------------------------------------	LAN        
!	     |		    	           |
!	    --------	  		 --------
!	   | IP Host |	 		| IP Host |
!	    --------	  		 --------
!
! NOTE: In the diagram above there are two IP standby routers,
! DECNIS B and DECNIS C. This script only sets up DECNIS C. You must
! have at least two DECNIS systems set up as IP standby routers. 
!
! This script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. IMPORTANT: Do not enter these commands dynamically on an
! operational router. 
! 
! For more information about the user NCL script files, refer to 
! the DECNIS Management manual.  
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 

! Create the IP standby entity on the LAN routing circuit.

create routing circuit l602-4-0 ip standby mode mac

!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 
!
! A set of sixteeen MAC addresses is reserved for use with the IP
! Standby protocol as virtual MAC addresses. These addresses are the
! same apart from the 10th hexadecimal digit which is the MAC selector. The MAC
! address format is always AA-00-04-00-0X-00, where X is the MAC
! selector.
!
! Set the MAC selector/IP address pair of each IP standby router on the
! LAN. This list must be exactly the same for each IP standby router
! on the LAN. 

set routing circuit l602-4-0 ip standby routers -
        { [ mac sel=1, addr={16.36.16.24, 16.36.20.24}], -
          [ mac sel=2, addr={16.36.16.25, 16.36.20.25}]}, -
	   monitored circuits {w622-5-0}

! Set the routing timers to the recommended values for good IP standby
! performance. 

set routing circuit l602-4-0 isis hello timer 1
set routing circuit l602-4-0 hello timer 1
set routing holding multiplier 2
set routing ISIS holding multiplier 2

! Set the Minimum LSP generation to the recommended value for good IP
! standby performance.

set routing minimum LSP generation interval 1

!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

! Enable IP standby

enable routing circuit l602-4-0 ip standby
!==============================================================================
