! IP Multicast - Example NCL Script
! =================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE  WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up a DECNIS with 3 circuits as an IP multicast
! router.
!
! This script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. 
! For more information about the user NCL script files, refer to 
! the DECNIS Management manual.  
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 
!
! Create the IGMP entity on all the interfaces of the DECNIS.
! 
create routing circuit l601-3-0 igmp
create routing circuit w622-4-0 igmp
create routing circuit f621-6-0 igmp

!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 
!
! For FDDI circuits only, specify which host groups (Class D IP
! destination addresses the DECNIS should listen to.
!
set routing circuit f621-6-0 igmp groups {224.99.0.6}

!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 
!
! Enable the IGMP entity on all circuits.
!
enable routing circuit l601-3-0 igmp
enable routing circuit w622-4-0 igmp
enable routing circuit f621-6-0 igmp

