! IPX WAN - Example NCL script 
! ============================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE  WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up IPX WAN functionality.
!
! The modem connect line can be set up using the DECNIS configurator.
!
! The script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 

! Create a PPP link entity

create ppp link w618-4-3 type synchronous

! Create a PPP routing circuit

create routing circuit W618-4-3 type ppp

! Create the IPX network protocol entities. 

create routing network protocol netware ipx
create routing circuit W618-4-3 network protocol netware ipx
!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 

!  

set ppp link w618-4-3 lower layer entity modem connect line W618-4-3
add ppp link w618-4-3 required control protocol {Novell IPX}

! Some protocols get set up by default and you may want to remove them
! from the PPP link.

remove ppp link w618-4-3 required control protocol {Internet Protocol}
remove ppp link w618-4-3 required control protocol {OSI Network Layer}
remove ppp link w618-4-3 required control protocol {DECnet Phase IV  }
remove ppp link w618-4-3 required control protocol {Bridging PDU     }

! Add IPX to the list of routing network protocols

set routing circuit W618-4-3 data link entity ppp link W618-4-3
add  routing circuit w618-4-3 network protocols {netware IPX}

! Set the NetWare Network Number. Remember to make the Network Number the same 
! at both ends of the link, and unique across the entire network.

set routing circuit W618-4-3 network protocol netware ipx NetWare Network -
	Number %x00000043
!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

enable ppp link w618-4-3 
enable routing circuit w618-4-3
enable routing network protocol netware ipx
!==============================================================================



