$  !  Copyright (c) 1987 Digital Equipment Corporation.  All rights reserved.
$  !  
$  !  MONSUM.COM  (Generate cluster multi-file summaries)
$  !  
$  !  This command file is to be placed in a cluster-accessible directory
$  !  called SYS$MONITOR and executed at the convenience of the cluster 
$  !  manager.  The file generates both 24-hour and "prime time" cluster
$  !  multi-file summaries and resubmits itself to run each day at midnight.
$  !  
$ SET DEF SYS$MONITOR
$ SET NOON
$  !  
$  !  Compute file specification for MONSUM.COM and resubmit the file.
$  !  
$ FILE = F$ENVIRONMENT("PROCEDURE")
$ FILE = F$PARSE(FILE,,,"DEVICE")+F$PARSE(FILE,,,"DIRECTORY")+F$PARSE(FILE,,,"NAME")
$ SUBMIT 'FILE' /AFTER=TOMORROW /NOPRINT
$  !  
$  !  Generate 24-hour cluster summary.
$  !  
$  !  
$ MONITOR/INPUT=(SYS$MONITOR:*MON*.DAT;*,MON$ARCHIVE:*MON*.DAT;*) -
   /NODISPLAY/SUMMARY=MONSUM.SUM -
   ALL_CLASSES,DISK/ITEM=ALL,SCS/ITEM=ALL -
   /BEGIN="YESTERDAY+0:0:0.00" /END="TODAY+0:0:0.00" /BY_NODE
$  !  
$  !  
$  !  Mail 24-hour summary file to cluster manager and delete the file from
$  !  SYS$MONITOR.
$  !
$  !  
$  !
$ MAIL/SUBJECT="Daily Monitor Cluster-wide Summary" MONSUM.SUM cluster_manager
$ DELETE MONSUM.SUM;*
$  !  
$  !  Generate prime-time cluster summary.
$  !  
$  !  
$ MONITOR/INPUT=(SYS$MONITOR:*MON*.DAT;*,MON$ARCHIVE:*MON*.DAT;*) -
   /NODISPLAY/SUMMARY=MONSUM.SUM -
   ALL_CLASSES,DISK/ITEM=ALL,SCS/ITEM=ALL -
   /BEGIN="YESTERDAY+9:0:0.00" /END="YESTERDAY+18:0:0.00" /BY_NODE
$  !  
$  !  
$  !  Mail prime-time summary file to cluster manager and delete the file
$  !  from SYS$MONITOR.
$  !
$  !
$ MAIL/SUBJECT="Prime-Time Monitor Cluster-wide Summary" MONSUM.SUM cluster_manager
$ DELETE MONSUM.SUM;*
$  !
$  !  End of MONSUM.COM
$  !
