$  !  Copyright (c) 1987 Digital Equipment Corporation.  All rights reserved.
$  !
$  !  MONITOR.COM  (Generate MONITOR recording file)
$  !
$  !  This command file is to be placed in a cluster-accessible
$  !  directory called SYS$MONITOR. At system startup time, for each
$  !  node, it creates in SYS$MONITOR a MONITOR recording file, which
$  !  is updated throughout the life of the boot. It also creates in
$  !  MON$ARCHIVE, a summary file from the recording file of the
$  !  previous boot, along with a copy of that recording file.
$  !  Logical name definitions for both cluster-accessible directories,
$  !  SYS$MONITOR and MON$ARCHIVE, must be included in SYSTARTUP.COM.
$  !  
$ SET DEF SYS$MONITOR
$ SET NOON
$ PURGE MONITOR.LOG/KEEP:2
$  !
$  !
$  !  Compute executing node name and recording and summary
$  !  file names (incorporating node name and date).
$  !
$ NODE = F$GETSYI("NODENAME")
$ DAY = F$EXTRACT(0,2,F$TIME())
$ IF F$EXTRACT(0,1,DAY) .EQS. " " THEN DAY = F$EXTRACT(1,1,DAY)
$ MONTH = F$EXTRACT(3,3,F$TIME())
$ ARCHFILNAM = "MON$ARCHIVE:"+NODE+"_MON"+DAY+MONTH
$ RECFIL = NODE+"_MON.DAT"
$ SUMFIL = ARCHFILNAM+".SUM"
$  !
$  !
$  !
$  !
$  !  Check for existence of recording file from previous boot
$  !  and skip summary if not present.
$  !
$ OPEN/READ/ERROR=NORECFIL RECORDING 'RECFIL'
$ CLOSE RECORDING
$  !
$  !
$  !  Generate summary file from previous boot
$  !
$ MONITOR /INPUT='RECFIL' /NODISPLAY /SUMMARY='SUMFIL' -
   ALL_CLASSES,DISK/ITEM=ALL,SCS/ITEM=ALL
$  !
$  !
$  !  Compute subject string and mail summary file to cluster manager
$  !
$ A="""
$ B=" MONITOR Summary "
$ SUB = A+NODE+B+F$TIME()+A
$ MAIL/SUBJECT='SUB' 'SUMFIL' cluster_manager
$  !
$  !
$  !  Archive recording file and delete it from SYS$MONITOR.
$  !
$ COPY 'RECFIL' 'ARCHFILNAM'.DAT
$ DELETE 'RECFIL';*
$  !
$ NORECFIL:
$ SET PROCESS/PRIORITY=15
$  !
$  !
$  ! Begin recording for this boot. The specified /INTERVAL value
$  ! is adequate for long-term summaries; you may require a smaller
$  ! value to get reasonable "semi-live" playback summaries (at the
$  ! expense of more disk space for the recording file).
$  !
$ MONITOR /INTERVAL=600 /NODISPLAY /RECORD='RECFIL' ALL_CLASSES
$  !
$  !
$  ! End of MONITOR.COM
$  !
