$! Begin Example 2.4
$!
$! This example exercises the F$cunits() lexical function
$! to calculate the Percent free of a disk.  It also 
$! does an approximation of percent free for disk with over
$! 1 million blocks. 
$!
$! Parameters
$!
$!  P1 => disk specification to display, default is all disks
$!
$ if p1 .nes. "" Then GOTO show_device_info
$ thisproc = f$environment("procedure")
$Loop:
$ disk = F$DEVICE("*","DISK")
$ if disk .eqs. "" then EXIT
$ @'thisproc' 'disk'
$ goto Loop
$!
$show_device_info: ! parameter supplied is disk to display
$! 
$! validate the disk is mounted
$!
$ disk = P1
$ if P1 .eqs. "" then disk = "sys$sysdevice"
$ if .NOT.  ( f$getdvi(disk,"EXISTS") .AND.  -
              f$getdvi(disk,"AVL")    .AND.  -
              f$getdvi(disk,"MNT")   ) then  EXIT
$ write sys$output "Results for disk : ''disk'"
$ line = f$fao("!4(16AS)","Units","Total", "FREE", "Percent")
$ write sys$output line
$!
$! do direct calculation or approximation first  (BLOCKS)
$!
$ TotalSize = f$fao("!UL",f$getdvi(disk,"MAXBLOCK"))
$ FreeSize = f$fao("!UL",f$getdvi(disk,"FREEBLOCKS"))
$ TotalDisplay = TotalSize  ! save original value for display
$ FreeDisplay = FreeSize    ! save original value for display
$ if f$length(TotalSize) .lt. 7 then GOTO No_approximation
$!
$! extract the higher order 7 bytes of a zero filled integer
$! for approximation.  e.g.  total = 100000000 free = 001000000
$!  1000000 / 001000 = 1%
$! 
$ TotalSize =  f$extract(0,7,f$fao("!10ZL",f$getdvi(disk,"MAXBLOCK")))
$ FreeSize  =  f$extract(0,7,f$fao("!10ZL",f$getdvi(disk,"FREEBLOCKS")))
$!
$No_approximation:
$!
$! list of the supported F$CUNIT units arguments
$!
$ uindex = -1
$ units = "BLOCKS,KB,MB,GB,TB"
$!
$! show approximation
$!
$ unit = "Approx"
$!
$ GOTO Compute_Percent
$!
$Fcunits_display:
$!
$! For each supported F$CUNIT unit, compute the percentage from
$! the units conversion and display.
$!
$Get_Unit:
$!--------
$ unit = f$element(uindex,",",units)
$ if unit .eqs. "," then EXIT
$!
$ TotalSize  =  f$cunits(f$string(f$fao("!UL",f$getdvi(disk,"MAXBLOCK"))),"BLOCKS",unit)  - "''unit'"
$ FreeSize   =  f$cunits(f$string(f$fao("!UL",f$getdvi(disk,"FREEBLOCKS"))),"BLOCKS",unit) -  "''unit'"
$!
$ TotalDisplay = TotalSize
$ FreeDisplay = FreeSize
$!
$! for unit >= gigabytes retain the fractional value
$! otherwise we lose too much precision
$!
$ if uindex .lt. 4 then goto Edit_Units_002
$!
$! for gigabyte scale, retain the fractional part
$! but delete the decimal point (i.e. multiply * 100)
$!
$ if f$locate(".",TotalSize) .eq. f$length(TotalSize)
$ then
$       TotalSize = TotalSize + "00" 
$ else
$       TotalSize = TotalSize - "."
$ endif
$ if f$locate(".",FreeSize) .eq. f$length(FreeSize)
$ then
$       FreeSize = FreeSize + "00"
$ else
$       FreeSize = FreeSize - "."
$ endif
$!
$ GOTO Compute_Percent
$!
$Edit_Units_002:
$!
$! For units < Gigabytes truncate any fraction
$! whole number is sufficient to calculate the percent
$!
$ if f$locate(".",TotalSize) .lt. f$length(TotalSize)
$ then
$       TotalSize = f$extract(0,f$length(TotalSize)-4,TotalSize)
$ endif
$!
$ if f$locate(".",FreeSize) .lt. f$length(FreeSize)
$ then
$       FreeSize = f$extract(0,f$length(FreeSize)-4,FreeSize)
$ endif
$!
$Compute_Percent:
$!
$! check for overflow on percentage calculation.  display
$! "overflow" for unit values that cannot be calculated 
$!
$ PCTfree = -1
$ if (((f$integer(FreeSize)*100)/100) .ne. f$integer(FreeSize)) .OR. -
      f$length(FreeSize) .gt. 8 .OR f$length(TotalSize) .gt. 8
$ then
$       PCTfree = "Overflow"
$ else
$       if TotalSize .eq. 0 .OR. FreeSize .eq. 0
$       then
$               PCTfree = 0
$       else
$               PCTfree = f$integer( (FreeSize*100) / TotalSize)
$       endif
$ endif
$!
$ line =   f$fao("!4(16AS)",Unit, TotalDisplay, FreeDisplay, f$string(PCTfree))
$ write sys$output line
$!
$ uindex = uindex + 1
$ GOTO Get_Unit
$!
$ EXIT
$!
$! End Example 2.4
