/*
** COPYRIGHT (c) 1996 BY
** DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
** ALL RIGHTS RESERVED.
**
** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
** ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
** INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
** COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
** OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
** TRANSFERRED.
**
** THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
** AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
** CORPORATION.
**
** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
** SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
*/

/*  This program is an example of how to gather emulated instruction statistics and
 *  how to set the instruction emulator to signal an emulated instructions more or
 *  fewer times than the default  (or 0).
 *
 *  The interfaces used below are not officially documented, nor are they guaranteed to
 *  remain consistent from release to release.
 *
 *  To build this example program do the following:
 *
 *	$ cc emulator_util+sys$library:sys$lib_c.tlb/lib
 *	$ link emulator_util/sysexe
 *
 *  To run the program, be sure that it's directory is included in the search list pointed
 *  to by the logical DCL$PATH.  (For example, $ DEFINE DCL$PATH SYS$LOGIN would work if 
 *  emulator_util.exe were located in SYS$LOGIN).  To get the number of instructions that
 *  were emulated by the previously running program, type "emulator_util" at the login prompt.
 *  Normally, the user is notified with a signal for the first 5 times an instruction is emulated.
 *  You can type "emulator_util sigmax 0" to set the maximum number of signals to 0 (so
 *  the user will not be notified when there is an emulated instruction).  Normally the counters
 *  that this program prints will remain valid only until the first instruction is emulated in a
 *  new image.  You can prevent the counters from being re-initialized by typing "emulator_util noinit"
 *  Additional options will be displayed if you type "emulator_util ?".
 *
 */
#include stdlib
#include stdio
#include ints
#include string
#include ctlp1flagsdef

extern uint64 CTL$GQ_EMULATE_COUNT,CTL$GQ_EMULATE_DATA[2];
extern uint64 CTL$GQ_EMULATE_RING_INDEX,CTL$GQ_EMULATE_PC_RING[];
extern uint64 CTL$GQ_EMULATE_FLAGS,CTL$GQ_EMULATE_SIGNAL_MASK,CTL$GQ_EMULATE_SIGNAL_MAX;



main (int argc, char *argv[])
{
    int i,j;
    int arg_index = 0;
    int printit;
    printit = (argc <= 1);  /*Print only if no command line args*/
    for (i=1; i < argc; i++) /*argv[0] is the image path*/
	{
	if (strcmp(argv[i],"sigmax") == 0)
	    {
	    i++; if (i>= argc) break;
	    CTL$GQ_EMULATE_DATA[0] = strtol(argv[i],(char**)NULL,0);
	    CTL$GQ_EMULATE_FLAGS |= CTLEMFLAGS$M_GET_SIG_COUNT;
	    }
	else if (strcmp(argv[i],"nosigmax") == 0)
	    {
	    CTL$GQ_EMULATE_FLAGS &= (~CTLEMFLAGS$M_GET_SIG_COUNT);
	    }
	else if (strcmp(argv[i],"sigmask") == 0)
	    {
	    i++; if (i>= argc) break;
	    CTL$GQ_EMULATE_SIGNAL_MASK = strtol(argv[i],(char**)NULL,0);
	    }
	else if (strcmp(argv[i],"noinit") == 0)
	    {
	    CTL$GQ_EMULATE_FLAGS |= CTLEMFLAGS$M_NO_NEW_IMAGE_RESET;
	    }
	else if (strcmp(argv[i],"init") == 0)
	    {
	    CTL$GQ_EMULATE_FLAGS &= (~CTLEMFLAGS$M_NO_NEW_IMAGE_RESET);
	    }
	else if (strcmp(argv[i],"default") == 0)
	    {
	    CTL$GQ_EMULATE_FLAGS = 0;
	    CTL$GQ_EMULATE_SIGNAL_MASK = 0xffffffffffffffff;
	    CTL$GQ_EMULATE_DATA[0] = 0;
	    CTL$GQ_EMULATE_DATA[1] = 0;
	    }
	else if (strcmp(argv[i],"print") == 0)
	    {
	    printit = 1;
	    }
	else 
	    {
	    if (strcmp(argv[i],"?") != 0) printf ("Unknown argument %s\n",argv[i]);
	    printf ("\nUsage:\n");
	    printf ("sigmax n       Set maximum number of times to signal emulation for this process\n");
	    printf ("nosigmax       Use default number of times to signal emulation for this process\n");
	    printf ("sigmask n      Set mask of the type of emulations to signal for this process\n");
	    printf ("noinit         Set emulator not to reset counters on a new image\n");
	    printf ("init           Set emulator to reset counters on a new image\n");
	    printf ("default        Set emulator flags to their default state\n");
	    printf ("print          Print the current counter values (even if other switches are set)\n");
	    printf ("\n");
	    printf (" Notes: Numbers can be decimal, hex (0xnnnn) or octal (0onnnn)\n");
	    printf ("        If no switches are specified, the counter values are printed.\n");
	    }
	}

    if (printit)
	{
	printf ("The number of instructions emulated is %d\n",CTL$GQ_EMULATE_COUNT);
	printf ("The PCs of the last %d emulated instructions are (most recent first):\n",CTL$C_EMULATE_RING_SIZE);

	for (i=0,j=CTL$GQ_EMULATE_RING_INDEX;  i < CTL$C_EMULATE_RING_SIZE;  i++,j=(--j & CTL$M_EMULATE_RING_SIZE))
	    {
	    printf("PC ring entry %d is %x\n",j,CTL$GQ_EMULATE_PC_RING[j]);
	    }
	}
    return 1;
}
