/*	.TITLE	DB_USER - Read server database				   *
 *	.IDENT	'X-1'							   */

/***************************************************************************/
/*									   */
/*  COPYRIGHT (c) 1991 BY						   */
/*  DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.		   */
/*  ALL RIGHTS RESERVED.						   */
/* 								           */
/*  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED  */
/*  ONLY IN  ACCORDANCE WITH  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE  */
/*  INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER  */
/*  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY  */
/*  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE IS  HEREBY  */
/*  TRANSFERRED.							   */
/* 									   */
/*  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE  */
/*  AND  SHOULD  NOT  BE  CONSTRUED AS  A COMMITMENT BY DIGITAL EQUIPMENT  */
/*  CORPORATION.							   */
/* 									   */
/*  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS  */
/*  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.		   */
/* 									   */
/*									   */
/***************************************************************************/

/*++									   */
/* FACILITY:	DECnet nontransparent task-to-task communication.          */

/* ABSTRACT:	DB_USER							   */

/* This program will read database created by DB_USER.			   */

/* ENVIRONMENT:	User mode						   */

/* AUTHOR:  Jim Colombo, 	CREATION DATE:  11-Nov-1991		   */

/*  INCLUDE EXTERNAL CONSTANTS                                             */

#pragma nomember_alignment
#include <fab>
#include <rab>
#include <xab>

#pragma member_alignment
#include <descrip>
#include <rmsdef>
#include <ssdef>
#include <stsdef>
#include <stdio>
#include <stdlib>

/*  DEFINE LOCAL CONSTANTS                                                 */

#define TEMP_MBX 0
#define MAX_BUFFS 100
#define MAX_LINKS 32   		    /*  Must be <= 32  for ffs/ffc to work */
#define MAX_NAME 20
#define MAX_ACCOUNT 11
#define MAX_PHONE 14
#define MAX_ADDRESS 30
#define MAX_LOCATION 30
#define MAX_MSG 128
#define MAX_REC_SIZE MAX_NAME+MAX_ACCOUNT+MAX_PHONE+MAX_ADDRESS+MAX_LOCATION+4
#define MAX_DISPLAY 160

/*  DEFINE GLOBAL DATA STRUCTURES                                          */

    struct msgvec_blk {		            /*  Message vector for $putmsg */
	short int count;
	short int options;
	int msg_code;
    } msgvec = { 1, 15, 0 };

    struct Data_Blk {		/*  Buffer layout matches one in DB_SERVER */
	char name[MAX_NAME];
	char account[MAX_ACCOUNT];
	char phone[MAX_PHONE];
	char address[MAX_ADDRESS];
	char location[MAX_LOCATION];
	int  status;
	char spare[7];
    };

/*  DECLARE GLOBAL DATA                                                    */

    _align (quadword) globaldef struct Data_Blk data_blk;

/*  DECLARE DATA                                                           */

    struct FAB db_fab;
    struct RAB db_rab;
    struct XABKEY db_xabkey;

    int return_status;
    char db_file[19] = "DB_DIR:DB_USER.IDX"; 
    char disp_buff[MAX_DISPLAY];

/*  BUILD DESCRIPTORS                                                      */

    struct dsc$descriptor_s prompt_record;
    static $DESCRIPTOR (prompt_name, "Name: ");
    static $DESCRIPTOR (prompt_account, "Account: ");
    static $DESCRIPTOR (prompt_phone, "Phone number: ");
    static $DESCRIPTOR (prompt_address, "Address: ");
    static $DESCRIPTOR (prompt_location, "Location: ");
    static $DESCRIPTOR (fao_ctrl,
	"!/!AF Account: !AF  Phone: !AF!/  Address:  !AF City: !AF!/" );
    struct dsc$descriptor_s disp_desc;

main ()

/* The initialization routine will create the database and prompt the user *
 * for each field in a database record. The user terminate input via ^Z.   *
 * Once the database has been written, the user is then prompted for the   *
 * name of a record to be read and displayed.				   */

{
    return_status = initialization ();
    if ( return_status & STS$M_SUCCESS ) {
	return_status = open_read_database ();
	while ( return_status & STS$M_SUCCESS ) {
	    if ( return_status & STS$M_SUCCESS )
		return_status = prompt_user_name();
	    if ( return_status & STS$M_SUCCESS ) {
		return_status = read_database ();
		display_record();
	    }
	}
    }
    if ( return_status == RMS$_EOF )
	return_status = SS$_NORMAL;
    exit ( return_status );
}

initialization ()

/* Initialize some global variables, create the database and request input *
 * from the user to write the database.					   */

{
    int x;

    return_status = initialize_variables ();
/*
    if ( return_status & STS$M_SUCCESS ) {
	    return_status = create_database ();
	    if ( return_status & STS$M_SUCCESS )
		return_status = prompt_user();
    }
*/
    return return_status;
}

initialize_variables ()

/* Initialize global pointers and variables				   */

{
    disp_desc.dsc$w_length = MAX_DISPLAY;
    disp_desc.dsc$a_pointer = &disp_buff; 
    disp_desc.dsc$b_dtype = DSC$K_DTYPE_T;
    disp_desc.dsc$b_class = DSC$K_CLASS_S;

    db_fab = cc$rms_fab;
    db_rab = cc$rms_rab;
    db_xabkey = cc$rms_xabkey;

    return_status = SS$_NORMAL;
    return return_status;
}

create_database ()

/* Create the database by call the system service routine sys$create.	   *
 * The file created is a fixed record index file.			   */

{
    db_fab.fab$b_fac = FAB$M_PUT;
    db_fab.fab$l_fna = &db_file;
    db_fab.fab$b_fns = sizeof ( db_file );
    db_fab.fab$w_ifi = 0;
    db_fab.fab$w_mrs = MAX_REC_SIZE;
    db_fab.fab$b_org = FAB$C_IDX;
    db_fab.fab$b_rat = FAB$M_CR;
    db_fab.fab$b_rfm = FAB$C_FIX;
    db_fab.fab$l_xab = &db_xabkey;

    db_xabkey.xab$b_cod = XAB$C_KEY;
    db_xabkey.xab$b_bln = sizeof ( db_xabkey );
    db_xabkey.xab$b_siz0 = MAX_REC_SIZE;

    db_rab.rab$l_fab = &db_fab;
    db_rab.rab$b_rac = RAB$C_KEY;
    db_rab.rab$b_krf = 0;
    db_rab.rab$b_ksz = MAX_NAME;
    db_rab.rab$w_usz = sizeof ( data_blk );

    return_status = sys$create ( &db_fab );

    if ( return_status & STS$M_SUCCESS )
	return_status = sys$connect ( &db_rab );

    return  return_status;
}

prompt_user ()

/* Prompt the user for a database record.				   */

{
    unsigned short int size;

    printf("Please enter the information requested for each record.\n");
    printf("Terminate by entering ^Z\n");

    prompt_record.dsc$b_dtype = DSC$K_DTYPE_T;
    prompt_record.dsc$b_class = DSC$K_CLASS_S;
    while ( return_status & STS$M_SUCCESS ) {
	prompt_record.dsc$w_length = MAX_NAME;
	prompt_record.dsc$a_pointer = &data_blk.name;
	return_status = lib$get_input ( &prompt_record,
					&prompt_name, &size );

	data_blk.name[size] = 0;
	if ( return_status & STS$M_SUCCESS ) {
	    prompt_record.dsc$w_length = MAX_ACCOUNT;
	    prompt_record.dsc$a_pointer = &data_blk.account;
	    return_status = lib$get_input ( &prompt_record,
					    &prompt_account, &size );
	    data_blk.account[size] = 0;
	}
	if ( return_status & STS$M_SUCCESS ) {
	    prompt_record.dsc$w_length = MAX_PHONE;
	    prompt_record.dsc$a_pointer = &data_blk.phone;
	    return_status = lib$get_input ( &prompt_record, 
					    &prompt_phone, &size );
	    data_blk.phone[size] = 0;
	}
	if ( return_status & STS$M_SUCCESS ) {
	    prompt_record.dsc$w_length = MAX_ADDRESS;
	    prompt_record.dsc$a_pointer = &data_blk.address;
	    return_status = lib$get_input ( &prompt_record,
					    &prompt_address, &size );
	    data_blk.address[size] = 0;
	}
	if ( return_status & STS$M_SUCCESS ) {
	    prompt_record.dsc$w_length = MAX_LOCATION;
	    prompt_record.dsc$a_pointer = &data_blk.location;
	    return_status = lib$get_input ( &prompt_record,
					    &prompt_location, &size );
	    data_blk.location[size] = 0;
	}
	if ( return_status & STS$M_SUCCESS )
	    return_status = write_database ();
    }
    if ( return_status == RMS$_EOF )
	return_status = SS$_NORMAL;
    return return_status;
}

prompt_user_name ()

/* Prompt the user for the name of a database record.			   */

{
    unsigned short int size;

    printf("Please enter the name of a database record.\n");
    printf("Terminate by entering ^Z\n");

    prompt_record.dsc$b_dtype = DSC$K_DTYPE_T;
    prompt_record.dsc$b_class = DSC$K_CLASS_S;
    prompt_record.dsc$w_length = MAX_NAME;
    prompt_record.dsc$a_pointer = &data_blk.name;
    return_status = lib$get_input ( &prompt_record,
				    &prompt_name, &size );
    data_blk.name[size] = 0;
    return return_status;
}

open_read_database ()

/* Open the database for reading.					   */

{
    db_fab.fab$b_fac = FAB$M_GET;
    db_fab.fab$l_fna = &db_file;
    db_fab.fab$b_fns = sizeof (db_file);
    db_fab.fab$w_mrs = MAX_REC_SIZE;
    db_fab.fab$b_org = FAB$C_IDX;
    db_fab.fab$b_rat = FAB$M_CR;
    db_fab.fab$b_rfm = FAB$C_FIX;

    db_rab.rab$l_fab = &db_fab;
    db_rab.rab$b_rac = RAB$C_KEY;
    db_rab.rab$b_krf = 0;
    db_rab.rab$b_ksz = MAX_NAME;
    db_rab.rab$w_usz = sizeof ( data_blk );

    return_status = sys$open ( &db_fab );

    if ( return_status & STS$M_SUCCESS )

	return_status = sys$connect ( &db_rab );

    return  return_status;
}

close_database ()

/* Close the database.							   */

{
    return_status = sys$close ( &db_fab );
    return return_status;
}

write_database ()

/*  write a database record.						   */

{
    db_rab.rab$l_rbf = &data_blk;
    db_rab.rab$w_rsz = MAX_REC_SIZE;
    return_status = sys$put ( &db_rab );

    data_blk.status = return_status;
    if ( return_status & STS$M_SUCCESS )
	printf("Database record %s written\n", data_blk.name);
    return return_status;
}

read_database ()

/*  Read the database using the name field of the request buffer.  The     *
 *  status of the read request is placed in the status field of the buffer *
 *  for return to the requestor.                                           */

{
    db_rab.rab$l_kbf = &data_blk.name;
    db_rab.rab$l_ubf = &data_blk;
    return_status = sys$get ( &db_rab );

    data_blk.status = return_status;
    return return_status;
}

display_record()

/* Display a database record.						   */

{
    if ( data_blk.status & STS$M_SUCCESS ) {
	disp_desc.dsc$w_length = MAX_DISPLAY;
	return_status = sys$fao ( &fao_ctrl, 
				  &disp_desc.dsc$w_length, &disp_desc,
				  MAX_NAME, &data_blk.name,
				  MAX_ACCOUNT, &data_blk.account,
				  MAX_PHONE, &data_blk.phone,
				  MAX_ADDRESS, &data_blk.address,
				  MAX_LOCATION, &data_blk.location );

	if ( return_status & STS$M_SUCCESS )
	    return_status = lib$put_output ( &disp_desc );
    }
    else {
	msgvec.msg_code = data_blk.status;
	return_status = sys$putmsg ( &msgvec, 0, 0, 0 );
    }
}
