$!*****************************************************************************
$!*                                                                           *
$!*  SYS$EXAMPLES:DAYLIGHT_SAVINGS.COM                                        *
$!*                                                                           *
$!* Copyright 2000 Compaq Computer Corporation                                *
$!*                                                                           *
$!* Compaq and the Compaq logo Registered in U.S. Patent and Trademark Office.*
$!*                                                                           *
$!* Confidential computer software. Valid license from Compaq required for    *
$!* possession, use or copying. Consistent with FAR 12.211 and 12.212,        *
$!* Commercial Computer Software, Computer Software Documentation, and        *
$!* Technical Data for Commercial Items are licensed to the U.S. Government   *
$!* under vendors standard commercial license.                                *
$!*                                                                           *
$!*****************************************************************************
$!
$!  The following $DECK/$EOD prevents the comments/instructions
$!  from being removed if this procedure is DCLDIETed.
$   goto after_deck
$DECK
$!  This procedure is useful to change between Daylight Savings Time
$!  and Standard Time when automatic OpenVMS DST/STD changing and
$!  DTSS are not in use.
$!
$!  It will either ADD or SUBTRACT one hour from the system time.
$!
$!  It will re-set the system Time Differential Factor,
$!      including
$!          the logical name, SYS$TIMEZONE_DIFFERENTIAL,
$!          the system cell, EXE$GQ_TDF, and
$!          the file SYS$SYSTEM:SYS$TIMEZONE.DAT.
$!
$!  The following logicals area also reset
$!
$!     SYS$TIMEZONE_DAYLIGHT_SAVING
$!     SYS$TIMEZONE_NAME
$!     SYS$TIMEZONE_RULE
$!
$!  N.B. -- These logicals are set based on the time zone rule file
$!          defined in SYS$SYSTEM:SYS$TIMEZONE_SRC.DAT, and the
$!          current date and time.  This if the time specfied in
$!          that time zone rule file for the change to/from DST/STD
$!          is in the future, they will not be set as you might expect.
$!          After the time for the change has past, you can re-set
$!          these logicals by executing
$!
$!              $ @SYS$MANAGER:UTC$TIME_SETUP "" RULE"
$!
$!          or by re-booting the system.
$!
$!  This procedure creates a command procedure, DST$CHANGE.COM, in the
$!  current directory.  The created procedure can execute on the current
$!  node only, or SYSMAN can be used to execute on all nodes in the cluster.
$!  If you choose to use SYSMAN, a second procedure, DST$SYSMAN.COM is
$!  created to execute DST$CHANGE.COM by using a SYSMAN DO command.
$!
$!  You can choose to execute immediately; to queue a job for future execution;
$!  or to save for possible modification.  If you choose to queue a job,
$!  it will be submitted to the SYS$BACH queue; if this is NOT satisfactory,
$!  save the procedure(s) and manually submit to the correct queue.
$!
$!  INPUT PARAMETERS
$!
$!      All parameters are optional.
$!      If parameters are not provided, input will be promoted
$!      and read from SYS$OUTPUT (normally the terminal).
$!
$!      P1  DAYLIGHT or STANDARD -- which you are changing _to_
$!      P2  NODE or CLUSTER -- changing this NODE only or the entire CLUSTER
$!      P3  EXECUTE, QUEUE or SAVE -- EXECUTE now, QUEUE for later
$!                                    or just SAVE the sysman procedure(s)
$!      P4  <date-time> -- time to run if QUEUED; unused otherwise
$!
$!  To execute this command procedure interactively, enter:
$!
$!          $ @SYS$EXAMPLES:DAYLIGHT_SAVINGS
$!
$!  and respond to the prompts.
$!
$!  To execute this command procedure with input provided by parameters,
$!  enter:
$!
$!          $ @SYS$EXAMPLES:DAYLIGHT_SAVINGS -
$!          _$      [ DAYLIGHT | STANDARD ] -
$!          _$      [ NODE | CLUSTER ] -
$!          _$      [ EXECUTE | QUEUE <time> | SAVE ]
$!
$!  The above example is shown on multiple lines for clarity; the command
$!  may be entered on a single line.  Parameters (except time) may be
$!  shortened -- only the first letter of each parameter is required.
$!
$EOD
$AFTER_DECK:
$!
$!  Modifications
$!
$!  X-7         2005-FEB-01         Charlie Hammond
$!      Corect type -- "Changess" -> "Changes"  (5 places)
$!
$!  X-6         2004-MAR-31         Charlie Hammond
$!      Update code for IA64
$!      Change two incorrect instances of "dst$dev_dir" to "dst$devdir"
$!      Add    @SYS$MANAGER:UTC$TIME_SETUP "" RULE
$!          to reset SYS$TIMEZONE_NAME and SYS$TIMEZONE_RULE
$!
$!  X-5         2003-NOV-06         Charlie Hammond
$!      Do not delete SYS$TIMEZONE_DAYLIGHT_SAVING, SYS$TIMEZONE_NAME
$!      or SYS$TIMEZONE_RULE.
$!      Re-define SYS$TIMEZONE_DAYLIGHT_SAVING to "0" or "1"
$!      depending on input.
$!
$!  X-4         2003-APR-15         Charlie Hammond
$!      Use the translation of SYS$SYSDEVICE:[VMS$COMMON.SYSMGR] as the
$!      device/directoroy for DST$CHANGE.COM and DST$SYSMAN.COM.
$!      This will work for ALL nodes that boot from this system disk,
$!      and _may_ work for nodes that boot from other system disks
$!      IFF this system disk is mounted on those nodes.
$!      (See VAXAXP.ZKO.DEC.COM::VMSNOTES #7024 for additional information.)
$!
$!  X-3         01-May-2001         Charlie Hammond
$!      Fix sign of time adjustment (was changing in the wrong direction)
$!      Correctl status comparisons to use .EQ. in place of .EQS.
$!
$!
$!
$!  Make sure DCL verbs aren't unexpected symbols
$!
$   set = "set"     ! in case "SET" is a symbol
$   set symbol /scope=(nolocal,noglobal)
$!
$   on control_y then goto y_exit
$   on warning then goto err_exit
$!
$   Say := write sys$output
$!
$!
$!  Warn if DTSS is in use
$!
$!  Look for process DTSS$CLERK or DTSS$SERVER to determine if
$!  DTSS is present and active.
$!
$!  If the following PIPE command succeeds in locating DTSS$...
$!      then  $STATUS will be %X10000001.
$!      For "no strings matched", $STATUS will be %X18D78053
$!
$   define sys$output nl:
$   set noon
$   pipe show system | search sys$input "DTSS$CLERK", "DTSS$SERVER"
$   dtss$status = $status
$   set on
$   deassign sys$output
$   if dtss$status .eq. %X10000001
$   then                                        ! DTSS found
$       say ""
$       say "DTSS is in use."
$       say "DTSS will make changes between DST and STD time."
$       say ""
$       say "The procedure(s) created by this procedure WILL NOT"
$       say "make any changes on nodes on which DTSS is in use."
$       say ""
$       say "(Press Ctrl-Y to abort.)"
$       say ""
$   endif
$!
$!
$!  Warn if AUTO_DLIGHT_SAV is set
$!
$   if f$getsyi("ARCH_NAME") .eqs. "Alpha"
$   then    ! check for a minimumum version of 7.3"
$       define sys$output nl:
$       set noon
$       product show product VMS /span_version=minimum=A7.3
$       sav$status = $status
$       set on
$       deassign sys$output
$       if sav$status .eq. 1
$       then
$           if f$getsyi("AUTO_DLIGHT_SAV")
$           then                            ! AUTO_DLIGHT_SAV set
$               say ""
$               say "The system parameter AUTO_DLIGHT_SAV is set."
$               say "OpenVMS will make changes between DST and STD time."
$               say ""
$               say "The procedure(s) created by this procedure WILL NOT"
$               say "make any changes on nodes on which AUTO_DLIGHT_SAV is set."
$               say ""
$               say "(Press Ctrl-Y to abort.)"
$               say ""
$           endif
$       endif
$   endif
$!
$!  Setup the translation of SYS$SYSDEVICE:[VMS$COMMON.SYSMGR] as the
$!  device/directoroy for DST$*.COM files.  This will work for ALL
$!  nodes that boot from this system disk, and _may_ work for nodes
$!  that boot from other system disks IFF this system disk is mounted
$!  on those nodes.
$!
$   dst$dev = f$trnlnm("SYS$SYSDEVICE")
$   dst$devdir = dst$dev + "[VMS$COMMON.SYSMGR]"
$!
$ASK_DST_STD:
$!
$   dst$std = "X"
$   if p1 .nes. ""
$   then
$       say "Changing to ''p1'"
$       ans = p1
$       goto p1_supplied
$   endif
$   say ""
$   read sys$output ans /prompt= -
        "Are you changing to DAYLIGHT or to STANDARD time? (DAYLIGHT/STANDARD): "
$   if ans .eqs. "^" then exit
$   if ans .eqs. "" then ans = "#"
$P1_SUPPLIED:
$   ans = f$edit(ans,"TRIM,UPCASE")
$   if f$locate(ans,"DAYLIGHT/STANDARD") .eq. 0 then dst$std = "D"
$   if f$locate(ans,"DAYLIGHT/STANDARD") .eq. 9 then dst$std = "S"
$   if ( (dst$std .nes. "D") .and. (dst$std .nes. "S") )
$   then
$       say ""
$       say "*** You must enter DAYLIGHT or STANDARD!"
$       say ""
$       p1 = ""
$       goto ask_dst_std
$   endif
$!
$ASK_LOCAL_CLU:
$!
$   loc$clu = "X"
$   if p2 .nes. ""
$   then
$       say "Change will be made on ''p2'"
$       ans = p2
$       goto p2_supplied
$   endif
$   say ""
$   read sys$output ans /prompt= -
        "Will the sysman be on this NODE only or CLUSTER wide? (NODE/CLUSTER): "
$   if ans .eqs. "^" then goto ask_dst_std
$   if ans .eqs. "" then ans = "#"
$P2_SUPPLIED:
$   ans = f$edit(ans,"TRIM,UPCASE")
$   if f$locate(ans,"NODE/CLUSTER") .eq. 0 then loc$clu = "N"
$   if f$locate(ans,"NODE/CLUSTER") .eq. 5 then loc$clu = "C"
$   if ( (loc$clu .nes. "N") .and. (loc$clu .nes. "C") )
$   then
$       say ""
$       say "*** You must enter NODE or CLUSTER!"
$       say ""
$       p2 = ""
$       goto ask_local_clu
$   endif
$!
$ASK_EX_Q_SAV:
$!
$   ex$q$sav = "X"
$   if p3 .nes. ""
$   then
$       say "Procedure action is ''p3'"
$       ans = p3
$       goto p3_supplied
$   endif
$   say ""
$   say "If you choose to SAVE the procedures, you can modify"
$   say "the SYSMAN environment, or make other changes before executing."
$!
$   if loc$clu .eqs. "C"
$   then
$   say ""
$   say "*   NOTE: If this OpenVMS cluster has multiple system disks and"
$   say "*   this system disk, ''dst$dev', is not mounted cluster wide, then"
$   say "*   this command will fail on nodes booted from other system disks."
$   say "*   In this case, you may wish to SAVE the procedures and modify them."
$   endif
$!
$   say ""
$   say "Do you wish to EXECUTE the change now, QUEUE it for future execution,"
$   say "or SAVE the created procedures without executing?"
$   read sys$output ans /prompt="    (EXECUTE/QUEUE/SAVE): "
$   if ans .eqs. "^" then goto ask_local_clu
$   if ans .eqs. "" then ans = "#"
$P3_SUPPLIED:
$   ans = f$edit(ans,"TRIM,UPCASE")
$   if f$locate(ans,"EXECUTE/QUEUE/SAVE") .eq. 0 then ex$q$sav = "X"
$   if f$locate(ans,"EXECUTE/QUEUE/SAVE") .eq. 8 then ex$q$sav = "Q"
$   if f$locate(ans,"EXECUTE/QUEUE/SAVE") .eq. 14 then ex$q$sav = "S"
$   if  ( (EX$Q$SAV .nes. "X") -
    .and. (EX$Q$SAV .nes. "Q") -
    .and. (EX$Q$SAV .nes. "S") )
$   then
$       say ""
$       say "*** You must enter EXECUTE, QUEUE or SAVE!"
$       say ""
$       p3 = ""
$       goto ask_ex_q_sav
$   endif
$!
$!
$!  Create the DST$CHANGE procedure.
$!
$!  Get the current TDF in seconds
$   log$tdf = f$integer(f$trnlnm("SYS$TIMEZONE_DIFFERENTIAL"))
$!  convert to minutes
$   new$tdf = log$tdf / 60
$!  Check that it is an integral numer of minutes
$   if new$tdf * 60 .ne. log$tdf
$   then
$       say ""
$       say "*** The value of the logical name SYS$TIMEZONE_DIFFERENTIAL"
$       say "*** is not an integral multiple of 60 (seconds per minute)!"
$       say ""
$       exit
$   endif
$!
$!  Set the new TDF and the time adjustment
$   if dst$std .eqs. "D"
$   then
$       new$tdf = new$tdf + 60
$       time$adj = +60
$   endif
$   if dst$std .eqs. "S"
$   then
$       new$tdf = new$tdf - 60
$       time$adj = -60
$   endif
$!
$!
$!  Write DST$CHANGE.COM, the procedure that will make the time change.
$!
$   close/error=open_change dst$change      ! Make sure it wasn't left open
$open_change:
$!
$!  Use CREATE to get desired record format
$   create 'dst$devdir'DST$CHANGE.COM
$!
$   open/append dst$change 'dst$devdir'DST$CHANGE.COM
$!
$   if dst$std .eqs. "D"
$   then
$       write dst$change -
    "$!  This procedure changes from Standard time to Daylight Saving time."
$   endif
$!
$   if dst$std .eqs. "S"
$   then
$       write dst$change -
    "$!  This procedure changes from Daylight Saving time to Standard time."
$   endif
$!
$   write dst$change -
    "$!      Created by DAYLIGHT_SAVINGS.COM ''f$time()'"
$!
$   close dst$change
$!
$   append sys$input 'dst$devdir'DST$CHANGE.COM
$DECK
$!  This procedure can be executed directly, or by a SYSMAN DO command
$!
$   Say := write sys$output
$!
$   arch$ = " "     ! Make sure the symbol is defined
$!
$   if f$getsyi("ARCH_NAME") .eqs. "IA64"
$   then
$       arch$ = "IA64"
$   endif
$!
$   if f$getsyi("ARCH_NAME") .eqs. "Alpha"
$   then    ! check for a minimumum version of 7.3
$       define sys$output nl:
$       set noon
$       product show product VMS /span_version=minimum=A7.3
$       if $status .eq. 1
$       then
$           arch$ = "NEW_ALPHA"
$       else
$           arch$ = "OLD_ALPHA"
$       endif
$       set on
$       deassign sys$output
$   endif
$!
$   if f$getsyi("ARCH_NAME") .eqs. "VAX"
$   then
$       arch$ = "VAX"
$   endif
$!
$   define sys$output nl:
$   set noon
$   pipe show system | search sys$input "DTSS$CLERK", "DTSS$SERVER"
$   dtss$status = $status
$   set on
$   deassign sys$output
$   if dtss$status .eq. %X10000001
$   then                                        ! DTSS found
$       say ""
$       say "DTSS is in use."
$       say "DTSS will make changes between DST and STD time."
$       say ""
$       say "This procedure will exit without making any changes."
$       say ""
$       exit
$   endif
$!
$   if f$getsyi("ARCH_NAME") .eqs. "Alpha"
$   then    ! check for a minimumum version of 7.3"
$       define sys$output nl:
$       set noon
$       product show product VMS /span_version=minimum=A7.3
$       if $status .eq. 1
$       then
$           if f$getsyi("AUTO_DLIGHT_SAV")
$           then                            ! AUTO_DLIGHT_SAV set
$               say ""
$               say "The system parameter AUTO_DLIGHT_SAV is set."
$               say "OpenVMS will make changes between DST and STD time."
$               say ""
$               say "This procedure will exit without making any changes."
$               say ""
$               deassign sys$output
$               exit
$           endif
$       endif
$       set on
$       deassign sys$output
$   endif
$!
$   if  ( (arch$ .nes. "IA64") -
    .and. (arch$ .nes. "NEW_ALPHA") -
    .and. (arch$ .nes. "OLD_ALPHA") -
    .and. (arch$ .nes. "VAX") )
$   then
$       say ""
$       say "*** Error selecting architecture (IA64/Alpha/VAX)"
$       say "*** Standard to/from Daylight time change not made"
$       say ""
$       exit
$   endif
$!
$  open/append sys$input 'dst$devdir'DST$CHANGE.COM
$!
$   @SYS$MANAGER:UTC$TIME_SETUP "" RULE                               !KSH121407
$!
$   if (  (arch$ .eqs. "VAX") -
    .or.  (arch$ .eqs. "OLD_ALPHA") )
$   then -
$EOD
$!
$!
$   open/append dst$change 'dst$devdir'DST$CHANGE.COM
$   write dst$change -
"        @sys$manager:utc$configure_tdf.com ""SET"" ''new$tdf' ''time$adj'"
$   close dst$change
$!
$!
$   append sys$input 'dst$devdir'DST$CHANGE.COM
$DECK
$   endif
$!
$!  Reset the following logical names.
$!
$!     SYS$TIMEZONE_DAYLIGHT_SAVING
$!     SYS$TIMEZONE_NAME
$!     SYS$TIMEZONE_RULE
$!
$EOD
$!
$!
$!
$   open/append dst$change  'dst$devdir'DST$CHANGE.COM
$   write dst$change -
"        @sys$manager:utc$time_setup.com """" ""TDF"" ''new$tdf' ''time$adj'"   !KSH121407
$   close dst$change
$!
$!
$   append sys$input 'dst$devdir'DST$CHANGE.COM
$DECK
$!
$ exit
$EOD
$!
$   say ""
$   say "Created file ''dst$devdir'DST$CHANGE.COM"
$!
$!
$!  Write DST$SYSMAN.COM, if this is being done cluster wide."
$!  This procedure will use SYSMAN to exeucte DST$CHANGE.COM"
$!
$   if loc$clu .nes. "C" then goto after_write_sysman
$!
$   close/error=open_sysman dst$sysman      ! Make sure it wasn't left open
$open_sysman:
$!  Use CREATE to get desired record format
$   create 'dst$devdir'DST$SYSMAN.COM
$!
$   open/append dst$sysman 'dst$devdir'DST$SYSMAN.COM
$!
$   write dst$sysman -
    "$!  This procedure executes DST$CHANGE.COM using a SYSMAN DO command."
$!
$   write dst$sysman -
    "$!      Created by DAYLIGHT_SAVINGS.COM ''f$time()'"
$   write dst$sysman -
    "$   mcr sysman"
$   write dst$sysman -
    "$DECK"
$   write dst$sysman -
    "        set environment /cluster"
$   write dst$sysman -
    "        do @''dst$devdir'DST$CHANGE.COM"
$   write dst$sysman -
    "        exit"
$   write dst$sysman -
    "$EOD"
$   write dst$sysman -
    "$   exit"
$!
$   close dst$sysman
$!
$   say "Created file ''dst$devdir'DST$SYSMAN.COM"
$!
$!
$after_write_sysman:
$!
$   if ex$q$sav .nes. "Q" then goto after_q
$!
$ask_q_time:
$   if p4 .nes. ""
$   then
$       say "Procedure will be queuend after ''p4'"
$       ans = p4
$       goto p4_supplied
$   endif
$   say "Enter the time at which the queued procedure will execute."
$   say "(Default is 2:00 AM tomorrow.)"
$   read sys$output ans /prompt= "    (DD-MMM-YYYY HH:MM): "
$   if ans .eqs. "^" then goto ask_ex_q_sav
$   if ans .eqs. "" then ans = "TOMORROW+2:00"
$P4_SUPPLIED:
$   set noon
$   after$time = "/AFTER=""''f$cvtime(ans,"ABSOLUTE")'"""
$   after$severity = $severity
$   set on
$   if .not. after$severity
$   then
$       p4 = ""
$       goto ask_q_time
$   endif
$!
$   if loc$clu .eqs. "N"
$   then                        ! Queue DST$CHANGE.COM
$       submit 'dst$devdir'DST$CHANGE.COM 'after$time'
$   endif
$!
$   if loc$clu .eqs. "C"
$   then                        ! Queue DST$SYSMAN.COM
$       submit 'dst$devdir'DST$SYSMAN.COM 'after$time'
$   endif
$!
$after_q:
$!
$!
$   if ex$q$sav .nes. "X" then goto after_x
$!
$ask_x_ok:
$!
$!  Skip the O.K. question if all params were input and valid
$   if ( (p1 .gts. "") .and. (p2 .gts. "") .and. (p3 .gts. "") ) -
        then goto after_ask_ok
$!
$   say ""
$   read sys$output ans /prompt = -
        "Is it O.K. to execute the time sysman now? (Yes/No): "
$   if ans .eqs. "^" then goto ask_ex_q_sav
$   ans = f$edit(ans,"TRIM,UPCASE")
$!
$   if f$locate(ans,"YES/NO") .eq. 4
$   then
$       say ""
$       say "The created procedure(s) will be saved but not executed."
$       say ""
$       exit
$   endif
$!
$   if f$locate(ans,"YES/NO") .ne. 0
$   then
$       say ""
$       say "*** You must enter YES or NO!"
$       say ""
$       goto ask_x_ok
$   endif
$!
$AFTER_ASK_OK:
$!
$   if loc$clu .eqs. "N"
$   then                        ! Execute DST$CHANGE.COM
$       set symbol /scope=global
$       @'dst$devdir'DST$CHANGE.COM
$   endif
$!
$   if loc$clu .eqs. "C"
$   then                        ! Execute DST$SYSMAN.COM
$       set symbol /scope=global
$       @'dst$devdir'DST$SYSMAN.COM
$   endif
$!
$after_x:
$!
$!
$   if ex$q$sav .nes. "S" then goto after_s
$!
$   say ""
$   say "The created procedure(s) will be saved."
$   say ""
$!
$after_s:
$!
$!
$   goto common_exit
$!
$!  ------------------------------------------------------------
$!  Exit routines
$!
$y_exit:        ! Ctrl_y exit routine
$!
$!  Display Ctrl_y message
$!
$   write sys$output "Exiting due to Ctrl_y entry"
$!
$   goto common_exit
$!
$err_exit:      ! error/warning exit routine
$!
$   sav_status = $status
$   write sys$output f$message(sav_status)
$   goto common_exit
$!
$common_exit:   ! common exit
$!
$!  Disable control_y and error handling
$   on control_y then continue
$   on warning then continue
$!
$!  Close any file left open...
$!
$   close/error=y_1 dst$change
$y_1:
$   close/error=y_2 dst$sysman
$y_2:
$!
$   exit
