/*
** COLLATED.C
**
** COPYRIGHT (c) 1993 BY
** DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
** ALL RIGHTS RESERVED.
**
** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
** ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
** INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
** COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
** OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
** TRANSFERRED.
**
** THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
** AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
** CORPORATION.
**
** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
** SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
**
** COMPONENT:
**
**   This module is part of SYS$EXAMPLES.
**
** MODULE DESCRIPTION:
**
**   This program creates an indexed file in the current directory with
**   a collated key.  The output file is named COLLATED.IDX
**
**   The output file is defined with one key in the first 20 bytes of the
**   record.  Maximum recordsize for the file is set to 128 bytes.
**
**   If any unexpected errors occur during processing, this program
**   does not explicity close open files.  It only returns the error
**   and relies on image rundown to close any open files.
*/

#include <stdio.h>
#include <ssdef.h>
#include <stsdef.h>
#include <descrip.h>
#include <starlet.h>
#include <rms.h>
#include <ncs$routines.h>

#define KEY0LENGTH 20                   /* Size of primary, collated key */
#define OUTRECSIZE 128                  /* Output record length */

/* Define a MACRO to check a status variable and return if an error occurred */
#define CHECK(status, string)\
    if ((status & STS$M_SUCCESS) == 0)\
    {\
        fprintf(stderr, "Error on %s...", string);\
        return (status);\
    }

static  char    onam[] = "COLLATED.IDX";/* Output file name */
struct  FAB     ofab;                   /* FAB for output file */
struct  XABKEY  key0;                   /* XABKEYs for key definitions */

$DESCRIPTOR(ncs, "Multinational_2");    /* National character set used */

int init()                              /* Initialize RMS structures */
{
    auto    int sts;                    /* Status of system calls */

    ofab = cc$rms_fab;                  /* Get a FAB for output */
    ofab.fab$l_fna = onam;              /* Output filename */
    ofab.fab$b_fns = sizeof(onam);      /* Length of output filename */
    ofab.fab$l_fop = FAB$M_CTG;         /* Allocate contiguous */
    ofab.fab$w_mrs = OUTRECSIZE;        /* Maximum record size */
    ofab.fab$b_rat = FAB$M_CR;          /* Implied carriage control */
    ofab.fab$b_rfm = FAB$C_VAR;         /* Variable length records */
    ofab.fab$b_shr = FAB$M_NIL;         /* No file sharing */
    ofab.fab$b_org = FAB$C_IDX;         /* Indexed file organization */
    ofab.fab$l_xab = (void *) &key0;    /* Start of XAB chain */

    key0 = cc$rms_xabkey;               /* Get a key XAB */
    key0.xab$b_ref = 0;                 /* Primary key is key #0 */
    key0.xab$b_dtp = XAB$C_COL;         /* Ascending collated data type */
    key0.xab$w_pos0 = 0;                /* 1st segment starts at byte 0 */
    key0.xab$b_siz0 = KEY0LENGTH;       /*   and is KEY0LENGTH bytes long */
    key0.xab$b_prolog = XAB$C_PRG3;     /* Request Prolog 3 */
    key0.xab$l_nxt = 0;                 /* End of XAB chain */
    sts = ncs$get_cs(&key0.xab$l_coltbl,/* Fetch collating table pointer... */
                     &ncs);
    CHECK(sts, "NCS$GET_CS");           /* Return any error */

    return (SS$_NORMAL);
}

main()
{
    auto    int     status;             /* Status of calls */

    status = init();                    /* Initialize RMS structures */
    CHECK(status, "initialization");    /* Return any error */
    status = sys$create(&ofab);         /* Create output file */
    CHECK(status, "output $CREATE");    /* Return any error */
    status = sys$close(&ofab);          /* Close output file */
    CHECK(status, "output $CLOSE");     /* Return any error */
    return (SS$_NORMAL);                /* Return success */
}
