$! begin Example 2.3
$!
$ percent_free == -1
$!
$ CALL percent_free "sys$sysdevice"
$ IF $status .AND. percent_free .gt. 0
$ then
$   if percent_free .ge. 5
$   then
$	    write sys$output "Sufficent freeblocks on disk"
$   else
$	    write sys$output "Warning Insufficent freeblocks on disk"
$   endif
$ else
$   write sys$output "Problem obtaining information for disk"
$ endif$!
$!
$ EXIT
$
$!
$   percent_free: subroutine
$ !
$ !   This subroutine will return, as an integer, the percentage of free
$ !   disk blocks for a given volume.  The percentage free is given by:
$ !
$ !                       (number of free blocks on the volume)
$ !     Percentage Free = ------------------------------------- * 100
$ !                              (volume size in blocks)
$ !
$ !   The volume name is passed in P1 and the result is returned in the
$ !   global symbol PERCENT_FREE.  For example:
$ !
$ !     $ call percent_free "disk$test"
$ !     $ write sys$output "Free space is ", percent_free, "%"
$ !
$ !   Since DCL does signed 32 bit arithmetic, all calculations and results
$ !   are done with the sign bit (bit 31) clear.  So, for values of free
$ !   blocks and volume size larger than %x7FFFFFFF we first clear the sign
$ !   bit, divide by two (shift right one bit) and then turn on bit 30.
$ !
$     freeblocks = f$getdvi(p1,"freeblocks")
$     volsize = f$getdvi(p1,"volsize")
$ !
$     if (freeblocks .lt. 0)
$     then pipe freeblocks[31,1] = 0 ; freeblocks = freeblocks / 2 ; freeblocks[30,1] = 1
$     else freeblocks = freeblocks / 2
$     endif
$ !
$     if (volsize .lt. 0)
$     then pipe volsize[31,1] = 0 ; volsize = volsize / 2 ; volsize[30,1] = 1
$     else volsize = volsize / 2
$     endif
$ !
$     if ((volsize / 100) .gt. 0)
$     then percent_free == freeblocks / (volsize / 100)
$     else percent_free == 0
$     endif
$ !
$   endsubroutine
$! End Example 2.3
