/**/
/***************************************************************************/
/**                                                                       **/
/**  Copyright 2010, Hewlett-Packard Development Company, L.P.           **/
/**                                                                       **/
/** Confidential computer software.  Valid license from HP and/or         **/
/** its subsidiaries required for possession, use, or copying.            **/
/**                                                                       **/
/** Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  **/
/** Computer Software Documentation, and Technical Data for Commercial    **/
/** Items are licensed to the U.S. Government under vendor's standard     **/
/** commercial license.                                                   **/
/**                                                                       **/
/** Neither HP nor any of its subsidiaries shall be liable for technical  **/
/** or editorial errors or omissions contained herein.  The information   **/
/** in this document is provided "as is" without warranty of any kind and **/
/** is subject to change without notice.  The warranties for HP products  **/
/** are set forth in the express limited warranty statements accompanying **/
/** such products.  Nothing herein should be construed as constituting an **/
/** additional warranty.                                                  **/
/**                                                                       **/
/***************************************************************************/
/********************************************************************************************************************************/
/* Created: 30-Mar-2010 17:25:59 by OpenVMS SDL EV3-3      */
/* Source:  13-FEB-2008 00:08:30 $1$DGA7274:[BACKUP.SRC]BAPIDEF.SDL;1 */
/********************************************************************************************************************************/
/*** MODULE bckapidef IDENT X-18 ***/
#pragma __member_alignment __save
#pragma __nomember_alignment
typedef struct _bck$pointer {
    char *string_ptr;                   /* 32/64-bit compatible address/pointer */
    unsigned int ptr_extended;          /* bit 31 of "ptr" (previous field) */
/*    sign-extended                                                         */
    } bck$pointer;
struct bck64$descriptor {
    unsigned short int bckdsc64$w_mbo;  /* Must Be == 1                     */
    unsigned char bckdsc64$b_dtype;
    unsigned char bckdsc64$b_class;
    int bckdsc64$l_mbmo;                /* Must_Be_MINUS_ONE (-1)           */
    unsigned int bckdsc64$q_length [2]; /* 64-bit length                    */
    bck$pointer bckdsc64$r_pointer;     /* 64-bit address/pointer           */
    } ;
typedef struct _bckEvent {
    struct dsc$descriptor bckevt_r_event_buffer; /* pointer to the event data */
    unsigned int bckevt_l_event_type;   /* type of event                    */
    unsigned int bckevt_l_event_subtype; /* Additional event specifiers     */
    unsigned int bckevt_q_event_ctx [2]; /* (reserved for future use)       */
    unsigned int bckevt_l_event_handle; /* (reserved for future use)        */
    } bckEvent;
/*                                                                          */
/*  BACKUP Operation Event Types                                            */
/*                                                                          */
#define BCK_K_EVENT_MIN 1
#define BCK_EVENT_K_CONTROL 1
#define BCK_EVENT_K_ERROR_MSG 2
#define BCK_EVENT_K_FILE_OPEN 3
#define BCK_EVENT_K_FILE_READ 4
#define BCK_EVENT_K_FILE_WRITE 5
#define BCK_EVENT_K_FILE_CLOSE 6
#define BCK_EVENT_K_JOURNAL_OPEN 7
#define BCK_EVENT_K_JOURNAL_WRITE 8
#define BCK_EVENT_K_JOURNAL_CLOSE 9
#define BCK_EVENT_K_LIST_OPEN 10
#define BCK_EVENT_K_LIST_WRITE 11
#define BCK_EVENT_K_LISTJOUR_WRITE 12
#define BCK_EVENT_K_LIST_CLOSE 13
#define BCK_EVENT_K_LOG 14
#define BCK_EVENT_K_OP_PHASE 15
#define BCK_EVENT_K_SAVESET_OPEN 16
#define BCK_EVENT_K_SAVESET_READ 17
#define BCK_EVENT_K_SAVESET_WRITE 18
#define BCK_EVENT_K_SAVESET_CLOSE 19
#define BCK_EVENT_K_STATISTICS 20
#define BCK_EVENT_K_USER_MSG 21
/*! Start for New callback event by R.Sato                                  */
#define BCK_EVENT_K_CONVERT_FILENAME 22
/*! End for New callback event by R.Sato                                    */
#define BCK_K_EVENT_MAX 22
#define BCK_K_EVENT_ALL -1
/*                                                                          */
/*  BACKUP Operation Event Type MASK def's                                  */
/*                                                                          */
#define BCK_EVENT_M_CONTROL 0x1
#define BCK_EVENT_M_ERROR_MSG 0x2
#define BCK_EVENT_M_FILE_OPEN 0x4
#define BCK_EVENT_M_FILE_READ 0x8
#define BCK_EVENT_M_FILE_WRITE 0x10
#define BCK_EVENT_M_FILE_CLOSE 0x20
#define BCK_EVENT_M_JOURNAL_OPEN 0x40
#define BCK_EVENT_M_JOURNAL_WRITE 0x80
#define BCK_EVENT_M_JOURNAL_CLOSE 0x100
#define BCK_EVENT_M_LIST_OPEN 0x200
#define BCK_EVENT_M_LIST_WRITE 0x400
#define BCK_EVENT_M_LISTJOUR_WRITE 0x800
#define BCK_EVENT_M_LIST_CLOSE 0x1000
#define BCK_EVENT_M_LOG 0x2000
#define BCK_EVENT_M_OP_PHASE 0x4000
#define BCK_EVENT_M_SAVESET_OPEN 0x8000
#define BCK_EVENT_M_SAVESET_READ 0x10000
#define BCK_EVENT_M_SAVESET_WRITE 0x20000
#define BCK_EVENT_M_SAVESET_CLOSE 0x40000
#define BCK_EVENT_M_STATISTICS 0x80000
#define BCK_EVENT_M_USER_MSG 0x100000
#define BCK_EVENT_M_CONVERT_FILENAME 0x200000
#define BCK_EVENT_M_ALL 0x400000
union fill_0_ {
    unsigned int BCK_EVENT_l_bckEvtMask;
    struct  {
        unsigned BCK_EVENT_V_CONTROL : 1;
        unsigned BCK_EVENT_V_ERROR_MSG : 1;
        unsigned BCK_EVENT_V_FILE_OPEN : 1;
        unsigned BCK_EVENT_V_FILE_READ : 1;
        unsigned BCK_EVENT_V_FILE_WRITE : 1;
        unsigned BCK_EVENT_V_FILE_CLOSE : 1;
        unsigned BCK_EVENT_V_JOURNAL_OPEN : 1;
        unsigned BCK_EVENT_V_JOURNAL_WRITE : 1;
        unsigned BCK_EVENT_V_JOURNAL_CLOSE : 1;
        unsigned BCK_EVENT_V_LIST_OPEN : 1;
        unsigned BCK_EVENT_V_LIST_WRITE : 1;
        unsigned BCK_EVENT_V_LISTJOUR_WRITE : 1;
        unsigned BCK_EVENT_V_LIST_CLOSE : 1;
        unsigned BCK_EVENT_V_LOG : 1;
        unsigned BCK_EVENT_V_OP_PHASE : 1;
        unsigned BCK_EVENT_V_SAVESET_OPEN : 1;
        unsigned BCK_EVENT_V_SAVESET_READ : 1;
        unsigned BCK_EVENT_V_SAVESET_WRITE : 1;
        unsigned BCK_EVENT_V_SAVESET_CLOSE : 1;
        unsigned BCK_EVENT_V_STATISTICS : 1;
        unsigned BCK_EVENT_V_USER_MSG : 1;
/*! Start for New callback event by R.Sato                                  */
        unsigned BCK_EVENT_V_CONVERT_FILENAME : 1;
/*! End for New callback event by R.Sato                                    */
        unsigned BCK_EVENT_V_ALL : 1;
        unsigned BCK_EVENT_V_FILL_2_ : 1;
        } BCK_EVENT_r_fill_1_;
    } ;
/*                                                                          */
/*  BACKUP Operation Event Subtypes                                         */
/*                                                                          */
#define BCKEVTST_K_MIN_EVENT 1
#define BCKEVTST_K_CONFIRM_EVENT 1
#define BCKEVTST_K_ASSIST_EVENT 2
#define BCKEVTST_K_RESTART_EVENT 3
#define BCKEVTST_K_MAX_EVENT 1
/*                                                                          */
/*  Journal List Information                                                */
/*                                                                          */
typedef struct _bckLisJourblk {
    struct dsc$descriptor bck_R_LJ_SS_Name; /* [Current] Saveset Filename   */
    unsigned int bck_Q_LJ_SS_Date [2];  /*  " Saveset Creation Date         */
    struct dsc$descriptor bck_R_LJ_Vol_Name; /* [Current] Volume Name       */
    unsigned int bck_L_LJ_Vol_Number;   /*  " Relative Volume Number        */
    } bckLisJourblk;
/*                                                                          */
/*  BACKUP API Message structure definitions                                */
/*                                                                          */
#define BCKMSGDESC_HDR_SIZE 8
typedef struct _bckMsgDesc {            /* User-Supplied Message Descriptor */
    unsigned int msg_code;              /* Error/condition value            */
    unsigned short int FAOarg_count;    /* Number of FAO parameters         */
    unsigned short int new_msg_options; /* Message options for the current msg. */
    unsigned int FAO_param [8];
    } bckMsgDesc;
/* FAO parameters (<9 for backup msgs)                                      */
#define BCKMSGVECT_HDR_SIZE 4
typedef struct _bckMsgVect {            /* Std. Message Argument Vector     */
    unsigned short int bckMsgVect_argcnt; /* Number of msg descriptors      */
    unsigned short int bckMsgVect_defmsgopts; /* Default message options    */
    bckMsgDesc bckMsgVect_msgdescs [2]; /* VARIABLE LENGTH array            */
/* (used [2] for C compiler compatibility)                                  */
    } bckMsgVect;
/*                                                                          */
/*  BACKUP API Control definitions                                          */
/*                                                                          */
#define bckCntrl_m_response_required 0x1
typedef struct _bckControl {
    unsigned int bckCntrl_l_event;      /* control event type               */
    unsigned int bckCntrl_l_function;   /* backup operation type            */
    bckMsgVect *bckCntrl_a_outmsgvect;  /* output messages and parameters   */
    union  {
        unsigned int bckCntrl_l_ctlflags; /* flags                          */
        struct  {
            unsigned bckCntrl_v_response_required : 1; /* response required = 1 */
            unsigned bckCntrl_v_fill_5_ : 7;
            } bckCntrl_r_fill_4_;
        } bckCntrl_r_fill_3_;
    struct dsc$descriptor bckCntrl_r_response_buffer; /* desc. for buffer to which  */
/*   response text is to be written                                         */
    unsigned int bckCntrl_l_response_status; /* (reserved for future use)   */
    unsigned int bckCntrl_l_control_options; /* (reserved for future use)   */
    } bckControl;
/*                                                                          */
/*  BACKUP Operation Control Event Types                                    */
/*                                                                          */
#define BCKCNTRL_K_MIN_EVENT 1
#define BCKCNTRL_K_CONFIRM_EVENT 1
#define BCKCNTRL_K_OPER_ASSIST_EVENT 2
#define BCKCNTRL_K_USER_ASSIST_EVENT 4
#define BCKCNTRL_K_RESTART_EVENT 8
#define BCKCNTRL_K_MAX_EVENT 8
/*                                                                          */
/*  backup operation type definitions                                       */
/*                                                                          */
#define BCK_OP_K_MIN 1
#define BCK_OP_K_SAVE 1
#define BCK_OP_K_RESTORE 2
#define BCK_OP_K_COPY 4
#define BCK_OP_K_LIST 8
#define BCK_OP_K_COMPARE 16
#define BCK_OP_K_MAX 16
#define BCK_K_OP_MASK 31
/*                                                                          */
/*  arg buffer items/options                                                */
/*                                                                          */
#define BCK_OPT_K_BCK_K_OPT_MIN 0
/*                                                                          */
/*  NEVER REMOVE from the following list !!! (obsolete items will be denoted) */
/*                                                                          */
/*  Always ADD items to the END of the following list !!!                   */
/*	(To maintain interface compatibility with prior versions)           */
/*                                                                          */
#define BCK_OPT_K_END_OPT 0
#define BCK_OPT_K_ALIAS 1
#define BCK_OPT_K_ASSIST 2
#define BCK_OPT_K_BACKUP 3
#define BCK_OPT_K_BEFORE_TYPE 4
/*    before_backup			    usage is /BEFORE=BACKUP         */
#define BCK_OPT_K_BEFORE_VALUE 5
#define BCK_OPT_K_BLOCK 6
/*    block_value                                                           */
#define BCK_OPT_K_CREATED 7
#define BCK_OPT_K_CARTRIDGE_MEDIA_IN 8
#define BCK_OPT_K_CARTRIDGE_NAME_IN 9
#define BCK_OPT_K_CARTRIDGE_SIDE_IN 10
#define BCK_OPT_K_CARTRIDGE_MEDIA_OUT 11
#define BCK_OPT_K_CARTRIDGE_NAME_OUT 12
#define BCK_OPT_K_CARTRIDGE_SIDE_OUT 13
#define BCK_OPT_K_COMMAND 14
#define BCK_OPT_K_COMMENT 15
#define BCK_OPT_K_COMPARE 16
#define BCK_OPT_K_CONFIRM 17
#define BCK_OPT_K_CRC 18
#define BCK_OPT_K_DELETE 19
#define BCK_OPT_K_DENSITY 20
#define BCK_OPT_K_DISMOUNT 21
/* Note:                                                                    */
/* Dismount is _NOT_ supported and _NOT_ implemented, (ignored),            */
/* but is included here as a place-holder.                                  */
#define BCK_OPT_K_DISPOSITION 22
/*    disp_keep                                                             */
/*    disp_release                                                          */
#define BCK_OPT_K_DRIVE_CLASS_IN 23
#define BCK_OPT_K_DRIVE_CLASS_OUT 24
#define BCK_OPT_K_ENCRYPT 25
#define BCK_OPT_K_ENCRYPT_USERALG 26
#define BCK_OPT_K_ENCRYPT_USERKEY 27
#define BCK_OPT_K_ENCRYPT_KEY_VALUE 28
#define BCK_OPT_K_EVENT_CALLBACK 29
#define BCK_OPT_K_EXACT_ORDER 30
#define BCK_OPT_K_EXCLUDE 31
#define BCK_OPT_K_EXPIRED 32
#define BCK_OPT_K_FAST 33
#define BCK_OPT_K_FILE_CALLBACK 34
/* Note:                                                                    */
/* File_callback is _NOT_ implemented, but is included here as a place-holder. */
/*                                                                          */
#define BCK_OPT_K_FILEMERGE 35
/* Note:                                                                    */
/* Filemerge is _NOT_ supported and _NOT_ implemented,                      */
/* but is included here as a place-holder.                                  */
/*                                                                          */
#define BCK_OPT_K_FULL 36
#define BCK_OPT_K_GROUP 37
#define BCK_OPT_K_HANDLE 38
#define BCK_OPT_K_IGNORE_TYPES 39
/*    ignore_access                                                         */
/*    ignore_interlock                                                      */
/*    ignore_label                                                          */
/*    ignore_nobackup                                                       */
#define BCK_OPT_K_IMAGE 40
#define BCK_OPT_K_INCREMENTAL 41
#define BCK_OPT_K_INITIALIZE 42
#define BCK_OPT_K_INPUT 43
#define BCK_OPT_K_INTERCHANGE 44
#define BCK_OPT_K_JOURNAL 45
#define BCK_OPT_K_JOURNAL_FILE 46
#define BCK_OPT_K_LABEL 47
#define BCK_OPT_K_LIST 48
#define BCK_OPT_K_LIST_FILE 49
#define BCK_OPT_K_LOG 50
#define BCK_OPT_K_MEDIA_FORMAT 51
/*    media_compaction                                                      */
/*    media_no_compaction                                                   */
#define BCK_OPT_K_MODIFIED 52
#define BCK_OPT_K_NEW_VERSION 53
#define BCK_OPT_K_OPERATION_TYPE 54
/*    compare                                                               */
/*    copy                                                                  */
/*    list                                                                  */
/*    save                                                                  */
/*    restore                                                               */
#define BCK_OPT_K_OUTPUT 55
#define BCK_OPT_K_OVERLAY 56
#define BCK_OPT_K_OWNER_IN_VALUE 57
/*    own_uic (value or default)                                            */
#define BCK_OPT_K_OWNER_OUT_TYPE 58
/*    own_default                                                           */
/*    own_original                                                          */
/*    own_parent                                                            */
/*    own_uic                                                               */
#define BCK_OPT_K_OWNER_OUT_VALUE 59
#define BCK_OPT_K_PHYSICAL 60
#define BCK_OPT_K_PROTECTION 61
#define BCK_OPT_K_RECORD 62
#define BCK_OPT_K_RELEASE_TAPE 63
#define BCK_OPT_K_REPLACE 64
/*    rewind is now obsolete, please use either REWIND_IN or REWIND_OUT.    */
#define BCK_OPT_K_REWIND 65
/*    rewind is now obsolete, please use either REWIND_IN or REWIND_OUT.    */
#define BCK_OPT_K_REWIND_IN 66
#define BCK_OPT_K_REWIND_OUT 67
#define BCK_OPT_K_SAVE_SET_IN 68
#define BCK_OPT_K_SAVE_SET_OUT 69
#define BCK_OPT_K_SCRATCH_ASGN_TYPE 70
#define BCK_OPT_K_SCRATCH_COLLECTION 71
#define BCK_OPT_K_SCRATCH_LOCATION 72
#define BCK_OPT_K_SCRATCH_MEDIA_NAME 73
#define BCK_OPT_K_SELECT 74
#define BCK_OPT_K_SINCE_TYPE 75
/*    since_backup			    usage is /SINCE=BACKUP          */
#define BCK_OPT_K_SINCE_VALUE 76
#define BCK_OPT_K_STORAGE_MANAGEMENT 77
#define BCK_OPT_K_TAPE_EXPIRATION 78
#define BCK_OPT_K_TRUNCATE 79
#define BCK_OPT_K_VALIDATE_PARAMETERS 80
#define BCK_OPT_K_VERIFY 81
#define BCK_OPT_K_UNSHELVE 82
#define BCK_OPT_K_VOLUME 83
/*                                                                          */
/*  Items added in V7.2                                                     */
/*                                                                          */
#define BCK_OPT_K_SNAPSHOT 84
#define BCK_OPT_K_CONVERT 85
#define BCK_OPT_K_MT3_DENSITY 86
/*                                                                          */
/*  Items added *after* V7.2 for HSM support                                */
/*  Changed HSM to HSMHEADER_ONLY                                           */
/*  HSM was never used so I changed it because                              */
/*  HSMHEADER_ONLY does the same thing that HSM was suppose                 */
/*  to do                                                                   */
#define BCK_OPT_K_HSMHEADER_ONLY 87
/* Changed OPTIONS_IN AND OPTIONS_OUT to /HSMOPTIONS_*                      */
/* they were not used before and I put am using /HSMOPTIONS                 */
/* for the qualifier so we do not waste a good /OPTIONS qualifier           */
#define BCK_OPT_K_HSMOPTIONS_IN 88
#define BCK_OPT_K_HSMOPTIONS_OUT 89
#define BCK_OPT_K_PRESHELVED 90
#define BCK_OPT_K_SHELVED 91
/* Item added for /FILES_SELECTED and /INPUT_FILES                          */
#define BCK_OPT_K_FILES_SELECTED_IN 92
#define BCK_OPT_K_INPUT_FILES_IN 93
#define BCK_OPT_K_DVE_LIMIT 94
#define BCK_OPT_K_DVE_SIZE 95
#define BCK_OPT_K_IO_LOAD 96
#define BCK_OPT_K_PROGRESS 97
#define BCK_OPT_K_REPAIR 98
#define BCK_OPT_K_DATA_FORMAT 99
#define BCK_OPT_K_DATA_FORMAT_COMPRESS 100
#define BCK_OPT_K_NOCONVERT 101
#define BCK_OPT_K_WINDOW_TYPES 102
/* window_full                                                              */
/* window_limited                                                           */
/*                                                                          */
/*  NEVER REMOVE items from the above list !!!                              */
/*	(obsolete items will be denoted)                                    */
/*                                                                          */
/*  Always ADD items to the END of the above list !!!                       */
/*	(To maintain interface compatibility with prior versions)           */
/*                                                                          */
#define BCK_K_OPT_MAX 102
/*                                                                          */
/*  Flag Definitions for various Types of Options                           */
/*                                                                          */
#define BCK_OPTYP_BEFORE_K_BACKUP 1     /*usage is /BEFORE=BACKUP           */
#define BCK_K_OPTYP_BEFORE_MASK 1
#define BCK_OPTYP_RELTAPE_K_NONE 0
#define BCK_OPTYP_RELTAPE_K_UNLOAD 1
#define BCK_OPTYP_RELTAPE_K_NO_UNLOAD 2
#define BCK_OPTYP_DISMOU_K_UNLOAD 1
#define BCK_OPTYP_DISMOU_K_NO_UNLOAD 2
#define BCK_OPTYP_DISP_K_KEEP 1
#define BCK_OPTYP_DISP_K_RELEASE 2
#define BCK_OPTYP_IGNORE_K_NOBACKUP 1
#define BCK_OPTYP_IGNORE_K_INTERLOCK 2
#define BCK_OPTYP_IGNORE_K_LABELS 4
#define BCK_OPTYP_IGNORE_K_ACCESS 8
#define BCK_OPTYP_IGNORE_K_LIMIT 1024
#define BCK_K_OPTYP_IGNORE_MASK 2047
#define BCK_OPTYP_MEDIA_K_COMPACTION 1
#define BCK_OPTYP_MEDIA_K_NO_COMPACTION 2
#define BCK_OPTYP_OWN_OUT_K_DEFAULT 1
#define BCK_OPTYP_OWN_OUT_K_ORIGINAL 2
#define BCK_OPTYP_OWN_OUT_K_PARENT 3
#define BCK_OPTYP_OWN_OUT_K_UIC 4
#define BCK_OPTYP_SCR_ASGN_K_BASE 1
#define BCK_OPTYP_SCR_ASGN_K_COMPOUND 2
#define BCK_OPTYP_SCR_ASGN_K_PREASGN 4
#define BCK_OPTYP_SCR_ASGN_K_SIDE 8
#define BCK_K_OPTYP_SCR_ASGN_MASK 15
#define BCK_OPTYP_SINCE_K_BACKUP 1      /*usage is /SINCE=BACKUP            */
#define BCK_K_OPTYP_SINCE_MASK 1
#define BCK_OPTYP_WINDOW_K_FULL 1
#define BCK_OPTYP_WINDOW_K_LIMITED 2
/*	*** RESERVED FOR POSSIBLE FUTURE USE ***                            */
/*  File name string format flags, (used to indicate non-escaped/non-generated  */
/*	file name strings that are compatible with QIO parameter calls).    */
/*                                                                          */
#define BCK_FNSTR_K_ODS2 1
#define BCK_FNSTR_K_EXTENDED 2
#define BCK_FNSTR_K_UCS2 4
#define BCK_K_FNSTR_MASK 7
/*                                                                          */
/*  Backup Option Structures, (used to specify backup operation attributes). */
/*                                                                          */
#define bck_opt_struct_flag_k_len 8
typedef struct _bck_opt_struct_flag {
    unsigned int option_type;           /* type of option/operation         */
    unsigned int opt_flag_value;        /* option flag(s)                   */
    } bck_opt_struct_flag;
#define bck_opt_struct_int_k_len 16
typedef struct _bck_opt_struct_int {
    unsigned int opt_int_type;          /* type of option/operation         */
    unsigned int int_filler;            /* (Quadword alignment filler)      */
    unsigned int opt_int_value [2];     /* 64-bit/32-bit integer            */
/* Note: the 32-bit integer should be                                       */
/* sign-extended into 2nd longword                                          */
    } bck_opt_struct_int;
#define bck_opt_struct_adr_k_len 16
typedef struct _bck_opt_struct_adr {
    unsigned int opt_adr_type;          /* type of option/operation         */
    unsigned int opt_adr_attributes;    /* Address Attributes (uses)        */
    int *opt_adr_value [2];             /* 64-bit/32-bit address            */
/* Note: the 32-bit address should be                                       */
/* sign-extended into 2nd longword                                          */
    } bck_opt_struct_adr;
#define bck_opt_struct_dsc_k_len 16
typedef struct _bck_opt_struct_dsc {
    unsigned int opt_dsc_type;          /* type of option/operation         */
    unsigned int dsc_flags;             /* Flags & Quadword alignment       */
    struct dsc$descriptor opt_dsc;      /* 32-bit string descriptor         */
    } bck_opt_struct_dsc;
#define bck_opt_struct_dsc_k_len64 32
typedef struct _bck_opt_struct_dsc64 {
    unsigned int opt_dsc64_type;        /* type of option/operation         */
    unsigned int dsc64_flags;           /* Flags & Quadword alignment       */
    struct bck64$descriptor opt_dsc64;  /* 64-bit string descriptor         */
    } bck_opt_struct_dsc64;
#define bck_opt_struct_dt_k_len 16
typedef struct _bck_opt_struct_dt {
    unsigned int opt_adt_type;          /* type of option/operation         */
    unsigned int adt_filler;            /* (Quadword alignment filler)      */
    unsigned int opt_adt_value [2];     /* date-time (ADT)                  */
    } bck_opt_struct_dt;
 
#pragma __member_alignment __restore
