 !
 !*************************************************************************
 !*                                                                       *
 !*  Copyright 2010, Hewlett-Packard Development Company, L.P.           *
 !*                                                                       *
 !* Confidential computer software.  Valid license from HP and/or         *
 !* its subsidiaries required for possession, use, or copying.            *
 !*                                                                       *
 !* Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *
 !* Computer Software Documentation, and Technical Data for Commercial    *
 !* Items are licensed to the U.S. Government under vendor's standard     *
 !* commercial license.                                                   *
 !*                                                                       *
 !* Neither HP nor any of its subsidiaries shall be liable for technical  *
 !* or editorial errors or omissions contained herein.  The information   *
 !* in this document is provided "as is" without warranty of any kind and *
 !* is subject to change without notice.  The warranties for HP products  *
 !* are set forth in the express limited warranty statements accompanying *
 !* such products.  Nothing herein should be construed as constituting an *
 !* additional warranty.                                                  *
 !*                                                                       *
 !*************************************************************************
 !********************************************************************************************************************************
 ! Created: 30-Mar-2010 17:26:04 by OpenVMS SDL EV3-3      
 ! Source:  13-FEB-2008 00:08:30 $1$DGA7274:[BACKUP.SRC]BAPIDEF.SDL;1 
 !********************************************************************************************************************************
      ! *** PREDECLARED TYPES
     
      %IF %DECLARED(%BASIC$QUADWORD_DECLARED) = 0 %THEN
         RECORD BASIC$QUADWORD
            LONG FILL(2)
         END RECORD
         %LET %BASIC$QUADWORD_DECLARED = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$OCTAWORD_DECLARED) = 0 %THEN
         RECORD BASIC$OCTAWORD
            LONG FILL(4)
         END RECORD
         %LET %BASIC$OCTAWORD_DECLARED = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$HFLOAT_AXP_DECLARED) = 0 %THEN
         RECORD BASIC$HFLOAT_AXP
            LONG FILL(4)
         END RECORD
         %LET %BASIC$HFLOAT_AXP_DECLARED = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$F_FLOATING_COMPLEX_DECL) = 0 %THEN
         RECORD BASIC$F_FLOATING_COMPLEX
            SINGLE REAL_PART
            SINGLE IMAGINARY_PART
         END RECORD
         %LET %BASIC$F_FLOATING_COMPLEX_DECL = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$D_FLOATING_COMPLEX_DECL) = 0 %THEN
         RECORD BASIC$D_FLOATING_COMPLEX
            DOUBLE REAL_PART
            DOUBLE IMAGINARY_PART
         END RECORD
         %LET %BASIC$D_FLOATING_COMPLEX_DECL = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$G_FLOATING_COMPLEX_DECL) = 0 %THEN
         RECORD BASIC$G_FLOATING_COMPLEX
            GFLOAT REAL_PART
            GFLOAT IMAGINARY_PART
         END RECORD
         %LET %BASIC$G_FLOATING_COMPLEX_DECL = 1
      %END %IF
     
      %IF %DECLARED(%BASIC$H_FLOAT_AXP_CMPLX_DCL) = 0 %THEN
         RECORD BASIC$H_FLOATING_COMPLEX_AXP
            BASIC$HFLOAT_AXP REAL_PART
            BASIC$HFLOAT_AXP IMAGINARY_PART
         END RECORD
         %LET %BASIC$H_FLOAT_AXP_CMPLX_DCL = 1
      %END %IF
     
    
    !*** MODULE bckapidef IDENT X-18 ***
    
    
      DECLARE LONG CONSTANT s_bck$pointer = 8
      record bck$pointer
         LONG string_ptr                    !  32/64-bit compatible address/pointer
         LONG ptr_extended                  !  bit 31 of "ptr" (previous field)
    !     sign-extended
      end record bck$pointer
    
      DECLARE LONG CONSTANT bckdsc64$s_bck64$descriptor = 24
      record bck64$descriptor
         WORD bckdsc64$w_mbo                !  Must Be == 1
         BYTE bckdsc64$b_dtype
         BYTE bckdsc64$b_class
         LONG bckdsc64$l_mbmo               !  Must_Be_MINUS_ONE (-1)
         BASIC$QUADWORD bckdsc64$q_length   !  64-bit length
         bck$pointer bckdsc64$r_pointer     !  64-bit address/pointer
      end record bck64$descriptor
    
      DECLARE LONG CONSTANT bckevt_s_bckEvent = 28
      record bckEvent
         dsc$descriptor bckevt_r_event_buffer  !  pointer to the event data
         LONG bckevt_l_event_type           !  type of event 
         LONG bckevt_l_event_subtype        !  Additional event specifiers 
         BASIC$QUADWORD bckevt_q_event_ctx  !  (reserved for future use)
         LONG bckevt_l_event_handle         !  (reserved for future use)
      end record bckEvent
    
    ! 
    !   BACKUP Operation Event Types
    ! 
      DECLARE LONG CONSTANT BCK_K_EVENT_MIN = 1
      DECLARE LONG CONSTANT BCK_EVENT_K_CONTROL = 1
      DECLARE LONG CONSTANT BCK_EVENT_K_ERROR_MSG = 2
      DECLARE LONG CONSTANT BCK_EVENT_K_FILE_OPEN = 3
      DECLARE LONG CONSTANT BCK_EVENT_K_FILE_READ = 4
      DECLARE LONG CONSTANT BCK_EVENT_K_FILE_WRITE = 5
      DECLARE LONG CONSTANT BCK_EVENT_K_FILE_CLOSE = 6
      DECLARE LONG CONSTANT BCK_EVENT_K_JOURNAL_OPEN = 7
      DECLARE LONG CONSTANT BCK_EVENT_K_JOURNAL_WRITE = 8
      DECLARE LONG CONSTANT BCK_EVENT_K_JOURNAL_CLOSE = 9
      DECLARE LONG CONSTANT BCK_EVENT_K_LIST_OPEN = 10
      DECLARE LONG CONSTANT BCK_EVENT_K_LIST_WRITE = 11
      DECLARE LONG CONSTANT BCK_EVENT_K_LISTJOUR_WRITE = 12
      DECLARE LONG CONSTANT BCK_EVENT_K_LIST_CLOSE = 13
      DECLARE LONG CONSTANT BCK_EVENT_K_LOG = 14
      DECLARE LONG CONSTANT BCK_EVENT_K_OP_PHASE = 15
      DECLARE LONG CONSTANT BCK_EVENT_K_SAVESET_OPEN = 16
      DECLARE LONG CONSTANT BCK_EVENT_K_SAVESET_READ = 17
      DECLARE LONG CONSTANT BCK_EVENT_K_SAVESET_WRITE = 18
      DECLARE LONG CONSTANT BCK_EVENT_K_SAVESET_CLOSE = 19
      DECLARE LONG CONSTANT BCK_EVENT_K_STATISTICS = 20
      DECLARE LONG CONSTANT BCK_EVENT_K_USER_MSG = 21
    ! ? Start for New callback event by R.Sato
      DECLARE LONG CONSTANT BCK_EVENT_K_CONVERT_FILENAME = 22
    ! ? End for New callback event by R.Sato
      DECLARE LONG CONSTANT BCK_K_EVENT_MAX = 22
      DECLARE LONG CONSTANT BCK_K_EVENT_ALL = -1
    ! 
    !   BACKUP Operation Event Type MASK def's
    ! 
      DECLARE LONG CONSTANT BCK_EVENT_M_CONTROL = x'00000001'
      DECLARE LONG CONSTANT BCK_EVENT_M_ERROR_MSG = x'00000002'
      DECLARE LONG CONSTANT BCK_EVENT_M_FILE_OPEN = x'00000004'
      DECLARE LONG CONSTANT BCK_EVENT_M_FILE_READ = x'00000008'
      DECLARE LONG CONSTANT BCK_EVENT_M_FILE_WRITE = x'00000010'
      DECLARE LONG CONSTANT BCK_EVENT_M_FILE_CLOSE = x'00000020'
      DECLARE LONG CONSTANT BCK_EVENT_M_JOURNAL_OPEN = x'00000040'
      DECLARE LONG CONSTANT BCK_EVENT_M_JOURNAL_WRITE = x'00000080'
      DECLARE LONG CONSTANT BCK_EVENT_M_JOURNAL_CLOSE = x'00000100'
      DECLARE LONG CONSTANT BCK_EVENT_M_LIST_OPEN = x'00000200'
      DECLARE LONG CONSTANT BCK_EVENT_M_LIST_WRITE = x'00000400'
      DECLARE LONG CONSTANT BCK_EVENT_M_LISTJOUR_WRITE = x'00000800'
      DECLARE LONG CONSTANT BCK_EVENT_M_LIST_CLOSE = x'00001000'
      DECLARE LONG CONSTANT BCK_EVENT_M_LOG = x'00002000'
      DECLARE LONG CONSTANT BCK_EVENT_M_OP_PHASE = x'00004000'
      DECLARE LONG CONSTANT BCK_EVENT_M_SAVESET_OPEN = x'00008000'
      DECLARE LONG CONSTANT BCK_EVENT_M_SAVESET_READ = x'00010000'
      DECLARE LONG CONSTANT BCK_EVENT_M_SAVESET_WRITE = x'00020000'
      DECLARE LONG CONSTANT BCK_EVENT_M_SAVESET_CLOSE = x'00040000'
      DECLARE LONG CONSTANT BCK_EVENT_M_STATISTICS = x'00080000'
      DECLARE LONG CONSTANT BCK_EVENT_M_USER_MSG = x'00100000'
      DECLARE LONG CONSTANT BCK_EVENT_M_CONVERT_FILENAME = x'00200000'
      DECLARE LONG CONSTANT BCK_EVENT_M_ALL = x'00400000'
      DECLARE LONG CONSTANT BCK_EVENT_s_fill_0_ = 4
      record fill_0_
         variant
            case
               LONG BCK_EVENT_l_bckEvtMask
            case
               group BCK_EVENT_r_fill_1_
    ! ? Start for New callback event by R.Sato
    ! ? End for New callback event by R.Sato
                  LONG CONTROL_bits   ! COMMENT ADDED BY SDL - CONTROL_bits contains bits CONTROL through FILL_2_
               end group BCK_EVENT_r_fill_1_
         end variant
      end record fill_0_
    
    ! 
    !   BACKUP Operation Event Subtypes
    ! 
      DECLARE LONG CONSTANT BCKEVTST_K_MIN_EVENT = 1
      DECLARE LONG CONSTANT BCKEVTST_K_CONFIRM_EVENT = 1
      DECLARE LONG CONSTANT BCKEVTST_K_ASSIST_EVENT = 2
      DECLARE LONG CONSTANT BCKEVTST_K_RESTART_EVENT = 3
      DECLARE LONG CONSTANT BCKEVTST_K_MAX_EVENT = 1
    ! 
    !   Journal List Information 
    ! 
      DECLARE LONG CONSTANT bck_s_bckLisJourblk = 28
      record bckLisJourblk
         dsc$descriptor bck_R_LJ_SS_Name    !  [Current] Saveset Filename
         BASIC$QUADWORD bck_Q_LJ_SS_Date    !   " Saveset Creation Date
         dsc$descriptor bck_R_LJ_Vol_Name   !  [Current] Volume Name
         LONG bck_L_LJ_Vol_Number           !   " Relative Volume Number
      end record bckLisJourblk
    
    ! 
    !   BACKUP API Message structure definitions
    ! 
      DECLARE LONG CONSTANT BCKMSGDESC_HDR_SIZE = 8
      DECLARE LONG CONSTANT s_bckMsgDesc = 40
      record bckMsgDesc                     !  User-Supplied Message Descriptor
         LONG msg_code                      !  Error/condition value
         WORD FAOarg_count                  !  Number of FAO parameters
         WORD new_msg_options               !  Message options for the current msg.
         LONG FAO_param(1 to 8)
      end record bckMsgDesc
    
    !  FAO parameters (<9 for backup msgs)
      DECLARE LONG CONSTANT BCKMSGVECT_HDR_SIZE = 4
      DECLARE LONG CONSTANT s_bckMsgVect = 84
      record bckMsgVect                     !  Std. Message Argument Vector
         WORD bckMsgVect_argcnt             !  Number of msg descriptors
         WORD bckMsgVect_defmsgopts         !  Default message options
         bckMsgDesc bckMsgVect_msgdescs(1 to 2)  !  VARIABLE LENGTH array
    !  (used [2] for C compiler compatibility)
      end record bckMsgVect
    
    ! 
    !   BACKUP API Control definitions
    ! 
      DECLARE LONG CONSTANT bckCntrl_m_response_required = x'00000001'
      DECLARE LONG CONSTANT bckCntrl_s_bckControl = 32
      record bckControl
         LONG bckCntrl_l_event              !  control event type
         LONG bckCntrl_l_function           !  backup operation type 
         LONG bckCntrl_a_outmsgvect         !  output messages and parameters
         group bckCntrl_r_fill_3_
            variant
               case
                  LONG bckCntrl_l_ctlflags  !  flags
               case
                  group bckCntrl_r_fill_4_
                      !  response required = 1
                     BYTE response_required_bits   ! COMMENT ADDED BY SDL - response_required_bits contains bits  &
 ! response_required through fill_5_
                  end group bckCntrl_r_fill_4_
            end variant
         end group bckCntrl_r_fill_3_
         dsc$descriptor bckCntrl_r_response_buffer  !  desc. for buffer to which 
    !    response text is to be written
         LONG bckCntrl_l_response_status    !  (reserved for future use)
         LONG bckCntrl_l_control_options    !  (reserved for future use)
      end record bckControl
    
    ! 
    !   BACKUP Operation Control Event Types
    ! 
      DECLARE LONG CONSTANT BCKCNTRL_K_MIN_EVENT = 1
      DECLARE LONG CONSTANT BCKCNTRL_K_CONFIRM_EVENT = 1
      DECLARE LONG CONSTANT BCKCNTRL_K_OPER_ASSIST_EVENT = 2
      DECLARE LONG CONSTANT BCKCNTRL_K_USER_ASSIST_EVENT = 4
      DECLARE LONG CONSTANT BCKCNTRL_K_RESTART_EVENT = 8
      DECLARE LONG CONSTANT BCKCNTRL_K_MAX_EVENT = 8
    ! 
    !   backup operation type definitions
    ! 
      DECLARE LONG CONSTANT BCK_OP_K_MIN = 1
      DECLARE LONG CONSTANT BCK_OP_K_SAVE = 1
      DECLARE LONG CONSTANT BCK_OP_K_RESTORE = 2
      DECLARE LONG CONSTANT BCK_OP_K_COPY = 4
      DECLARE LONG CONSTANT BCK_OP_K_LIST = 8
      DECLARE LONG CONSTANT BCK_OP_K_COMPARE = 16
      DECLARE LONG CONSTANT BCK_OP_K_MAX = 16
      DECLARE LONG CONSTANT BCK_K_OP_MASK = 31
    ! 
    !   arg buffer items/options
    ! 
      DECLARE LONG CONSTANT BCK_OPT_K_BCK_K_OPT_MIN = 0
    ! 
    !   NEVER REMOVE from the following list ??? (obsolete items will be denoted)
    ! 
    !   Always ADD items to the END of the following list ???
    ! 	(To maintain interface compatibility with prior versions)
    ! 
      DECLARE LONG CONSTANT BCK_OPT_K_END_OPT = 0
      DECLARE LONG CONSTANT BCK_OPT_K_ALIAS = 1
      DECLARE LONG CONSTANT BCK_OPT_K_ASSIST = 2
      DECLARE LONG CONSTANT BCK_OPT_K_BACKUP = 3
      DECLARE LONG CONSTANT BCK_OPT_K_BEFORE_TYPE = 4
    !     before_backup			    usage is /BEFORE=BACKUP
      DECLARE LONG CONSTANT BCK_OPT_K_BEFORE_VALUE = 5
      DECLARE LONG CONSTANT BCK_OPT_K_BLOCK = 6
    !     block_value
      DECLARE LONG CONSTANT BCK_OPT_K_CREATED = 7
      DECLARE LONG CONSTANT BCK_OPT_K_CARTRIDGE_MEDIA_IN = 8
      DECLARE LONG CONSTANT BCK_OPT_K_CARTRIDGE_NAME_IN = 9
      DECLARE LONG CONSTANT BCK_OPT_K_CARTRIDGE_SIDE_IN = 10
      DECLARE LONG CONSTANT BCK_OPT_K_CARTRIDGE_MEDIA_OUT = 11
      DECLARE LONG CONSTANT BCK_OPT_K_CARTRIDGE_NAME_OUT = 12
      DECLARE LONG CONSTANT BCK_OPT_K_CARTRIDGE_SIDE_OUT = 13
      DECLARE LONG CONSTANT BCK_OPT_K_COMMAND = 14
      DECLARE LONG CONSTANT BCK_OPT_K_COMMENT = 15
      DECLARE LONG CONSTANT BCK_OPT_K_COMPARE = 16
      DECLARE LONG CONSTANT BCK_OPT_K_CONFIRM = 17
      DECLARE LONG CONSTANT BCK_OPT_K_CRC = 18
      DECLARE LONG CONSTANT BCK_OPT_K_DELETE = 19
      DECLARE LONG CONSTANT BCK_OPT_K_DENSITY = 20
      DECLARE LONG CONSTANT BCK_OPT_K_DISMOUNT = 21
    !  Note:
    !  Dismount is _NOT_ supported and _NOT_ implemented, (ignored),
    !  but is included here as a place-holder.
      DECLARE LONG CONSTANT BCK_OPT_K_DISPOSITION = 22
    !     disp_keep
    !     disp_release
      DECLARE LONG CONSTANT BCK_OPT_K_DRIVE_CLASS_IN = 23
      DECLARE LONG CONSTANT BCK_OPT_K_DRIVE_CLASS_OUT = 24
      DECLARE LONG CONSTANT BCK_OPT_K_ENCRYPT = 25
      DECLARE LONG CONSTANT BCK_OPT_K_ENCRYPT_USERALG = 26
      DECLARE LONG CONSTANT BCK_OPT_K_ENCRYPT_USERKEY = 27
      DECLARE LONG CONSTANT BCK_OPT_K_ENCRYPT_KEY_VALUE = 28
      DECLARE LONG CONSTANT BCK_OPT_K_EVENT_CALLBACK = 29
      DECLARE LONG CONSTANT BCK_OPT_K_EXACT_ORDER = 30
      DECLARE LONG CONSTANT BCK_OPT_K_EXCLUDE = 31
      DECLARE LONG CONSTANT BCK_OPT_K_EXPIRED = 32
      DECLARE LONG CONSTANT BCK_OPT_K_FAST = 33
      DECLARE LONG CONSTANT BCK_OPT_K_FILE_CALLBACK = 34
    !  Note:
    !  File_callback is _NOT_ implemented, but is included here as a place-holder.
    ! 
      DECLARE LONG CONSTANT BCK_OPT_K_FILEMERGE = 35
    !  Note:
    !  Filemerge is _NOT_ supported and _NOT_ implemented,
    !  but is included here as a place-holder.
    ! 
      DECLARE LONG CONSTANT BCK_OPT_K_FULL = 36
      DECLARE LONG CONSTANT BCK_OPT_K_GROUP = 37
      DECLARE LONG CONSTANT BCK_OPT_K_HANDLE = 38
      DECLARE LONG CONSTANT BCK_OPT_K_IGNORE_TYPES = 39
    !     ignore_access
    !     ignore_interlock
    !     ignore_label
    !     ignore_nobackup
      DECLARE LONG CONSTANT BCK_OPT_K_IMAGE = 40
      DECLARE LONG CONSTANT BCK_OPT_K_INCREMENTAL = 41
      DECLARE LONG CONSTANT BCK_OPT_K_INITIALIZE = 42
      DECLARE LONG CONSTANT BCK_OPT_K_INPUT = 43
      DECLARE LONG CONSTANT BCK_OPT_K_INTERCHANGE = 44
      DECLARE LONG CONSTANT BCK_OPT_K_JOURNAL = 45
      DECLARE LONG CONSTANT BCK_OPT_K_JOURNAL_FILE = 46
      DECLARE LONG CONSTANT BCK_OPT_K_LABEL = 47
      DECLARE LONG CONSTANT BCK_OPT_K_LIST = 48
      DECLARE LONG CONSTANT BCK_OPT_K_LIST_FILE = 49
      DECLARE LONG CONSTANT BCK_OPT_K_LOG = 50
      DECLARE LONG CONSTANT BCK_OPT_K_MEDIA_FORMAT = 51
    !     media_compaction
    !     media_no_compaction
      DECLARE LONG CONSTANT BCK_OPT_K_MODIFIED = 52
      DECLARE LONG CONSTANT BCK_OPT_K_NEW_VERSION = 53
      DECLARE LONG CONSTANT BCK_OPT_K_OPERATION_TYPE = 54
    !     compare
    !     copy
    !     list
    !     save
    !     restore
      DECLARE LONG CONSTANT BCK_OPT_K_OUTPUT = 55
      DECLARE LONG CONSTANT BCK_OPT_K_OVERLAY = 56
      DECLARE LONG CONSTANT BCK_OPT_K_OWNER_IN_VALUE = 57
    !     own_uic (value or default)
      DECLARE LONG CONSTANT BCK_OPT_K_OWNER_OUT_TYPE = 58
    !     own_default
    !     own_original
    !     own_parent
    !     own_uic
      DECLARE LONG CONSTANT BCK_OPT_K_OWNER_OUT_VALUE = 59
      DECLARE LONG CONSTANT BCK_OPT_K_PHYSICAL = 60
      DECLARE LONG CONSTANT BCK_OPT_K_PROTECTION = 61
      DECLARE LONG CONSTANT BCK_OPT_K_RECORD = 62
      DECLARE LONG CONSTANT BCK_OPT_K_RELEASE_TAPE = 63
      DECLARE LONG CONSTANT BCK_OPT_K_REPLACE = 64
    !     rewind is now obsolete, please use either REWIND_IN or REWIND_OUT.
      DECLARE LONG CONSTANT BCK_OPT_K_REWIND = 65
    !     rewind is now obsolete, please use either REWIND_IN or REWIND_OUT.
      DECLARE LONG CONSTANT BCK_OPT_K_REWIND_IN = 66
      DECLARE LONG CONSTANT BCK_OPT_K_REWIND_OUT = 67
      DECLARE LONG CONSTANT BCK_OPT_K_SAVE_SET_IN = 68
      DECLARE LONG CONSTANT BCK_OPT_K_SAVE_SET_OUT = 69
      DECLARE LONG CONSTANT BCK_OPT_K_SCRATCH_ASGN_TYPE = 70
      DECLARE LONG CONSTANT BCK_OPT_K_SCRATCH_COLLECTION = 71
      DECLARE LONG CONSTANT BCK_OPT_K_SCRATCH_LOCATION = 72
      DECLARE LONG CONSTANT BCK_OPT_K_SCRATCH_MEDIA_NAME = 73
      DECLARE LONG CONSTANT BCK_OPT_K_SELECT = 74
      DECLARE LONG CONSTANT BCK_OPT_K_SINCE_TYPE = 75
    !     since_backup			    usage is /SINCE=BACKUP
      DECLARE LONG CONSTANT BCK_OPT_K_SINCE_VALUE = 76
      DECLARE LONG CONSTANT BCK_OPT_K_STORAGE_MANAGEMENT = 77
      DECLARE LONG CONSTANT BCK_OPT_K_TAPE_EXPIRATION = 78
      DECLARE LONG CONSTANT BCK_OPT_K_TRUNCATE = 79
      DECLARE LONG CONSTANT BCK_OPT_K_VALIDATE_PARAMETERS = 80
      DECLARE LONG CONSTANT BCK_OPT_K_VERIFY = 81
      DECLARE LONG CONSTANT BCK_OPT_K_UNSHELVE = 82
      DECLARE LONG CONSTANT BCK_OPT_K_VOLUME = 83
    ! 
    !   Items added in V7.2
    ! 
      DECLARE LONG CONSTANT BCK_OPT_K_SNAPSHOT = 84
      DECLARE LONG CONSTANT BCK_OPT_K_CONVERT = 85
      DECLARE LONG CONSTANT BCK_OPT_K_MT3_DENSITY = 86
    ! 
    !   Items added *after* V7.2 for HSM support
    !   Changed HSM to HSMHEADER_ONLY
    !   HSM was never used so I changed it because
    !   HSMHEADER_ONLY does the same thing that HSM was suppose
    !   to do
      DECLARE LONG CONSTANT BCK_OPT_K_HSMHEADER_ONLY = 87
    !  Changed OPTIONS_IN AND OPTIONS_OUT to /HSMOPTIONS_*
    !  they were not used before and I put am using /HSMOPTIONS
    !  for the qualifier so we do not waste a good /OPTIONS qualifier
      DECLARE LONG CONSTANT BCK_OPT_K_HSMOPTIONS_IN = 88
      DECLARE LONG CONSTANT BCK_OPT_K_HSMOPTIONS_OUT = 89
      DECLARE LONG CONSTANT BCK_OPT_K_PRESHELVED = 90
      DECLARE LONG CONSTANT BCK_OPT_K_SHELVED = 91
    !  Item added for /FILES_SELECTED and /INPUT_FILES
      DECLARE LONG CONSTANT BCK_OPT_K_FILES_SELECTED_IN = 92
      DECLARE LONG CONSTANT BCK_OPT_K_INPUT_FILES_IN = 93
      DECLARE LONG CONSTANT BCK_OPT_K_DVE_LIMIT = 94
      DECLARE LONG CONSTANT BCK_OPT_K_DVE_SIZE = 95
      DECLARE LONG CONSTANT BCK_OPT_K_IO_LOAD = 96
      DECLARE LONG CONSTANT BCK_OPT_K_PROGRESS = 97
      DECLARE LONG CONSTANT BCK_OPT_K_REPAIR = 98
      DECLARE LONG CONSTANT BCK_OPT_K_DATA_FORMAT = 99
      DECLARE LONG CONSTANT BCK_OPT_K_DATA_FORMAT_COMPRESS = 100
      DECLARE LONG CONSTANT BCK_OPT_K_NOCONVERT = 101
      DECLARE LONG CONSTANT BCK_OPT_K_WINDOW_TYPES = 102
    !  window_full
    !  window_limited
    ! 
    !   NEVER REMOVE items from the above list ??? 
    ! 	(obsolete items will be denoted)
    ! 
    !   Always ADD items to the END of the above list ???
    ! 	(To maintain interface compatibility with prior versions)
    ! 
      DECLARE LONG CONSTANT BCK_K_OPT_MAX = 102
    ! 
    !   Flag Definitions for various Types of Options
    ! 
      DECLARE LONG CONSTANT BCK_OPTYP_BEFORE_K_BACKUP = 1  ! usage is /BEFORE=BACKUP
      DECLARE LONG CONSTANT BCK_K_OPTYP_BEFORE_MASK = 1
      DECLARE LONG CONSTANT BCK_OPTYP_RELTAPE_K_NONE = 0
      DECLARE LONG CONSTANT BCK_OPTYP_RELTAPE_K_UNLOAD = 1
      DECLARE LONG CONSTANT BCK_OPTYP_RELTAPE_K_NO_UNLOAD = 2
      DECLARE LONG CONSTANT BCK_OPTYP_DISMOU_K_UNLOAD = 1
      DECLARE LONG CONSTANT BCK_OPTYP_DISMOU_K_NO_UNLOAD = 2
      DECLARE LONG CONSTANT BCK_OPTYP_DISP_K_KEEP = 1
      DECLARE LONG CONSTANT BCK_OPTYP_DISP_K_RELEASE = 2
      DECLARE LONG CONSTANT BCK_OPTYP_IGNORE_K_NOBACKUP = 1
      DECLARE LONG CONSTANT BCK_OPTYP_IGNORE_K_INTERLOCK = 2
      DECLARE LONG CONSTANT BCK_OPTYP_IGNORE_K_LABELS = 4
      DECLARE LONG CONSTANT BCK_OPTYP_IGNORE_K_ACCESS = 8
      DECLARE LONG CONSTANT BCK_OPTYP_IGNORE_K_LIMIT = 1024
      DECLARE LONG CONSTANT BCK_K_OPTYP_IGNORE_MASK = 2047
      DECLARE LONG CONSTANT BCK_OPTYP_MEDIA_K_COMPACTION = 1
      DECLARE LONG CONSTANT BCK_OPTYP_MEDIA_K_NO_COMPACTION = 2
      DECLARE LONG CONSTANT BCK_OPTYP_OWN_OUT_K_DEFAULT = 1
      DECLARE LONG CONSTANT BCK_OPTYP_OWN_OUT_K_ORIGINAL = 2
      DECLARE LONG CONSTANT BCK_OPTYP_OWN_OUT_K_PARENT = 3
      DECLARE LONG CONSTANT BCK_OPTYP_OWN_OUT_K_UIC = 4
      DECLARE LONG CONSTANT BCK_OPTYP_SCR_ASGN_K_BASE = 1
      DECLARE LONG CONSTANT BCK_OPTYP_SCR_ASGN_K_COMPOUND = 2
      DECLARE LONG CONSTANT BCK_OPTYP_SCR_ASGN_K_PREASGN = 4
      DECLARE LONG CONSTANT BCK_OPTYP_SCR_ASGN_K_SIDE = 8
      DECLARE LONG CONSTANT BCK_K_OPTYP_SCR_ASGN_MASK = 15
      DECLARE LONG CONSTANT BCK_OPTYP_SINCE_K_BACKUP = 1  ! usage is /SINCE=BACKUP
      DECLARE LONG CONSTANT BCK_K_OPTYP_SINCE_MASK = 1
      DECLARE LONG CONSTANT BCK_OPTYP_WINDOW_K_FULL = 1
      DECLARE LONG CONSTANT BCK_OPTYP_WINDOW_K_LIMITED = 2
    ! 	*** RESERVED FOR POSSIBLE FUTURE USE ***
    !   File name string format flags, (used to indicate non-escaped/non-generated 
    ! 	file name strings that are compatible with QIO parameter calls).
    ! 
      DECLARE LONG CONSTANT BCK_FNSTR_K_ODS2 = 1
      DECLARE LONG CONSTANT BCK_FNSTR_K_EXTENDED = 2
      DECLARE LONG CONSTANT BCK_FNSTR_K_UCS2 = 4
      DECLARE LONG CONSTANT BCK_K_FNSTR_MASK = 7
    ! 
    !   Backup Option Structures, (used to specify backup operation attributes).
    ! 
      DECLARE LONG CONSTANT bck_opt_struct_flag_k_len = 8
      DECLARE LONG CONSTANT s_bck_opt_struct_flag = 8
      record bck_opt_struct_flag
         LONG option_type                   !  type of option/operation
         LONG opt_flag_value                !  option flag(s) 
      end record bck_opt_struct_flag
    
      DECLARE LONG CONSTANT bck_opt_struct_int_k_len = 16
      DECLARE LONG CONSTANT s_bck_opt_struct_int = 16
      record bck_opt_struct_int
         LONG opt_int_type                  !  type of option/operation
         LONG int_filler                    !  (Quadword alignment filler)
         BASIC$QUADWORD opt_int_value       !  64-bit/32-bit integer
    !  Note: the 32-bit integer should be
    !  sign-extended into 2nd longword
      end record bck_opt_struct_int
    
      DECLARE LONG CONSTANT bck_opt_struct_adr_k_len = 16
      DECLARE LONG CONSTANT s_bck_opt_struct_adr = 16
      record bck_opt_struct_adr
         LONG opt_adr_type                  !  type of option/operation
         LONG opt_adr_attributes            !  Address Attributes (uses)
         LONG opt_adr_value(1 to 2)         !  64-bit/32-bit address
    !  Note: the 32-bit address should be
    !  sign-extended into 2nd longword
      end record bck_opt_struct_adr
    
      DECLARE LONG CONSTANT bck_opt_struct_dsc_k_len = 16
      DECLARE LONG CONSTANT s_bck_opt_struct_dsc = 16
      record bck_opt_struct_dsc
         LONG opt_dsc_type                  !  type of option/operation
         LONG dsc_flags                     !  Flags ? Quadword alignment
         dsc$descriptor opt_dsc             !  32-bit string descriptor
      end record bck_opt_struct_dsc
    
      DECLARE LONG CONSTANT bck_opt_struct_dsc_k_len64 = 32
      DECLARE LONG CONSTANT s_bck_opt_struct_dsc64 = 32
      record bck_opt_struct_dsc64
         LONG opt_dsc64_type                !  type of option/operation
         LONG dsc64_flags                   !  Flags ? Quadword alignment 
         bck64$descriptor opt_dsc64         !  64-bit string descriptor
      end record bck_opt_struct_dsc64
    
      DECLARE LONG CONSTANT bck_opt_struct_dt_k_len = 16
      DECLARE LONG CONSTANT s_bck_opt_struct_dt = 16
      record bck_opt_struct_dt
         LONG opt_adt_type                  !  type of option/operation
         LONG adt_filler                    !  (Quadword alignment filler)
         BASIC$QUADWORD opt_adt_value       !  date-time (ADT)
      end record bck_opt_struct_dt
    
