/**/
/***************************************************************************/
/**                                                                       **/
/**  Copyright 2010, Hewlett-Packard Development Company, L.P.           **/
/**                                                                       **/
/** Confidential computer software.  Valid license from HP and/or         **/
/** its subsidiaries required for possession, use, or copying.            **/
/**                                                                       **/
/** Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  **/
/** Computer Software Documentation, and Technical Data for Commercial    **/
/** Items are licensed to the U.S. Government under vendor's standard     **/
/** commercial license.                                                   **/
/**                                                                       **/
/** Neither HP nor any of its subsidiaries shall be liable for technical  **/
/** or editorial errors or omissions contained herein.  The information   **/
/** in this document is provided "as is" without warranty of any kind and **/
/** is subject to change without notice.  The warranties for HP products  **/
/** are set forth in the express limited warranty statements accompanying **/
/** such products.  Nothing herein should be construed as constituting an **/
/** additional warranty.                                                  **/
/**                                                                       **/
/***************************************************************************/
/********************************************************************************************************************************/
/* Created: 30-Mar-2010 17:25:05 by OpenVMS SDL EV3-3      */
/* Source:  13-JUL-2009 17:15:40 $1$DGA7274:[BACKUP.SRC]BACKDEF.SDL;1 */
/********************************************************************************************************************************/
/*** MODULE $BBHDEF ***/
#pragma __member_alignment __save
#pragma __nomember_alignment
#define BBH$K_COMMON 32                 /* end of common header             */
#define BBH$C_COMMON 32                 /* end of common header             */
#define BBH$K_LEVEL1 257                /* level 1, version 1               */
#define BBH$K_LEVEL5 1281               /* level 5, version 1               */
#define BBH$M_NOCRC 0x1
#define BBH$M_COMPRESSED_SS 0x2
#define BBH$M_COMPRESSED_BUFFER 0x4
#define BBH$K_LENGTH 256                /* length of block header           */
#define BBH$C_LENGTH 256                /* length of block header           */
struct BBHDEF {
    unsigned short int BBH$W_SIZE;      /* size in bytes of block header    */
    unsigned short int BBH$W_OPSYS;     /* operating system ID              */
    unsigned short int BBH$W_SUBSYS;    /* subsystem ID                     */
    unsigned short int BBH$W_APPLIC;    /* application ID                   */
    unsigned int BBH$L_NUMBER;          /* block sequence number            */
    char BBHDEF$$_FILL_1 [20];          /* reserved                         */
    union  {
        unsigned short int BBH$W_STRUCLEV; /* block structure level         */
        struct  {
            unsigned char BBH$B_STRUCVER; /* structure version number       */
            unsigned char BBH$B_STRUCLEV; /* major structure level          */
            } BBH$R_FILL_1_;
        } BBH$R_FILL_0_;
    unsigned short int BBH$W_VOLNUM;    /* media volume number              */
    unsigned int BBH$L_CRC;             /* block CRC                        */
    unsigned int BBH$L_BLOCKSIZE;       /* block size in bytes              */
    union  {
        unsigned int BBH$L_FLAGS;       /* block flags                      */
        struct  {
            unsigned BBH$V_NOCRC : 1;   /* no CRC computed for block        */
            unsigned BBH$V_COMPRESSED_SS : 1; /* compressed saveset         */
            unsigned BBH$V_COMPRESSED_BUFFER : 1; /* compressed block       */
            unsigned BBH$V_COMPRESS_ALGO : 4; /* compression algorithm used - for future */
            unsigned BBH$V_FILL_4_ : 1;
            } BBH$R_FILL_3_;
        } BBH$R_FILL_2_;
    char BBH$T_SSNAME [32];             /* save set name (counted ASCII)    */
/* for compatibility sake don't change                                      */
/* *** Note: Old overlay form must be used in FID & DID due to SDL bug      */
/* *** that omits the field size symbol in a structured field.              */
    union  {
        unsigned short int BBH$W_FID [3]; /* current file ID                */
        struct  {
            unsigned short int BBH$W_FID_NUM; /* file number                */
            unsigned short int BBH$W_FID_SEQ; /* file sequence number       */
            union  {
                unsigned short int BBH$W_FID_RVN; /* relative volume number  */
                struct  {
                    unsigned char BBH$B_FID_RVN; /* alternate format RVN    */
                    unsigned char BBH$B_FID_NMX; /* alternate format file number extension  */
                    } BBH$R_FID_RVN_FIELDS;
                } BBH$R_FID_RVN_OVERLAY;
            } BBH$R_FID_FIELDS;
        } BBH$R_FID_OVERLAY;
    union  {
        unsigned short int BBH$W_DID [3]; /* current directory ID           */
        struct  {
            unsigned short int BBH$W_DID_NUM; /* file number                */
            unsigned short int BBH$W_DID_SEQ; /* file sequence number       */
            union  {
                unsigned short int BBH$W_DID_RVN; /* relative volume number  */
                struct  {
                    unsigned char BBH$B_DID_RVN; /* alternate format RVN    */
                    unsigned char BBH$B_DID_NMX; /* alternate format file number extension  */
                    } BBH$R_DID_RVN_FIELDS;
                } BBH$R_DID_RVN_OVERLAY;
            } BBH$R_DID_FIELDS;
        } BBH$R_DID_OVERLAY;
    char BBH$T_FILENAME [128];          /* current file name                */
    unsigned char BBH$B_RTYPE;          /* record type of current file      */
    unsigned char BBH$B_RATTRIB;        /* record attributes of current file  */
    unsigned short int BBH$W_RSIZE;     /* record size of current file      */
    unsigned char BBH$B_BKTSIZE;        /* bucket size of current file      */
    unsigned char BBH$B_VFCSIZE;        /* VFC area size of current file    */
    unsigned short int BBH$W_MAXREC;    /* maximum record size of current file  */
    unsigned int BBH$L_FILESIZE;        /* allocation of current file       */
    unsigned int BBH$L_CMPRSBLKSIZ;     /* compressed block size            */
    char BBH$T_RESERVED2 [18];          /* reserved                         */
    unsigned short int BBH$W_CHECKSUM;  /* header checksum                  */
    } ;
 
#pragma __member_alignment __restore
/*** MODULE $BRHDEF ***/
#pragma __member_alignment __save
#pragma __nomember_alignment
/*+                                                                         */
/*                                                                          */
/* BRH - backup record header. This structure prefixes each record          */
/* within a data block. It identifies the type and use of the record.       */
/*                                                                          */
/*-                                                                         */
#define BRH$K_NULL 0                    /* null record                      */
#define BRH$K_SUMMARY 1                 /* BACKUP summary record            */
#define BRH$K_VOLUME 2                  /* volume summary record            */
#define BRH$K_FILE 3                    /* file attribute record            */
#define BRH$K_VBN 4                     /* file virtual block record        */
#define BRH$K_PHYSVOL 5                 /* physical volume attribute record  */
#define BRH$K_LBN 6                     /* physical volume logical block record  */
#define BRH$K_FID 7                     /* file ID record                   */
#define BRH$K_FILE_EXT 8                /* file attribute extension record  */
#define BRH$K_LBN_576 9                 /* 576 byte LBN record              */
#define BRH$K_RS_DIRATTR 10             /* RSTS directory attribute record  */
#define BRH$K_ALIAS 11
#define BRH$K_MAX_RTYPE 12              /* max record type                  */
#define BRH$M_BADDATA 0x1
#define BRH$M_DIRECTORY 0x2
#define BRH$M_NONSEQUENTIAL 0x4
#define BRH$M_BLOCKERRS 0x8
#define BRH$M_ALIAS_ENTRY 0x10
#define BRH$M_HEADONLY 0x20
#define BRH$K_LENGTH 16
#define BRH$C_LENGTH 16
struct BRHDEF {
    unsigned short int BRH$W_RSIZE;     /* record size in bytes             */
    unsigned short int BRH$W_RTYPE;     /* record type                      */
    union  {
        unsigned int BRH$L_FLAGS;       /* record flags                     */
        struct  {
            unsigned BRH$V_BADDATA : 1; /* data error occurred in record    */
            unsigned BRH$V_DIRECTORY : 1; /* record belongs to a directory file  */
            unsigned BRH$V_NONSEQUENTIAL : 1; /* data record is not in LBN / VBN sequence */
            unsigned BRH$V_BLOCKERRS : 1; /* per block error mask present   */
            unsigned BRH$V_ALIAS_ENTRY : 1; /* file saved via alias entry   */
            unsigned BRH$V_HEADONLY : 1; /* File's data isn't copied        */
            unsigned BRH$V_FILL_7_ : 2;
            } BRH$R_FILL_6_;
        } BRH$R_FILL_5_;
    unsigned int BRH$L_ADDRESS;         /* address of data (e.g., VBN or LBN)  */
    unsigned short int BRH$W_BLOCKFLAGS; /* per block error mask            */
    unsigned short int BRH$W_RESERVED;  /* reserved                         */
    } ;
 
#pragma __member_alignment __restore
/*** MODULE $BSADEF ***/
#pragma __member_alignment __save
#pragma __nomember_alignment
/*+                                                                         */
/*                                                                          */
/* BACKUP attribute codes. These attributes appear in various records       */
/* in a save set.                                                           */
/*                                                                          */
/*-                                                                         */
/*                                                                          */
/* Definition for file ID record                                            */
/* (Structure level definition shared with other attribute records)         */
/*                                                                          */
struct BSADEF {
    unsigned short int BSA$W_STRUCLEV;  /* save set structure level         */
    unsigned short int BSA$W_FID_NUM;   /* NUM word of file ID              */
    union  {
        unsigned short int BSA$W_FID_RVN; /* RVN word of file ID            */
        struct  {
            unsigned char BSA$B_FID_RVN; /* alternate format RVN word       */
            unsigned char BSA$B_FID_NMX; /* alternate format RVN word       */
            } BSA$R_FILL_9_;
        } BSA$R_FILL_8_;
    unsigned short int BSA$W_FID_COUNT; /* count of SEQ words following     */
    unsigned short int BSA$W_FID_SEQ;   /* SEQ word of file ID, repeated    */
/*     BSA$W_FID_COUNT times                                                */
/*                                                                          */
/* Attribute entry header                                                   */
/*                                                                          */
    } ;
#define BSA$K_LENGTH 4                  /* length of attribute descriptor   */
#define BSA$C_LENGTH 4                  /* length of attribute descriptor   */
/*                                                                          */
struct BSADEF1 {
    unsigned short int BSA$W_SIZE;      /* size of attribute value          */
    unsigned short int BSA$W_TYPE;      /* attribute code                   */
/* Data item within placement attribute record                              */
/*                                                                          */
    } ;
struct BSADEF2 {
    unsigned short int BSA$W_PLC_PTR;   /* placement pointer                */
    unsigned int BSA$L_PLC_COUNT;       /* count of placed blocks           */
    union  {
        unsigned int BSA$L_PLC_LBN;     /* LBN of placed blocks             */
        struct  {
            unsigned short int BSA$W_PLC_LOLBN; /*                          */
            unsigned short int BSA$W_PLC_HILBN;
            } BSA$R_FILL_11_;
        } BSA$R_FILL_10_;
    } ;
/*                                                                          */
/* ALIAS record structure                                                   */
/*                                                                          */
#define BSA$M_IGNORED_ALIAS 0x1
#define BSA_ALIAS$K_LENGTH 32           /* Length of fixed portion of ALIAS record */
#define BSA_ALIAS$C_LENGTH 32           /* Length of fixed portion of ALIAS record */
/*                                                                          */
struct BSADEF4 {
    unsigned short int BSA$W_ALIAS_STRUCLEV; /* save set structure level    */
/* *** Note: Old overlay form must be used in FID & DID due to SDL bug      */
/* *** that omits the field size symbol in a structured field.              */
    union  {
        unsigned short int BSA$W_ALIAS_DID [3]; /* ALIAS directory ID       */
        struct  {
            unsigned short int BSA$W_ALIAS_DID_NUM; /* ALIAS Dir. file number  */
            unsigned short int BSA$W_ALIAS_DID_SEQ; /* ALIAS Dir. file sequence number  */
            union  {
                unsigned short int BSA$W_ALIAS_DID_RVN; /* ALIAS Dir. relative volume number  */
                struct  {
                    unsigned char BSA$B_ALIAS_DID_RVN; /* alternate format RVN  */
                    unsigned char BSA$B_ALIAS_DID_NMX; /* alternate format file number extension  */
                    } BSA$R_ALIAS_DID_RVN_FIELDS;
                } BSA$R_ALIAS_DID_RVN_OVERLAY;
            } BSA$R_ALIAS_DID_FIELDS;
        } BSA$R_ALIAS_DID_OVERLAY;
    unsigned short int BSA$W_ALIAS_ENTRY_DIR_RSS; /* alias entry Dir. filename size */
    unsigned short int BSA$W_ALIAS_ENTRY_RSS; /* alias entry filename size  */
    union  {
        unsigned short int BSA$W_PRIM_DID [3]; /* Primary File directory ID  */
        struct  {
            unsigned short int BSA$W_PRIM_DID_NUM; /* Primary File Dir. file number  */
            unsigned short int BSA$W_PRIM_DID_SEQ; /* Primary File Dir. file sequence number  */
            union  {
                unsigned short int BSA$W_PRIM_DID_RVN; /* Primary File Dir. relative volume number  */
                struct  {
                    unsigned char BSA$B_PRIM_DID_RVN; /* alternate format RVN  */
                    unsigned char BSA$B_PRIM_DID_NMX; /* alternate format file number extension  */
                    } BSA$R_PRIM_DID_RVN_FIELDS;
                } BSA$R_PRIM_DID_RVN_OVERLAY;
            } BSA$R_PRIM_DID_FIELDS;
        } BSA$R_PRIM_DID_OVERLAY;
    union  {
        unsigned short int BSA$W_PRIM_FID [3]; /* Primary file ID           */
        struct  {
            unsigned short int BSA$W_PRIM_FID_NUM; /* Primary File file number  */
            unsigned short int BSA$W_PRIM_FID_SEQ; /* Primary File file sequence number  */
            union  {
                unsigned short int BSA$W_PRIM_FID_RVN; /* Primary File relative volume number  */
                struct  {
                    unsigned char BSA$B_PRIM_FID_RVN; /* alternate format RVN  */
                    unsigned char BSA$B_PRIM_FID_NMX; /* alternate format file number extension  */
                    } BSA$R_PRIM_FID_RVN_FIELDS;
                } BSA$R_PRIM_FID_RVN_OVERLAY;
            } BSA$R_PRIM_FID_FIELDS;
        } BSA$R_PRIM_FID_OVERLAY;
    unsigned short int BSA$W_ALIAS_PRIM_DIR_RSS; /* Primary file entry Dir. filename size */
    unsigned short int BSA$W_ALIAS_PRIM_RSS; /* Primary file entry filename size */
    union  {
        unsigned int BSA$L_ALIAS_FLAGS; /* Alias Record Flags               */
        struct  {
            unsigned BSA$V_IGNORED_ALIAS : 1; /*   1 = alias entry ignored  */
            unsigned BSA$V_FILL_14_ : 7;
            } BSA$R_FILL_13_;
        } BSA$R_FILL_12_;
/*  Variable length strings follow the fixed portion of the ALIAS Record.   */
/*  These strings are:                                                      */
/*	the alias entry directory name string, (includes brackets),         */
/*	the alias entry name string, (NTV),                                 */
/*	the primary file directory name string, (includes brackets),        */
/*	and the primary file name string, (NTV).                            */
/*                                                                          */
    } ;
/*                                                                          */
/* Attribute type codes                                                     */
/*                                                                          */
/*                                                                          */
/* BACKUP summary record                                                    */
/*                                                                          */
#define BSA$K_SSNAME 1                  /* save set name                    */
#define BSA$K_COMMAND 2                 /* command line                     */
#define BSA$K_COMMENT 3                 /* user comment                     */
#define BSA$K_USERNAME 4                /* name of user who wrote the set   */
#define BSA$K_USERUIC 5                 /* UIC of user                      */
#define BSA$K_DATE 6                    /* date backup was done             */
#define BSA$K_OPSYS 7                   /* operating system                 */
#define BSA$K_SYSVER 8                  /* operating system version         */
#define BSA$K_NODENAME 9                /* operating system node name       */
#define BSA$K_SIR 10                    /* CPU system ID register           */
#define BSA$K_DRIVEID 11                /* ID of drive writing backup       */
#define BSA$K_BACKVER 12                /* version number of BACKUP         */
#define BSA$K_BLOCKSIZE 13              /* block size of save set           */
#define BSA$K_XORSIZE 14                /* size of each XOR group           */
#define BSA$K_BUFFERS 15                /* number of buffers                */
#define BSA$K_VOLSETNAM 16              /* volume set name                  */
#define BSA$K_NVOLS 17                  /* number of volumes in set         */
#define BSA$K_BACKSIZE 18               /* total file space in save set     */
#define BSA$K_BACKFILES 19              /* total number of files in save set  */
/*                                                                          */
/* Volume summary record                                                    */
/*                                                                          */
#define BSA$K_VOLSTRUCT 20              /* volume structure level           */
#define BSA$K_VOLNAME 21                /* volume label                     */
#define BSA$K_OWNERNAME 22              /* volume owner name                */
#define BSA$K_FORMAT 23                 /* volume file format name          */
#define BSA$K_RVN 24                    /* relative volume number           */
#define BSA$K_VOLOWNER 25               /* volume owner UIC                 */
#define BSA$K_PROTECT 26                /* volume protection mask           */
#define BSA$K_FILEPROT 27               /* volume default file protection   */
#define BSA$K_RECPROT 28                /* volume default record protection  */
#define BSA$K_VOLCHAR 29                /* volume characteristics bits      */
#define BSA$K_VOLDATE 30                /* volume creation date             */
#define BSA$K_WINDOW 31                 /* default file window size         */
#define BSA$K_LRU_LIM 32                /* default directory LRU limit      */
#define BSA$K_EXTEND 33                 /* default file extend size         */
#define BSA$K_CLUSTER 34                /* storage map cluster factor       */
#define BSA$K_RESFILES 35               /* number of reserved files         */
#define BSA$K_VOLSIZE 36                /* original volume size in blocks   */
#define BSA$K_TOTSIZE 37                /* total file space in volume set   */
#define BSA$K_TOTFILES 38               /* total number of files in volume set  */
#define BSA$K_MAXFILES 39               /* maximum number of files allowed  */
#define BSA$K_MAXFILNUM 40              /* highest file number              */
#define BSA$K_SERIALNUM 41              /* pack serial number               */
/*                                                                          */
/* File attribute record                                                    */
/*                                                                          */
#define BSA$K_FILENAME 42               /* file name                        */
#define BSA$K_STRUCLEV 43               /* file structure level             */
#define BSA$K_FID 44                    /* file ID                          */
#define BSA$K_BACKLINK 45               /* directory ID back link           */
#define BSA$K_FILESIZE 46               /* file size in blocks              */
#define BSA$K_UIC 47                    /* file owner UIC                   */
#define BSA$K_FPRO 48                   /* file protection mask             */
#define BSA$K_RPRO 49                   /* record protection mask           */
#define BSA$K_ACLEVEL 50                /* access level                     */
#define BSA$K_UCHAR 51                  /* file characteristics             */
#define BSA$K_RECATTR 52                /* record attributes area           */
#define BSA$K_REVISION 53               /* revision number                  */
#define BSA$K_CREDATE 54                /* creation date                    */
#define BSA$K_REVDATE 55                /* revision date                    */
#define BSA$K_EXPDATE 56                /* expiration date                  */
#define BSA$K_BAKDATE 57                /* backup date                      */
/*                                                                          */
/* Physical volume attribute record                                         */
/*                                                                          */
#define BSA$K_SECTORS 58                /* sectors per track                */
#define BSA$K_TRACKS 59                 /* tracks per cylinder              */
#define BSA$K_CYLINDERS 60              /* cylinders per volume             */
#define BSA$K_MAXBLOCK 61               /* number of logical blocks per volume  */
#define BSA$K_DEVTYP 62                 /* device type                      */
#define BSA$K_SERIAL 63                 /* serial number                    */
#define BSA$K_DEVNAM 64                 /* device name                      */
#define BSA$K_LABEL 65                  /* label                            */
#define BSA$K_BADBLOCK 66               /* bad block descriptor, a sequence of  */
/* pairs of longwords where the first                                       */
/* is an LBN, the second is a count                                         */
/*                                                                          */
/* Additions                                                                */
/*                                                                          */
#define BSA$K_INDEXLBN 67               /* (VS) Index file bitmap starting LBN  */
#define BSA$K_BOOTBLOCK 68              /* (VS) Boot block image            */
#define BSA$K_BOOTVBN 69                /* (FA) VBN within file for 1st boot image  */
#define BSA$K_PLACEMENT 70              /* (FA) Placement data              */
#define BSA$K_DIR_UIC 71                /* (FA) UIC of directory            */
#define BSA$K_DIR_FPRO 72               /* (FA) Protection of directory     */
#define BSA$K_DIR_STATUS 73             /* (FA) Status of directory         */
#define BSA$K_DIR_VERLIM 74             /* (FA) Version limit of directory  */
#define BSA$K_VERLIMIT 75               /* (FA) File version limit          */
#define BSA$K_RETAINMIN 76              /* (VS) Minimum file retention period  */
#define BSA$K_RETAINMAX 77              /* (VS) Maximum file retention period  */
#define BSA$K_ACLSEGMENT 78             /* (FA) ACL segment for the file    */
#define BSA$K_HIGHWATER 79              /* (FA) Highwater mark              */
#define BSA$K_JNL_FLAGS 80              /* (FA) Journal control flags       */
#define BSA$K_CRYPDATKEY 81             /* (BS) File encryption attribute   */
#define BSA$K_LBNSIZE 82                /* (PS) Disk block size in bytes    */
#define BSA$K_RS_DIRCRE 83              /* (DA) RSTS directory creation attribute */
#define BSA$K_RS_DIRATTR 84             /* (DA) RSTS directory attributes   */
#define BSA$K_RS_FILECHAR 85            /* (FA) RSTS specific file attributes */
#define BSA$K_RS_VOLCHAR 86             /* (VS) RSTS specific volume characteristics */
#define BSA$K_RU_ACTIVE 87              /* (FA) Active recovery units recoverable facility id (if non-zero) */
#define BSA$K_BACKREV 88                /* (VS) Backup revision count.      */
#define BSA$K_MIN_CLASS 89              /* (VS) Volume min security class   */
#define BSA$K_MAX_CLASS 90              /* (VS) Volume max security class   */
#define BSA$K_CLASS_PROT 91             /* (FA) File security class         */
#define BSA$K_BOOTVBN2 92               /* (FA) VBN within file for 2nd boot image */
#define BSA$K_ACCDATE 93                /* (FA) File access date, (ODS5)    */
#define BSA$K_ATTDATE 94                /* (FA) File attribute revision date, (ODS5) */
#define BSA$K_EX_RECATTR 95             /* (FA) Extended RMS record attributes, (ODS5) */
#define BSA$K_LENGTH_HINT 96            /* (FA) File length hint, (ODS5)    */
#define BSA$K_LINKCOUNT 97              /* (FA) (hard) link count (ODS5)     */
#define BSA$K_GPT_VBN 98                /* (FA) VBN within file for EFI/GPT partition image */
#define BSA$K_GPT_TYPE 99               /* (FA) Type of EFI/GPT partition image (see GPT_TYPE codes below) */
#define BSA$K_CRYPAESDATKEY 100         /* (BS) File encryption attribute for AES */
#define BSA$K_EXPSIZE 101               /* (VS)	Volume Expansion Size       */
#define BSA$K_COMPRESSALGO 102          /* (BS) File compressed with deflate algorithm */
#define BSA$K_NUM_ATRS 103              /* number of attribute codes        */
/*                                                                          */
/* Placement data type codes                                                */
/*                                                                          */
#define BSA$K_PLC_FID 1                 /* file ID                          */
#define BSA$K_PLC_COUNT 2               /* count of unplaced blocks         */
#define BSA$K_PLC_PLACE 3               /* placement pointer, count of placed blocks  */
#define BSA$K_PLC_PLLBN 4               /* placement pointer, count, LBN of placed blocks  */
/*                                                                          */
/* GPT_TYPE codes                                                           */
/*                                                                          */
#define BSA$K_GPT_BOOT 1                /* boot partition                   */
#define BSA$K_GPT_DIAG 2                /* diagnostic partition             */
/*                                                                          */
/* Lengths of above attributes                                              */
/*                                                                          */
/*                                                                          */
/* BACKUP summary record                                                    */
/*                                                                          */
#define BSA$S_SSNAME 79                 /* save set name                    */
#define BSA$S_COMMAND 1024              /* command line                     */
#define BSA$S_COMMENT 255               /* user comment                     */
#define BSA$S_USERNAME 32               /* name of user who wrote the set   */
#define BSA$S_USERUIC 4                 /* UIC of user                      */
#define BSA$S_DATE 8                    /* date backup was done             */
#define BSA$S_OPSYS 2                   /* operating system                 */
#define BSA$S_SYSVER 4                  /* operating system version         */
#define BSA$S_NODENAME 12               /* operating system node name       */
#define BSA$S_SIR 4                     /* CPU system ID register           */
#define BSA$S_DRIVEID 16                /* ID of drive writing backup       */
#define BSA$S_BACKVER 32                /* version number of BACKUP         */
#define BSA$S_BLOCKSIZE 4               /* block size of save set           */
#define BSA$S_XORSIZE 2                 /* size of each XOR group           */
#define BSA$S_BUFFERS 2                 /* number of buffers                */
#define BSA$S_VOLSETNAM 12              /* volume set name                  */
#define BSA$S_NVOLS 2                   /* number of volumes in set         */
#define BSA$S_BACKSIZE 8                /* total file space in save set     */
#define BSA$S_BACKFILES 4               /* total number of files in save set  */
/*                                                                          */
/* Volume summary record                                                    */
/*                                                                          */
#define BSA$S_VOLSTRUCT 2               /* volume structure level           */
#define BSA$S_VOLNAME 12                /* volume label                     */
#define BSA$S_OWNERNAME 12              /* volume owner name                */
#define BSA$S_FORMAT 12                 /* volume file format name          */
#define BSA$S_RVN 2                     /* relative volume number           */
#define BSA$S_VOLOWNER 4                /* volume owner UIC                 */
#define BSA$S_PROTECT 2                 /* volume protection mask           */
#define BSA$S_FILEPROT 2                /* volume default file protection   */
#define BSA$S_RECPROT 2                 /* volume default record protection  */
#define BSA$S_VOLCHAR 2                 /* volume characteristics bits      */
#define BSA$S_VOLDATE 8                 /* volume creation date             */
#define BSA$S_WINDOW 1                  /* default file window size         */
#define BSA$S_LRU_LIM 1                 /* default directory LRU limit      */
#define BSA$S_EXTEND 2                  /* default file extend size         */
#define BSA$S_CLUSTER 2                 /* storage map cluster factor       */
#define BSA$S_RESFILES 2                /* number of reserved files         */
#define BSA$S_VOLSIZE 4                 /* original volume size in blocks   */
#define BSA$S_TOTSIZE 8                 /* total file space in volume       */
#define BSA$S_TOTFILES 4                /* total number of files in volume  */
#define BSA$S_MAXFILES 4                /* maximum number of files allowed  */
#define BSA$S_MAXFILNUM 4               /* highest file number              */
#define BSA$S_SERIALNUM 4               /* pack serial number               */
/*                                                                          */
/* File attribute record                                                    */
/*                                                                          */
#define BSA$S_FILENAME 128              /* file name                        */
#define BSA$S_STRUCLEV 2                /* file structure level             */
#define BSA$S_FID 6                     /* file ID                          */
#define BSA$S_BACKLINK 6                /* directory ID back link           */
#define BSA$S_FILESIZE 4                /* file size in blocks              */
#define BSA$S_UIC 4                     /* file owner UIC                   */
#define BSA$S_FPRO 2                    /* file protection mask             */
#define BSA$S_RPRO 2                    /* record protection mask           */
#define BSA$S_ACLEVEL 1                 /* access level                     */
#define BSA$S_UCHAR 4                   /* file characteristics             */
#define BSA$S_RECATTR 32                /* record attributes area           */
#define BSA$S_REVISION 2                /* revision number                  */
#define BSA$S_CREDATE 8                 /* creation date                    */
#define BSA$S_REVDATE 8                 /* revision date                    */
#define BSA$S_EXPDATE 8                 /* expiration date                  */
#define BSA$S_BAKDATE 8                 /* backup date                      */
/*                                                                          */
/* Physical volume attribute record                                         */
/*                                                                          */
#define BSA$S_SECTORS 1                 /* sectors per track                */
#define BSA$S_TRACKS 1                  /* tracks per cylinder              */
#define BSA$S_CYLINDERS 2               /* cylinders per volume             */
#define BSA$S_MAXBLOCK 4                /* number of logical blocks per volume  */
#define BSA$S_DEVTYP 4                  /* device type                      */
#define BSA$S_SERIAL 4                  /* serial number                    */
#define BSA$S_DEVNAM 64                 /* device name                      */
#define BSA$S_LABEL 12                  /* label                            */
#define BSA$S_BADBLOCK 8                /* bad block descriptor (one pair)  */
/*                                                                          */
/* Additions                                                                */
/*                                                                          */
#define BSA$S_INDEXLBN 4                /* (VS) Index file bitmap starting LBN  */
#define BSA$S_BOOTBLOCK 512             /* (VS) Boot block image            */
#define BSA$S_BOOTVBN 4                 /* (FA) VBN within file for boot block  */
#define BSA$S_BOOTVBN2 4                /* (FA) VBN within file for boot image  */
#define BSA$S_GPT_VBN 4                 /* (FA) VBN within EFI/GPT partition file */
#define BSA$S_GPT_TYPE 4                /* (FA) type of EFI/GPT partition file */
#define BSA$S_PLACEMENT 2048            /* (FA) Placement data              */
#define BSA$S_DIR_UIC 4                 /* (FA) UIC of directory            */
#define BSA$S_DIR_FPRO 2                /* (FA) Protection of directory     */
#define BSA$S_DIR_STATUS 1              /* (FA) Status of directory         */
#define BSA$S_DIR_VERLIM 2              /* (FA) Version limit of directory  */
#define BSA$S_VERLIMIT 2                /* (FA) File version limit          */
#define BSA$S_RETAINMIN 8               /* (VS) Minimum file retention period  */
#define BSA$S_RETAINMAX 8               /* (VS) Maximum file retention period  */
#define BSA$S_ACLSEGMENT 380            /* (FA) ACL segment for the file    */
#define BSA$S_HIGHWATER 4               /* (FA) Highwater mark              */
#define BSA$S_JNL_FLAGS 1               /* (FA) Journal control flags       */
#define BSA$S_CRYPDATKEY 24             /* (BS) Saveset encryption key      */
#define BSA$S_CRYPAESDATKEY 64          /* (BS) Saveset encryption key AES  */
#define BSA$S_LBNSIZE 2                 /* (PS) Disk block size in bytes    */
#define BSA$S_RS_DIRCRE 4               /* (FA) RSTS directory creation attribute */
#define BSA$S_RS_DIRATTR 14             /* (FA) RSTS directory attributes   */
#define BSA$S_RS_FILECHAR 12            /* (FA) RSTS specific file attributes */
#define BSA$S_RS_VOLCHAR 4              /* (VS) RSTS specific volume characteristics */
#define BSA$S_RU_ACTIVE 1               /* (FA) Active recovery units recoverable facility id (if non-zero) */
#define BSA$S_BACKREV 2                 /* (VS) Backup revision count.      */
#define BSA$S_MIN_CLASS 20              /* (VS) Volume min security class   */
#define BSA$S_MAX_CLASS 20              /* (VS) Volume max security class   */
#define BSA$S_CLASS_PROT 20             /* (FA) File security class         */
#define BSA$S_ACCDATE 8                 /* (FA) File access date, (ODS5)    */
#define BSA$S_ATTDATE 8                 /* (FA) File attribute revision date, (ODS5) */
#define BSA$S_EX_RECATTR 8              /* (FA) Extended RMS record attributes, (ODS5) */
#define BSA$S_LENGTH_HINT 16            /* (FA) File length hint, (ODS5 / FAT) */
#define BSA$S_LINKCOUNT 2               /* (FA) (hard) link count (ODS5)    */
#define BSA$S_EXPSIZE 4                 /* (VS) Dynamic Volume Expansion Size  */
#define BSA$S_COMPRESSALGO 8            /* (BS) File compressed with deflate algorithm */
/*                                                                          */
/* Placement data type codes                                                */
/*                                                                          */
#define BSA$S_PLC_FID 6                 /* file ID                          */
#define BSA$S_PLC_COUNT 4               /* count of unplaced blocks         */
#define BSA$S_PLC_PLACE 6               /* placement pointer, count of placed blocks  */
#define BSA$S_PLC_PLLBN 10              /* placement pointer, count, LBN of placed blocks  */
#define BSA$K_CRYP_DESCBC 1             /* Code for DES Cypher Block Chaining */
#define BSA$K_CRYP_DESECB 2             /* Code for DES Electronic Code Book. */
struct BSADEF3 {
    unsigned char BSA$B_CRYPTYP;        /* Byte code describing saveset encr alg */
    char BSA$T_CRYPRES0 [3];            /* Unused                           */
    unsigned int BSA$Q_CRYPKEY [2];     /* DES key used to encrypt saveset  */
    unsigned int BSA$Q_CRYPIV [2];      /* DES initialize vector prototype  */
    unsigned int BSA$L_CRYPCKSM;        /* Checksum for attribute record    */
    } ;
#define BSA$K_CRYP_AESCBC128 1          /* Code for AES Cypher Block Chaining */
#define BSA$K_CRYP_AESCBC192 2          /* Code for AES Cypher Block Chaining */
#define BSA$K_CRYP_AESCBC256 3          /* Code for AES Cypher Block Chaining */
#define BSA$K_CRYP_AESECB128 4          /* Code for AES Electronic Code Book. */
#define BSA$K_CRYP_AESECB192 5          /* Code for AES Electronic Code Book. */
#define BSA$K_CRYP_AESECB256 6          /* Code for AES Electronic Code Book. */
#define BSA$K_CRYP_AESCFB128 7
#define BSA$K_CRYP_AESCFB192 8
#define BSA$K_CRYP_AESCFB256 9
#define BSA$K_CRYP_AESOFB128 10
#define BSA$K_CRYP_AESOFB192 11
#define BSA$K_CRYP_AESOFB256 12
struct BSADEF5 {
    unsigned short int BSA$W_CRYPAES_TYP; /* Word code describing saveset encr alg */
    char BSA$T_CRYPAES_KEY [32];        /* AES key used to encrypt saveset  */
    char BSA$T_CRYPAES_IV [16];         /* AES initialize vector prototype  */
    unsigned int BSA$L_CRYPAES_CKSM;    /* Checksum for attribute record    */
    char BSA$T_CRYPAES_FILLER_TO_16 [10];
    } ;
 
#pragma __member_alignment __restore
/*** MODULE $BJLDEF ***/
#pragma __member_alignment __save
#pragma __nomember_alignment
/*+                                                                         */
/*                                                                          */
/* BACKUP journal file.                                                     */
/*                                                                          */
/*-                                                                         */
#define BJL$S_SIZE_LEN 1                /* length of size                   */
#define BJL$K_STRUCLEV 0                /* structure level                  */
#define BJL$K_SSNAME 1                  /* save set name                    */
#define BJL$K_VOLUME 2                  /* volume identification            */
#define BJL$K_DIRECTORY 3               /* directory name                   */
#define BJL$K_FILE 4                    /* file name                        */
struct BJLDEF {
    unsigned char BJL$B_SIZE;           /* record length (XOR format)       */
    unsigned char BJL$B_TYPE;           /* record type                      */
    unsigned char BJL$B_DATA;           /* beginning of data portion of record  */
/*                                                                          */
/* Following definitions are all relative to data portion of record.        */
/*                                                                          */
/* Structure level record.                                                  */
/*                                                                          */
    } ;
#define BJL$K_LEVEL1 257                /* level 1, version 1               */
#define BJL$K_LEVEL2 258                /* level 1, version 2               */
#define BJL$K_LEVEL5 1281               /* level 5, version 1               */
#define BJL$K_STRUC_LEN 2               /* length of record                 */
#define BJL$C_STRUC_LEN 2               /* length of record                 */
/*                                                                          */
struct BJLDEF1 {
    union  {
        unsigned short int BJL$W_STRUCLEV; /* structure level               */
        struct  {
            unsigned char BJL$B_STRUCVER; /* structure version number       */
            unsigned char BJL$B_STRUCLEV; /* major structure level          */
            } BJL$R_FILL_16_;
        } BJL$R_FILL_15_;
/* Save set name record.                                                    */
/*                                                                          */
    } ;
#define BJL$K_SSNAME_LEN 257            /* maximum length of record         */
#define BJL$C_SSNAME_LEN 257            /* maximum length of record         */
struct BJLDEF2 {
    unsigned int BJL$Q_CREDATE [2];     /* creation date and time           */
    char BJL$T_SSNAME [247];            /* save set name (variable length)  */
    unsigned short int BJL$W_SSNAME_FLAGS; /* flags, (Ref. NAMESTR_SEG_FLAGS, etc.) */
    } ;
/* The following masks define flag bits for file/directory name string      */
/* segmentation.  The structure is being defined in this way because the    */
/* name string segment flag may be used in several journal file record flag fields. */
/* By defining the structure in this manner the flags are relative to the   */
/* start of the record's flag field(s) and are not position dependant.      */
/*                                                                          */
#define BJL$M_MORE_SEGMENTS 0x2
struct NAMESTR_SEG_FLAGS {
    unsigned BJL$v_namestrseg_fill1 : 1; /* reserve space for filename flags */
/*	  i.e. BJL$V_HEADONLY compatibility                                 */
    unsigned BJL$V_MORE_SEGMENTS : 1;   /* 0 = last segment,                */
/* 1 = more segments to follow                                              */
/*                                                                          */
/*	Add any new flags here.                                             */
/*                                                                          */
    unsigned BJL$V_FILL_17_ : 6;
    } ;
/*                                                                          */
/* Volume identification record.                                            */
/*                                                                          */
#define BJL$K_VOLUME_LEN 14             /* length of record                 */
#define BJL$C_VOLUME_LEN 14             /* length of record                 */
struct BJLDEF3 {
    char BJL$T_VOLNAME [12];            /* volume label                     */
    unsigned short int BJL$W_VOLNUMBER; /* volume sequence number           */
    } ;
/*                                                                          */
/* Directory record.                                                        */
/*                                                                          */
#define BJL$K_DIR_LEN 254               /* maximum length of record         */
#define BJL$C_DIR_LEN 254               /* maximum length of record         */
/* stored in XOR format                                                     */
struct BJLDEF4 {
    char BJL$T_DIRNAME [252];           /* directory name (variable length)  */
    unsigned short int BJL$W_DIRNAME_FLAGS; /* flags, (Ref. NAMESTR_SEG_FLAGS, etc.) */
    } ;
/*                                                                          */
/* File record.                                                             */
/*                                                                          */
/* The following masks define flag bits.  The structure is being defined    */
/* in this way because the flags do not have a set position in the record   */
/* defined by BJLDEF5 but simply follow directly after the file name.       */
/* By defining the structures in this manner there is a full longword       */
/* reserved but is not position dependant                                   */
#define BJL$M_HEADONLY 0x1
struct FLAG_BITS {
    unsigned BJL$V_HEADONLY : 1;        /* NOBACKUP was set when file was saved */
    unsigned BJL$V_FILL_18_ : 7;
    } ;
#define BJL$K_FILE_LEN 254              /* maximum length of record         */
#define BJL$C_FILE_LEN 254              /* maximum length of record         */
struct BJLDEF5 {
    char BJL$T_FILENAME [250];          /* file name (variable length)      */
    unsigned int BJL$L_FLAGS;           /* flags                            */
/* Ref.  FLAG_BITS and NAMESTR_SEG_FLAGS                                    */
    } ;
#define BCK_DEF_JOURBUFF_SIZE 512       /* default journal buffer size      */
 
#pragma __member_alignment __restore
