$!
$!***************************************************************************
$!*									    *
$!*  COPYRIGHT (c) 1987, 1992 BY					    *
$!*  DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.		    *
$!*  ALL RIGHTS RESERVED.						    *
$!* 									    *
$!*  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED  *
$!*  ONLY IN  ACCORDANCE WITH  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE  *
$!*  INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER  *
$!*  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY  *
$!*  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE IS  HEREBY  *
$!*  TRANSFERRED.							    *
$!* 									    *
$!*  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE  *
$!*  AND  SHOULD  NOT  BE  CONSTRUED AS  A COMMITMENT BY DIGITAL EQUIPMENT  *
$!*  CORPORATION.							    *
$!* 									    *
$!*  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS  *
$!*  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.		    *
$!* 									    *
$!***************************************************************************
$!
$ type sys$input:
***************************************************************************
*  Creating a NEW user account... If at ANY TIME you need help about a    *
*  prompt, just type "?".						  *
***************************************************************************

$ !
$ !	Add a new user account to the system
$ !
$ !
$ ! Default values
$ !
$ on controly then goto bad_message
$ userdisk = "SYS$SYSDEVICE:"		! Default disk for new users
$ defgrp = "200"                        ! Default group number
$ defmem = ""                           ! Default member number
$ defacc = ""                           ! Default account name
$ defquo = 1000                         ! Default disk quota
$ defovr = 100                          ! Default overdraft quota
$ grp = ""
$ 
$ uaf = "$authorize"
$ on warning then goto cleanup
$ olddir = f$environment("DEFAULT")
$ prevpriv = f$setprv("SYSPRV")
$ if .not. f$priv("SYSPRV") then goto nopriv
$ set default sys$system
$ write sys$output ""
$ !
$ ! Get new user names
$ !
$get_usernames:
$ inquire user "Username(s) - separate by commas"
$ if (user .nes. "?") then goto skip_help_1
$ type sys$input:

The username is the name the user will use to actually log in. It is not the
user's full name, but rather some abbreviation of it. For instance, an account
for John Smith, might have the username SMITH, JOHN, JSMITH, SMITH_J, etc.

Each user that you enter will receive a single account. So if you type in
"FRANKLIN,SMITH", two accounts will be created, and you will be asked for
information pertaining to each of them.

$ goto get_usernames
$skip_help_1:
$ !
$ ! Extract one user name from list
$ !
$ext_name:
$ username = f$extract(0,f$locate(",",user),user)
$ user = user - username - ","
$ if username .eqs. "" then goto cleanup
$ !
$ ! Process extracted name, get full name and password
$ !
$full_name:
$ write sys$output ""
$ write sys$output " *** Processing ",username,"'s account ***"
$ write sys$output ""
$full_name_1:
$ inquire full_name "Full name for ''username'"
$ if (full_name .nes. "?") then goto skip_help_2
$ type sys$input:

Type in the full name of the person who is going to receive this account. For
instance, an account with the username SMITH, might be for a person with the
full name of John Smith.

$ goto full_name_1
$skip_help_2:
$ set term/noecho
$ inquire password "Password (password is not echoed to terminal) [''username']"
$ set term/echo
$ if (password .nes. "?") then goto skip_help_3
$ type sys$input:

This is the password that the user must know in order to get into his account.
Since the user can use SET PASSWORD to change it, it defaults to being the same
as his username.

Note that when the user first logs in, the system will tell him that his
password has already expired. This forces him to change it to something else.

$ goto skip_help_2
$skip_help_3:
$ if password .eqs. "" then password = username
$ !
$ ! List containing all accounts.  Use list to acquire an unspecified
$ ! UIC group and member number to give to the new user.
$ !
$ goto get_uic
$display_UIC_list:
$ type sys$input:

Each user has a specific User Identification Code (UIC) which consists of two
numbers, and is usually displayed in the format [group,member]. The first
number is the "group". People with the same group number can access each
other's files through the group protection code.

For instance, if you set protection using the following command:
	$ SET PROTECTION=(GROUP:R,WORLD) NEWS.TXT
only people in the same group could read the file "NEWS.TXT".

The following is a list of UIC's that already exist on the system: (You do not
have to specify one of these groups, if you do not want to.)

$ uaf show [*,*]/brief
$ write sys$output ""
$ goto get_uic
$display_UIC_members:
$ type sys$input:

Since the UIC should uniquely identify every person on the system, a member
number must also be specified for each individual. If a person is in
the same group, he must have a different member number, or it will not be
possible to put him into the RIGHTSLIST database.

The following is a list of all users in the specified group:

$ set noon
$ uaf show ['grp',*]/brief
$ set on
$ write sys$output ""
$ goto get_member
$ !
$ ! Get group and member numbers
$ !
$get_uic:
$ write sys$output ""
$ inquire grp "UIC Group number [''defgrp']"
$ if grp .eqs. "?" then goto display_UIC_list
$ if grp .eqs. "" then grp = defgrp
$get_member:
$ inquire uic "UIC Member number"
$ if((uic .eqs. "?").or.(uic.eqs."")) then goto display_UIC_members
$ !
$ ! Combine group and member numbers to create complete UIC
$ ! in the form - [group,member]
$ !
$create_uic:
$ if f$loc("[",uic) .eq. f$len(uic) .and. -
	f$loc("<",uic) .eq. f$len(uic) then uic = "[" + grp + "," + uic + "]"
$ !
$ ! Get account name and privileges
$ !
$get_accpriv:
$ inquire account "Account name"
$ if ((account .nes. "").and.(account .nes."?")) then goto skip_help_4
$ type sys$input:

You must enter the account name to be used for the user. This is generally
used for billing purposes.

$ goto get_accpriv
$skip_help_4:
$ inquire privs "Privileges [TMPMBX,NETMBX]"
$ if privs .nes."?" then goto skip_help_5
$ type sys$input:

All users must be given a list of privileges. The privileges available, and
their meanings are as follows:
    No Privilege:
	NONE	- No privileges at all
    Normal Privileges:
	MOUNT	- Execute mount volume QIO
	NETMBX	- Create network connections
	TMPMBX	- Create temporary mailbox
    Group Privileges:
	GROUP	- Control processes in the same group
	GRPPRV	- Group access through SYSTEM protection field
    Devour Privileges:
	ACNT	- Disable accounting
	ALLSPOOL- Allocate spooled devices
	BUGCHK	- Make bugcheck error log entries
	EXQUOTA	- Exceed disk quotas
	GRPNAM	- Insert group logical names in the name table
	PRMCEB	- Create/delete permanent common event flag clusters
	PRMGBL	- Create permanent global sections
	PRMMBX	- Create permanent mailboxes
	SHMEM	- Create/delete structures in shared memory
    System privileges:
	ALTPRI	- Set base priority higher than allotment
	OPER	- Perform operator functions
	PSWAPM	- Change process swap mode
	WORLD	- Control any process
	SECURITY- Perform security related functions
	SHARE	- Access devices allocated to other users
	SYSLCK	- Lock system-wide resources
    Files privileges:
	DIAGNOSE- Diagnose devices
	SYSGBL	- Create system-wide global sections
	VOLPRO	- Override volume protection
    ALL privileges:
	BYPASS	- Disregard protection
	CMEXEC	- Change to executive mode
	CMKRNL	- Change to kernel mode
	DETACH	- Create detached processes of arbitrary UIC
	LOG_IO	- Issue logical I/O requests
	PFNMAP	- Map to specific physical pages
	PHY_IO	- Issue physical I/O requests
	READALL	- Possess read access to everything
	SETPRV	- Enable any privilege
	SYSNAM	- insert system logical names in the name table
	SYSPRV	- Access objects through SYSTEM protection field

    (ALL can be specified to give the user every one of the above privileges.)

$ goto skip_help_4
$skip_help_5:
$ write sys$output ""
$ if privs .nes. "" then privs = "/PRIV=(" + privs + ")"
$ userdir = username
$ !
$ ! Get login directory and device
$ !
$get_login:
$ inquire tmp "Login directory [''userdir']"
$ if tmp .nes. "?" then goto skip_help_6
$ type sys$input:

This is the default directory that the user will have when he logs into his
account. If the directory does not already exist, it will automatically be 
created. (Generally, the user directory is the same as the username.)

$ goto get_login
$skip_help_6:
$ if tmp .nes. "" then userdir = tmp
$get_login_device:
$ inquire tmp "Login device [''userdisk']"
$ if tmp .nes. "?" then goto skip_help_7
$ type sys$input:

This is the default device that the user will have when he logs into his
account. For instance, if you have 2 hard disk drives you may want to put
every user account onto the second hard disk, and keep all the system stuff
on the first disk. In that case you would specify the device name for the
second disk here. 

$goto get_login_device
$skip_help_7:
$ write sys$output ""
$ if tmp .eqs. "" then tmp = userdisk 
$ if .not. f$getdvi(tmp,"EXISTS") then goto audb_10
$ if f$getdvi(tmp,"DEVCLASS") .eq. 1 then goto audb_20
$audb_10:
$ write sys$output "''tmp' is not a valid device ..."
$ write sys$output ""
$ goto get_login_device
$audb_20:
$ if .not. f$getdvi(tmp,"MNT")
$   then
$	write sys$output "''tmp' is not mounted ..."
$	write sys$output "Account not added ..."
$	write sys$output ""
$	goto not_added
$ endif
$ userdisk = tmp
$ userdisk = userdisk - ":" + ":"
$ !
$ ! Get disk quota and overdraft quota if enabled on the volume.
$ !
$get_quotas:
$ dquota = 0
$ if f$search("''userdisk'[0,0]QUOTA.SYS") .eqs. "" then goto create_account
$ dquota = 1
$ask_quota:
$ inquire quota "Disk quota [''defquo']
$ if quota .nes."?" then goto skip_help_8
$ type sys$input:

This is the amount of space that you want the user to be able to have while
he is logged out.

$ goto ask_quota
$skip_help_8:
$ if quota .eqs. "" then quota = defquo
$ask_overdraft:
$ inquire overdraft "Overdraft quota [''defovr']"
$ if overdraft.nes."?" then goto skip_help_9
$ type sys$input:

This is the amount of space that the user can use while he is logged in, if
he accidentally exceeds his quota.

$ goto ask_overdraft
$skip_help_9:
$ write sys$output ""
$ if overdraft .eqs. "" then overdraft = defovr
$ defquo = quota
$ defovr = overdraft
$ open/write file sys$scratch:addquota.tmp
$ write file "$ SET DEFAULT ''userdisk' "
$ write file "$ RUN SYS$SYSTEM:DISKQUOTA
$ write file "ADD ",uic,"/PERM=",quota,"/OVERDRAFT=",overdraft
$ write file "$ SET DEFAULT SYS$SYSTEM"
$ close file
$ @sys$scratch:addquota.tmp
$ delete sys$scratch:addquota.tmp;*/nolog
$ !
$ ! Create new user directory. Create new account.
$ !
$create_account:
$ create/dir/owner='uic'/prot=(s=rwe,o=rwe,g=re,w) 'userdisk'['userdir']/LOG
$ open/write file sys$scratch:adduaf.tmp
$ write file "$ RUN SYS$SYSTEM:AUTHORIZE"
$ write file "ADD ",username,"/OWN=""",full_name,"""/ACCO=",account,-
	"/DEV=''userdisk'/DIR=[''userdir']/UIC=",uic,privs,"/PASSW=",password,-
        "/FLAG=NODISUSER"
$ close file
$ @sys$scratch:adduaf.tmp
$ delete sys$scratch:adduaf.tmp;*/nolog
$ on controly then goto good_message
$ !
$ ! Show newly created account to check for possible errors
$ !
$show_account:
$ write sys$output ""
$ write sys$output "Check newly created account:"
$ write sys$output ""
$ open/write file sys$scratch:shouaf.tmp
$ write file "$ RUN SYS$SYSTEM:AUTHORIZE"
$ write file "SHOW ",username,""
$ close file
$ @sys$scratch:shouaf.tmp
$ delete sys$scratch:shouaf.tmp;*/nolog
$ !
$ ! If an error in account then remove account.
$ ! If no error then process next user name, create next account.
$ !
$ write sys$output ""
$ask_ok:
$ inquire ok "Is everything satisfactory with the account [YES]"
$ if ok .nes. "?" then goto skip_help_10
$ type sys$input:

If you feel there is something wrong with the account type "NO". This will
erase what you have done, and allow you to start over. Otherwise, press
[return] and the account will be left in the authorization file.

$ goto ask_ok
$skip_help_10:
$ if ok .eqs. "" then ok = "yes"
$ if .not. ok then goto remove_uaf
$not_added:
$ if user .nes. "" then goto ext_name
$cleanup:
$ set term /echo
$ prevpriv = f$setpriv(prevpriv)
$ set default 'olddir'
$ exit
$ !
$ ! Remove account, then return and process same account again
$ !
$remove_uaf:
$ write sys$output ""
$ write sys$output "Removing newly created account"
$ write sys$output ""
$ open/write file sys$scratch:remuaf.tmp
$ write file "$ RUN SYS$SYSTEM:AUTHORIZE"
$ write file "REMOVE ",username,""
$ write file "$ DELETE ",userdisk,"[000000]",userdir,".DIR;1/LOG"
$ write file "$ SET DEFAULT ''userdisk' "
$ write file "$ RUN SYS$SYSTEM:DISKQUOTA
$ write file "REMOVE ",uic
$ write file "$ SET DEFAULT SYS$SYSTEM"
$ close file
$ @sys$scratch:remuaf.tmp
$ del sys$scratch:remuaf.tmp;*/nolog
$ on controly then goto good_message
$ write sys$output ""
$ goto full_name                               ! go process same account
$good_message:
$ write sys$output ""
$ write sys$output "Program halted by control_y, account has already been created."
$ write sys$output ""
$ goto cleanup
$bad_message:
$ write sys$output ""
$ write sys$output "Program halted by control_y, account has not yet been created."
$ write sys$output ""
$ goto cleanup
$nopriv:
$ write sys$output "You need SETPRV or SYSPRV privilege to run this procedure"
$ goto cleanup
