#ifndef __ACME_SERVER_H
#define __ACME_SERVER_H

/*
**  #pragma module ACME_SERVER_H "X-4" 
*/

/*************************************************************************
/*                                                                       *
/* Copyright 2002 Compaq Computer Corporation                            *
/*                                                                       *
/* COMPAQ Registered in U.S. Patent and Trademark Office.                *
/*                                                                       *
/* Confidential computer software. Valid license from Compaq or          *
/* authorized sublicensor required for possession, use or copying.       *
/* Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *
/* Computer Software Documentation, and Technical Data for Commercial    *
/* Items are licensed to the U.S. Government under vendor's standard     *
/* commercial license.                                                   *
/*                                                                       *
/* Compaq shall not be liable for technical or editorial errors or       *
/* omissions contained herein. The information in this document is       *
/* subject to change without notice.                                     *
/*                                                                       *
/************************************************************************/

/*
**++
**
**  FACILITY:  VMS Authentication Server
**
**  ABSTRACT:
**
**	This module contains common header information for building the
**	authentication server.
**
**--
**
**  AUTHOR:  Andrew J. Moskal			CREATION DATE:  17-Oct-1997
**
**  Modification History:
**
**	X-4	AJM62605	Andrew J. Moskal	25-Jun-1998
**				Matthew P. Doremus
**		Set 'extern nodel' to 'strict_refdef' to consolidate psects.
**		Include FAB, FSCN, KFD, KFE and IMCB definitions.
**		Provide additional pthread support; thread and mutex attributes.
**		Clean up AST routine prototypes.
**		Declare PUTMSG action routine prototype.
**		Declare global routines:
**		    ACME_SendOperator
**		    ACME_UCS4_to_Latin1
**		    and ACME_Latin1_to_UCS4
**		Add interim declarations:
**		    DYN$C_SECURITY_ACMESDB
**		    DYN$C_SECURITY_ACMEADB
**		    DYN$C_SECURITY_ACMECH
**		    DYN$C_SECURITY_ACMERM (in lieu of DYN_C_SECURITY_ACMERM)
**		Build with enhanced debug capabilities.
**
**	X-3	AJM62507	Andrew J. Moskal	19-May-1998
**		Include OPCDEF.
**		Add REPORT_FAILURE macro.
**		Add interim DYN_C_SECURITY_ACMERM definition.
**
**	X-2	AJM62306	Andrew J. Moskal	11-Mar-1998
**		Include ACMESRVMSGDEF.H.
**
**	X-1	AJM6211B	Andrew J. Moskal	12-Jan-1998
**		Initial entry.
**
**
*/


/*
 *  Include Files
 */
#pragma extern_model strict_refdef

#define	__NEW_STARLET	1

#include <builtins>
#include <ctype>
#include <descrip>			/* Argument descriptor formats        */
#include <iledef>			/* Item list entry formats            */
#include <libdef>			/* RTL LIB$ message codes, etc...     */
#include <lib$routines>			/* RTL LIB$ routines                  */
#include <libvmdef>			/* LIB$...VM definitions              */
#include <math>				/* Mathematics RTL definitions        */
#include <stdarg>			/* Variable argument list access      */
#include <stdio>			/* Sandard I/O functions              */
#include <stdlib>			/* Standard library functions         */
#include <string>			/* Standard string handling functions */
#include <ssdef>			/* System status values               */
#include <uiddef>			/* Unique identifier value format     */
#include <utcblkdef>			/* UTC date/time definitions          */

#include <acmedef>			/* Common ACME definitions            */
#include <acmemsgdef>			/* ACME message codes                 */

#if __VMS_VER < 70220000
#include <acmeagentdef>			/* ACME agent related definitions     */
#else
#include <acmeagent_cb_def>
#include <acmeagent_co_def>
#include <acmeagent_data_def>
#endif

#define         STACK_SIZE_REQUIRED     2 * 1024

/*
 *  Local Definitions
 */
typedef struct dsc$descriptor_s dsc_s_t;

#define	_DSC_S(name) dsc_s_t name = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}

typedef struct dsc64$descriptor_s dsc64_s_t;

#define	_DSC64_S(name) dsc64_s_t name = \
		{1, DSC$K_DTYPE_T, DSC$K_CLASS_S, -1, 0, 0}

#define _RND_LEN(value) ((value + 3) & 0XFFFC)

#define SUCCESS(status) \
	((status) & 1)

#define FAILURE(status) \
	(!SUCCESS(status))

#define RETURN_FAILURE(status) \
	if (FAILURE(status)) return (status)

#define REPORT_FAILURE(status) \
	if (FAILURE(status)) lib$signal (status)

#define SIGNAL_FAILURE(status) \
	if (FAILURE(status)) lib$signal (status)

#endif	    /* __ACME_SERVER_H */
