/************************************************************************
**                                                                      *
**         COPYRIGHT  (c)  DIGITAL EQUIPMENT CORPORATION, 1993          *
**         ALL RIGHTS RESERVED.  UNPUBLISHED - RIGHTS RESERVED          *
**         UNDER THE COPYRIGHT LAWS OF THE UNITED STATES.               *
**                                                                      *
**         RESTRICTED RIGHTS LEGEND: USE, DUPLICATION, OR DISCLOSURE    *
**         BY THE U.S. GOVERNMENT IS SUBJECT TO RESTRICTIONS AS SET     *
**         FORTH IN SUBPARAGRAPH (C)(1)(II) OF DFARS 252.227-7013,      *
**         OR IN FAR 52.227-19, OR IN FAR 52.227-14 ALT. III, AS        *
**         APPLICABLE.                                                  *
**                                                                      *
**         THIS SOFTWARE IS PROPRIETARY TO AND EMBODIES CONFIDENTIAL    *
**         TECHNOLOGY OF DIGITAL.  POSSESSION, USE, OR COPYING OF THE   *
**         SOFTWARE AND MEDIA IS AUTHORIZED ONLY PURSUANT TO A VALID    *
**         WRITTEN LICENSE FROM DIGITAL.                                *
**                                                                      *
*************************************************************************
**++
**
**  FACILITY:
**
**      X.25 Example Program
**
**  ABSTRACT:
**
**	SEND PROGRAM
**  
**      Digital is furnishing this example software "as is" without
**      warranty of any kind, express or implied, including the implied
**      warranties of merchantability and fitness for a particular purpose.
**      Digital disclaims any and all liability for the performance or
**      non-performance of this software.
**
**
**      This program is intended to run with the receive example programes. 
**	Data is entered via the terminal to the send program, and sent by
**	X.25 to the receive program.  
**	
**	The following NCL commands can be used to configure X.25.  This 
**      configeration assumes the following
**	    - the send and recieve programs are running  on the same system
**	    - the same gateway is used to place and outgoing call and recieve 
**	    - the incomming call.
**	    - the recieve example is started by a application entity
**	    - the file specified by the application entity contains a DCL
**	      command to run the receive executable.
**	      
**
**    create x25 access
**    create x25 client
**    !
**    !	Create DTE classes
**    !
**    create x25 access dte class crock type remote
**    set x25 access dte class crock service node {(node=dundee, -
**	    rating=512)}
**    create x25 access dte class crock1 type remote
**    set x25 access dte class crock1 service node {(node=dundee, -
**	    rating=512)}
**    !                                                                 
**    !	Create security DTE class
**    !
**    create x25 access security dte class default
**    !
**    !	Create remote DTE entity
**    !
**    create x25 access security dte class default remote dte match_all -
**	    remote address prefix *
**    set x25 access security dte class default remote dte match_all -
**	    rights identifier {match_all}
**    !
**    !	Create template
**    !
**    create x25 access template net_template1
**    set x25 access template net_template1 dte class crock
**    create x25 access template default
**    !
**    !	Create filter
**    !
**    create x25 access filter receive
**    set x25 access filter receive incoming dte address 12345
**    !
**    !	Create security filter
**    !
**    create x25 access security filter default
**    set x25 access security filter default acl -
**	    {(identifier=(match_all),access=all)}
**    !
**    !	Create application entity
**    !
**    create x25 access application receive
**    set x25 access application receive filters {receive}
**    set x25 access application receive user system
**    set x25 access application receive file sys$system:x25$receive.com
**    !
**    !	Enable everything
**    !
**    enable x25 access
**    enable x25 client
**    enable x25 access application receive
**
**
**
**  FUNCTIONAL DESCRIPTION:
**
**	* Include external macro and constant definitions
**	  and define local macros and constants
**	* Declare the NCB structure and fill with call connect information
**	* Declare structures for NCB descriptor, mailbox message and IOSB
**	* Create a mailbox for the network device
**	* Assign an input/output (I/O) channel to the network
**	  device (NWA0:)
**	* Set up a virtual circuit
**	* Read the mailbox to obtain the status of the connection
**	* Loop reading data from keyboard and sending to remote
**	  process until control-z received
**	* Clear the call
**	* Deassign the mailbox and I/O channels
**
**--
**/
 
/*
* Included macros and definitions
*/
 
#include <starlet.h>
#include <stdio.h>		    /* Standard C i/o		*/
#include <ssdef.h>		    /* System services		*/
#include <descrip.h>		    /* Calling std. descriptors	*/
#include <iodef.h>		    /* i/o definitions		*/
#include <psilib.h>		    /* P.S.I. constants		*/
#include <string.h>

/*
* Local macros and definitions
*/
 
#define check_status(x) if (!((x) &1)) sys$exit(x) 	/* Error handler */
#define IOBSZ	128
#define CTRLZ	26


/*
* Define the following three constants as required,
* REMDTE is the remote DTE address and
* TEMPLATE is the template of the default values for the call parameters
*/

#define REMDTE	"12345"
#define TEMPLATE "NET_TEMPLATE1"
 
/*
* Entry point 
*/
 
main()
{ 
    /*
    * Local storage
    */

    int status;				    /* Service return status	*/
    short x25_channel, mbx_channel;	    /* Channel numbers for i/o	*/
    char iobuf[IOBSZ];			    /* I/o buffer		*/
    
    /*
    * Network connect block
    */
 
    static struct ncb {
        struct rem_dte {		    /* DTE Address		*/
        	short len;		
        	short code;
        	char s_siz;		    /* Counted ascii string	*/
        	char s[sizeof(REMDTE)-1];
        } rem_dte;
	struct template {		    /* Template			*/
		short len;
		short code;
		char s_siz;
		char s[sizeof(TEMPLATE)-1];
	} template;
    } ncb = { 	{ sizeof(struct rem_dte),
        	  psi$c_ncb_remdte,
    	  	  sizeof(ncb.rem_dte.s),
    		  REMDTE  },
		{ sizeof(struct template),
		  psi$c_ncb_template,
		  sizeof(ncb.template.s),
		  TEMPLATE }
    	    };
 
    /*
    * NCB Descriptor
    */
    
    static struct dsc$descriptor ncb_desc = {	sizeof(ncb),
    						DSC$K_DTYPE_VT,
    						DSC$K_CLASS_VS,
    						(char*)&ncb	};
    /*
    * Mailbox message buffer
    */
    
    static struct mbx_mess {
    	short msgtype;
    	short unit;
    	char name_siz;
    	char name[15];
    	char info_siz;
    	char info[15];
    } mbx_mess;
 
    /*
    * IO Status block definition
    */
 
    volatile struct {
        unsigned short	status;			/* Final io status	*/
        unsigned short	dlen;			/* Usually data length	*/
        unsigned short 	devdep1, devdep2;	/* Device dependent	*/
        }  iosb;
 
    /*
    * Static string descriptors for mailbox and network device
    */
 
    static $DESCRIPTOR(mbx_name, "X25S_MBX");
    static $DESCRIPTOR(dev_name, "_NWA0:");
	
    /* 
    * Create network device mailbox and assign network channel
    */
 
    status = sys$crembx(0,			/* Create mailbox	*/
    			&mbx_channel,		/* channel		*/
    			0,
    			0,
    			0,
    			0,
    			&mbx_name);		/* logical name		*/
    check_status(status);			/* Check for error	*/
 
    						/* Assign a channel	*/
    status = sys$assign(&dev_name,		/* to network device	*/
    			&x25_channel,		/* channel number	*/
    			0,
    			&mbx_name);		/* mailbox logical name	*/
    check_status(status);			/* Check for error	*/

 
    /*
    * Set up a virtual call to receive program and get connect information
    * from the mailbox
    */
 
    status = sys$qiow(	0, 			/* Issue QIO and wait	*/
    			x25_channel,		/* to network device	*/
    			IO$_ACCESS,		/* funtion is make call	*/
    			&iosb,			/* I/O status block	*/
    			0,
    			0,
    			0,
    			&ncb_desc,		/* call NCB descriptor	*/
    			0,
    			0,
    			0,
    			0);
    check_status(status);			/* Check for error	*/
    check_status(iosb.status);


    status = sys$qiow(	0,			/* Issue QIO and wait	*/
    			mbx_channel,		/* to mailbox channel	*/
    			IO$_READVBLK,		/* function is read	*/
    			&iosb,			/* I/O status block	*/
    			0,
    			0,
    			&mbx_mess,		/* mailbox buffer	*/
    			sizeof(struct mbx_mess),/* and its size		*/
    			0,
    			0,
    			0,
    			0);
    check_status(status);
    check_status(iosb.status);			/* Check for I/O error	*/
 
    /*
    * Code to decode call accept mailbox message
    */
    
    /* ... */
 
    /*
    * Enter mainloop to read from stdin stream and send it over the network
    * to the remote process.  When end of file is reached call will be
    * cleared.
    */
 
    /*
    * Read lines from stdin until EOF
    */
    while(((char *)gets(iobuf)) != NULL) {

    	status = sys$qiow(0,			/* Issue QIO and wait	*/
    			x25_channel,		/* to network device	*/
    			IO$_WRITEVBLK,		/* function is write	*/
    			&iosb,			/* I/O status block	*/
    			0,
    			0,
    			iobuf, 			/* buffer address	*/
    			strlen(iobuf) + 1,	/* and size incldng '/0'*/
    			0,
    			0,
    			0,
    			0);
    	check_status(status);
    	check_status(iosb.status);		/* Check for I/O error	*/
    }
 
    /*
    * End of file was encountered. Send control-Z to remote process, clear
    * the call and deassign the I/O channels.
    */
 
    iobuf[0] = CTRLZ; 				/* I/O buffer is ctl-Z	*/
 
    status = sys$qiow(	0,			/* Issue QIO and wait	*/
    			x25_channel,		/* to the network device*/
    			IO$_WRITEVBLK,		/* function is write	*/
    			&iosb,			/* I/O status block	*/
    			0,
    			0,
    			iobuf, 			/* I/O buffer		*/
			1,			/* and its length	*/
    			0,
    			0,
    			0,
    			0);
    check_status(status);
    check_status(iosb.status);			/* Check for I/O error	*/


    status = sys$qiow(	0,			/* Issue QIO and wait	*/
    			x25_channel,		/* to network device	*/
    			IO$_DEACCESS,		/* functn is clear call */
    			&iosb,			/* I/O status block	*/
    			0,
    			0,
    			0,
    			0,
    			0,
    			0,
    			0,
    			0);
    check_status(status);
    check_status(iosb.status);			/* Check for I/O error	*/
 
    status = sys$dassgn(x25_channel);		/* Deassign netwk device*/
    check_status(status);			/* Check for error	*/
 
    status = sys$dassgn(mbx_channel);		/* Deassign mailbox	*/
    check_status(status);			/* Check for error	*/
 
    sys$exit(SS$_NORMAL);			/* Exit with success	*/
 
}
