	PROGRAM PSI$X25_RECEIVE_FORTRAN
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CC                                                                      C
CC         COPYRIGHT  (c)  DIGITAL EQUIPMENT CORPORATION, 1993          C
CC         ALL RIGHTS RESERVED.  UNPUBLISHED - RIGHTS RESERVED          C
CC         UNDER THE COPYRIGHT LAWS OF THE UNITED STATES.               C
CC                                                                      C
CC         RESTRICTED RIGHTS LEGEND: USE, DUPLICATION, OR DISCLOSURE    C
CC         BY THE U.S. GOVERNMENT IS SUBJECT TO RESTRICTIONS AS SET     C
CC         FORTH IN SUBPARAGRAPH (C)(1)(II) OF DFARS 252.227-7013,      C
CC         OR IN FAR 52.227-19, OR IN FAR 52.227-14 ALT. III, AS        C
CC         APPLICABLE.                                                  C
CC                                                                      C
CC         THIS SOFTWARE IS PROPRIETARY TO AND EMBODIES CONFIDENTIAL    C
CC         TECHNOLOGY OF DIGITAL.  POSSESSION, USE, OR COPYING OF THE   C
CC         SOFTWARE AND MEDIA IS AUTHORIZED ONLY PURSUANT TO A VALID    C
CC         WRITTEN LICENSE FROM DIGITAL.                                C
CC                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CC++
C
C  FACILITY:
C
C      X25 Example Program
C
C  ABSTRACT:
C
C	RECEIVE PROGRAM
C  
C       Digital is furnishing this example software "as is" without
C       warranty of any kind, express or implied, including the implied
C       warranties of merchantability and fitness for a particular purpose.
C       Digital disclaims any and all liability for the performance or
C       non-performance of this software.
C
C
C       This program is intended to run with the send example programes. 
C	Data is entered via the terminal to the send program, and sent by
C	X.25 to the receive program.  
C	
C	The following NCL commands can be used to configure X.25.  This 
C      configeration assumes the following
C	    - the send and recieve programs are running  on the same system
C	    - the same gateway is used to place and outgoing call and recieve 
C	    - the incomming call.
C	    - the recieve example is started by a application entity
C	    - the file specified by the application entity contains a DCL
C	      command to run the receive executable.
C	      
C
C    create x25 access
C    create x25 client
C    !
C    !	Create DTE classes
C    !
C    create x25 access dte class crock type remote
C    set x25 access dte class crock service node {(node=dundee, -
C	    rating=512)}
C    create x25 access dte class crock1 type remote
C    set x25 access dte class crock1 service node {(node=dundee, -
C	    rating=512)}
C    !                                                                 
C    !	Create security DTE class
C    !
C    create x25 access security dte class default
C    !
C    !	Create remote DTE entity
C    !
C    create x25 access security dte class default remote dte match_all -
C	    remote address prefix *
C    set x25 access security dte class default remote dte match_all -
C	    rights identifier {match_all}
C    !
C    !	Create template
C    !
C    create x25 access template net_template1
C    set x25 access template net_template1 dte class crock
C    create x25 access template default
C    !
C    !	Create filter
C    !
C    create x25 access filter receive
C    set x25 access filter receive incoming dte address 12345
C    !
C    !	Create security filter
C    !
C    create x25 access security filter default
C    set x25 access security filter default acl -
C	    {(identifier=(match_all),access=all)}
C    !
C    !	Create application entity
C    !
C    create x25 access application receive
C    set x25 access application receive filters {receive}
C    set x25 access application receive user system
C    set x25 access application receive file sys$system:x25$receive.com
C    !
C    !	Enable everything
C    !
C    enable x25 access
C    enable x25 client
C    enable x25 access application receive
C
C
C   FUNCTIONAL DESCRIPTION:
C 
C       * Declare references to external variables and declare
C         local variables
C 	* Assign a mailbox for the network device to SYS$NET
C       * Assign an input/output (I/O) channel to the network
C         device (NWA0:)
C 	* Wait until a connection request appears in mailbox
C 	* Accept the connection
C 	* Loop reading data until control-z received
C 	* Clear the call
C 	* Deassign the mailbox and I/O channels
C
C--
C+
C External References:
C-
	IMPLICIT INTEGER*4 S
	EXTERNAL IO$_ACCESS, IO$_DEACCESS, IO$M_ACCEPT
	EXTERNAL IO$_READVBLK, IO$_WRITEVBLK
C+
C Literal Definitions:
C-
	INTEGER*2 MBXBUFSIZ, RCV_LEN
	CHARACTER* (*)  PSI_DEV, MBX
	PARAMETER  (PSI_DEV = '_NWA0:') 
	PARAMETER  (MBX = 'SYS$NET') 
	PARAMETER  (MBXBUFSIZ = 200) 
	PARAMETER  (RCV_LEN = 200) 
	PARAMETER  (MBX_HEADER_LENGTH = 21) 


C+
C Local Variables:
C-
	INTEGER*4 ACCEPT_NCB (2), FUNC
	INTEGER*2 IOSB (4), PSI_CHAN, MBX_CHAN
	LOGICAL*1 MBXBUF (MBXBUFSIZ), RCV_BUF (RCV_LEN) 
C+
C Open SYS$OUTPUT to write out message.
C-
	OPEN (UNIT = 1, FILE = 'SYS$OUTPUT', STATUS = 'NEW') 
C+
C Assign mailbox for network.
C-
	I = SYS$ASSIGN (MBX, MBX_CHAN,,) 
	IF (.NOT.I) GOTO 99




C+
C Assign a channel for PSI.
C-
	I = SYS$ASSIGN (PSI_DEV, PSI_CHAN,, MBX) 
	IF (.NOT.I) GOTO 99
C+
C Read the mailbox for connects.
C-
	I = SYS$QIOW (%VAL (0), %VAL (MBX_CHAN), IO$_READVBLK, IOSB,,, 
	1 MBXBUF, %VAL (MBXBUFSIZ),,,,) 
	IF (.NOT.I) GOTO 99
	IF (.NOT.IOSB (1)) GOTO 98


C+
C Accept the connection.
C-
	ACCEPT_NCB (1)  = IOSB(2) - MBX_HEADER_LENGTH
	ACCEPT_NCB (2)  = %LOC (MBXBUF (22)) 
	FUNC = %LOC (IO$_ACCESS) .OR.%LOC (IO$M_ACCEPT) 
	I = SYS$QIOW (%VAL (0), %VAL (PSI_CHAN), %VAL (FUNC), IOSB,,, 
	1 %VAL (0), ACCEPT_NCB,,,,) 
	IF (.NOT.I) GOTO 99
	IF (.NOT.IOSB (1)) GOTO 98



C+
C Loop to receive messages from PSI_SEND. If an end of file message
C is received  (first byte contains 26 - control-Z),  clear the call.
C-
10	I = SYS$QIOW (%VAL (0), %VAL (PSI_CHAN), IO$_READVBLK, IOSB,,, 
	1 RCV_BUF, %VAL (RCV_LEN),,,,) 
	IF (.NOT.I) GOTO 99
	IF (.NOT.IOSB (1)) GOTO 98
C+
C If message is ^Z then exit else output message.
C-
	IF (RCV_BUF (1) .EQ.26) GOTO 20



	WRITE (1, 100)  (RCV_BUF (J), J = 1, IOSB (2)) 
100	FORMAT (' ', 80A1) 
	GOTO 10


C+
C End of file - close output file.
C-
20	CLOSE (UNIT = 1) 
C+
C Clear the call.
C-
	I = SYS$QIOW (%VAL (0), %VAL (PSI_CHAN), IO$_DEACCESS, IOSB,,, 
	1 ,,,,,) 
	IF (.NOT.I) GOTO 99
	IF (.NOT.IOSB (1)) GOTO 98
C+
C Deassign the network device channel.
C-
	I = SYS$DASSGN (%VAL (PSI_CHAN)) 
	IF (.NOT.I) GOTO 99
C+
C Deassign mailbox channel.
C-
	I = SYS$DASSGN (%VAL (MBX_CHAN)) 
	IF (.NOT.I) GOTO 99
C+
C Exit with success code.
C-
	CALL SYS$EXIT (%VAL (1)) 
C+
C Exit with error status.
C-
98	I = IOSB (1) 
99	CALL SYS$EXIT (%VAL (I)) 
	END
