/****************************************************************************/
/*                                                                          */
/*                    ****  COPYRIGHT NOTICE ****                           */
/*                                                                          */
/*                                                                          */
/*  Copyright (c) Digital Equipment Corporation, 1992                       */
/*                                                                          */
/*  All Rights Reserved.  Unpublished rights reserved under the             */
/*  copyright laws of the United States.                                    */
/*                                                                          */
/*  The software contained on this media is proprietary to and              */
/*  embodies the confidential technology of  Digital Equipment              */
/*  Corporation.  Possession, use, duplication or dissemination             */
/*  of the software and media is authorized only pursuant to a              */
/*  valid written license from Digital Equipment Corporation.               */
/*                                                                          */
/*                                                                          */
/*  The information in this software is subject to change  without  notice  */
/*  and  should  not  be  construed  as  a commitment by DIGITAL EQUIPMENT  */
/*  CORPORATION.                                                            */
/*                                                                          */
/*  DIGITAL assumes no responsibility for the use or  reliability  of  its  */
/*  software on equipment which is not supplied by DIGITAL.                 */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

/************************************************************************
 **
 **
 **   FACILITY:          DECss7 IVP (Installation Verification Procedure)
 **
 **   ENVIRONMENT:       OSF/1 V3.0
 **
 **   MODULE NAME:       ss7_ivp_typedefs.h
 **
 **   DESCRIPTION:       Common types definition
 **                      
 **   AUTHORS:          Marc Beatini
 **
 **   CREATION DATE:    17 February 1995
 **
 **   MODIFICATION HISTORY:
 **       Name       (UserID)        Date        Comments
 **
 ************************************************************************/



/*
**
**  Data structure definitions
**
*/

/*"message_class" values: (ASCII codes values are used for ease of debugging) */
#define	cell_ID_msg_class   65	/* ASCII "A" for a "cell ID" message */
#define	TCAP_tr_msg_class   66	/* ASCII "B" for a "TCAP trace" message */

#define	cell_ID_msg_length  9	/* total size of "cell ID" message below */
#define	TCAP_tr_msg_length  255	/* total size of "TCAP trace" message below */

typedef struct {
	int cell_x, 
            cell_y;
} cell_ID_type;

typedef struct {
	unsigned long           dialogue_id;
	long                    component_id;
	long                    linked_id;
        char                    ope_data[MAX_DATA_LEN];
        unsigned long           ope_len;
        char                    parm_data[MAX_DATA_LEN];
        unsigned long           parm_len; 
      	unsigned char           last;
	unsigned long           identifier;
	unsigned char           last_component;
    	unsigned long           user_info;
} hlr_invoke_indication_t;

typedef struct {
	unsigned long           dialogue_id;
	long                    component_id;
        char                    ope_data[MAX_DATA_LEN];
        unsigned long           ope_len;
        char                    parm_data[MAX_DATA_LEN];
        unsigned long           parm_len; 
      	unsigned char           last;
      	unsigned char           last_component;
	unsigned long           user_info;
} msc_result_t;

typedef struct {
	unsigned long           dialogue_id;
	long                    component_id;
	unsigned long           user_info;
} msc_cancel_t;

typedef struct {
	unsigned long           dialogue_id;
	char                    dest_data[MAX_DATA_LEN];
	unsigned long           dest_len;
	char                    orig_data[MAX_DATA_LEN];
	unsigned long           orig_len;
	unsigned long           quality_of_service;
	unsigned char           components_present;
	unsigned long           user_info;
} write_begin_ind_t;

typedef struct {
	unsigned long           dialogue_id;
	long                    component_id;
	long                    linked_id;
        char                    ope_data[MAX_DATA_LEN];
        unsigned long           ope_len;
        char                    parm_data[MAX_DATA_LEN];
        unsigned long           parm_len; 
	unsigned char           last;
	unsigned long           identifier;
	unsigned char           last_component;
	unsigned long           user_info;
} write_invoke_ind_t;	

typedef struct {
	unsigned long           dialogue_id;
	unsigned long           quality_of_service;
	unsigned char           components_present;
	unsigned long           user_info;
} write_continue_ind_t;

typedef struct {
	unsigned long           dialogue_id;
	unsigned long           source;
        char                    reason_data[MAX_DATA_LEN];
        unsigned long           reason_len;
	unsigned long           quality_of_service;
	unsigned long           user_info;
} write_abort_ind_t;

typedef struct {
	unsigned long           dialogue_id;
	long                    component_id;
        char                    error_data[MAX_DATA_LEN];
        unsigned long           error_len;
        char                    parm_data[MAX_DATA_LEN];
        unsigned long           parm_len; 
	unsigned long           identifier;
	unsigned char           last_component;
	unsigned long           user_info;
} write_error_ind_t;

typedef struct {
	unsigned long           dialogue_id;
	long                    component_id;
	unsigned long           source;
	unsigned long           type;
	unsigned long           problem;
        char                    parm_data[MAX_DATA_LEN];
        unsigned long           parm_len; 
	unsigned char           last_component;
	unsigned long           user_info;
} write_reject_ind_t; 

typedef struct {
	unsigned long           dialogue_id;
	long                    component_id;
        char                    ope_data[MAX_DATA_LEN];
        unsigned long           ope_len;
        char                    parm_data[MAX_DATA_LEN];
        unsigned long           parm_len; 
	unsigned char           last;
	unsigned char           last_component;
	unsigned long           user_info;
} write_result_ind_t; 

typedef struct {
	unsigned long           dialogue_id;
	long                    component_id;
	unsigned long           user_info;
} write_cancel_ind_t;

typedef struct {
	unsigned long          dialogue_id;
	unsigned long          quality_of_service;
	unsigned char          components_present;
	unsigned long          user_info;
} write_end_ind_t;

typedef struct {
	int   ind_type;
	void  *next;
	union {
		hlr_invoke_indication_t indic;
		write_begin_ind_t       begin;
		write_invoke_ind_t      invoke;
		write_continue_ind_t    cont;
		write_abort_ind_t       abrt;
		write_error_ind_t       error;
		write_reject_ind_t      reject;
		write_result_ind_t      result;
		write_cancel_ind_t      cancel;
		write_end_ind_t         end;
		msc_result_t            msc_result;
                msc_cancel_t            msc_cancel; 
	} val;
} to_process_t;

struct queue {
   struct queue *flink;
   struct queue *blink;
   to_process_t *object;
};


