$! RESET_DEVICE_PROTECTION
$!
$! P1 = device type (default = "TAPE")
$! P2 = device name subset (default = "*")
$!
$! This command procedure resets the security profile for disk
$! and tape devices or terminal devices from the security class device
$! template (i.e. DEVICE.DISK, DEVICE.TAPE, or DEVICE.TERMINAL).  The security
$! profile includes device ownership, SOGW (16-bit) protection, and an initial
$! ACL.  This command procedure accepts a wild-card device designation.
$!
$! To restore the device allocation behavior of pre-V6.0 VMS systems, use the
$! following commands:
$!
$!  set security/class=security/profile=template=disk device/prot=(w:rw)
$!  @reset_device_protection disk *
$!  set security/class=security/profile=template=tape device/prot=(w:rw)
$!  @reset_device_protection tape *
$!
$! Other examples:
$!
$!  @reset_device_protection disk $254$dua*	! all $254$DUA disk devices
$!  @reset_device_protection tape *mub*		! all MUB tape devices
$!  @reset_device_protection term *		! all local terminals
$!
$!
$! 
$!  NOTE: The change in default protection prevents any unprivileged user
$!    from allocating a tape or disk, denying access to users who really
$!    require access.  The shipped configuration will be overly restrictive
$!    for some sites, no default policy can meet the requirements of all
$!    sites.  The default protection is probably a good choice for disks
$!    intended for 'public' access (mounted /SYSTEM or /CLUSTER).  For
$!    this reason, this procedure will not alter the protection for
$!    devices which are currently mounted.
$! 
$
$   old_privs = ""
$
$   on control_y then goto leave
$   on warning then goto leave
$
$   old_privs = f$setprv("BYPASS,SHARE")
$
$   dtype = p1
$   dname = p2
$
$ get_dtype:
$   if dtype .eqs. "" then inquire dtype "Select device type (DISK, TAPE, TERM) [TAPE]"
$   if dtype .eqs. "" then dtype = "TAPE"
$   template = dtype
$   if dtype .eqs. "DISK" then goto get_dtype_done
$   if dtype .eqs. "TAPE" then goto get_dtype_done
$   if f$extract(0,4,dtype) .eqs. "TERM" 
$	then
$	dtype = "TERM" 
$	template = "TERMINAL"
$	goto get_dtype_done
$	endif
$   dtype = ""
$   goto get_dtype
$ get_dtype_done:
$
$   if dname .eqs. "" then inquire dname "Select device name subset          [*]"
$   if dname .eqs. "" then dname = "*"
$
$   on severe_error then goto leave
$
$ loop:
$   device = f$device(dname,dtype)
$   if device .eqs. "" then goto loop_done
$   if f$getdvi(device,"MNT") then goto loop
$   set security /log -
	/like=(class=security_class,name=device.'template') -
	/class=device 'device'
$   goto loop
$ loop_done:
$
$ leave:
$   set noon
$   set proc/priv=('old_privs')
$   exit
