$ goto start
$!
$! This command procedure is an example of using the DCL lexical functions
$! that return Resource Affinity Domain (RAD) information. The RAD items
$! return comma-separated lists.
$!
$ start:
$   say :== write sys$output
$!
$   system  = f$getsyi("hw_name")
$   node    = f$getsyi("NODENAME")
$   version = f$getsyi("VERSION")
$   arch    = f$getsyi("ARCH_NAME")
$   galaxy  = f$getsyi("GALAXY")
$!
$   say ""
$   say "Node: ",node," Version: ",version,"  System: ",  system
$!
$! Is RAD support on?
$!
$   rad_count = f$getsyi("RAD_MAX_RADS")
$
$   if  rad_count .gt. "1" then goto we_have_rads
$   say ""
$   say "''node consists of only a single RAD."
$   say ""
$   exit
$!
$ we_have_rads:
$   rad_cpus      = f$getsyi("rad_cpus")
$   rad_memsize   = f$getsyi("rad_memsize")
$   rad_shmemsize = f$getsyi("rad_shmemsize")
$!
$   rad = 0
$ symb_loop:
$   rad$cpu$'rad'   = ""	
$   rad$mem$'rad'   = ""
$   rad$shmem$'rad' = ""
$   rad = rad + 1
$   if rad .lt. rad_count then goto symb_loop
$
$   n = 0
$ memory_loop:
$   rad = f$element(n,",",rad_memsize)
$   if rad .eqs. "," then goto memory_done   
$   n = n+1
$   mem_size = f$element(n,",",rad_memsize)
$   rad$mem$'rad' = mem_size
$   n = n + 1
$   goto memory_loop
$!
$ memory_done: 
$!
$   n = 0
$ shared_memory_loop:
$   rad = f$element(n,",",rad_shmemsize)
$   if rad .eqs. "," then goto shared_memory_done
$   n = n+1
$   shmem_size = f$element(n,",",rad_shmemsize)
$   rad$shmem$'rad' = shmem_size
$   n = n + 1
$   goto shared_memory_loop
$!
$ shared_memory_done:
$
$   n = 0
$ cpu_loop:
$   cpu_rad = f$element(n,",",rad_cpus)
$   if cpu_rad .eqs. "," then goto cpu_done
$   n = n + 1
$   cpu = f$element(n,",",rad_cpus)
$   if cpu .eqs. "," then goto cpu_done
$   n = n + 1
$   rad$cpu$'cpu_rad' = rad$cpu$'cpu_rad' + cpu + ","
$   goto cpu_loop
$!
$ cpu_done:
$!
$! Outuput headers
$!
$   say ""
$   if galaxy .eq. 0
$   then
$       say "RAD   Memory (GB)   CPUs"
$       say "===   ===========   ==============="
$   else
$       say "                    Galaxy"
$       say "      Private       Shared"
$       say "RAD   Memory (GB)   Memory (GB)   CPUs"
$       say "===   ===========   ===========   ==============="
$   endif
$
$! Format the Output
$
$   rad = 0
$ output_loop:
$   cpu_list := ""
$   multi = 0
$   first = 1
$   seperator = ","
$   if rad$cpu$'rad' .eqs. "" then goto no_cpus
$   goto next_cpu
$
$!
$! Convert the list of CPUs to a more compact list.
$!
$ cpu_format_loop:
$   if cpu .eq. last_cpu + 1
$   then
$	seperator = "-"
$	last_cpu = cpu
$	goto next_cpu
$   endif
$
$   cpu_list = cpu_list + seperator + last_cpu + "," + cpu
$   last_cpu = cpu
$   seperator = ","
$
$ next_cpu:
$
$   comma = f$locate(",",rad$cpu$'rad')
$   cpu = f$extract(0,comma,rad$cpu$'rad')
$   rad$cpu$'rad' = f$extract(comma+1,f$length(rad$cpu$'rad'),rad$cpu$'rad')
$   if cpu .nes. ""
$   then
$       if first .eq. 1
$       then
$	    last_cpu = cpu
$	    cpu_list = cpu
$           first  = 0
$           goto next_cpu
$        endif
$        goto cpu_format_loop
$    endif
$!
$    cpu_list = cpu_list + seperator + last_cpu
$
$ no_cpus:
$!
$! Compute memory size in GBs and display
$!
$    mem_gb = rad$mem$'rad'/131072
$    mem_mb = rad$mem$'rad'/128
$    mem_gb_frac = ((mem_mb - (mem_gb*1024)) * 100 ) / 1024
$
$    tmp = rad$mem$'rad' + rad$shmem$'rad'
$    if tmp .eq. 0
$    then
$       if cpu_list .eqs. "" then goto next_rad
$    endif
$
$   
$    l = f$length(rad$cpu$'rad')
$    rad$cpu$'rad' = f$extract(0,l-1,rad$cpu$'rad')
$    if galaxy .eq. 0
$    then
$        say f$fao("!3UL   !6SL.!2ZL     !AS", rad,mem_gb, mem_gb_frac,cpu_list )
$    else
$        shmem_gb = rad$shmem$'rad'/131072
$        shmem_mb = rad$shmem$'rad'/128
$        shmem_gb_frac = ((shmem_mb - (shmem_gb*1024)) * 100 ) / 1024
$        say f$fao("!3UL   !6SL.!2ZL     !6SL.!2ZL     !AS", rad,mem_gb, mem_gb_frac,shmem_gb,shmem_gb_frac,cpu_list )
$    endif
$ next_rad:
$    rad = rad + 1
$    if rad .eq. rad_count then goto done
$    goto output_loop
$!
$ done:
$   say ""
$   exit
