4	PROGRAM VOTS_FORTRAN_EXAMPLE
C
	IMPLICIT NONE
C
	INCLUDE '($SYSSRVNAM)'
	INCLUDE '($IODEF)'
	INCLUDE '($MSGDEF)'
	INCLUDE '($SSDEF)'
	INCLUDE 'SYS$LIBRARY:OSIT'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	INTEGER*4 GET_STREAM_BLOCK, GET_VOTS_CHANNEL, ATTACH_TO_TSAP
C
	INTEGER*4 STATUS, IO_STREAM
C
	CALL INITIALISE_DATA_STRUCTURES ()
C
	IO_STREAM = GET_STREAM_BLOCK ()
	IF (IO_STREAM .NE. 0) THEN
	    IF ( (GET_VOTS_CHANNEL (STREAMS(IO_STREAM))) .AND.
	1       (ATTACH_TO_TSAP (STREAMS(IO_STREAM))) ) THEN
		STATUS = SYS$HIBER()
	    ELSE
		WRITE (*,*) 'Failed to attach to TSAP'
	    END IF
	END IF
C
	END

C-----------------------------------------------------------------------
	SUBROUTINE INITIALISE_DATA_STRUCTURES (DUMMYARG)
C
	IMPLICIT NONE
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	INTEGER*4 DUMMYARG
	INTEGER*4 I
C
	DO I = 1,TOP_STREAM
	    STREAMS(I).STREAM    = I
	    STREAMS(I).REF_COUNT = 0
	    STREAMS(I).DEV_CHN   = 0
	    STREAMS(I).MBX_CHN   = 0
	END DO
C	   
	DO I = 1,TOP_MBX_BUFFER
	    MBX_BUFFERS(I).STREAM    = 0
	    MBX_BUFFERS(I).REF_COUNT = 0
	    MBX_BUFFERS(I).STATUS    = 0
	    MBX_BUFFERS(I).IOSB(1)   = 0
	    MBX_BUFFERS(I).IOSB(2)   = 0
	    MBX_BUFFERS(I).IOSB(3)   = 0
	    MBX_BUFFERS(I).IOSB(4)   = 0
	    MBX_BUFFERS(I).BUF_LEN   = 128
	    MBX_BUFFERS(I).BUF_USED  = 0
	    MBX_BUFFERS(I).MSGTYPE  = 0
	    MBX_BUFFERS(I).UNIT      = 0
	END DO
C
	DO I = 1,TOP_BUFFER
	    BUFFERS(I).STREAM    = 0
	    BUFFERS(I).REF_COUNT = 0
	    BUFFERS(I).BUF 	 = I
	    BUFFERS(I).STATUS    = 999
	    BUFFERS(I).IOSB(1)   = 0
	    BUFFERS(I).IOSB(2)   = 0
	    BUFFERS(I).IOSB(3)   = 0
	    BUFFERS(I).IOSB(4)   = 0
	    BUFFERS(I).BUF_LEN   = 128
	    BUFFERS(I).BUF_USED  = 0
	END DO
C
	END

C-----------------------------------------------------------------------
	INTEGER*4 FUNCTION GET_STREAM_BLOCK (DUMMYARG)
C
	IMPLICIT NONE
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	INTEGER*4 DUMMYARG
	INTEGER*4 I
C
	GET_STREAM_BLOCK = 0
C
	DO I = 1,TOP_STREAM
	    IF (STREAMS(I).REF_COUNT .EQ. 0) THEN
		STREAMS(I).REF_COUNT = 1
		GET_STREAM_BLOCK = I
		RETURN
	    END IF
	END DO
C
	WRITE (*,*) 'Failed to allocate stream block'
C
	END

C-----------------------------------------------------------------------
	SUBROUTINE INCREMENT_STREAM_REF_COUNT (IO_STREAM)
C
	IMPLICIT NONE
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
C	We must make sure that we are using the real stream block and
C	not a copy of it in one of the buffers, so we get the stream number
C	and access the stream block via the COMMON data area.
C
	RECORD /STREAMBLOCK/ IO_STREAM
C
	INTEGER*4 STREAM
C
	STREAM = IO_STREAM.STREAM
C
	STREAMS(STREAM).REF_COUNT = STREAMS(STREAM).REF_COUNT + 1
C
	END

C-----------------------------------------------------------------------
	SUBROUTINE DECREMENT_STREAM_REF_COUNT (IO_STREAM)
C
	IMPLICIT NONE
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
C	We must make sure that we are using the real stream block and
C	not a copy of it in one of the buffers, so we get the stream number
C	and access the stream block via the COMMON data area.
C
	RECORD /STREAMBLOCK/ IO_STREAM
C
	INTEGER*4 STREAM
C
	STREAM = IO_STREAM.STREAM
C
	STREAMS(STREAM).REF_COUNT = STREAMS(STREAM).REF_COUNT - 1
C
	END

C-----------------------------------------------------------------------
	SUBROUTINE FREE_STREAM_BLOCK (IO_STREAM)
C
	IMPLICIT NONE
C
	INCLUDE	'($SYSSRVNAM)'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
C	We must make sure that we are using the real stream block and
C	not a copy of it in one of the buffers, so we get the stream number
C	and access the stream block via the COMMON data area.
C
	RECORD /STREAMBLOCK/ IO_STREAM
C
	INTEGER*4 STREAM, STATUS
C
	STREAM = IO_STREAM.STREAM
C
	WRITE (*,*) 'Freeing Stream Block ',STREAM
C
	STREAMS(STREAM).REF_COUNT = STREAMS(STREAM).REF_COUNT - 1
C
C	As this stream block is no longer being used, deassign the VOTS
C	and mailbox channels.
C
	STATUS = SYS$DASSGN (%VAL (STREAMS(STREAM).DEV_CHN))
	IF (.NOT. STATUS) CALL LIB$SIGNAL (%VAL (STATUS))
C
	STATUS = SYS$DASSGN (%VAL (STREAMS(STREAM).MBX_CHN))
	IF (.NOT. STATUS) CALL LIB$SIGNAL (%VAL (STATUS))
C
	STREAMS(STREAM).DEV_CHN = 0
	STREAMS(STREAM).MBX_CHN = 0
C
	END

C-----------------------------------------------------------------------
	INTEGER*4 FUNCTION GET_MBX_BUFFER (DUMMYARG)
C
	IMPLICIT NONE
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	INTEGER*4 DUMMYARG
	INTEGER*4 I
C
	GET_MBX_BUFFER = 0
C
	DO I = 1,TOP_MBX_BUFFER
	    IF (MBX_BUFFERS(I).REF_COUNT .EQ. 0) THEN
		MBX_BUFFERS(I).REF_COUNT = 1
		GET_MBX_BUFFER = I 
		RETURN
	    END IF
	END DO
C
	WRITE (*,*) 'Failed to allocate mailbox buffer'
C
	END

C-----------------------------------------------------------------------
	SUBROUTINE FREE_MBX_BUFFER (MBX_BUF)
C
	IMPLICIT NONE
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
C
	RECORD /MBXBUFFER/ MBX_BUF
C
	MBX_BUF.REF_COUNT = 0
C
	END

C-----------------------------------------------------------------------
	INTEGER*4 FUNCTION GET_BUFFER (DUMMYARG)
C
	IMPLICIT NONE
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	INTEGER*4 DUMMYARG
	INTEGER*4 I
C
	GET_BUFFER = 0
C
	DO I = 1,TOP_BUFFER
	    IF (BUFFERS(I).REF_COUNT .EQ. 0) THEN
		BUFFERS(I).REF_COUNT = 1
		GET_BUFFER = I
		RETURN
	    END IF
	END DO
C
	WRITE (*,*) 'Failed to allocate buffer'
C
	END

C-----------------------------------------------------------------------
	SUBROUTINE FREE_BUFFER (BUF)
C
	IMPLICIT NONE
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
C
	RECORD /VOTSBUFFER/ BUF
C
	BUF.REF_COUNT = BUF.REF_COUNT - 1
C
	END

C-----------------------------------------------------------------------
	INTEGER*4 FUNCTION GET_VOTS_CHANNEL (IO_STREAM)
C
	IMPLICIT NONE
C
	INCLUDE '($SYSSRVNAM)'
	INCLUDE '($IODEF)'
	INCLUDE '($MSGDEF)'
	INCLUDE '($SSDEF)'
	INCLUDE '($DVIDEF)'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /STREAMBLOCK/ IO_STREAM
C
	INTEGER*4 LIB$ASN_WTH_MBX
C
	INTEGER*4 STATUS, MAX_MSG, BUF_QUO
C
	CHARACTER*11 NET_DEV /'OSIT$DEVICE'/
C
C	Setting MAX_MSG and BUF_QUO to zero means that the VMS defaults
C	(as specified by the SYSGEN parameters DEFMBXMXMSG and 
C	DEFMBXBUFQUO) will be used to established the size of the
C	mailbox.
C
	MAX_MSG = 0
	BUF_QUO = 0
C
C	WRITE (*,*) 'Assign channels for stream block', IO_STREAM.STREAM
C
C	Assign a channel with an associated mailbox to VOTS
C
	STATUS = LIB$ASN_WTH_MBX (
	1			  NET_DEV,
	1			  MAX_MSG,
	1			  BUF_QUO,
	1			  IO_STREAM.DEV_CHN,
	1			  IO_STREAM.MBX_CHN
	1			 )
C
	IF (.NOT. STATUS) CALL LIB$SIGNAL (%VAL (STATUS))
C
C	WRITE (*,*) 'Device channel ', IO_STREAM.DEV_CHN
C	WRITE (*,*) 'Mailbox channel ', IO_STREAM.MBX_CHN
C
 	GET_VOTS_CHANNEL = STATUS      
C
	END

C-----------------------------------------------------------------------
	INTEGER*4 FUNCTION ATTACH_TO_TSAP (IO_STREAM)
C
	IMPLICIT NONE
C
	INCLUDE '($SYSSRVNAM)'
	INCLUDE '($IODEF)'
	INCLUDE '($MSGDEF)'
	INCLUDE '($SSDEF)'
	INCLUDE 'SYS$LIBRARY:OSIT'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /STREAMBLOCK/ IO_STREAM
C
	INTEGER*4 GET_MBX_BUFFER, MBX_READ
C
	BYTE NFB (5)
	DATA NFB /NFB$C_FC_ATTACH_TSAP, 0, 0, 0, 0/
C
	RECORD /DESCR/ NFB_DESCR
C
	CHARACTER*4 TSAP_ID /'ECHO'/
C
	INTEGER*4 STATUS, MBX_BUF
	INTEGER*2 IOSB(4)
C
C	NFB_DESCR.LENGTH = 4
	NFB_DESCR.LENGTH = 5 
	NFB_DESCR.ADDRESS = %LOC (NFB)
C
C	Attach to TSAP "ECHO"
C
	STATUS = SYS$QIOW (,
	1		   %VAL (IO_STREAM.DEV_CHN),
	1		   %VAL (IO$_ACPCONTROL),
	1		   IOSB,,,
	1		   %REF (NFB_DESCR),
	1		   %DESCR (TSAP_ID),,,,
	1		   )
	IF (.NOT. STATUS) CALL LIB$STOP (%VAL (STATUS))
	IF (.NOT. IOSB(1)) THEN
	    CALL LIB$SIGNAL (%VAL (IOSB(1)))
	    CALL LIB$STOP (%VAL (IOSB(3)))
	END IF
C
	MBX_BUF = GET_MBX_BUFFER ()
C
	STATUS = MBX_READ (IO_STREAM, MBX_BUFFERS(MBX_BUF))
C
	ATTACH_TO_TSAP = STATUS
C
	END

C-----------------------------------------------------------------------
	INTEGER*4 FUNCTION VOTS_CONNECT (IO_STREAM)
C
	IMPLICIT NONE
C
	INCLUDE '($SYSSRVNAM)'
	INCLUDE '($IODEF)'
	INCLUDE '($MSGDEF)'
	INCLUDE '($SSDEF)'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /STREAMBLOCK/ IO_STREAM
C
	RECORD /MBXBUFFER/ MBX_BUFFER
C
	CHARACTER*24 NCB /'INTERNET%12::"TSAP=ECHO"'/
C
	INTEGER*4 STATUS
	INTEGER*2 IOSB(4)
C
	MBX_BUFFER.BUF_LEN = 128
C
C	WRITE (*,*) 'T-CONreq - stream ', IO_STREAM.STREAM
C
C	Request a Transport connection
C
	STATUS = SYS$QIOW (,
	1		   %VAL (IO_STREAM.DEV_CHN), 
	1		   %VAL (IO$_ACCESS),
	1		   IOSB,,,,
	1		   %DESCR (NCB),,,,
	1		   )
	IF (.NOT. STATUS) CALL LIB$STOP (%VAL (STATUS))
	IF (.NOT. IOSB(1)) THEN
	    CALL LIB$SIGNAL (%VAL (IOSB(1)))
	    CALL LIB$STOP (%VAL (IOSB(3)))
	END IF
C
C	Check connection has been accepted by reading mailbox
C
	STATUS = SYS$QIOW (,
	1		   %VAL (IO_STREAM.MBX_CHN),
	1		   %VAL (IO$_READVBLK),
	1		   %REF (MBX_BUFFER.IOSB),,,
	1		   %REF (MBX_BUFFER.MSGTYPE),
	1		   %VAL (MBX_BUFFER.BUF_LEN),,,,
	1		  )
	IF (.NOT. STATUS) CALL LIB$STOP (%VAL (STATUS))
	IF (.NOT. IOSB(1)) THEN
	    CALL LIB$SIGNAL (%VAL (IOSB(1)))
	    CALL LIB$STOP (%VAL (IOSB(3)))
	END IF
C
C	Check mailbox message is confirmation
C
	IF (MBX_BUFFER.MSGTYPE .EQ. MSG$_CONFIRM) THEN
	    VOTS_CONNECT = STATUS
C	    WRITE (*,*) 'T-CONconf - stream ', IO_STREAM.STREAM
	ELSE IF (MBX_BUFFER.MSGTYPE .EQ. MSG$_REJECT) THEN
C	    WRITE (*,*) 'T-DISind (reject) - stream ', IO_STREAM.STREAM
	    CALL LIB$STOP (%VAL (SS$_PATHLOST))
	END IF
C
	VOTS_CONNECT = STATUS
C
	END

C-----------------------------------------------------------------------
	INTEGER*4 FUNCTION ACCEPT_TC (IO_STREAM, NCB_STRING)
C
	IMPLICIT NONE
C
	INCLUDE '($SYSSRVNAM)'
	INCLUDE '($MSGDEF)'
	INCLUDE '($IODEF)'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /STREAMBLOCK/ IO_STREAM
C
	BYTE NCB_STRING (*)
C
	INTEGER*4 GET_BUFFER, VOTS_READ
C
	RECORD /DESCR/ NCB
C
	INTEGER*4 STATUS, BUF
	INTEGER*2 IOSB(4)
C
C 	Build the NCB's descriptor 
C
	NCB.LENGTH = NCB_STRING(1)
	NCB.ADDRESS = %LOC (NCB_STRING(2))
C
C	WRITE (*,*) 'T-CONresp (accept) - stream ', IO_STREAM.STREAM
C
C	Now accept the TC
C
	STATUS = SYS$QIOW (,
	1		   %VAL (IO_STREAM.DEV_CHN), 
	1		   %VAL (IO$_ACCESS),
	1		   IOSB,,,,
	1		   %REF (NCB),,,,
	1		  )
	IF (.NOT. STATUS) CALL LIB$STOP (%VAL (STATUS))
	IF (.NOT. IOSB(1)) THEN
	    CALL LIB$SIGNAL (%VAL (IOSB(1)))
	    CALL LIB$STOP (%VAL (IOSB(3)))
	END IF
C
	BUF = GET_BUFFER ()
	STATUS = VOTS_READ (IO_STREAM, BUFFERS(BUF))
C
	ACCEPT_TC = STATUS
C
	END

C-----------------------------------------------------------------------
	INTEGER*4 FUNCTION REJECT_TC (IO_STREAM, NCB_STRING)
C
	IMPLICIT NONE
C
	INCLUDE '($SYSSRVNAM)'
	INCLUDE '($MSGDEF)'
	INCLUDE '($IODEF)'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /STREAMBLOCK/ IO_STREAM
C
	BYTE NCB_STRING (*)
C
	INTEGER*4 GET_BUFFER, VOTS_READ
C
	RECORD /DESCR/ NCB
C
	INTEGER*4 STATUS, BUF
	INTEGER*2 IOSB(4)
C
C 	Build the NCB's descriptor 
C
	NCB.LENGTH = NCB_STRING(1)
	NCB.ADDRESS = %LOC (NCB_STRING(2))
C
C	WRITE (*,*) 'T-CONresp (reject) - stream ', IO_STREAM.STREAM
C
C	Now accept the TC
C
	STATUS = SYS$QIOW (,
	1		  %VAL (IO_STREAM.DEV_CHN), 
	1		  %VAL (IO$_ACCESS),
	1		  IOSB,,,,
	1		  %REF (NCB),,,,
	1		  )
	IF (.NOT. STATUS) CALL LIB$STOP (%VAL (STATUS))
	IF (.NOT. IOSB(1)) THEN
	    CALL LIB$SIGNAL (%VAL (IOSB(1)))
	    CALL LIB$STOP (%VAL (IOSB(3)))
	END IF
C
	REJECT_TC = STATUS
C
	END

C-----------------------------------------------------------------------
	SUBROUTINE MBX_READ_AST (MBX_BUF)
C
	IMPLICIT NONE
C
	INCLUDE '($SYSSRVNAM)'
	INCLUDE '($MSGDEF)'
	INCLUDE '($SSDEF)'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /MBXBUFFER/ MBX_BUF
C
	INTEGER*4 GET_STREAM_BLOCK, GET_VOTS_CHANNEL, ACCEPT_TC, MBX_READ
	INTEGER*4 STATUS, STREAM
C
	IF (.NOT. MBX_BUF.IOSB(1)) THEN
	    CALL LIB$SIGNAL (%VAL (MBX_BUF.IOSB(1)))
	    CALL LIB$STOP (%VAL (MBX_BUF.IOSB(3)))
	END IF
C
	MBX_BUF.BUF_USED = MBX_BUF.IOSB(2)
C
	IF (MBX_BUF.MSGTYPE .EQ. MSG$_CONNECT) THEN
C
C	    It is a T-Connect Indication, so call the action routine
C	    and remember to issue a new read on the TSAP's mailbox
C
C	    WRITE (*,*) 'T-CONind (mbx)'

	    CALL T_CONNECT_INDICATION (MBX_BUF)
	    STATUS = MBX_READ (STREAMS(MBX_BUF.STREAM), MBX_BUF)

	ELSE IF (MBX_BUF.MSGTYPE .EQ. MSG$_INTMSG) THEN
C
C	    Expedited data has arrived, at the present moment we
C	    don't do anything with, so lets just re-issue the
C	    MBX read.
C
C	    WRITE (*,*) 'T-EXPDATAind - stream ', MBX_BUF.STREAM

	    STATUS = MBX_READ (STREAMS(MBX_BUF.STREAM), MBX_BUF)

	ELSE IF (MBX_BUF.MSGTYPE .EQ. MSG$_ABORT) THEN
C
C	    If is a T-Disconnect Indication, so call the action routine
C	    and free up the mailbox message buffer since the TC is
C	    going away.
C
C	    WRITE (*,*) 'T-DISind (mbx) - stream ', MBX_BUF.STREAM

	    CALL T_DISCONNECT_INDICATION (STREAMS(MBX_BUF.STREAM))
	    CALL FREE_MBX_BUFFER (MBX_BUF)

	END IF
C
	END

C--------------------------------------------------------------------
	INTEGER*4 FUNCTION MBX_READ (IO_STREAM, MBX_BUF)
C
	IMPLICIT NONE
C
	INCLUDE '($SYSSRVNAM)'
	INCLUDE '($IODEF)'
	INCLUDE '($MSGDEF)'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /STREAMBLOCK/ IO_STREAM
	RECORD /MBXBUFFER/ MBX_BUF
C
	INTEGER*4 STATUS
C
	EXTERNAL MBX_READ_AST
C
	MBX_BUF.STREAM = IO_STREAM.STREAM
C
	STATUS = SYS$QIO (,
	1		  %VAL (IO_STREAM.MBX_CHN),
	1		  %VAL (IO$_READVBLK),
	1		  %REF (MBX_BUF.IOSB),
	1		  %REF (MBX_READ_AST),
	1		  MBX_BUF,
	1		  %REF (MBX_BUF.MSGTYPE),
	1		  %VAL (MBX_BUF.BUF_LEN),,,,
	1		 )
	IF (.NOT. STATUS) CALL LIB$STOP (%VAL (STATUS))
C
	MBX_READ = STATUS
C
	END

C-----------------------------------------------------------------------
	SUBROUTINE VOTS_READ_AST (BUFFER)
C
	IMPLICIT NONE
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /VOTSBUFFER/ BUFFER
C
	INTEGER*4 GET_BUFFER, VOTS_READ, VOTS_WRITE
C
	RECORD /STREAMBLOCK/ IO_STREAM
C
	INTEGER*4 BUF
C
	INTEGER*4 STATUS, I
C
	IO_STREAM = STREAMS(BUFFER.STREAM)
C
	CALL DECREMENT_STREAM_REF_COUNT (IO_STREAM)
	BUFFER.REF_COUNT = BUFFER.REF_COUNT - 1
C
	IF (.NOT. BUFFER.IOSB(1)) THEN
C	    WRITE (*,*) 'T-DISind (chan) - stream ', IO_STREAM.STREAM
	    CALL T_DISCONNECT_INDICATION (IO_STREAM)
	ELSE
C	    WRITE (*,*) 'T-DATAind - stream ', IO_STREAM.STREAM
C
	    BUFFER.BUF_USED = BUFFER.IOSB(2)
C
	    STATUS = VOTS_WRITE (IO_STREAM, BUFFER)
C
	    BUF = GET_BUFFER ()
	    STATUS = VOTS_READ (IO_STREAM, BUFFERS(BUF))
C
	END IF
C
	END

C-----------------------------------------------------------------------
	INTEGER*4 FUNCTION VOTS_READ (IO_STREAM, BUFFER)
C
	IMPLICIT NONE
C
	INCLUDE '($SYSSRVNAM)'
	INCLUDE '($IODEF)'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
C	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /STREAMBLOCK/ IO_STREAM
	RECORD /VOTSBUFFER/ BUFFER
C
	EXTERNAL VOTS_READ_AST
C
	INTEGER*4 STATUS
C
	BUFFER.STREAM = IO_STREAM.STREAM
C
	CALL INCREMENT_STREAM_REF_COUNT (IO_STREAM)
C
C	Issue up a read to VOTS
C
	STATUS = SYS$QIO (,
	1		  %VAL (IO_STREAM.DEV_CHN),
	1		  %VAL (IO$_READVBLK),
	1		  %REF (BUFFER.IOSB),
	1		  %REF (VOTS_READ_AST),
	1		  BUFFER,
	1		  %REF (BUFFER.BUFFER),
	1		  %VAL (BUFFER.BUF_LEN),,,,
	1		 )
	IF (.NOT. STATUS) CALL LIB$STOP (%VAL (STATUS))
C
	VOTS_READ = STATUS
C
	END

C-----------------------------------------------------------------------
	SUBROUTINE VOTS_WRITE_AST (BUFFER)
C
	IMPLICIT NONE
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /VOTSBUFFER/ BUFFER
C
	CALL DECREMENT_STREAM_REF_COUNT (STREAMS(BUFFER.STREAM))
C
	BUFFER.REF_COUNT = BUFFER.REF_COUNT - 1
C
	IF (.NOT. BUFFER.IOSB(1)) THEN
C	    WRITE (*,*) 'T-DISind (chan) - stream ', BUFFER.STREAM
	    CALL T_DISCONNECT_INDICATION (STREAMS(BUFFER.STREAM))
	END IF
C
	END

C-----------------------------------------------------------------------
	INTEGER*4 FUNCTION VOTS_WRITE (IO_STREAM, BUFFER)
C
	IMPLICIT NONE
C
	INCLUDE '($SYSSRVNAM)'
	INCLUDE '($IODEF)'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /STREAMBLOCK/ IO_STREAM
	RECORD /VOTSBUFFER/ BUFFER
C
	EXTERNAL VOTS_WRITE_AST
C
	INTEGER*4 STATUS
C
	BUFFER.STREAM = IO_STREAM.STREAM
	BUFFER.REF_COUNT = BUFFER.REF_COUNT + 1
C
C	WRITE (*,*) 'T-DATAreq - stream ', BUFFER.STREAM
C
	CALL INCREMENT_STREAM_REF_COUNT (IO_STREAM)
C
C	Issue up a write to VOTS
C
	STATUS = SYS$QIO (,
	1		  %VAL (IO_STREAM.DEV_CHN),
	1		  %VAL (IO$_WRITEVBLK),
	1		  %REF (BUFFER.IOSB),
	1		  %REF (VOTS_WRITE_AST),
	1		  BUFFER,
	1		  %REF (BUFFER.BUFFER),
	1		  %VAL (BUFFER.BUF_USED),,,,
	1	         )
	IF (.NOT. STATUS) CALL LIB$STOP (%VAL (STATUS))
C
	VOTS_WRITE = STATUS
C
	END

C-----------------------------------------------------------------------
	SUBROUTINE T_CONNECT_INDICATION (MBX_BUF)
C
	IMPLICIT NONE
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /MBXBUFFER/ MBX_BUF
C
	INTEGER*4 GET_STREAM_BLOCK, GET_MBX_BUFFER, GET_VOTS_CHANNEL
	INTEGER*4 ACCEPT_TC, REJECT_TC, MBX_READ
C
	BYTE NCB(128)
	INTEGER*4 NCB_OFFSET, NCB_LENGTH, I
C
	INTEGER*4 STATUS, STREAM, MBX_BUF_NO
C
C	Copy the NCB out of the MBX message a byte at a time, we need it
C	to accept or reject the inbound TC
C
	NCB_OFFSET = MBX_BUF.BUFFER(1) + 1
	NCB_LENGTH = MBX_BUF.BUFFER(NCB_OFFSET + 1)
	DO I = 1,NCB_LENGTH + 1
	    NCB(I) = MBX_BUF.BUFFER(I + NCB_OFFSET)
	END DO	
C
C	If we have a free stream block and can assign a channel to VOTS
C	we will accept this new inbound TC
C
	STREAM = GET_STREAM_BLOCK ()
	IF ((STREAM .NE. 0) .AND.
	1   (GET_VOTS_CHANNEL (STREAMS(STREAM)))) THEN
C
C	Accept the TC, get a new MBX buffer (the current one will be re-used
C	on the TSAP's MBX and issue a read on the TC's MBX so we are told when 
C	the TC goes away
C
	    STATUS = ACCEPT_TC (STREAMS(STREAM), NCB)

	    MBX_BUF_NO= GET_MBX_BUFFER ()
	    STATUS = MBX_READ (STREAMS(STREAM), MBX_BUFFERS(MBX_BUF_NO))
	ELSE
C
C	Reject the TC on the channel which the MSG$_CONNECT mailbox message
C	arrived
C
	    STATUS = REJECT_TC (STREAMS(MBX_BUF.STREAM), NCB)
	END IF
C
	END

C-----------------------------------------------------------------------
	SUBROUTINE T_DISCONNECT_INDICATION (IO_STREAM)
C
	IMPLICIT NONE
C
	INCLUDE '($SYSSRVNAM)'
	INCLUDE '($IODEF)'
C
	INCLUDE 'TOOLS$SRC:OSIT$RECORD_STRUCTURES'
	INCLUDE 'TOOLS$SRC:OSIT$STORAGE'
C
	RECORD /STREAMBLOCK/ IO_STREAM
C
	INTEGER*4 STATUS, STREAM_NO
	INTEGER*2 IOSB(4)
C
C	We use the stream number in the record given to use to get back to
C	the original stream block.  This makes sure that we are not using
C	a copy of the stream block held in one of the buffers
C
	STREAM_NO = IO_STREAM.STREAM
C
C	Only when there is no outstanding I/O on the channel do we attempt
C	to get rid of the TC and free up the stream block
C
	IF (STREAMS(STREAM_NO).REF_COUNT .EQ. 1) THEN
	    STATUS = SYS$QIOW (,
	1		       %VAL (IO_STREAM.DEV_CHN), 
	1		       %VAL (IO$_DEACCESS),
	1		       IOSB,,,,,,,,,
	1		      )
	    IF (.NOT. STATUS) CALL LIB$STOP (%VAL (STATUS))
	    IF (.NOT. IOSB(1)) THEN
		CALL LIB$SIGNAL (%VAL (IOSB(1)))
		CALL LIB$STOP (%VAL (IOSB(3)))
	    END IF
C
	    CALL FREE_STREAM_BLOCK (IO_STREAM)
	END IF
C
	END
