! X.25 Local relay - Example NCL script
! =====================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up a DECNIS to provide Local Switching of SVCs/PVCs 
! between LAPB DTEs.
!
! This function allows the following configurations :
!
!       1. Locally connected LAPB DTEs (e.g. connected to a W618 port)
!	   can make X.25 calls directly to the DECNIS (which is running
!	   in DCE mode) for switching to another local DTE.
!
!	   This feature offers the option of using the DECNIS to connect 
!	   multiple X.25 DTEs without needing an X.25 switch.
!	   remote public/private X.25 network connections.
!
!       2. Locally connected LAPB DTEs (e.g. connected to a W618 port)
!	   can make X.25 calls directly to the DECNIS (which is running
!	   in DCE mode) for switching to a LAPB DTE connected to a
!	   public or private X.25 network.
!
!	   This feature offers a 'gateway' service to X.25 network services.
!	   For example, multiple X.25 DTEs connected directly via W618 
!	   device ports could be relayed over a single DTE connected to 
!          a public X.25 network via a W622 device port.
!
! This example must be set up with values that match the basic
! configuration that you set up with the DECNIS configurator.
! Wherever <name> appears, replace it with a value that
! matches your basic DECNIS configuration. 
!
! This script assumes that PSI Security has been set OPEN
! (i.e. answering NO to the DECNIS configurator question on PSI Security)
!
! Notes - 
! The DTEs that are to carry the SVC,PVC calls must
! have compatible Packet/Window size attributes, that is, Default Packet Size, 
! Default Window Size on both LAPB and LLC2 DTEs should be the same value.
!
! The script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!===============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++
! Add this section to NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS.

create X25 Relay

! Create the X25 Relay Client and X25 Access Filter  entities to 
! relay calls from LAPB DTE dte-0 to LAPB DTE dte-1.
!
! Note - SVCs (Call requests) can be switched onto the same DTE
! that the call arrived on if required.

create X25 Relay client  dte-0-to-dte-1
create X25 Access filter dte-0-to-dte-1

! Create the X25 Relay Client and X25 Access Filter  entities to 
! relay calls from LAPB DTE dte-1 to LAPB DTE dte-0

create X25 Relay client  dte-1-to-dte-0
create X25 Access filter dte-1-to-dte-0

! Create a X25 Relay PVC entity to connect a PVC on
! LAPB DTE dte-0 with a PVC on dte-1.

create X25 Relay pvc pvc1-pvc2
!===============================================================================
! 			EXTRA_SET.NCL
!			+++++++++++++ 
! Add this section to NIS_<name>_EXTRA_SET.NCL file for your DECNIS.

set    X25 Relay client dte-0-to-dte-1 dte class <name>

! where <name> is the name of an X25 Access DTE Class that
! 'dte-1' is a member of.

set    X25 Relay client dte-0-to-dte-1 Rights identifiers (PSI$OPEN_SECURITY)

! This is sufficient if PSI security is OPEN.  Otherwise, check
! the X25 Access Security DTE Class default Remote DTE <name> for
! the Rights identifiers required to call the LAPB DTEs you wish
! to connect to.

set    X25 Relay client dte-0-to-dte-1 filter (dte-0-to-dte-1)

! Set up the filter to match the calls from the LLC2 Client.
! Any of the X25 Access attributes can be used to match the 
! call.  A few example fields are given below.

set    X25 Access filter dte-0-to-dte-1 inbound dte class <name>

! Where <name> matches the 'Inbound DTE Class' attribute of the 
! LLC2 DTE that received the call.

set    X25 Access filter dte-0-to-dte-1 Call Data Value %XFF000000444543
set    X25 Access filter dte-0-to-dte-1 Call Data Mask  %XFFFFFFFFFFFFFF

set    X25 Relay  client dte-1-to-dte-0 dte class <name>
set    X25 Relay  client dte-1-to-dte-0 Rights identifiers (PSI$OPEN_SECURITY)
set    X25 Relay  client dte-1-to-dte-0 filter (dte-1-to-dte-0)

set    X25 Access filter dte-1-to-dte-0 inbound dte class <name>
set    X25 Access filter dte-1-to-dte-0 Call Data Value %XFF000000444543
set    X25 Access filter dte-1-to-dte-0 Call Data Mask  %XFFFFFFFFFFFFFF

! Setup the X25 Relay PVC attributes

set    X25 Relay  pvc pvc1-pvc2 local pvc <name1>, remote pvc <name2>

! Where <name1> is the name of a PVC on one of the DTEs and <name2> the name
! of a PVC on the other DTE.  Note - you can switch two PVCs on the same DTE is 
! required.
! e.g.  set X25 Relay  pvc pvc1-pvc2 local pvc pvc1, remote pvc pvc2

set    X25 Relay  pvc pvc1-pvc2 Rights identifiers (PSI$OPEN_SECURITY)
!===============================================================================
! 			EXTRA_ENABLE.NCL 
!			++++++++++++++++
! Add this section to NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS.

enable X25 Relay client dte-0-to-dte-1
enable X25 Relay client dte-1-to-dte-0
enable X25 Relay pvc    pvc1-pvc2
!===============================================================================
