! Packet Prioritization - Example NCL Script 
! ==========================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
! This script sets up packet prioritization on a DECNIS so that
! traffic is prioritized in the following way:
!
! On interface - W622-5-0		  On interface - L602-3-0
! Priority   Packet Type  		  Priority  Packet Type  
!     1	      TELNET			      1	     TELNET, TOS = 
!     2       TOS = minimize delay		     minimize delay
!     3	      ICMP, IPX (encapsulated)	      3	     ICMP, IPX (encapsulated)
!     4	      Any other IP, any bridged,      4	     Any other IP, any bridged, 
!	      any OSI, any other IPX,		     any OSI, any other IPX,
!	      any DECnet			     any DECnet
!     6	      FTP			      6	     FTP
!
! The following diagram shows the relationship between the required
! PACKET, GROUP and CLASS entities. 
!
!  PACKET	   PACKET	   PACKET	   PACKET	PACKET	
!  TELNET	  MIN-DELAY	  IPX_ENCAPS 	    ICMP	 FTP
!(TCP port 23)   (TOS - Prec=	 (UDP port 213)    (IP prot 1)	(TCP port 20/21)
!		  min delay, 
!		  ser=ignore)
!    |		     |                |               |            |
!    |		     |		      |		      |		   |
!  GROUP 	   GROUP 	    GROUP 	    GROUP 	 GROUP 	
! TELNET	  MIN-DELAY	   IPX_ENCAPS	     ICMP	  FTP
!    |		     |		          \	    /  		   |
!  Class 1	 Class 2	            Class 3     	Class 6
!
!
! The script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 

! Create the PRIORITY module 

create priority

! Create PACKET entities 

create priority packet telnet type ip tcp , ip port range = [23..23]
create priority packet min_delay type ip tos , ip tos -
	value = {precedence = ignore , service = minimize delay}
create priority packet ipx_encaps type ip udp , ip port range = [213..213]
create priority packet icmp type ip protocol , ip protocol = 1
create priority packet ftp type ip tcp , ip port range = [20..21]

! Create GROUP entities

create priority group telnet
create priority group min_delay
create priority group ipx_encaps
create priority group icmp
create priority group ftp

! Create INTERFACE entities for the port you want to apply prioritization to.

create priority interface w622-5-0 communication port w622-5-0
create priority interface l602-3-0 communication port l602-3-0

!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 
!
! Set the match action of each PACKET entity to point to a GROUP.

set priority packet telnet match action = priority group telnet
set priority packet min_delay match action = priority group min_delay
set priority packet ipx_encaps match action = priority group ipx_encaps
set priority packet icmp match action = priority group icmp
set priority packet ftp match action = priority group ftp

! Set the assigned class for each GROUP

set priority group telnet assigned class 1
set priority group min_delay assigned class 2
set priority group ipx_encaps assigned class 3
set priority group icmp assigned class 3
set priority group ftp assigned class 6

! Assign class 2 to Queue 1 on the L602-3-0 interface. This means that
! both TELNET and MIN_DELAY packets have a priority of 1 on this interface. 

set priority interface l602-3-0 class 2 assigned queue = 1

!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

! Enable Priority Interface and Priority Module

enable priority interface w622-5-0
enable priority interface l602-3-0
enable priority
!==============================================================================

