! OSPF Multiple Areas Configuration - Example NCL Script
! ======================================================
!
!	         +++++++++++++++++++++++++++++++++++++
! 	COPYRIGHT (c) 1990, 1995 BY
! 	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
! 	ALL RIGHTS RESERVED.
!
! 	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
! 	ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
! 	INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
! 	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
! 	OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
! 	TRANSFERRED.
!
! 	THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
! 	AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
! 	CORPORATION.
!
! 	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
! 	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!	           +++++++++++++++++++++++++++++++++++++
!
! This script sets up DECNIS 'B' as shown in the configuration below:
!
!                                    OSPF-Area-2
!                                       ---------
!                                     | DECNIS D |
!                                       ---------
!				    HDLC | (point-to-point)
!				         |
!  OSPF-Area-0                           |                         OSPF-Area-1
!    --------    Ethernet broadcast    --------     X25 DA NBMA     --------
!  | DECNIS A |----------------------| DECNIS B |-----------------| DECNIS C |
!    --------                          --------                      -------- 
!      backbone
!
! DECNIS 'B' is an OSPF Area Border Router (ABR). It attaches the 
! OSPF areas 1.1.1.1 and 2.2.2.2 to the backbone area  0.0.0.0 using 
! three interfaces:
!
!	o An Ethernet broadcast interface to area 0.0.0.0,
!	o An X.25 NBMA interface to area 1.1.1.1,
!	o An HDLC point-to-point interface to area 2.2.2.2.
!
! The script is divided into three sections:
!	EXTRA_CREATE.NCL
!	EXTRA_SET.NCL
!	EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to
! the DECNIS Management manual.
!==============================================================================
!			EXTRA_CREATE.NCL
!			++++++++++++++++                                     
! Add this section to the NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS. 

! Create all areas including the Backbone area

CREATE ROUTING CONTROL PROTOCOL OSPF-Area-0 TYPE OSPF AREA
CREATE ROUTING CONTROL PROTOCOL OSPF-Area-1 TYPE OSPF AREA
CREATE ROUTING CONTROL PROTOCOL OSPF-Area-2 TYPE OSPF AREA

! Create the OSPF logical circuits with the same names as the routing
! circuits they are associated with.

CREATE ROUTING CONTROL PROTOCOL OSPF-Area-0 - 
 LOGICAL CIRCUIT l602-3-1 TYPE BROADCAST

CREATE ROUTING CONTROL PROTOCOL OSPF-Area-1 -
 LOGICAL CIRCUIT RX25-DA TYPE NBMA

CREATE ROUTING CONTROL PROTOCOL OSPF-Area-2 -
 LOGICAL CIRCUIT w618-4-0 TYPE POINT TO POINT
 
! DECNIS 'B' is eligible to become Designated Router on the
! attached NBMA network (it takes the default OSPF PRIORITY
! of 1).
!
! An NBMA network requires a configured list of the router's
! neighbors on that network if it is eligible to become DR...

CREATE ROUTING CONTROL PROTOCOL OSPF-Area-1 -
 LOGICAL CIRCUIT RX25-DA -
  ADJACENCY decnis-C OSPF NEIGHBOR ADDRESS 16.36.16.100
!==============================================================================
!			EXTRA_SET.NCL
!			+++++++++++++
! Add this section to the NIS_<name>_EXTRA_SET.NCL file for your DECNIS. 

! Associate each area with the OSPF general entity

SET ROUTING CONTROL PROTOCOL OSPF-Area-0 -
 OSPF GENERAL INSTANCE OSPF-General

SET ROUTING CONTROL PROTOCOL OSPF-Area-1 -
 OSPF GENERAL INSTANCE OSPF-General

SET ROUTING CONTROL PROTOCOL OSPF-Area-2 -
 OSPF GENERAL INSTANCE OSPF-General

! Set the area IDs for each area

SET ROUTING CONTROL PROTOCOL OSPF-Area-0 OSPF AREA ID 0.0.0.0

SET ROUTING CONTROL PROTOCOL OSPF-Area-1 OSPF AREA ID 1.1.1.1

SET ROUTING CONTROL PROTOCOL OSPF-Area-2 OSPF AREA ID 2.2.2.2

! Associate each OSPF logical circuit with a physical routing circuit.

SET ROUTING CONTROL PROTOCOL OSPF-Area-1 -
 LOGICAL CIRCUIT RX25-DA CIRCUIT ROUTING CIRCUIT RX25-DA

SET ROUTING CONTROL PROTOCOL OSPF-Area-0 -
 LOGICAL CIRCUIT l602-3-1 CIRCUIT ROUTING CIRCUIT l602-3-1

SET ROUTING CONTROL PROTOCOL OSPF-Area-2 -
 LOGICAL CIRCUIT w618-4-0 CIRCUIT ROUTING CIRCUIT w618-4-0
!==============================================================================
!			EXTRA_ENABLE.NCL
!			++++++++++++++++
! Add this section to the NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS. 

! Enable the OSPF-General control protocols, the OSPF-Area control
! protocols and their circuits

ENABLE ROUTING CONTROL PROTOCOL OSPF-General

ENABLE ROUTING CONTROL PROTOCOL OSPF-Area-0
ENABLE ROUTING CONTROL PROTOCOL OSPF-Area-1
ENABLE ROUTING CONTROL PROTOCOL OSPF-Area-2

ENABLE ROUTING CONTROL PROTOCOL OSPF-Area-0 LOGICAL CIRCUIT l602-3-1
ENABLE ROUTING CONTROL PROTOCOL OSPF-Area-1 LOGICAL CIRCUIT RX25-DA
ENABLE ROUTING CONTROL PROTOCOL OSPF-Area-2 LOGICAL CIRCUIT w618-4-0
!==============================================================================

