! OC-3 ATM Classical IP - Example NCL script
! ==========================================
!
!           +++++++++++++++++++++++++++++++++++++++++++++++++++
!     COPYRIGHT (C) 1995 BY DIGITAL EQUIPMENT CORPORATION, MAYNARD,
!     MASSACHUSETTS.
!     ALL RIGHTS RESERVED.
!
!     THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
!     ONLY  IN  ACCORDANCE WITH THE  TERMS  OF  SUCH  LICENSE AND  WITH THE
!     INCLUSION OF THE ABOVE  COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER
!     COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
!     OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
!     TRANSFERRED.
!
!     THE INFORMATION IN THIS  SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
!     AND  SHOULD NOT BE  CONSTRUED AS A  COMMITMENT BY  DIGITAL  EQUIPMENT
!     CORPORATION.
!
!     DIGITAL ASSUMES NO  RESPONSIBILITY FOR THE USE OR  RELIABILITY OF ITS
!     SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
!           +++++++++++++++++++++++++++++++++++++++++++++++++++
!
! This script sets up the DECNIS to provide OC-3 Classical IP. The script 
! configures 5 OC-3 permanent circuits to 5 IP end nodes within the same 
! subnet 1.1.1.0.
!
! Wherever <name> appears, you should replace it with a value that matches
! your basic DECNIS configuration.
!
! This script is divided into three sections:
!      EXTRA_CREATE.NCL
!      EXTRA_SET.NCL
!      EXTRA_ENABLE.NCL
! Each section should be added to the relevant user NCL script file for your
! DECNIS. For more information about user NCL script files, refer to the
! DECNIS Management manual.
!===============================================================================
!                             EXTRA_CREATE.NCL
!                             ++++++++++++++++
! Add this section to NIS_<name>_EXTRA_CREATE.NCL file for your DECNIS.
!
! Ensure that a device exists for the network interface card.
!
Create Device Unit W631-7 Name W631-7
!
! Ensure that the multiplexed interface module exists.
!
Create Multiplexed Interface
!
! Ensure that the ATM connection management module exists.
!
Create ATM Connection Management
!
! Ensure that the ATM multiprotocol encapsulation module exists.
!
Create ATM Multiprotocol Encapsulation
!
! Create the multiplexed interface line characteristics. Note that this
! example creates an OC-3 interface type.
!
Create Multiplexed Interface Line W631-7-0 -
	Communications Port = W631-7-0, -
	Interface Type = OC-3, -
	Framing Type = Sonet
!
! Create the multiplexed interface line logical channel and logical channel map.
!
Create Multiplexed Interface Line W631-7-0 Logical Channel W631-7-0 Map {0}
!
! Create the ATM connection management line.
!
Create ATM Connection Management Line W631-7-0
!
! Create the ATM Connection Management PVCs. Note that there can be multiple 
! PVCs on each ATM Connection Management line. The VCI valid range is 32 
! through 1023. The VPI valid range is 0 through 255 with 0 as the default.
! Specify that the ATM Adaptation Layer is of type AAL5 and that the ATM line 
! uses LLC encapsulation.
!
Create ATM Connection Management Line W631-7-0 PVC W631-7-1 -
	Virtual Circuit Identifier = 32, -
	Virtual Path Identifier = 0, -
	AAL Type = AAL5, -
	Encapsulation Type = LLC Encapsulation
Create ATM Connection Management Line W631-7-0 PVC W631-7-2 -
	Virtual Circuit Identifier = 33, -
	Virtual Path Identifier = 0, -
	AAL Type = AAL5, -
	Encapsulation Type = LLC Encapsulation
Create ATM Connection Management Line W631-7-0 PVC W631-7-3 -
	Virtual Circuit Identifier = 34, -
	Virtual Path Identifier = 0, -
	AAL Type = AAL5, -
	Encapsulation Type = LLC Encapsulation
Create ATM Connection Management Line W631-7-0 PVC W631-7-4 -
	Virtual Circuit Identifier = 35, -
	Virtual Path Identifier = 0, -
	AAL Type = AAL5, -
	Encapsulation Type = LLC Encapsulation
Create ATM Connection Management Line W631-7-0 PVC W631-7-5 -
	Virtual Circuit Identifier = 36, -
	Virtual Path Identifier = 0, -
	AAL Type = AAL5, -
	Encapsulation Type = LLC Encapsulation
!
! Create the ATM multiprotocol encapsulation links.
!
Create ATM Multiprotocol Encapsulation Link W631-7-1
Create ATM Multiprotocol Encapsulation Link W631-7-2
Create ATM Multiprotocol Encapsulation Link W631-7-3
Create ATM Multiprotocol Encapsulation Link W631-7-4
Create ATM Multiprotocol Encapsulation Link W631-7-5
!
! Create the routing circuits.
!
Create Routing Circuit W631-7-1 Type = ATM Permanent
Create Routing Circuit W631-7-2 Type = ATM Permanent
Create Routing Circuit W631-7-3 Type = ATM Permanent
Create Routing Circuit W631-7-4 Type = ATM Permanent
Create Routing Circuit W631-7-5 Type = ATM Permanent
!
!===============================================================================
!                            EXTRA_SET.NCL
!                            ++++++++++++++++
! Add this section to NIS_<name>_EXTRA_SET.NCL file for your DECNIS.
!
! Set the clock timing source to network or local
!
Set Multiplexed Interface Line W631-7-0 Clock Source = Local
!
! Associate the ATM connection management line with the multiplexed interface
! logical channel.
!
Set ATM Connection Management Line W631-7-0 Lower Layer Entity = -
	Multiplexed Interface Line W631-7-0 Logical Channel W631-7-0
!
! Disable cell scrambling.
!
Set ATM Connection Management Line W631-7-0 Cell Scrambling = Disabled
!
! Configure the circuits to suit the requirements of the routing circuit 
! bandwidth and switch.
!
Set ATM Connection Management Line W631-7-0 PVC W631-7-1 -
	Peak Rate = 100, -
	Minimum Guaranteed Rate = 20, -
	Traffic Shaping Priority = 1
Set ATM Connection Management Line W631-7-0 PVC W631-7-2 -
	Peak Rate = 100, -
	Minimum Guaranteed Rate = 20, -
	Traffic Shaping Priority = 1
Set ATM Connection Management Line W631-7-0 PVC W631-7-3 -
	Peak Rate = 100, -
	Minimum Guaranteed Rate = 20, -
	Traffic Shaping Priority = 1
Set ATM Connection Management Line W631-7-0 PVC W631-7-4 -
	Peak Rate = 100, -
	Minimum Guaranteed Rate = 20, -
	Traffic Shaping Priority = 1
Set ATM Connection Management Line W631-7-0 PVC W631-7-5 -
	Peak Rate = 100, -
	Minimum Guaranteed Rate = 20, -
	Traffic Shaping Priority = 1
!
! Associate the ATM multiprotocol encapsulation links with the ATM connection
! management PVCs.
!
Set ATM Multiprotocol Encapsulation Link W631-7-1 Lower Layer Entity = -
	ATM Connection Management Line W631-7-0 PVC W631-7-1
Set ATM Multiprotocol Encapsulation Link W631-7-2 Lower Layer Entity = -
	ATM Connection Management Line W631-7-0 PVC W631-7-2
Set ATM Multiprotocol Encapsulation Link W631-7-3 Lower Layer Entity = -
	ATM Connection Management Line W631-7-0 PVC W631-7-3
Set ATM Multiprotocol Encapsulation Link W631-7-4 Lower Layer Entity = -
	ATM Connection Management Line W631-7-0 PVC W631-7-4
Set ATM Multiprotocol Encapsulation Link W631-7-5 Lower Layer Entity = -
	ATM Connection Management Line W631-7-0 PVC W631-7-5
!
! Set the maximum protocol data unit (PDU) size of the ATM multiprotocol
! encapsulation links.
!
Set ATM Multiprotocol Encapsulation Link W631-7-1 Maximum PDU Size = 4490
Set ATM Multiprotocol Encapsulation Link W631-7-2 Maximum PDU Size = 4490
Set ATM Multiprotocol Encapsulation Link W631-7-3 Maximum PDU Size = 4490
Set ATM Multiprotocol Encapsulation Link W631-7-4 Maximum PDU Size = 4490
Set ATM Multiprotocol Encapsulation Link W631-7-5 Maximum PDU Size = 4490
!
! Associate the routing circuit with the ATM multiprotocol encapsulation link.
!
Set Routing Circuit W631-7-1 Data Link Entity = -
	ATM Multiprotocol Encapsulation Link W631-7-1
Set Routing Circuit W631-7-2 Data Link Entity = -
	ATM Multiprotocol Encapsulation Link W631-7-2
Set Routing Circuit W631-7-3 Data Link Entity = -
	ATM Multiprotocol Encapsulation Link W631-7-3
Set Routing Circuit W631-7-4 Data Link Entity = -
	ATM Multiprotocol Encapsulation Link W631-7-4
Set Routing Circuit W631-7-5 Data Link Entity = -
	ATM Multiprotocol Encapsulation Link W631-7-5
!
! Set up the routing circuit network protocols and SDU size.
!
Set Routing Circuit W631-7-1 Network Protocols = {IP}, -
	Manual IP Data Link SDU Size = 4490
Set Routing Circuit W631-7-2 Network Protocols = {IP}, -
	Manual IP Data Link SDU Size = 4490
Set Routing Circuit W631-7-3 Network Protocols = {IP}, -
	Manual IP Data Link SDU Size = 4490
Set Routing Circuit W631-7-4 Network Protocols = {IP}, -
	Manual IP Data Link SDU Size = 4490
Set Routing Circuit W631-7-5 Network Protocols = {IP}, -
	Manual IP Data Link SDU Size = 4490
!
! Set the IP address and subnetwork mask for the IP interface.
!
Set Routing Circuit W631-7-1 -
	Neighbor IP Address = 1.1.1.1, -
	Subnet Address = {Address = 1.1.1.10, Mask = 255.255.255.255}
Set Routing Circuit W631-7-2 -
	Neighbor IP Address = 1.1.1.2, -
	Subnet Address = {Address = 1.1.1.10, Mask = 255.255.255.255}
Set Routing Circuit W631-7-3 -
	Neighbor IP Address = 1.1.1.3, -
	Subnet Address = {Address = 1.1.1.10, Mask = 255.255.255.255}
Set Routing Circuit W631-7-4 -
	Neighbor IP Address = 1.1.1.4, -
	Subnet Address = {Address = 1.1.1.10, Mask = 255.255.255.255}
Set Routing Circuit W631-7-5 -
	Neighbor IP Address = 1.1.1.5, -
	Subnet Address = {Address = 1.1.1.10, Mask = 255.255.255.255}
!
!===============================================================================
!                            EXTRA_ENABLE.NCL
!                            ++++++++++++++++
! Add this section to NIS_<name>_EXTRA_ENABLE.NCL file for your DECNIS.
!
!
Set Device Unit W631-7 Auto Load False
Enable Device Unit W631-7
Load Device Unit W631-7	
Set Device Unit W631-7 Auto Load True
!
Enable Multiplexed Interface Line W631-7-0 Logical Channel W631-7-0
Enable Multiplexed Interface Line W631-7-0
Enable ATM Connection Management Line W631-7-0
Enable ATM Multiprotocol Encapsulation Link W631-7-1
Enable ATM Multiprotocol Encapsulation Link W631-7-2
Enable ATM Multiprotocol Encapsulation Link W631-7-3
Enable ATM Multiprotocol Encapsulation Link W631-7-4
Enable ATM Multiprotocol Encapsulation Link W631-7-5
Enable Routing Circuit W631-7-1
Enable Routing Circuit W631-7-2
Enable Routing Circuit W631-7-3
Enable Routing Circuit W631-7-4
Enable Routing Circuit W631-7-5
!
!===============================================================================
