#pragma module MONITOR_CONVERT "X-2"

//****************************************************************************
//                                                                           *
//    Copyright 1976, 2003 Hewlett-Packard Development Company, L.P.        *   
//                                                                           *    
//   Confidential computer software.  Valid license from HP and/or           *    
//   its subsidiaries required for possession, use, or copying.              *    
//                                                                           *    
//   Consistent with FAR 12.211 and 12.212, Commercial Computer Software,    *    
//   Computer Software Documentation, and Technical Data for Commercial      *    
//   Items are licensed to the U.S. Government under vendor's standard       *    
//   commercial license.                                                     *    
//                                                                           *    
//   Neither HP nor any of its subsidiaries shall be liable for technical    *    
//   or editorial errors or omissions contained herein.  The information     *    
//   in this document is provided "as is" without warranty of any kind and   *    
//   is subject to change without notice.  The warranties for HP products    *    
//   are set forth in the express limited warranty statements accompanying   *    
//   such products.  Nothing herein should be construed as constituting an   *    
//   additional warranty.                                                    *    
//                                                                           *    
//****************************************************************************
//
//
//   Abstract:
//
//	This utility will take new format recorded MONITOR data file and
//	convert it to the old un-aligned format. The resulting data file
//	can then be used by the MONITOR utility from older OpenVMS versions
//	prior to OpenVMS V8.2 to be played back.
//
//
//   Build Instructions:
//
//	$ cc monitor_convert+sys$share:sys$lib_c/lib
//	$ link monitor_convert
//	$ define monitor_convert sys$disk:[]monitor_convert
//	$ mc monitor_convert <input-file> <output-file>
//
//
//   Modified by:
//
//       X-2	CMOS		Christian Moser		13-AUG-2003
//		Add conversion of RMS class record
//
//       X-1	CMOS    	Christian Moser		18-JUL-2003
//		Initial version.
//--

//
// Imported definitions
//
#define  __NEW_STARLET 1
#include ints
#include mondef
#include rms
#include ssdef
#include starlet
#include stdio
#include stdlib
#include string
#include stsdef

#define	HEADER_TYPE	128
#define	SYI_TYPE	129

#define PRO_CLSNO 	  0		// Class number for PROCESSES class 
#define STA_CLSNO 	  1             // Class number for STATES class 
#define MOD_CLSNO 	  2             // Class number for MODES class 
#define PAG_CLSNO 	  3             // Class number for PAGE class 
#define IO_CLSNO 	  4             // Class number for IO class 
#define FCP_CLSNO 	  5             // Class number for FCP class 
#define LCK_CLSNO 	  7             // Class number for LOCK class 
#define NET_CLSNO 	  8             // Class number for DECNET class 
#define FIL_CLSNO 	 11      	// Class number for FILE_SYSTEM_CACHE class 
#define DSK_CLSNO 	 12             // Class number for DISK class 
#define DLO_CLSNO 	 14             // Class number for DLOCK class 
#define SCS_CLSNO 	 15             // Class number for SCS class 
#define SYS_CLSNO 	 17             // Class number for SYSTEM class 
#define CLU_CLSNO 	 19             // Class number for CLUSTER class 
#define RMS_CLSNO 	 20             // Class number for RMS class 
#define MSC_CLSNO 	 21             // Class number for MSCP_SERVER class 
#define TRA_CLSNO 	 22            	// Class number for TRANSACTION class 
#define RLO_CLSNO 	 26             // Class number for RLOCK (Remastered Lock) screen 
#define TMR_CLSNO 	 27             // Class number for TIMER class 


//
// Global variables
//
struct FAB 	fab_in;
struct FAB 	fab_out;
struct RAB 	rab_in;
struct RAB 	rab_out;



int main (int argc, char *argv[])
{
int		i, j, k;
int		status;
char		*default_file = "*.DAT";
char		*buf_in;
char		*buf_out;
int		rec_type;
char		*ch;
CLASS_HDR	*cls;


	//
	// Make sure we got all the arguments, otherwise display a brief
	// verbose message on how to use this utility.
	//
	if (argc != 3)
	  {
	  printf ( "Usage:  $ mc dev:[dir]monitor_convert <input-file> <output-file>\n" );
	  return SS$_NORMAL;
	  }


	//
	// Open input file 
	//
	fab_in = cc$rms_fab;
	fab_in.fab$l_fna = default_file;
	fab_in.fab$b_fns = strlen (default_file);
	fab_in.fab$l_dna = default_file;
	fab_in.fab$b_dns = strlen (default_file);
	fab_in.fab$l_fna = argv[1];
	fab_in.fab$b_fns = strlen (argv[1]);
	status = sys$open ( &fab_in );
	if ( !$VMS_STATUS_SUCCESS (status) )  return status;

	rab_in = cc$rms_rab;
	rab_in.rab$l_fab = &fab_in;
	buf_in = malloc ( fab_in.fab$w_mrs + 1 );
	rab_in.rab$l_ubf = buf_in;
	rab_in.rab$w_usz = fab_in.fab$w_mrs;
	
	status = sys$connect ( (struct _rabdef *)&rab_in );
	if ( !$VMS_STATUS_SUCCESS (status) )  return status;

	//
	// Create output file 
	//
	fab_out = cc$rms_fab;
	fab_out.fab$l_fna = default_file;
	fab_out.fab$b_fns = strlen (default_file);
	fab_out.fab$l_dna = default_file;
	fab_out.fab$b_dns = strlen (default_file);
	fab_out.fab$l_fna = argv[2];
	fab_out.fab$b_fns = strlen (argv[2]);
	status = sys$create ( &fab_out );
	if ( !$VMS_STATUS_SUCCESS (status) )  return status;

	rab_out = cc$rms_rab;
	rab_out.rab$l_fab = &fab_out;
	buf_out = malloc ( fab_in.fab$w_mrs + 1 );
	rab_out.rab$l_rbf = buf_out;
	
	status = sys$connect ( (struct _rabdef *)&rab_out );
	if ( !$VMS_STATUS_SUCCESS (status) )  return status;

	//
	// Loop reading all records and convert them before writing them out
	//
	while ( 1 )
	  {
	  status = sys$get ( &rab_in );
	  if ( status == RMS$_EOF )  break;
	  if ( !$VMS_STATUS_SUCCESS (status) )  return status;

	  //
	  // Fetch the record type out of the first byte and shift down 6 bits.
	  // This will give us the category of records (0|1=class, 2=DIGITAL,
	  // 3=Customer).
	  //
	  ch = (char *) buf_in;
	  rec_type = ((int)*ch & 0xff) >> 6;

	  //
	  // Convert aligned class records to un-aligned format
	  //
	  if ( rec_type < 2 )
	    {

	    //
	    // Convert CLASS header 
	    //
	    CLASS_HDR		*cls;
	    CLASS_HDR_OLD	*oldcls;
	    int			data_len;
	    int16		reserved;

	    cls = (CLASS_HDR *) buf_in;
	    oldcls = (CLASS_HDR_OLD *) buf_out;
	    oldcls->mnr_oldcls$b_type = cls->mnr_cls$b_type;
	    memcpy ( &oldcls->mnr_oldcls$b_flags, &cls->mnr_cls$b_flags, 1 );
	    oldcls->mnr_oldcls$b_index = cls->mnr_cls$b_index;
	    reserved = cls->mnr_cls$w_reserved;
	    oldcls->mnr_oldcls$q_stamp = cls->mnr_cls$q_stamp;
	    oldcls->mnr_oldcls$w_reserved = reserved;

	    //
	    // depending on the class type convert some aligned structures
	    // to un-aligned record formats
	    // 
	    switch ( (int8)cls->mnr_cls$b_type )
	      {

	      //
	      // Convert PROCESS class record
	      //
	      case PRO_CLSNO:
		{
		PROCESS_CLASS	 *pro;
		OLDPROCESS_CLASS *oldpro;
		PRO_CLASS_PRE	 *propre;

		memcpy ( (void *)((int)buf_out + MNR_OLDCLS$K_SIZE), 
			 (void *)((int)buf_in + MNR_CLS$K_SIZE), 
			 MNR_PRO$K_PSIZE );
		propre = (PRO_CLASS_PRE *) ((int)buf_in + MNR_CLS$K_SIZE);
		pro = (PROCESS_CLASS *) ((int)buf_in + MNR_CLS$K_SIZE + MNR_PRO$K_PSIZE);
		oldpro = (OLDPROCESS_CLASS *) ((int)buf_out + MNR_OLDCLS$K_SIZE + MNR_PRO$K_PSIZE);

		for ( i=0; i<propre->mnr_pro$l_pctrec; i++ )
		  {
		  oldpro->mnr_oldpro$l_ipid = pro->mnr_pro$l_ipid;
		  oldpro->mnr_oldpro$l_uic = pro->mnr_pro$l_uic;
		  oldpro->mnr_oldpro$w_state = pro->mnr_pro$w_state;
		  oldpro->mnr_oldpro$b_pri = pro->mnr_pro$b_pri;
		  memcpy ( oldpro->mnr_oldpro$t_lname, pro->mnr_pro$t_lname, 16 );
		  oldpro->mnr_oldpro$l_gpgcnt = pro->mnr_pro$l_gpgcnt;
		  oldpro->mnr_oldpro$l_ppgcnt = pro->mnr_pro$l_ppgcnt;
		  oldpro->mnr_oldpro$l_sts = pro->mnr_pro$l_sts;
		  oldpro->mnr_oldpro$l_diocnt = pro->mnr_pro$l_diocnt;
		  oldpro->mnr_oldpro$l_pageflts = pro->mnr_pro$l_pageflts;
		  oldpro->mnr_oldpro$l_cputim = pro->mnr_pro$l_cputim;
		  oldpro->mnr_oldpro$l_biocnt = pro->mnr_pro$l_biocnt;
		  oldpro->mnr_oldpro$l_epid = pro->mnr_pro$l_epid;
		  oldpro->mnr_oldpro$l_efwm = pro->mnr_pro$l_efwm;
		  oldpro->mnr_oldpro$l_rbstran = pro->mnr_pro$l_rbstran;
		  pro = (PROCESS_CLASS *) ((int)pro + MNR_PRO$K_SIZE);
		  oldpro = (OLDPROCESS_CLASS *) ((int)oldpro + MNR_OLDPRO$K_SIZE);
		  }

		rab_out.rab$w_rsz = MNR_OLDCLS$K_SIZE + MNR_PRO$K_PSIZE + (propre->mnr_pro$l_pctrec * MNR_OLDPRO$K_SIZE);
		break;
		}

	      //
	      // Convert MODES class record
	      //
	      case MOD_CLSNO:
		{
		MODES_CLASS	*mod;
		OLDMODES_CLASS	*oldmod;
		CLASS_PRE	*modpre;

		memcpy ( (void *)((int)buf_out + MNR_OLDCLS$K_SIZE), 
			 (void *)((int)buf_in + MNR_CLS$K_SIZE), 
			 MNR_CMP$K_SIZE );
		modpre = (CLASS_PRE *) ((int)buf_in + MNR_CLS$K_SIZE);
		mod = (MODES_CLASS *) ((int)buf_in + MNR_CLS$K_SIZE + MNR_CMP$K_SIZE);
		oldmod = (OLDMODES_CLASS *) ((int)buf_out + MNR_OLDCLS$K_SIZE + MNR_CMP$K_SIZE);

		for ( i=0; i<modpre->mnr_cmp$l_eltct; i++ )
		  {
		  oldmod->mnr_oldmod$b_cpuid = mod->mnr_mod$b_cpuid;
		  oldmod->mnr_oldmod$l_inter = mod->mnr_mod$l_inter;
		  oldmod->mnr_oldmod$l_mpsync = mod->mnr_mod$l_mpsync;
		  oldmod->mnr_oldmod$l_kernel = mod->mnr_mod$l_kernel;
		  oldmod->mnr_oldmod$l_exec = mod->mnr_mod$l_exec;
		  oldmod->mnr_oldmod$l_super = mod->mnr_mod$l_super;
		  oldmod->mnr_oldmod$l_compat = mod->mnr_mod$l_compat;
		  oldmod->mnr_oldmod$l_user = mod->mnr_mod$l_user;
		  oldmod->mnr_oldmod$l_idle = mod->mnr_mod$l_idle;
		  mod = (MODES_CLASS *) ((int)mod + MNR_MOD$K_SIZE);
		  oldmod = (OLDMODES_CLASS *) ((int)oldmod + MNR_OLDMOD$K_SIZE);
		  }

		rab_out.rab$w_rsz = MNR_OLDCLS$K_SIZE + MNR_CMP$K_SIZE + (modpre->mnr_cmp$l_eltct * MNR_OLDMOD$K_SIZE);
		break;
		}

	      //
	      // Convert DISK class record
	      //
	      case DSK_CLSNO:
		{
		DISK_CLASS	*dsk;
		OLDDISK_CLASS	*olddsk;
		CLASS_PRE	*dskpre;

		memcpy ( (void *)((int)buf_out + MNR_OLDCLS$K_SIZE), 
			 (void *)((int)buf_in + MNR_CLS$K_SIZE), 
			 MNR_CMP$K_SIZE );
		dskpre = (CLASS_PRE *) ((int)buf_in + MNR_CLS$K_SIZE);
		dsk = (DISK_CLASS *) ((int)buf_in + MNR_CLS$K_SIZE + MNR_CMP$K_SIZE);
		olddsk = (OLDDISK_CLASS *) ((int)buf_out + MNR_OLDCLS$K_SIZE + MNR_CMP$K_SIZE);

		for ( i=0; i<dskpre->mnr_cmp$l_eltct; i++ )
		  {
	          olddsk->mnr_olddsk$w_allocls = dsk->mnr_dsk$w_allocls;
		  olddsk->mnr_olddsk$t_ctrlr = dsk->mnr_dsk$t_ctrlr;
	          olddsk->mnr_olddsk$w_unitno = dsk->mnr_dsk$w_unitno;
	          olddsk->mnr_olddsk$b_flags = dsk->mnr_dsk$b_flags;
	          olddsk->mnr_olddsk$t_nodename = dsk->mnr_dsk$t_nodename;
	          olddsk->mnr_olddsk$t_volnamel = dsk->mnr_dsk$q_volnamel;
	          olddsk->mnr_olddsk$t_volnameh = dsk->mnr_dsk$l_volnameh;
	          olddsk->mnr_olddsk$l_opcnt = dsk->mnr_dsk$l_opcnt;
	          olddsk->mnr_olddsk$l_ioqueln = dsk->mnr_dsk$l_ioqueln;
		  dsk = (DISK_CLASS *) ((int)dsk + MNR_DSK$K_SIZE);
		  olddsk = (OLDDISK_CLASS *) ((int)olddsk + MNR_OLDDSK$K_SIZE);
		  }

		rab_out.rab$w_rsz = MNR_OLDCLS$K_SIZE + MNR_CMP$K_SIZE + (dskpre->mnr_cmp$l_eltct * MNR_OLDDSK$K_SIZE);
		break;
		}

	      //
	      // Convert RMS class
	      //
	      case RMS_CLSNO:
		{
		RMS_CLASS	*rms;
		OLDRMS_CLASS	*oldrms;
		CLASS_PRE	*rmspre;

		memcpy ( (void *)((int)buf_out + MNR_OLDCLS$K_SIZE), 
			 (void *)((int)buf_in + MNR_CLS$K_SIZE), 
			 MNR_CMP$K_SIZE );
		rmspre = (CLASS_PRE *) ((int)buf_in + MNR_CLS$K_SIZE);
		rms = (RMS_CLASS *) ((int)buf_in + MNR_CLS$K_SIZE + MNR_CMP$K_SIZE);
		oldrms = (OLDRMS_CLASS *) ((int)buf_out + MNR_OLDCLS$K_SIZE + MNR_CMP$K_SIZE);

		for ( i=0; i<rmspre->mnr_cmp$l_eltct; i++ )
		  {
	          oldrms->mnr_oldrms$b_filnum = rms->mnr_rms$b_filnum;
		  memcpy ( &oldrms->mnr_oldrms$l_org, &rms->mnr_rms$l_org, MNR_RMS$K_SIZE - 4 );
		  rms = (RMS_CLASS *) ((int)rms + MNR_RMS$K_SIZE);
		  oldrms = (OLDRMS_CLASS *) ((int)oldrms + MNR_OLDRMS$K_SIZE);
		  }

		rab_out.rab$w_rsz = MNR_OLDCLS$K_SIZE + MNR_CMP$K_SIZE + (rmspre->mnr_cmp$l_eltct * MNR_OLDRMS$K_SIZE);
		break;
		}

	      //
	      // other class records will not be converted
	      //
	      default:
		{
		memcpy ( (void *)((int)buf_out + MNR_OLDCLS$K_SIZE), 
			 (void *)((int)buf_in + MNR_CLS$K_SIZE), 
			 rab_in.rab$w_rsz - MNR_CLS$K_SIZE );
		rab_out.rab$w_rsz = rab_in.rab$w_rsz - (MNR_CLS$K_SIZE - MNR_OLDCLS$K_SIZE);
		}

	      }
	    }

	  //
	  // Convert aligned DIGITAL control records to un-aligned format
	  //
	  if ( rec_type == 2 )
	    {
	    switch ( (uint8)*ch )
	      {

	      //
	      // Convert HEADER_TYPE record
	      //
	      case HEADER_TYPE:
		{
		FILE_HDR	*hdr;
		FILE_HDR_OLD	*oldhdr;

		hdr = (FILE_HDR *) buf_in;
		oldhdr = (FILE_HDR_OLD *) buf_out;

		oldhdr->mnr_oldhdr$b_type = hdr->mnr_hdr$b_type;
		memcpy ( &oldhdr->mnr_oldhdr$l_flags, &hdr->mnr_hdr$l_flags, 4 );
		oldhdr->mnr_oldhdr$q_beginning = hdr->mnr_hdr$q_beginning;
		oldhdr->mnr_oldhdr$q_ending = hdr->mnr_hdr$q_ending;
		oldhdr->mnr_oldhdr$l_interval = hdr->mnr_hdr$l_interval;
		oldhdr->mnr_oldhdr$o_rev0clsbits[0] = hdr->mnr_hdr$o_rev0clsbits[0];
		oldhdr->mnr_oldhdr$o_rev0clsbits[1] = hdr->mnr_hdr$o_rev0clsbits[1];
		oldhdr->mnr_oldhdr$l_recct = hdr->mnr_hdr$l_recct;
		memcpy ( oldhdr->mnr_oldhdr$t_ident, "MON31050", 8 );
		memcpy ( oldhdr->mnr_oldhdr$t_comment, hdr->mnr_hdr$t_comment, 60 );
		oldhdr->mnr_oldhdr$w_comlen = hdr->mnr_hdr$w_comlen;
		memcpy ( oldhdr->mnr_oldhdr$o_classbits, hdr->mnr_hdr$o_classbits, 16 );
		memcpy ( oldhdr->mnr_oldhdr$t_revlevels, hdr->mnr_hdr$t_revlevels, 128 );
		if ( oldhdr->mnr_oldhdr$t_revlevels[PRO_CLSNO] != 0 )
		  oldhdr->mnr_oldhdr$t_revlevels[PRO_CLSNO] = MNR_OLDPRO$C_PRO_REV;
		if ( oldhdr->mnr_oldhdr$t_revlevels[DSK_CLSNO] != 0 )
		  oldhdr->mnr_oldhdr$t_revlevels[DSK_CLSNO] = MNR_OLDDSK$C_DISK_REV;

		rab_out.rab$w_rsz = MNR_OLDHDR$K_SIZE;
		break;
		}

	      //
	      // Convert SYI_TYPE record
	      //
	      case SYI_TYPE:
		{
		SYS_INFO	*syi;
		SYS_INFO_OLD	*oldsyi;

		syi = (SYS_INFO *) buf_in;
		oldsyi = (SYS_INFO_OLD *) buf_out;

		oldsyi->mnr_oldsyi$b_type = syi->mnr_syi$b_type;
		memcpy ( &oldsyi->mnr_oldsyi$w_flags, &syi->mnr_syi$w_flags, 2 );
		oldsyi->mnr_oldsyi$q_boottime = syi->mnr_syi$q_boottime;
		oldsyi->mnr_oldsyi$w_maxprcct = syi->mnr_syi$w_maxprcct;
		oldsyi->mnr_oldsyi$b_mpcpus = syi->mnr_syi$b_mpcpus;
		memcpy ( oldsyi->mnr_oldsyi$t_nodename, syi->mnr_syi$t_nodename, 16 );
		oldsyi->mnr_oldsyi$l_balsetmem = syi->mnr_syi$l_balsetmem;
		oldsyi->mnr_oldsyi$l_mpwhilim = syi->mnr_syi$l_mpwhilim;
		oldsyi->mnr_oldsyi$l_cputype = syi->mnr_syi$l_cputype;
		oldsyi->mnr_oldsyi$b_index = syi->mnr_syi$b_index;
		oldsyi->mnr_oldsyi$l_cpuconf = syi->mnr_syi$l_cpuconf;
		oldsyi->mnr_oldsyi$b_vpcpus = syi->mnr_syi$b_vpcpus;
		oldsyi->mnr_oldsyi$l_vpconf = syi->mnr_syi$l_vpconf;

		rab_out.rab$w_rsz = MNR_OLDSYI$K_SIZE;
		break;
		}

	      //
	      // other record types will not be converted
	      //
	      default:
		{
		memcpy ( buf_out, buf_in, rab_in.rab$w_rsz );
		rab_out.rab$w_rsz = rab_in.rab$w_rsz;
		}
	      }
	    }

	  //
	  // CUSTOMER records will not be converted
	  //
	  if ( rec_type == 3 )
	    {
	    memcpy ( buf_out, buf_in, rab_in.rab$w_rsz );
	    rab_out.rab$w_rsz = rab_in.rab$w_rsz;
	    }

	  //
	  // Write converted record to output file
	  //
	  status = sys$put ( &rab_out );
	  if ( !$VMS_STATUS_SUCCESS (status) )  return status;
	  }

	//
	// Close input and output files
	//
	status = sys$close ( &fab_in );
	if ( !$VMS_STATUS_SUCCESS (status) )  return status;
	status = sys$close ( &fab_out );
	if ( !$VMS_STATUS_SUCCESS (status) )  return status;

	return SS$_NORMAL;
}
