$!  Copyright (c) 1987 Digital Equipment Corporation.  All rights reserved.
$!
$!   This is the command procedure for the system manager's menu. MicroVAX
$!   users receive the menu by default when they log into the system manager's
$!   account (SYSTEM).
$!
$!   If your processor is not a MicroVAX you may want to use this command
$!   command procedure as a model for designing your own.
$!
$ GOTO SKIP_CNTRLY
$!----------------------------------------------------------------
$!
$!	Control Y was pressed if we got to this routine.
$!		Put this here so there is FAST response to ^Y
$!
$!----------------------------------------------------------------
$CNTRLY:
$ TYPE SYS$INPUT:

	Command procedure aborted by Control Y

$ SET DEFAULT 'DEFDIR'
$ EXIT
$!
$SKIP_CNTRLY:
$!
$!   This is the command procedure for the system manager's menu. It
$!   allows the MicroVAX system manager to perform routine system
$!   management tasks without referring to a manual.
$!
$ DEFDIR = F$ENVIRONMENT("DEFAULT")
$ SET NOON
$ ON CONTROL_Y THEN GOTO CNTRLY
$ GOTO MENU_NOWAIT
$!
$!   Enter here, if you want the text on the screen to remain displayed
$!
$MAIN_MENU:
$ WRITE SYS$OUTPUT ""
$ INQUIRE/NOPUNCT DUMMY "		Press [RETURN] for main menu"
$!
$!   Screen gets cleared, and menu is displayed below.
$!
$!   NOTE: To add entries to the menu, do the following:
$!	1) Change the "MENU_ENTRIES =" to the appropriate new number
$!	2) Add the entry to the text portion of the menu.
$!	3) Define two GOTO points named as follows:
$!	    a) DO_#: - Control will be transfered to this point when the
$!		       number (#) is entered.
$!	    b) HELP_#: - Control will be tranfered to this point when
$!			 "?#" is entered.
$!
$MENU_NOWAIT:
$!
$!	Other command procedures might change these symbols, so
$!	reset them everytime we have to put up the menu.
$!
$ SET DEFAULT SYS$MANAGER:
$ SAY = "WRITE SYS$OUTPUT"
$ ESC[0,8] = 27
$ DASHES = "------------------------------------------------"
$ CRLF = F$FAO("!/")
$ CLS = ESC+"[H"+ESC+"[J"
$ IF .NOT.F$GETDVI("SYS$OUTPUT","TT_ANSICRT") THEN CLS = CRLF+DASHES+CRLF
$ MENU_ENTRIES = 13
$ SAY CLS
$ TYPE SYS$INPUT
Main Menu

	 1 - Exit to DCL
	 2 - Log out of the SYSTEM account
	 3 - Invoke the MAIL utility
	 4 - Add a user account to the system
	 5 - Install optional software
	 6 - Tailor a VMS system
	 7 - Create or Modify an Autologin Terminal
	 8 - Back up or Restore the user files on a disk
	 9 - Build a Standalone BACKUP kit
        10 - Set the maximum number of interactive logins
	11 - Configure the network
	12 - Shut down or start up the network
	13 - SHUT DOWN the system

$ READ/END_OF_FILE=DO_1/PROMPT="Enter a number (? or ?# for HELP): " -
	SYS$COMMAND NUMBER
$ IF F$EXTRACT(0,1,NUMBER) .NES. "?" THEN GOTO SKIP_HELP
$!
$!	The user entered a "?" if here.
$!
$ IF NUMBER .EQS. "?" THEN GOTO HELP_MAIN
$ N = F$INTEGER(F$EXTRACT(1,2,NUMBER))
$ IF (N.LT.1).OR.(N.GT.MENU_ENTRIES) THEN GOTO MM_ERROR
$ SAY CLS
$ GOTO HELP_'F$STRING(N)'
$!
$!	The user didn't ask for help, run the command file that he wants
$!
$SKIP_HELP:
$ N = F$INTEGER(NUMBER)
$ IF ((N.LT.1).OR.(N.GT.MENU_ENTRIES)) THEN GOTO MM_ERROR
$ SAY CLS
$ GOTO DO_'F$STRING(N)'
$!
$!   An incorrect answer has been entered if here.
$!
$ MM_ERROR:
$ TYPE SYS$INPUT

Please enter either a number, "?" or "?#" where # is the number of
the specific item that you want help with.

$ GOTO MAIN_MENU
$!--------------------------------------------------------------------
$!
$!   We have received a valid entry
$!
$!--------------------------------------------------------------------
$!
$!	1 - Exit to DCL
$!
$DO_1:
$ TYPE SYS$INPUT:

If you wish to use the menus again, type the following:
	$ @SYS$EXAMPLES:MGRMENU

$ SET DEFAULT 'DEFDIR'
$ EXIT
$!
$!	2 - Log off of the system
$!
$DO_2:
$ INQUIRE/NOPUNCT YESNO "Are you sure that you want to log off [NO]? "
$ IF F$EXTRACT(0,1,YESNO) .EQS. "Y" THEN LOGOUT
$ GOTO MAIN_MENU
$!
$!	3 - Invoke the MAIL utility
$!
$DO_3:
$ ON ERROR THEN CONTINUE
$ DEFINE/NOLOG/USER SYS$INPUT SYS$COMMAND
$ MAIL
$ GOTO MENU_NOWAIT
$!
$!	4 - Add a user to the system
$!
$DO_4:
$ CF="ADDUSER"
$ GOTO DO_COM
$!
$!	5 - Install optional software
$!
$DO_5:
$ CF = "SYS$UPDATE:VMSINSTAL"
$ GOTO DO_COM
$!
$!	6 - Tailor a VMS system
$!
$DO_6:
$ SAY "Tailoring your system requires that the system be rebooted."
$ INQUIRE/NOPUNCTUATION SURE "Are you sure you wish to go through with it? "
$ IF (.NOT.SURE) THEN GOTO MAIN_MENU
$AUTOGEN_P1:
$ @SYS$UPDATE:AUTOGEN SAVPARAMS GENPARAMS
$ SAY "The system parameter values have been calculated based on the"
$ SAY "current feedback information."
$ SAY ""
$ INQUIRE/NOPUNCTUATION SURE "Do you want to examine the calculated values? "
$ IF (.NOT.SURE) THEN GOTO AUTOGEN_P2
$ DEFINE/NOLOG/USER SYS$INPUT SYS$COMMAND
$ EDIT/TPU/READ/NOMOD SYS$SYSTEM:SETPARAMS.DAT
$ SAY "Please see the VMS System Manager's Manual for details on modifying"
$ SAY "AUTOGEN parameters."
$ SAY ""
$ INQUIRE/NOPUNCTUATION SURE "Do you want to modify the values? "
$ IF (.NOT.SURE) THEN GOTO AUTOGEN_P2
$ DEFINE/NOLOG/USER SYS$INPUT SYS$COMMAND
$ EDIT/TPU SYS$SYSTEM:MODPARAMS.DAT
$ GOTO AUTOGEN_P1
$AUTOGEN_P2:
$ SAY "AUTOGEN will now update the system parameters and reboot."
$ @SYS$UPDATE:AUTOGEN SETPARAMS REBOOT
$ GOTO MAIN_MENU
$!
$!	7 - Create or modify an autologin system
$!
$DO_7:
$ SAY "Enter the name of the terminal that you would like to modify"
$ SAY "for automatic login, or a blank line to exit."
$ SAY ""
$ INQUIRE/NOPUNCTUATION TERM "Terminal (ddcu)? "
$ IF TERM .EQS. "" THEN GOTO DONE_7
$ SAY "Enter the username you would like to automatically login on ''TERM'."
$ SAY "Enter a blank line to display and optionally modify the characteristics of ''TERM'."
$ SAY ""
$ INQUIRE/NOPUNCTUATION USER "Username? "
$ IF USER .EQS. "" THEN GOTO DELETEREC
$ MCR SYSMAN ALF ADD 'TERM' 'USER'
$ GOTO DO_7
$DELETEREC:
$ MCR SYSMAN ALF SHOW 'TERM'
$ INQUIRE/NOPUNCTUATION YN "Do you want to modify the above? "
$ IF .NOT. YN THEN GOTO DO_7
$ INQUIRE/NOPUNCTUATION YN "Do you wish to remove ''TERM' from the database? "
$ IF .NOT. YN THEN GOTO DELETEUSERNAME
$ MCR SYSMAN ALF REMOVE 'TERM'
$ GOTO DO_7
$DELETEUSERNAME:
$ INQUIRE/NOPUNCTUATION YN "Do you wish to remove a username from the database? "
$ IF .NOT. YN THEN GOTO DO_7
$ INQUIRE/NOPUNCTUATION USER "Username? "
$ IF USER .EQS. "" THEN GOTO DO_7
$ MCR SYSMAN ALF REMOVE 'TERM'/USERNAME='USER'
$ GOTO DO_7
$DONE_7:
$ GOTO MAIN_MENU
$!
$!	8 - <B>ackup or <R>estore the disk
$!
$DO_8:
$ INQUIRE/NOPUNC TEMP__1 "<B>ackup or <R>estore a disk? "
$ IF F$EXTRACT(0,1,TEMP__1) .EQS. "B" THEN @SYS$EXAMPLES:BACKUSER
$ IF F$EXTRACT(0,1,TEMP__1) .EQS. "R" THEN @SYS$EXAMPLES:RESTUSER
$ GOTO MAIN_MENU
$!
$!	9 - Build a standalone backup kit
$!
$DO_9:
$ CF = "SYS$UPDATE:STABACKIT"
$ GOTO DO_COM
$!
$!	10 - Set the maximum number of interactive logins
$!
$DO_10:
$ INQUIRE/NOPUNC COUNT "What do you want the maximum number of logins to be? "
$ IF COUNT .EQS. "" THEN GOTO SKIP_11_1
$ ON ERROR THEN CONTINUE
$ SET LOGINS/INTERACTIVE='COUNT'
$ GOTO MAIN_MENU
$SKIP_11_1:
$ SAY "Maximum number of interactive logins has NOT changed."
$ GOTO MAIN_MENU
$!
$!	11 - Configure the network
$!
$DO_11:
$ CF = "NETCONFIG"
$ GOTO DO_COM
$!
$!	12 - Shut down or start up the network
$!
$DO_12:
$ INQUIRE/NOPUNC WHICH "Do you wish to <Sh>ut down or <St>art up the network? "
$ IF F$EXTRACT(0,2,WHICH) .EQS. "SH" THEN GOTO SHUT_NET
$ IF F$EXTRACT(0,2,WHICH) .EQS. "ST" THEN GOTO START_NET
$ GOTO MAIN_MENU
$SHUT_NET:
$ RUN SYS$SYSTEM:NCP
SET EXECUTOR STATE SHUT
$ GOTO MAIN_MENU
$START_NET:
$ CF="STARTNET"
$ GOTO DO_COM
$!
$!	13 - SHUT DOWN the system
$!
$DO_13:
$ INQUIRE/NOPUNCT YESNO "Are you sure you want to SHUTDOWN the system [NO]? "
$ IF F$EXTRACT(0,1,YESNO) .NES. "Y" THEN GOTO MAIN_MENU
$ CF="SYS$SYSTEM:SHUTDOWN"
$ PARAMS="0 SHUTDOWN YES NO LATER NO NONE"
$ GOTO DO_COM
$!-------------------------------------------------------------
$!
$!   The small routine below executes command file 'CF'
$!
$!-------------------------------------------------------------
$DO_COM:
$ IF F$SEARCH(CF+".COM") .EQS. "" THEN GOTO NO_COM_FILE
$ @'CF' 'PARAMS'
$ GOTO MAIN_MENU
$NO_COM_FILE:
$ SAY "ERROR: Command file "+CF+".COM does not exist."
$ GOTO MAIN_MENU
$!-------------------------------------------------------------
$!
$!   The help text begins below.
$!
$!-------------------------------------------------------------
$HELP_MAIN:
$ SAY CLS
$ TYPE SYS$INPUT:
	This is the system manager menu, which will assist you in
	performing some routine system management tasks.

	The name of the command procedure that generates the system
	manager menu is MGRMENU.COM. This command procedure resides
	in SYS$EXAMPLES. Enter the following command at the dollar
	sign prompt ($) to invoke the system manager menu:

		$ @SYS$EXAMPLES:MGRMENU

	If you are using a MicroVAX, this menu appears, be default,
	on the terminal screen each time you log in to the system 
	manager's account (SYSTEM). If you do not want the menu to
	appear when you log in to the SYSTEM account, edit the LOGIN.COM
	file for this account. Insert a comment character (!) after the
	dollar sign in the following line:

		$ IF F$SEARCH ... @SYS$EXAMPLES:MGRMENU.COM
		(becomes $! IF F$SEARCH ... @SYS$EXAMPLES:MGRMENU.COM)



$ INQUIRE/NOPUNCTUATION DUMMY "                     Press [RETURN] to continue"
$ SAY CLS
$ TYPE SYS$INPUT:
	For more information about VMS system management, refer to the
	following manuals:
		VMS User's Manual
		Alpha VMS Installation, Upgrade, and Operations Manual
		VMS System Manager's Manual

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   1 - Exit to DCL
$!
$HELP_1:
$ TYPE SYS$INPUT:

	Selecting this option causes you to exit from the menu and
	return to the DCL prompt ($). You can enter any DCL command
	at this prompt. To reinvoke the system manager menu, enter
	the following command:
		$ @SYS$EXAMPLES:MGRMENU.COM

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   2 - Log out of the SYSTEM account
$!
$HELP_2:
$ TYPE SYS$INPUT:

	Selecting this option causes you to log out of the SYSTEM
	account. If you use this option, you must log back into 
	the system account or another account to use the system.

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   3 - Invoke the MAIL utility
$!
$HELP_3:
$ TYPE SYS$INPUT:

	If you have received mail, use this option to invoke the MAIL
	Utility. When you exit from MAIL, you return to the system
	manager menu.

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   4 - Add a user to the system
$!
$HELP_4:
$ TYPE SYS$INPUT:

	Selecting this option invokes the SYS$EXAMPLES:ADDUSER.COM
	command procedure.

	ADDUSER.COM invokes the AUTHORIZE Utility to add a new user 
	account to the system.

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   5 - Install optional software
$!
$HELP_5:
$ TYPE SYS$INPUT:

	Selecting this option invokes the SYS$UPDATE:VMSINSTAL.COM
	command procedure.

	Use this option to install optional software products.

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   6 - Tailor a VMS system
$!
$HELP_6:
$ TYPE SYS$INPUT:

	Selecting this option invokes the SYS$UPDATE:AUTOGEN.COM 
	command procedure to tailor your system.

	When this item is selected, AUTOGEN is invoked to save the 
	current feedback information and calculate new values for 
	the system parameters. At this time you may review the cal-
	culated values and change them. Finally, AUTOGEN is invoked
	again to set the new parameter values and reboot your sys-
	tem.

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   7 - Create or Modify an Autologin terminal
$!
$HELP_7:
$ TYPE SYS$INPUT:

	Selecting this option allows you to create an autologin 
	terminal, or to modify or delete an existing autologin
	terminal, using SYSMAN.

	Autologin terminals are terminals that automatically log
	into an account rather than prompt for a username.

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   8 - Back up or restore the user files on a disk
$!
$HELP_8:
$ TYPE SYS$INPUT:

	When you select this option, you are asked whether you 
	want to back up the user files on a disk or restore them to
	a disk using removable media. The following system files
	are saved: SYSUAF.DAT, RIGHTSLIST.DAT, VAXVMSSYS.PAR, NET*.DAT,
	NOTICE.TXT, MODPARAMS.DAT, and VMSMAIL.DAT. Also, all of the
	files in SYS$MANAGER are saved.

	After this question is answered, you are prompted for the
	device name of the disk that you want to back up or restore.
	You are then prompted for the name of the device which has the 
	removable media used for the backup.

	If you choose to back up the user files on a disk, the 
	SYS$EXAMPLES:BACKUSER.COM command procedure is invoked. If you 
	choose to restore the user files on the system disk, the 
	SYS$EXAMPLES:RESTUSER.COM command procedure is invoked.

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   9 - Build a Standalone BACKUP kit
$!
$HELP_9:
$ TYPE SYS$INPUT:

	Selecting this option invokes the SYS$MANAGER:STABACKIT.COM
	command procedure.

	Use this option to build a Standalone BACKUP kit on diskettes,
	tape cartridge, or an alternate system root on the system disk.

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   10 - Set maximum number of interactive logins
$!
$HELP_10:
$ TYPE SYS$INPUT:

	Selecting this option prompts you for the number of interactive
	users you want to be logged in at a time. After you enter a
	number, the following command is executed:

		$ SET LOGINS/INTERACTIVE=number you entered

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   11 - Configure the Network.
$!
$HELP_11:
$ TYPE SYS$INPUT:

	Selecting this option invokes the SYS$MANAGER:NETCONFIG.COM
	command procedure.

	When you first install the DECnet software onto your system,
	you should set a node name and a node address.

$ GOTO MAIN_MENU
$!
$!	HELP FOR:   12 - Start up or shut down the network
$!
$HELP_12:
$ TYPE SYS$INPUT:

	When you select this option, you are asked whether you 
	want to shut down or start up the network. If you do not
	want to do either, press RETURN.

	If you choose the shut down option, NCP is run and the
	following command is entered in NCP:

		NCP> SET EXECUTOR STATE SHUT

	If you choose to start up the network, you invoke
	the SYS$MANAGER:STARTNET.COM command procedure.
	
$ GOTO MAIN_MENU
$!
$!	HELP FOR:   13 - SHUT DOWN the system.
$!
$HELP_13:
$ TYPE SYS$INPUT:

	Use this option to shut down the ENTIRE system. This
	option invokes the SYS$SYSTEM:SHUTDOWN.COM command
	procedure. After this command procedure has completed,
	you can turn the power switch on your system to the
	"0" (off) position.

$ GOTO MAIN_MENU
