/*  X-1
**
**   Copyright  Digital Equipment Corporation, 1994  All Rights Reserved.
**   Unpublished rights reserved under the copyright laws of the United States.
**
**   The software contained on this media is proprietary to and embodies the
**   confidential technology of Digital Equipment Corporation.  Possession, use,
**   duplication or dissemination of the software and media is authorized only
**   pursuant to a valid written license from Digital Equipment Corporation.
**
**   RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure by the U.S.
**   Government is subject to restrictions as set forth in Subparagraph
**   (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19, as applicable.
**
**
**++
**  FACILITY:
**
**      Example Device Driver for OpenVMS AXP
**
**  MODULE DESCRIPTION:
**
**	This module contains the fallback table remapping for DEC Multinational
**	Character Set "MCS".
**
**  AUTHOR:
**
**      OpenVMS Alpha Development Group
**
**  MODIFICATION HISTORY:
**
**      X-1     VMS000          OpenVMS Alpha Drivers	20-July-1994
**              Initial version.
**
**--
*/


/*
*+
*       Build up a table with the whole ASCII 8-Bit character set.  This table
* is used to translate 8-Bit characters to 7-Bit characters if the printer is 
* doing character fallback translation.  This only exists for to keep the
* printer code equivalent to that in the old LP11 interface.  Any modern
* printer that is likely to be controlled by LRDRIVER should be capable of
* deaing with 8-Bit characters.
*-
*/
static unsigned char	TRANS_TABLE[256] =  { 
'\x00',         /* NUL   */
'\x01',         /* SOH   */
'\x02',         /* STX   */
'\x03',         /* ETX   */
'\x04',         /* EOT   */
'\x05',         /* ENQ   */
'\x06',         /* ACK   */
'\x07',         /* BEL   */
'\x08',         /* BS    */
'\x09',         /* HT    */
'\x0A',         /* LF    */
'\x0B',         /* VT    */
'\x0C',         /* FF    */
'\x0D',         /* CR    */
'\x0E',         /* SO    */
'\x0F',         /* SI    */
'\x10',         /* DLE   */
'\x11',         /* DC1   */
'\x12',         /* DC2   */
'\x13',         /* DC3   */
'\x14',         /* DC4   */
'\x15',         /* NAK   */
'\x16',         /* SYN   */
'\x17',         /* ETB   */
'\x18',         /* CAN   */
'\x19',         /* EM    */
'\x1A',         /* SUB   */
'\x1B',         /* ESC   */
'\x1C',         /* FS    */
'\x1D',         /* GS    */
'\x1E',         /* RS    */
'\x1F',         /* US    */
'\x20',         /* SP    */
'\x21',         /* !     */
'\x22',         /* "     */
'\x23',         /* #     */
'\x24',         /* $     */
'\x25',         /* %     */
'\x26',         /* &     */
'\x27',         /* '     */
'\x28',         /* (     */
'\x29',         /* )     */
'\x2A',         /* *     */
'\x2B',         /* +     */
'\x2C',         /* ,     */
'\x2D',         /* -     */
'\x2E',         /* .     */
'\x2F',         /* /     */
'\x30',         /* 0     */
'\x31',         /* 1     */
'\x32',         /* 2     */
'\x33',         /* 3     */
'\x34',         /* 4     */
'\x35',         /* 5     */
'\x36',         /* 6     */
'\x37',         /* 7     */
'\x38',         /* 8     */
'\x39',         /* 9     */
'\x3A',         /* :     */
'\x3B',         /* ;     */
'\x3C',         /* <     */
'\x3D',         /* =     */
'\x3E',         /* >     */
'\x3F',         /* ?     */
'\x40',         /* @     */
'\x41',         /* A     */
'\x42',         /* B     */
'\x43',         /* C     */
'\x44',         /* D     */
'\x45',         /* E     */
'\x46',         /* F     */
'\x47',         /* G     */
'\x48',         /* H     */
'\x49',         /* I     */
'\x4A',         /* J     */
'\x4B',         /* K     */
'\x4C',         /* L     */
'\x4D',         /* M     */
'\x4E',         /* N     */
'\x4F',         /* O     */
'\x50',         /* P     */
'\x51',         /* Q     */
'\x52',         /* R     */
'\x53',         /* S     */
'\x54',         /* T     */
'\x55',         /* U     */
'\x56',         /* V     */
'\x57',         /* W     */
'\x58',         /* X     */
'\x59',         /* Y     */
'\x5A',         /* Z     */
'\x5B',         /* [     */
'\x5C',         /* \     */
'\x5D',         /* ]     */
'\x5E',         /* ^     */
'\x5F',         /* _     */
'\x60',         /* `     */
'\x61',         /* a     */
'\x62',         /* b     */
'\x63',         /* c     */
'\x64',         /* d     */
'\x65',         /* e     */
'\x66',         /* f     */
'\x67',         /* g     */
'\x68',         /* h     */
'\x69',         /* i     */
'\x6A',         /* j     */
'\x6B',         /* k     */
'\x6C',         /* l     */
'\x6D',         /* m     */
'\x6E',         /* n     */
'\x6F',         /* o     */
'\x70',         /* p     */
'\x71',         /* q     */
'\x72',         /* r     */
'\x73',         /* s     */
'\x74',         /* t     */
'\x75',         /* u     */
'\x76',         /* v     */
'\x77',         /* w     */
'\x78',         /* x     */
'\x79',         /* y     */
'\x7A',         /* z     */
'\x7B',         /* {     */
'\x7C',         /* |     */
'\x7D',         /* }     */
'\x7E',         /* ~     */
'\x7F',         /* DEL   */
'\x5F',         /*     80 */ /* Remap most of the C1/GR codes to _ */
'\x5F',         /*     81 */
'\x5F',         /*     82 */
'\x5F',         /*     83 */
'\x5F',         /* IND 84 */
'\x5F',         /* NEL 85 */
'\x5F',         /* SSA 86 */
'\x5F',         /* ESA 87 */
'\x5F',         /* HTS 88 */
'\x5F',         /* HTJ 89 */
'\x5F',         /* VTS 8A */
'\x5F',         /* PLD 8B */
'\x5F',         /* PLU 8C */
'\x5F',         /* RI  8D */
'\x5F',         /* SS2 8E */
'\x5F',         /* SS3 8F */
'\x5F',         /* DCS 90 */
'\x5F',         /* PU1 91 */
'\x5F',         /* PU2 92 */
'\x5F',         /* STS 93 */
'\x5F',         /* CCH 94 */
'\x5F',         /* MW  95 */
'\x5F',         /* SPA 96 */
'\x5F',         /* EPA 97 */
'\x5F',         /*     98 */
'\x5F',         /*     99 */
'\x5F',         /*     9A */
'\x5F',         /* CSI 9B */
'\x5F',         /* ST  9C */
'\x5F',         /* OSC 9D */
'\x5F',         /* PM  9E */
'\x5F',         /* APC 9F */
'\x5F',         /*     A0 */
'\x21',         /*    A1 */
'\x63',         /*    A2 */
'\x4C',         /*    A3 */
'\x5F',         /*     A4 */
'\x59',         /*    A5 */
'\x5F',         /*     A6 */
'\x5F',         /*    A7 */
'\x4F',         /*    A8 */
'\x5F',         /*    A9 */
'\x61',         /*    AA */
'\x5F',         /*    AB */
'\x5F',         /*     AC */
'\x5F',         /*     AD */
'\x5F',         /*     AE */
'\x5F',         /*     AF */
'\x6F',         /*    B0 */
'\x2B',         /*    B1 */
'\x32',         /*    B2 */
'\x33',         /*    B3 */
'\x5F',         /*     B4 */
'\x75',         /*    B5 */
'\x5F',         /*    B6 */
'\x2E',         /*    B7 */
'\x5F',         /*     B8 */
'\x31',         /*    B9 */
'\x6F',         /*    BA */
'\x5F',         /*    BB */
'\x5F',         /*    BC */
'\x5F',         /*    BD */
'\x5F',         /*     BE */
'\x3F',         /*    BF */
'\x41',         /*    C0 */
'\x41',         /*    C1 */
'\x41',         /*    C2 */
'\x41',         /*    C3 */
'\x41',         /*    C4 */
'\x41',         /*    C5 */
'\x5F',         /*    C6 */
'\x43',         /*    C7 */
'\x45',         /*    C8 */
'\x45',         /*    C9 */
'\x45',         /*    CA */
'\x45',         /*    CB */
'\x49',         /*    CC */
'\x49',         /*    CD */
'\x49',         /*    CE */
'\x49',         /*    CF */
'\x5F',         /*     D0 */
'\x4E',         /*    D1 */
'\x4F',         /*    D2 */
'\x4F',         /*    D3 */
'\x4F',         /*    D4 */
'\x4F',         /*    D5 */
'\x4F',         /*    D6 */
'\x5F',         /*    D7 */
'\x4F',         /*    D8 */
'\x55',         /*    D9 */
'\x55',         /*    DA */
'\x55',         /*    DB */
'\x55',         /*    DC */
'\x59',         /*    DD */
'\x5F',         /*     DE */
'\x5F',         /*    DF */
'\x61',         /*    E0 */
'\x61',         /*    E1 */
'\x61',         /*    E2 */
'\x61',         /*    E3 */
'\x61',         /*    E4 */
'\x61',         /*    E5 */
'\x5F',         /*    E6 */
'\x5F',         /*    E7 */
'\x65',         /*    E8 */
'\x65',         /*    E9 */
'\x65',         /*    EA */
'\x65',         /*    EB */
'\x69',         /*    EC */
'\x69',         /*    ED */
'\x69',         /*    EE */
'\x69',         /*    EF */
'\x5F',         /*     F0 */
'\x6E',         /*    F1 */
'\x6F',         /*    F2 */
'\x6F',         /*    F3 */
'\x6F',         /*    F4 */
'\x6F',         /*    F5 */
'\x6F',         /*    F6 */
'\x5F',         /*    F7 */
'\x6F',         /*    F8 */
'\x75',         /*    F9 */
'\x75',         /*    FA */
'\x75',         /*    FB */
'\x75',         /*    FC */
'\x79',         /*    FD */
'\x5F',         /*     FE */
'\x5F',         /*     FF */
};


/*
*+
*       Define chrarcter that can be translated to uppercase by subtracting
* 32 from their value.  These are "a" through "{", "}", "" through "", and 
* "" through "".
*-
*/
static unsigned int CASE_TABLE[8] = {0, 0, 0, 0x2FFFFFFE, 0, 0, 0, 0x3FFEFFFF};


/*
*+
*       Define those characters that cannot be printed.
*-
*/
static unsigned int CTRL_TABLE[8] = {0xFFFFFFFF, 0, 0, 0x80000000, 0xFFFFFFFF, 0, 0, 0};
