$ !
$ ! Determine the hardware platform this is being built on.
$ !
$ VAX = "TRUE"
$ SYSTEM = F$GETSYI("HW_MODEL")
$ IF SYSTEM .GT. 1023 THEN VAX = "FALSE"
$ !
$ ! Assemble macro module for rating
$ !
$ IF VAX
$ THEN
$ !
$ ! For OpenVMS VAX
$ !
$	MACRO SYS$EXAMPLES:LAT$RATING_DPT+SYS$LIBRARY:LIB/LIBRARY
$ ELSE
$ !
$ ! For OpenVMS AXP
$ !
$	MACRO /MIGRATION /NOTIE /MACHINE /SYMBOL -
	/OBJ=LAT$RATING_DPT -
	SYS$LIBRARY:ARCH_DEFS.MAR+ -
	SYS$EXAMPLES:LAT$RATING_DPT+SYS$LIBRARY:LIB/LIB+ -
	SYS$LIBRARY:STARLET/LIB
$ ENDIF
$ !
$ ! Compile C module that has the rating calculation logic
$ !
$ IF VAX
$ THEN
$ !
$ ! For OpenVMS VAX (VAX C compiler)
$ !
$	CC /LIST /MACHINE=INTER SYS$EXAMPLES:LAT$RATING_CALC.C
$ !
$ ! If DEC C is used, compile as follows:
$ !
$ !	CC /DECC /STANDARD=VAXC /MACHINE=INTER SYS$EXAMPLES:LAT$RATING_CALC.C
$ ELSE
$ !
$ ! For OpenVMS AXP (uses DEC C compiler)
$ !
$	CC /MACHINE /NOMEMBER_ALIGN /STANDARD=VAXC /DEFINE=(ALPHA) -
	SYS$EXAMPLES:LAT$RATING_CALC.C
$ ENDIF
$ !
$ ! Make object library
$ !
$ LIBRARY /CREATE LAT$RATING LAT$RATING*.OBJ /NOGLOBALS
$ !
$ !	Link rating image
$ !
$ !	WARNING!!! WARNING!!!  DO NOT LINK AGAINST THE C RTL!!!
$ !	LAT$RATING is a VMS driver image - shareable images cannot
$ !	be reference from it.
$ !
$ IF VAX
$ THEN
$ !
$ ! For OpenVMS VAX, link this way to make an image that is
$ ! loadable by SYSGEN.
$ !
$	LINK/NOTRACEBACK /MAP=LAT$RATING.MAP /EXE=LAT$RATING.EXE -
	/FULL /CROSS /SYSTEM=0 /HEADER -
	LAT$RATING /INCLUDE=(LAT$RATING_DPT,LAT$RATING_CALC),-
	SYS$SYSTEM:SYS.STB/SEL,SYS$INPUT/OPTION
PSECT_ATTR=$$$105_PROLOGUE,NOPIC,USR,CON,REL,LCL,NOSHR,EXE,RD,WRT,NOVEC
PSECT_ATTR=$$$115_DRIVER,NOPIC,USR,CON,REL,LCL,NOSHR,EXE,RD,WRT,NOVEC
PSECT_ATTR=$CODE,NOPIC,USR,CON,REL,LCL,NOSHR,EXE,RD,WRT,NOVEC
PSECT_ATTR=$DATA,NOPIC,USR,CON,REL,LCL,NOSHR,EXE,RD,WRT,NOVEC
COLLECT=NONPAGED_READWRITE_PSECTS/ATTRIBUTES=RESIDENT,-
	$$$115_DRIVER,-
	$CODE,-
	$DATA
$
$ !
$ ! Now produce symbol table file for debugging
$ !
$	LINK/NOTRACEBACK /USERLIB=PROC /NOMAP /NOEXE -
	/SHARE /SYMBOL=LAT$RATING.STB -
	LAT$RATING /INCLUDE=(LAT$RATING_DPT,LAT$RATING_CALC),-
	SYS$SYSTEM:SYS.STB/SEL,SYS$INPUT/OPTION
BASE=0
UNIVERSAL=*
PSECT_ATTR=$$$105_PROLOGUE,NOPIC,USR,CON,REL,LCL,NOSHR,EXE,RD,WRT,NOVEC
PSECT_ATTR=$$$115_DRIVER,NOPIC,USR,CON,REL,LCL,NOSHR,EXE,RD,WRT,NOVEC
PSECT_ATTR=$CODE,NOPIC,USR,CON,REL,LCL,NOSHR,EXE,RD,WRT,NOVEC
PSECT_ATTR=$DATA,NOPIC,USR,CON,REL,LCL,NOSHR,EXE,RD,WRT,NOVEC
COLLECT=NONPAGED_READWRITE_PSECTS/ATTRIBUTES=RESIDENT,-
	$$$115_DRIVER,-
	$CODE,-
	$DATA
$
$ ELSE
$ !
$ ! For OpenVMS AXP - link to make a loadable execlet via
$ ! SYSMAN IO
$ !
$	LINK /USERLIB=PROC /NATIVE_ONLY /BPAGE=14 /SECTION /REPLACE -
	/VMS_EXEC /NODEMAND_ZERO /NOTRACEBACK -
	/MAP=LAT$RATING /FULL /CROSS -
	/SHARE=LAT$RATING -
	/SYSEXE /NOSYSSHR -
	/SYMBOL=LAT$RATING -
	SYS$INPUT /OPT
SYMBOL_TABLE=GLOBAL
CLUSTER=LAT$RATING,,,-
	LAT$RATING/INCLUDE=(LAT$RATING_DPT,LAT$RATING_CALC),-
	SYS$LIBRARY:VMS$VOLATILE_PRIVATE_INTERFACES.OLB/INCLUDE=(BUGCHECK_CODES)/LIB,-
	SYS$LIBRARY:STARLET.OLB/INCLUDE:(SYS$DRIVER_INIT, SYS$DOINIT)
PSECT_ATTR=_AMAC$CODE,PIC,USR,CON,REL,GBL,NOSHR,EXE,RD,NOWRT,NOVEC
PSECT_ATTR=_AMAC$LINKAGE,PIC,USR,CON,REL,GBL,NOSHR,NOEXE,RD,WRT,NOVEC
PSECT_ATTR=$CODE$,PIC,USR,CON,REL,GBL,NOSHR,EXE,RD,NOWRT,NOVEC
PSECT_ATTR=$LINK$,PIC,USR,CON,REL,GBL,NOSHR,NOEXE,RD,WRT,NOVEC
PSECT_ATTR=$PLIT$,PIC,USR,CON,REL,GBL,NOSHR,NOEXE,RD,WRT,NOVEC
PSECT_ATTR=$INITIAL$,PIC,USR,CON,REL,GBL,NOSHR,NOEXE,RD,WRT,NOVEC
PSECT_ATTR=$LITERAL$,PIC,USR,CON,REL,GBL,NOSHR,NOEXE,RD,WRT,NOVEC
PSECT_ATTR=$OWN$,PIC,USR,CON,REL,GBL,NOSHR,NOEXE,RD,WRT,NOVEC
PSECT_ATTR=$DATA$,PIC,USR,CON,REL,GBL,NOSHR,NOEXE,RD,WRT,NOVEC
PSECT_ATTR=$GLOBAL$,PIC,USR,CON,REL,GBL,NOSHR,NOEXE,RD,WRT,NOVEC
PSECT_ATTR=$BSS$,PIC,USR,CON,REL,GBL,NOSHR,NOEXE,RD,WRT,NOVEC
PSECT_ATTR=$READONLY$,PIC,USR,CON,REL,GBL,NOSHR,NOEXE,RD,WRT,NOVEC
PSECT_ATTR=EXEC$INIT_CODE,NOSHR
PSECT_ATTR=EXEC$INIT_LINKAGE,PIC,USR,CON,REL,GBL,NOSHR,EXE,RD,WRT,NOVEC
PSECT_ATTR=$$$115_LINKAGE,PIC,USR,CON,REL,GBL,NOSHR,NOEXE,RD,WRT,NOVEC
COLLECT=NONPAGED_READONLY_PSECTS/ATTRIBUTES=RESIDENT,-
        _AMAC$CODE,-
        EXEC$NONPAGED_CODE,-
	$$$115_DRIVER,-
        $CODE$
COLLECT=NONPAGED_READWRITE_PSECTS/ATTRIBUTES=RESIDENT,-
        _AMAC$LINKAGE,-
        EXEC$NONPAGED_DATA,-
        EXEC$NONPAGED_LINKAGE,-
	$$$105_PROLOGUE,-
	$$$110_DATA,-
	$$$115_LINKAGE,-
        $PLIT$,-
	$INITIAL$,-
	$LITERAL$,-
        $GLOBAL$,-
        $OWN$,-
	$DATA$,-
        $LINK$,-
	$BSS$,-
	$READONLY$
COLLECT=INITIALIZATION_PSECTS/ATTRIBUTES=INITIALIZATION_CODE,-
        EXEC$INIT_LINKAGE,-
        EXEC$INIT_CODE,-
        EXEC$INIT_000,-
        EXEC$INIT_001,-
        EXEC$INIT_002,-
        EXEC$INIT_SSTBL_000,-
        EXEC$INIT_SSTBL_001,-
        EXEC$INIT_SSTBL_002
$
$ ENDIF
$ EXIT
