/*
** COPYRIGHT (c) 1993 BY
** DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.
** ALL RIGHTS RESERVED.
**
** THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
** ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
** INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
** COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
** OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
** TRANSFERRED.
**
** THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE
** AND  SHOULD  NOT  BE  CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPMENT
** CORPORATION.
**
** DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
** SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
**
** COMPONENT:
**
**   This module is part of SYS$EXAMPLES.
**
** MODULE DESCRIPTION:
**
**   The record format of the input file is shown below:
**
**       Description     Column
**      -------------    ------
**      First Name        00-10
**      Middle Initial    11-11
**      Last Name         12-26
**      Street Address    27-46
**      City              47-58
**      State             59-60
**      Zip Code          61-65
**
**   $ DEFINE FDL SYS$EXAMPLES:CREATEIDX.FDL
**   $ DEFINE INPUT SYS$LOGIN:CREATEIDX.IDX
**   $ RUN FDLEXAM
**
**   If any unexpected errors occur during processing, this program
**   does not explicity close open files.  It only returns the error
**   and relies on image rundown to close any open files.
**
*/

#include <stdio.h>
#include <ssdef.h>
#include <stsdef.h>
#include <descrip.h>
#include <starlet.h>
#include <rms.h>
#include <lib$routines.h>

unsigned int fdl$parse();
unsigned int fdl$release();

#define INPRECSIZE 128                  /* Input record length */

/* Define a MACRO to check a status variable and return if an error occurred */
#define CHECK(status, string)\
    if ((status & STS$M_SUCCESS) == 0)\
    {\
        fprintf(stderr, "Error on %s...", string);\
        return (status);\
    }

struct  FAB     *ifab;             /* FABs for input and output files */
struct  RAB     *irab;             /* RABs for input and output files */
struct  record                          /* Record layout: */
        { char  first[11];		/*   First name */
          char  initial;		/*   Middle initial */
          char  last[15];               /*   Last name */
          char  address[20];            /*   Street address */
          char  city[12];               /*   City */
          char  state[2];		/*   State (abbreviated) */
          char  zip[5];                 /*   Zip code */
          char  fill[62];               /*   Padding to MRS of file (128) */
        } buff;

static  char    *header =               /* Header string */
    "First       I Last            Address              City         ST Zip";

$DESCRIPTOR(fdl_desc, "FDL:");

int get_record(struct RAB *rabptr)
/*
** This function obtains the next record from an input file.
** If the file is currently open for shared access, and the
** current record is locked, a sleep() for one second is
** performed, and the access is retried.  There is no retry
** limit, and this function could have if a locked record is
** never released.
**
** This function could easily be modified to use a retry counter,
** and abort the function if the retry limit has been exceeded.
*/
{
    static  float   wait_time = 1.0;        /* Time to stall between $GETs */
    auto    int     status;             /* Status of calls */

    while((status = sys$get(rabptr)) == RMS$_RLK)
        lib$wait(&wait_time);            /* Get record from input file */

   return (status);
}

main()
{
    auto    int     status;             /* Status of calls */
    auto    int     header_flag = 0;

    status = fdl$parse(&fdl_desc, &ifab, &irab);
    CHECK(status, "FDL$PARSE");         /* Return any error */

    irab->rab$l_ubf = (char *) &buff;             /* Buffer address */
    irab->rab$w_usz = INPRECSIZE;        /* Buffer size */
    status = sys$open(ifab);           /* Open input file */
    CHECK(status, "$OPEN");       /* Return any error */
    status = sys$connect(irab);        /* Connect input RAB to FAB */
    CHECK(status, "$CONNECT");    /* Return any error */
    status = get_record(irab);          /* Get first record from input file */
    while (status != RMS$_EOF)          /* Loop until end of input file */
    {
        CHECK(status, "$GET");    /* Return any error */
        if (header_flag == 0)
            puts(header);
        header_flag = 1;
	printf("%11.11s %c %15.15s %20.20s %12.12s %2.2s %5.5s\n",
                buff.first, buff.initial, buff.last,
                buff.address, buff.city, buff.state, buff.zip);
        status = get_record(irab);      /* Get first record from input file */
    }
    status = sys$close(ifab);          /* Close input file */
    CHECK(status, "$CLOSE");      /* Return any error */
    status = fdl$release(&ifab);
    CHECK(status, "FDL$PARSE");         /* Return any error */
    return (SS$_NORMAL);                /* Return success */
}

