/*
 * This program assumes that file DECDTM$EXAMPLE2.FILE_1 and
 * DECDTM$EXAMPLE2.FILE_2 are created and marked for recovery unit
 * journaling using the command file SYS$EXAMPLES:DECDTM$EXAMPLE2.COM
 *
 * Type the following for VAX:
 * $ CC SYS$EXAMPLES:DECDTM$EXAMPLE2
 * $ LINK DECDTM$EXAMPLE2,SYS$INPUT/OPTION
 * SYS$SHARE:VAXCRTL/SHARE
 *
 * Type the following for ALPHA AXP(tm):
 * $ GEMCC/STANDARD=VAXC SYS$EXAMPLES:DECDTM$EXAMPLE2
 * $ LINK/ALPHA DECDTM$EXAMPLE2
 *
 * Then:
 * $ @SYS$EXAMPLES:DECDTM$EXAMPLE2
 * $ RUN DECDTM$EXAMPLE2
 */

#include <errno.h>
#include <ssdef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <starlet.h>

#define check_status(syscall) \
    if (status != SS$_NORMAL || (status = iosb.status) != SS$_NORMAL) { \
        fprintf (stderr, "Failed to %s the transaction\n", syscall); \
        fprintf (stderr, "Error was: %s", strerror (EVMSERR, status)); \
        exit (EXIT_FAILURE); \
    }

int main (int argc, char *argv[])
{
    FILE *fp1, *fp2;
    unsigned int status, count;
    int set_status;
    unsigned char tid[16];
    struct iosb {
        unsigned short status, mbz;
        unsigned long  reason;
    } iosb;

    /* Open the 2 files */

    if ((fp1 = fopen ("DECDTM$EXAMPLE2.FILE_1", "r+", "ctx=rec")) == NULL) {
        perror ("fopen DECDTM$EXAMPLE2.FILE_1");
        exit (EXIT_FAILURE);
    }
    setbuf (fp1, NULL);

    if ((fp2 = fopen ("DECDTM$EXAMPLE2.FILE_2", "r+", "ctx=rec")) == NULL) {
        perror ("fopen DECDTM$EXAMPLE2.FILE_2");
        exit (EXIT_FAILURE);
    }
    setbuf (fp2, NULL);

    count = 0;

    printf ("Running DECdtm example program.\n");
    printf ("Please hit CTRL-Y to interrupt.\n");

    /* Loop forever updating both files under transaction control */

    for (;;) {

        /* Update the count */

        count = count + 1;

        /* Start the transaction */

        status = sys$start_transw (1, 0, &iosb, NULL, 0, tid);
        check_status ("start");

        /* Update the record in each file */

        rewind (fp1);
        if (fprintf (fp1, "%12d", count) <= 0)
            perror ("failed to update DECDTM$EXAMPLE2.FILE_1");

        rewind (fp2);
        if (fprintf (fp2, "%12d", count) <= 0)
            perror ("failed to update DECDTM$EXAMPLE2.FILE_2");

        /* End the transaction if no error occurred, otherwise abort it */

        if (errno == 0) {
            status = sys$end_transw (1, 0, &iosb, NULL, 0, tid);
            check_status ("end");
        } else {
            status = sys$abort_transw (1, 0, &iosb, NULL, 0, tid);
            check_status ("abort");
        }
    }
    return (SS$_NORMAL);
}
