$ Set Noon
$!---------------------------------------------------------------------------
$! *************************************************************************
$! *                                                                       *
$! *  CREATE_INFOSERVER_SERVICE.COM                  V1.0                  *
$! *                                                                       *
$! *************************************************************************
$! *                                                                       *
$! *  Copyright 1976, 2009 Hewlett-Packard Development Company, L.P.      *
$! *                                                                       *
$! * Confidential computer software.  Valid license from HP and/or         *
$! * its subsidiaries required for possession, use, or copying.            *
$! *                                                                       *
$! * Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *
$! * Computer Software Documentation, and Technical Data for Commercial    *
$! * Items are licensed to the U.S. Government under vendor's standard     *
$! * commercial license.                                                   *
$! *                                                                       *
$! * Neither HP nor any of its subsidiaries shall be liable for technical  *
$! * or editorial errors or omissions contained herein.  The information   *
$! * in this document is provided "as is" without warranty of any kind and *
$! * is subject to change without notice.  The warranties for HP products  *
$! * are set forth in the express limited warranty statements accompanying *
$! * such products.  Nothing herein should be construed as constituting an *
$! * additional warranty.                                                  *
$! *                                                                       *
$! *************************************************************************
$!
$!
$!		D   E   S   C   R   I   P   T   I   O   N
$!
$! This command procedure will:
$!
$!	- Create a Bootable Infoserver service from OS distribution
$!	- Create an Infoserver service from Layered Products CD/DVD 
$!	- Create Online Documentation Infoserver Service from Documentation/ISO-9660 CD
$!	- Create a Bootable Infoserver service from Image Backup distribution or ISO fIle
$!	- Create a Layered Products Infoserver service from Image Backup distribution or ISO file
$!	- Create Online Documentation Infoserver Service from Physical Backup distribution or ISO file
$!	- Create Writeable Infoserver Service for Network Attached Storage (Password Protected)
$!	- Save current set of active Infoserver services in command file for execution on reboot
$!
$!
$!	Author: Eddie Orcutt
$!
$!-------------------------------------------------------------------------
$!
$ On CONTROL_Y Then Goto Def_Clean
$ Define/user Sys$output nl:
$ Product Show Product VMS /span_version=minimum=8.2-1
$ If .not. $status .or. $status .eq. %X0652A043
$ Then
$	Write Sys$output "Need VMS 8.2-1 Integrity or 8.3 Alpha for Infoserver Support"
$	Exit $status
$ Endif
$ Priv_Flag = 0
$ Req_Privs = "PHY_IO,SYSNAM,SYSPRV,CMKRNL,PRMMBX,LOG_IO,OPER,NETMBX,TMPMBX"
$ If f$Privilege(Req_Privs) .eqs. "FALSE"
$ Then
$      If f$Privilege("SETPRV") .eqs. "TRUE"
$      Then
$	    Priv_Flag = 1
$	    Current_Privs = F$Setprv(Req_Privs)
$      Else
$	    Exit 36				!Insufficient Privs Exit Code
$      Endif
$ Endif
$!
$ Save_Dir = F$Environment("DEFAULT")		!Save current Directory
$!
$Main_Menu:
$ Type/page NL:					! Clear screen
$ If F$GETDVI ("SYS$OUTPUT", "TT_DECCRT") .eqs. "TRUE"
$ Then
$ Type sys$input
   #3[1mInfoserver Software Library Setup[0m
   #4[1mInfoserver Software Library Setup[0m
$ Else
$	Type Sys$input  
       Infoserver Software Library Setup
$ Endif
$ Type Sys$input


1.     Create Online OS Distribution From CD/DVD
2.     Create Online Layered Product Distribution From CD/DVD
3.     Create Online Documentation Service from Documentation/ISO-9660 CD
4.     Create Online OS Distribution From Backup Saveset/ISO File
5.     Create Online Layered Product Distribution From Backup Saveset/ISO File
6.     Create Online Documentation Service from Backup Saveset/ISO File
7.     Create Writeable Infoserver Service for Network Attached Storage
8.     Save Current Set of Active Infoserver Services in Command File
9.     Help (Read First)
10.    Exit


$ read/prompt="Enter Selection [10]: "/end_of_file=Main_Menu sys$command selection
$ if selection .eqs. "1" then goto sel_1
$ if selection .eqs. "2" then goto sel_1
$ if selection .eqs. "3" then goto sel_1
$ if selection .eqs. "4" then goto sel_4
$ if selection .eqs. "5" then goto sel_4
$ if selection .eqs. "6" then goto sel_4
$ if selection .eqs. "7" then goto sel_7
$ if selection .eqs. "8" then goto sel_8
$ if selection .eqs. "9" then goto sel_9
$Def_Clean:
$ Set Default 'Save_Dir'					!Restore Default Directory
$ If Priv_Flag .eq. 1 Then Temp = F$Setprv(Current_Privs)	!Restore Previous Privs
$ exit 1							!Exit if No Selection Made
$!
$sel_1:
$!
$!
$!	--------------------------------------------------------------------------------
$!	Selection 1 - Create Online Distribution From CD/DVD Source
$!	Selection 2 - Create Online Layered Product Distribution From CD/DVD
$!	Selection 3 - Create Online Documentation Service from Documentation/ISO-9660 CD
$!	--------------------------------------------------------------------------------
$!
$ Gosub Check_LD_LAD
$!
$Retry_1:
$!
$ read/prompt="Enter Name of CD/DVD with Source Distribution: "/end_of_file=Main_Menu sys$command CD_DVD
$ If "''CD_DVD'" .eqs. "" then Goto Main_menu
$ If f$Locate(":",CD_DVD) .eq. f$Length(CD_DVD) Then CD_DVD = CD_DVD + ":"
$!
$ Extra = ""
$ If F$Getdvi("''CD_DVD'","EXISTS") .eqs. "TRUE" 
$  Then
$     If F$Getdvi("''CD_DVD'","MNT") .eqs. "FALSE" 
$     Then
$	    If Selection .eqs. "3" Then Extra = "/media=CDROM/Undefined=(STREAM:512)"
$	    Mount/over=id/noassist/nomess'Extra' 'CD_DVD'
$	    If .not. $Status
$	    Then
$		Write sys$output "Please insert media into drive"
$		Goto Retry_1
$	    Endif
$     Else
$	    Write sys$output "Device already mounted - Enter another device"
$    Goto Retry_1 
$     Endif
$ Else
$    Write sys$output "Device does not exists - Please re-enter"
$    Goto Retry_1 
$  Endif
$!
$Retry_11:
$ read/prompt="Enter device to hold target distribution - disk:[dir]: "/end_of_file=sel1_cleanup sys$command Disk_Target
$ If "''Disk_Target'" .eqs. "" then Goto Sel1_cleanup
$ LD_Device = F$Parse(Disk_Target,,,"DEVICE",)
$ LD_Directory = F$Parse(Disk_Target,,,,)
$ If LD_Device .eqs. "" .or. LD_Directory .eqs. ""
$ Then
$     Write Sys$output "Invalid device or directory name - Please re-enter:"
$     Goto  Retry_11
$ Endif
$!
$ Maxblocks = F$Getdvi("''CD_DVD'","MAXBLOCK")
$ Volume_Label = F$Getdvi("''CD_DVD'","VOLNAM")
$ If Selection .eqs. "3" 
$ Then 
$     Dism/nounload 'CD_DVD'
$     Mount/foreign/noassist/nomess 'CD_DVD'	!Need for Physical Backup
$ Endif
$!
$ Set Default 'Disk_Target'
$ Write sys$output "Creating ''Disk_Target'''Volume_Label'.dsk - This may take 8-15 minutes"
$ Ld Create 'Volume_Label'.dsk /size='Maxblocks'
$Retry_Create1:
$ Define/user sys$output nl:
$ Define/user sys$error nl:
$ Ld Connect/Share/Symbol 'Volume_Label'.dsk
$ If .not. $Status Then Goto Retry_Create1		!In case of Name Conflict on Another Cluster Node
$ Write Sys$output "Allocated device is lda''LD_Unit':"
$!
$ Init/Nohigh/Sys lda'LD_Unit': 'Volume_Label'
$ Mount/For/nomess lda'LD_Unit': 'Volume_Label'
$ Write sys$output "Restoring ''CD_DVD' to lda''LD_Unit': - This may take up to 45 minutes"
$ If Selection .eqs. "3"
$ Then
$     Backup/Physical 'CD_DVD' lda'LD_Unit':
$     Dism lda'LD_Unit':
$     Dism/nounload 'CD_DVD'
$     VS_Label = F$Extract(20,12,F$Unique())					!Temporary Unique Label
$     Mount/system/nowrite/nomess/Bind='VS_Label' lda'LD_Unit': 'Volume_Label'
$ Else
$     Backup/Image 'CD_DVD' lda'LD_Unit':
$     Dism lda'LD_Unit':
$     Dism/nounload 'CD_DVD'
$     Mount/system/nowrite/nomess lda'LD_Unit': 'Volume_Label'
$ Endif
$ Infoserver create service 'Volume_Label' lda'LD_Unit':
$!
$ If Selection .eqs. "2" .or. Selection .eqs. "3" Then Goto No_OS_Disk1
$!
$ Gosub OS_Disk
$!
$No_OS_Disk1:
$ Gosub Client_Input
$ Infoserver show service
$ Set Default 'Save_Dir'
$ read/prompt="Press Enter to Continue: "/end_of_file=Main_Menu sys$command Blank
$ Goto Main_Menu
$!
$sel1_cleanup:
$ Dism/nounload 'CD_DVD'
$ Goto Retry_1
$!
$!
$sel_4:
$!
$!
$!	-------------------------------------------------------------------------------------
$!	Selection 4 - Create Online OS Distribution From Backup Saveset/ISO file
$!	Selection 5 - Create Online Layered Product Distribution From Backup Saveset/ISO File
$!	Selection 6 - Create Online Documentation Service from Backup Saveset/ISO File
$!	-------------------------------------------------------------------------------------
$!
$ Gosub Check_LD_LAD
$!
$Retry_4:
$!
$ read/prompt="Enter name of OS backup saveset/ISO file - device:[dir]file.ext : "/end_of_file=Main_Menu sys$command B_Saveset
$ If "''B_Saveset'" .eqs. "" then Goto Main_menu
$ BS_Name = F$Search("''B_Saveset'")
$ If BS_Name .eqs. "" 
$ Then
$     Write Sys$output "Invalid File Specification - Please re-enter:"
$     Goto  Retry_4
$ Endif
$!
$ File_Type = F$Parse(B_Saveset,,,"TYPE",)
$ If File_Type .nes. ".BCK" .and. File_Type .nes. ".ISO"
$ Then
$     Write Sys$output "Invalid File Type - Please re-enter:"
$     Goto  Retry_4
$ Endif
$!
$ If File_Type .eqs. ".ISO" 
$ Then 
$Retry_Create2:
$     Define/user sys$output nl:
$     Define/user sys$error nl:
$     Ld Connect/Share/Symbol 'B_Saveset'
$     If .not. $Status Then Goto Retry_Create2			!In case of Name/Unit Conflict
$     Write Sys$output "Allocated device is lda''LD_Unit':"
$!
$     Mount/over=id/nomess lda'LD_Unit':
$     Volume_Label = F$Getdvi("lda''LD_Unit':","VOLNAM")
$     Dism lda'LD_Unit':
$     Goto ISO_Service4
$ Endif
$!
$Retry_41:
$ read/prompt="Enter device & directory to hold target distribution - disk:[dir]: "/end_of_file=Retry_4 sys$command Disk_Target
$ If "''Disk_Target'" .eqs. "" then Goto Retry_4
$ LD_Directory = F$Parse(Disk_Target,,,,)
$ If LD_Directory .eqs. ""
$ Then
$     Write Sys$output "Invalid Device or Directory Name - Please re-enter:
$     Goto  Retry_41
$ Endif
$!

$ Maxblocks = F$file_attributes(B_Saveset,"ALQ")	!Get Backup Saveset File Allocation Size
$ Temp_Volume_Label = "Temp_Label"
$!
$ Set Default 'Disk_Target'
$ Write sys$output "Creating ''Disk_Target'''Temp_Volume_Label'.dsk - This may take 8-15 minutes"
$ Ld Create 'Temp_Volume_Label'.dsk /size='Maxblocks'
$Retry_Create2_1:
$ Define/user sys$output nl:
$ Define/user sys$error nl:
$ Ld Connect/Share/Symbol 'Temp_Volume_Label'.dsk
$ If .not. $Status Then Goto Retry_Create2_1		!In case of Name Conflict on Another Cluster Node
$ Write Sys$output "Allocated device is lda''LD_Unit':"
$!
$ Init/Nohigh/Sys lda'LD_Unit': 'Temp_Volume_Label'
$ Mount/For/nomess lda'LD_Unit': 'Temp_Volume_Label'
$ Write sys$output "Restoring ''B_Saveset' to lda''LD_Unit': - This may take up to 45 minutes"
$ If Selection .eqs. "6"
$ Then
$     Define/user sys$output nl:
$     Define/user sys$error nl:
$     Backup/Physical 'B_Saveset'/save lda'LD_Unit':
$ Else
$     Backup/Image 'B_Saveset'/save lda'LD_Unit':
$ Endif
$ Dism lda'LD_Unit':
$ Mount/over=id/nomess lda'LD_Unit':
$ Volume_Label = F$Getdvi("lda''LD_Unit':","VOLNAM")
$ Dism lda'LD_Unit':
$ Ld Disconnect lda'LD_Unit': 
$ Rename 'Temp_Volume_Label'.dsk 'Volume_Label'.dsk
$Retry_Create2_2:
$ Define/user sys$output nl:
$ Define/user sys$error nl:
$ Ld Connect/Share/Symbol 'Volume_Label'.dsk 
$ If .not. $Status Then Goto Retry_Create2_2		!In case of Name Conflict on Another Cluster Node
$ Write Sys$output "Allocated device is lda''LD_Unit':"
$!
$ISO_Service4:
$ If Selection .eqs. "6"
$ Then
$     VS_Label = F$Extract(20,12,F$Unique())					!Temporary Unique Label
$     Mount/system/nowrite/nomess/Bind='VS_Label' lda'LD_Unit': 'Volume_Label'
$ Else
$     Mount/system/nowrite/nomess lda'LD_Unit': 'Volume_Label'
$ Endif
$ Infoserver create service 'Volume_Label' lda'LD_Unit':
$!
$ If Selection .eqs. "5" .or. Selection .eqs. "6" then Goto No_OS_Disk4
$!
$ Gosub OS_Disk
$!
$No_OS_Disk4:
$ Gosub Client_Input
$ Infoserver show service
$ Set Default 'Save_Dir'
$ read/prompt="Press Enter to Continue: "/end_of_file=Main_Menu sys$command Blank
$ Goto Main_Menu
$!
$!
$sel_7:
$!
$!
$!	----------------------------------------------------------------------
$!	Selection 7 - Create Writeable Infoserver Service for Network Attached
$!			  Storage (Password Protected)
$!	----------------------------------------------------------------------
$!
$ Gosub Check_LD_LAD
$!
$Retry_7:
$ read/prompt="Enter device & directory to hold Network Attached Storage logical disk - disk:[dir]: "/end_of_file=Main_Menu sys$command Disk_Target
$ If "''Disk_Target'" .eqs. "" then Goto Main_Menu
$ LD_Directory = F$Parse(Disk_Target,,,,)
$ If LD_Directory .eqs. ""
$ Then
$     Write Sys$output "Invalid Device or Directory Name - Please re-enter:
$     Goto  Retry_7
$ Endif
$Retry_71:
$ read/prompt="Enter size of logical disk - [in Blocks - min=6005000]: "/end_of_file=Retry_7 sys$command Maxblocks
$ If "''Maxblocks'" .eqs. "" then Goto Retry_7
$ If maxblocks .lt. 6005000
$ Then
$     Write Sys$output "Logical Disk Size Too Small - Please re-enter:
$     Goto  Retry_71
$ Endif
$Retry_72:
$ read/prompt="Enter Infoserver Service Name for Network Attahced Storage: "/end_of_file=Retry_71 sys$command NAS_Name
$ If "''NAS_Name'" .eqs. "" then Goto Retry_71
$ If F$Length(NAS_Name) .gt. 12	
$ Then
$      Write sys$Output "Please Limit Name to 12 Characters - Please re-enter: "
$      Goto Retry_72
$ Endif
$Retry_73:
$ read/prompt="Enter password for Infoserver Service: "/end_of_file=Retry_72 sys$command NAS_Password
$ If "''NAS_Password'" .eqs. "" then Goto Retry_72
$ If F$Length(NAS_Password) .gt. 39	
$ Then
$      Write sys$Output "Please Limit password to 12 Characters - Please re-enter: "
$      Goto Retry_73
$ Endif
$!
$ Set Default 'Disk_Target'
$ Write sys$output "Creating ''Disk_Target'''NAS_Name'.dsk - This may take 10-20 minutes"
$ Ld Create 'NAS_Name'.dsk /size='Maxblocks'
$Retry_Create7:
$ Define/user sys$output nl:
$ Define/user sys$error nl:
$ Ld Connect/Share/Symbol 'NAS_Name'.dsk
$ If .not. $Status Then Goto Retry_Create7		!In case of Name Conflict on Another Cluster Node
$ Write Sys$output "Allocated device is lda''LD_Unit':"
$!
$ Init/Nohigh/Sys lda'LD_Unit': 'NAS_Name'
$ Mount/For/nomess/system lda'LD_Unit': 'NAS_Name'
$ Infoserver create service/Writers/password='NAS_Password' 'NAS_Name' lda'LD_Unit':
$ Type Sys$input

To mount this service on a client node please type in the following commands:

$ Write Sys$output "$ @sys$startup:ess$startup client	<-- One time only - Typically system startup"
$ Write Sys$output "$ ladcp:==mcr ess$ladcp"
$ Write Sys$output "$ ladcp bind/connect/system/write/password=''NAS_Password' ''NAS_Name'"
$ Write Sys$output "$ mount/system DAD$''NAS_Name' ''NAS_Name'
$ Write Sys$Output " "
$ Write Sys$Output "Or if you intend to perform a Backup/Image to this device then type:"
$ Write Sys$Output " "
$ Write Sys$output "$ mount/system/foreign DAD$''NAS_Name' ''NAS_Name'
$ Write Sys$Output " "
$ read/prompt="Press Enter to Continue: "/end_of_file=Main_Menu sys$command Blank
$ Infoserver show service
$ Set Default 'Save_Dir'
$ read/prompt="Press Enter to Continue: "/end_of_file=Main_Menu sys$command Blank
$ Goto Main_Menu
$!
$!
$sel_8:
$!
$!
$!	-----------------------------------------------------------------
$!	Selection 8 - Save Current Set of Active Services in Command File
$!	-----------------------------------------------------------------
$!
$ Gosub Check_LD_LAD
$!
$Retry_8:
$ read/prompt="Enter Name of Save Command File - device:[dir]file.ext : "/end_of_file=Main_Menu sys$command B_Save
$ If "''B_Save'" .eqs. "" then Goto W_Default
$ B_Device = F$Parse(B_Save,,,"DEVICE",)
$ B_Directory = F$Parse(B_Save,,,,)
$ If B_Device .eqs. "" .or. B_Directory .eqs. ""
$ Then
$     Write Sys$output "Invalid Device or Directory Name - Please re-enter:"
$     Goto  Retry_8
$ Endif
$W_Default:
$ Infoserver save 'B_Save'
$ If B_Save .eqs. "" then B_Save = "ess$lad_services.com"
$ Write sys$output "Please add command @''B_Save' to sys$manager:systartup_vms.com"
$ read/prompt="Press Enter to Continue: "/end_of_file=Main_Menu sys$command Blank
$ Goto Main_Menu
$!
$!
$sel_9:
$!
$!
$!	------------------------------------------------
$!	Selection 9 - Help - Why, How to, Pre-requisites
$!	------------------------------------------------
$!
$ type/page NL:				! Clear screen
$ Type sys$input

Run this procedure only on the node to be used for the Infoserver Library Server

Pre-requisites:

1.  For Itanium Node boot support, you Must enable BOOTP by using the 
    sys$manager:tcpip$config.com command procedure (Selection 3 - Server 
    Components) before selecting item 1 or 4 in the main menu.  This is a
    one time setup (on an Itanium or Alpha node only).

2.  Execute the command procedure sys$startup:ld$startup.com to start the LD
    disk driver.  If not, this command procedure will execute it for you.
    Also call this command procedure in the system startup file
    sys$manager:systartup_vms.com to restart LD driver across reboots.

3.  Execute the command procedure sys$startup:ess$lad_startup.com to start the
    LASTDRIVER and LASTport/Disk server.  If not, this command procedure will 
    execute it for you.  Also call this command procedure in the system 
    startup file sys$manager:systartup_vms.com to restart LASTDRIVER and 
    LASTport/Disk server across reboots.

$ read/prompt="Press Enter to Continue (CTRL/Z for Main Menu): "/end_of_file=Main_Menu sys$command Blank
$ type/page NL:				! Clear screen
$ Type sys$input

This procedure automates the task of creating Infoserver services that are 
served to the LAN.  Each service is created on its own logical disk which 
allows for appropriate services to be bootable from the network.  Services 
are named according to the label on the source CD/DVD distribution or the 
label in the backup saveset/ISO file.  


NOTE:  Do not place Infoserver services (created on LD devices) on a 
       production or OS disk as the LD utility locks the disk the LD
       device is being created on. The duration of LD device creation
       can be up to 15 minutes.


If using a backup saveset as the source OS or layered product volume, 
the backup saveset must have been created as an IMAGE backup 
(Backup/Image command).

If using a backup saveset as the source ISO9660 documentation volume, 
the backup saveset must have been created as an PHYSICAL backup 
(Backup/Physical command).

$ read/prompt="Press Enter to Continue (CTRL/Z for Main Menu): "/end_of_file=Main_Menu sys$command Blank
$ type/page NL:				! Clear screen
$ Type sys$input

This command procedure can only be run on Alpha systems with VMS 8.3
or later or Itanium systems with VMS 8.2-1 or later.

For an OS bootable service, this procedure also copies from the source 
distribution the platform specific boot file(s) to the correct directory.

VAX -		ISL_SVAX_"OS_Version".sys copied to Mom$System:
		ISL_LVAX_"OS_Version".sys copied to Mom$System:

Alpha - 	Apb_"OS_Version".sys copied to Mom$System:

Integrity - 	Ipb.exe copied to tcpip$tftp_root:["OS_Version"]
		VMS_Loader.efi copied to tcpip$tftp_root:["OS_Version"]

Where "OS_Version" is the version of the OS you are loading.



$ read/prompt="Press Enter to Continue (CTRL/Z for Main Menu): "/end_of_file=Main_Menu sys$command Blank
$ type/page NL:				! Clear screen
$ Type sys$input

Selection 1: Creates an OS bootable Infoserver service from OS CD/DVD source 
             media.  Inputs: CD/DVD name (e.g. $1$DQA0:) and the target
             device and directory to hold the logical disk (e.g. 
             $1$DGA20:[VMS_Software]).  Infoserver service name will be the
             same as the CD/DVD disk label (e.g. I640831).  Boot files are 
             also copied to the appropriate directory.   You must enable BOOTP
             support in the Sys$Manager:Tcpip$Config.com command procedure 
             (Selection 3 - Server Components) to complete this selection for
             an Itanium OS CD/DVD source.

Selection 2: Creates a non-bootable layered product Infoserver service 
             from layered products CD/DVD source media.  Inputs: CD/DVD name
             (e.g. $1$DQA0:) and the target device and directory to hold the
             logical disk (e.g.. $1$DGA20:[VMS_Software]).  Infoserver service 
             name will be the same as the CD/DVD disk label (e.g. AXPBINSEP071)

Selection 3: Creates a non-bootable documentation Infoserver service 
             from ISO-9660 CD/DVD documentation source media.  Inputs: CD/DVD 
             name (e.g. $1$DQA0:) and the target device and directory to hold 
             the logical disk (e.g. $1$DGA20:[VMS_Software]).  Infoserver 
             service name will be the same as the CD/DVD disk label 
            (e.g. AXPDOCSEP071). 

$ read/prompt="Press Enter to Continue (CTRL/Z for Main Menu): "/end_of_file=Main_Menu sys$command Blank
$ type/page NL:				! Clear screen
$ Type sys$input

Selection 4: Creates an OS bootable Infoserver service from OS backup saveset
             or ISO file source media.  Inputs: backup saveset or ISO file name
             (e.g. $1$DGA20:[SW]I640831.bck or $1$DGA20:[SW]i640831.iso) and 
             the target device and directory to hold the logical disk (e.g. 
             $1$DGA20:[VMS_Software]).  Infoserver service name will be the
             same as the backup saveset/ISO file label (e.g. I640831).  Backup
             saveset must have been created with the Backup/Image command.
             Boot files are also copied to the appropriate directory. You must
             enable BOOTP support in the Sys$Manager:Tcpip$Config.com command 
             procedure (Selection 3 - Server Components) to complete this 
             selection for an Itanium OS backup saveset/ISO file source.

Selection 5: Creates a non-bootable layered product Infoserver service 
             from layered products backup saveset or ISO file source media.  
             Inputs: backup saveset or ISO file name (e.g. $1$DGA20:
             [SW]AXPBINSEP071.bck or $1$DGA20:[SW]AXPBINSEP071.iso) and the
             target device and directory to hold the logical disk (e.g. 
             $1$DGA20:[VMS_Software]).  Infoserver service name will be the 
             same as the backup saveset/ISO file label (e.g. AXPBINSEP071)


$ read/prompt="Press Enter to Continue (CTRL/Z for Main Menu): "/end_of_file=Main_Menu sys$command Blank
$ type/page NL:				! Clear screen
$ Type sys$input

Selection 6: Creates a non-bootable documentation Infoserver service 
             from backup saveset or ISO file documentation source media.  
             Inputs: backup saveset or ISO file name (e.g. $1$DGA20:
             [SW]ARCHIVE_DVD1.bck or $1$DGA20:[SW]ARCHIVE_DVD1.iso) and the 
             target device and directory to hold the logical disk (e.g. 
             $1$DGA20:[VMS_Software]).  Infoserver service name will be the 
             same as the backup saveset/ISO file label (e.g. AXPDOCSEP071)

Selection 7: Creates a read/write Infoserver service that provides network 
             disk (Network Attached Storage) or NAS disk functionality. This
             NAS disk can be used for general user storage or for system
             backups across the network.  This NAS disk is password protected.
             Inputs: target device and directory to hold the logical disk (e.g. 
             $1$DGA20:[NET_BACKUPS]), Infoserver service name (12 characters 
             max - e.g. MYBACKUP), logical disk size (in blocks - min 6005000
             e.g. 8000000), Infoserver service password (39 character max - 
             e.g. MYPASSWORD).

Selection 8: Saves the current set of Infoserver commands that created current
             set of Infoserver services as a command file.  This command file
             can be placed in the sys$manager:systartup_vms.com file to
             automatically recreate the Infoserver services on reboot. 

$ read/prompt="Press Enter to Continue (CTRL/Z for Main Menu): "/end_of_file=Main_Menu sys$command Blank
$ Goto Main_Menu
$!
$!
$!	----------------------------------
$!	Subroutine OS_Disk Copy boot files
$!	----------------------------------
$!
$OS_Disk:
$!
$ If f$Locate("VAXVMS",Volume_Label) .ne. f$Length(Volume_Label) 
$ Then
$     VL_Length = F$Length(Volume_Label)
$     OS_Length = VL_Length - 6
$     OS_Version = F$Extract(6,'OS_Length',Volume_Label)
$     Copy lda'LD_Unit':[sys0.sysexe]ISL_SVAX_'OS_Version'.sys LAN$DLL:         !Defaults to MOM$SYSTEM
$     Copy lda'LD_Unit':[sys0.sysexe]ISL_LVAX_'OS_Version'.sys LAN$DLL:
$!
$     Type/page NL:
$     Type Sys$input
If you have not already done so, you must register each VAX client needing MOP
boot support in the NCP or LANCP database using one of the following commands:

NCP:

$     Write Sys$output "Set node Name load file ISL_SVAX_''OS_Version'.sys hardware address xx-xx-xx-xx-xx-xx"
$     Write Sys$output "Define node Name load file  ISL_SVAX_''OS_Version'.sys hardware address xx-xx-xx-xx-xx-xx"
$     Write Sys$output "OR"
$     Write Sys$output "Set node Name load file ISL_LVAX_''OS_Version'.sys hardware address xx-xx-xx-xx-xx-xx"
$     Write Sys$output "Define node Name load file ISL_LVAX_''OS_Version'.sys hardware address xx-xx-xx-xx-xx-xx"
$     Type Sys$input

LANCP: 

Set device EIA0/DLL=Enable	<-- Where EIA0 is your boot server LAN device
Define device EIA0/DLL=Enable 	<-- Where EIA0 is your boot server LAN device
$     Write Sys$output "Set node Name/address=xx-xx-xx-xx-xx-xx/file=ISL_SVAX_''OS_Version'.sys"
$     Write Sys$output "Define node Name/address=xx-xx-xx-xx-xx-xx/file=ISL_SVAX_''OS_Version'.sys"
$     Write Sys$output "OR"
$     Write Sys$output "Set node Name/address=xx-xx-xx-xx-xx-xx/file=ISL_LVAX_''OS_Version'.sys"
$     Write Sys$output "Define node Name/address=xx-xx-xx-xx-xx-xx/file=ISL_LVAX_''OS_Version'.sys"
$     Type Sys$input

Where: Name is the SCSNODE name of your VAX client 
       xx-xx-xx-xx-xx-xx is the MAC address of your VAX client

$ Endif 
$ If f$Locate("ALPHA",Volume_Label) .ne. f$Length(Volume_Label) 
$ Then
$     VL_Length = F$Length(Volume_Label)
$     OS_Length = VL_Length - 5
$     OS_Version = F$Extract(5,'OS_Length',Volume_Label)
$     Copy lda'LD_Unit':[sys0.sysexe]Apb_'OS_Version'.sys LAN$DLL:         	!Defaults to MOM$SYSTEM
$     Type/page NL:
$     Type Sys$input
If you have not already done so, you must register each Alpha client needing 
MOP boot support in the NCP or LANCP database using one of the following 
commands:

NCP:

$     Write Sys$output "Set node Name load file Apb_''OS_Version'.sys hardware address xx-xx-xx-xx-xx-xx"
$     Write Sys$output "Define node Name load file Apb_''OS_Version'.sys hardware address xx-xx-xx-xx-xx-xx"
$     Type Sys$input

LANCP: 

Set device EIA0/DLL=Enable	<-- Where EIA0 is your boot server LAN device
Define device EIA0/DLL=Enable 	<-- Where EIA0 is your boot server LAN device
$     Write Sys$output "Set node Name/address=xx-xx-xx-xx-xx-xx/file=Apb_''OS_Version'.sys"
$     Write Sys$output "Define node Name/address=xx-xx-xx-xx-xx-xx/file=Apb_''OS_Version'.sys"
$     Type Sys$input

Where: Name is the SCSNODE name of the Alpha client 
       xx-xx-xx-xx-xx-xx is the MAC address of the Alpha client

$ Endif 
$ If f$Locate("I64",Volume_Label) .ne. f$Length(Volume_Label) 
$ Then
$Retry_12:
$     If F$TRNLNM("TCPIP$TFTP_ROOT","LNM$SYSTEM",,"SUPERVISOR","CASE_BLIND",) .EQS. "" 
$	Then
$	     Type sys$input

    You must enable BOOTP support in the Sys$Manager:Tcpip$Config.com
    command procedure (Selection 3 - Server Components) before continuing.


$	     read/prompt="Press Enter When Ready to Continue: "/end_of_file=Main_Menu sys$command Blank
$	     Goto Retry_12
$	Endif
$     Tftp_Dir = "tcpip$tftp_root:[''Volume_Label']"
$     If F$Parse(Tftp_Dir,,,,) .eqs. "" Then Create/dir tcpip$tftp_root:['Volume_Label']
$     Copy lda'LD_Unit':[Vms$common.sysexe]Ipb.exe tcpip$tftp_root:['Volume_Label']
$     Copy lda'LD_Unit':[Vms$common.sysexe]VMS_Loader.efi tcpip$tftp_root:['Volume_Label']
$     Type/page NL:
$     Type Sys$input
If you have not already done so, you must register each Integrity client (non 
cell based clients - cell based clients can use the EFI dbprofile command) 
needing BOOTP boot support in the BOOTP database using the following commands:

BOOTP:

$     Write Sys$output "Tcpip set host Name/address=yyy.yyy.yyy.yyy"
$     Write Sys$output "Tcpip set Bootp Name/Hardware=Address=xx-xx-xx-xx-xx-xx/file=[''Volume_Label']VMS_Loader.efi"
$     Type Sys$input

Where: Name is the TCPIP host name of your Integrity client
       yyy.yyy.yyy.yyy is the TCPIP address of your Integrity client
       xx-xx-xx-xx-xx-xx is the MAC address of your Integrity client

$ Endif
$ read/prompt="Press Enter to Continue: "/end_of_file=Main_Menu sys$command Blank
$ Return
$!
$!
$!
$!	------------------------------------------------------------
$!	Subroutine Client Input - Commands Entered on Client System
$!	                          to mount service on remote node
$!	------------------------------------------------------------
$!
$Client_Input:
$!
$ Type Sys$input

To mount this service on a client node please type in the following commands:

$ Write Sys$output "$ @sys$startup:ess$startup client	<-- One time only - Typically system startup"
$ Write Sys$output "$ ladcp:==mcr ess$ladcp"
$ Write Sys$output "$ ladcp bind/connect/system ''Volume_Label'"
$ Write Sys$output "$ mount/nowrite/system DAD$''Volume_Label' ''Volume_Label'"
$ Write Sys$Output " "
$ read/prompt="Press Enter to Continue: "/end_of_file=Main_Menu sys$command Blank
$ Write Sys$Output " "
$ Return
$!
$!
$!	----------------------------------------------------------------
$!	Subroutine Check LD & LAD - Check if prerequisite software 
$!				    LD Disk Driver & Infoserver Service
$!				    is started
$!	---------------------------------------------------------------
$!
$Check_LD_LAD:
$!
$ if .not. f$file_attributes("sys$system:ld$utility.exe","known") then @sys$startup:Ld$Startup.com			!Start LD Disk Driver
$ if .not. f$getdvi("lad:","exists") then @sys$startup:ess$lad_startup.com	!Start Infoserver service
$ Infoserver := mcr ess$infoserver						!Interactive commands
$!
$ Return
