/**/
/***************************************************************************/
/**                                                                       **/
/**  Copyright 2010, Hewlett-Packard Development Company, L.P.           **/
/**                                                                       **/
/** Confidential computer software.  Valid license from HP and/or         **/
/** its subsidiaries required for possession, use, or copying.            **/
/**                                                                       **/
/** Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  **/
/** Computer Software Documentation, and Technical Data for Commercial    **/
/** Items are licensed to the U.S. Government under vendor's standard     **/
/** commercial license.                                                   **/
/**                                                                       **/
/** Neither HP nor any of its subsidiaries shall be liable for technical  **/
/** or editorial errors or omissions contained herein.  The information   **/
/** in this document is provided "as is" without warranty of any kind and **/
/** is subject to change without notice.  The warranties for HP products  **/
/** are set forth in the express limited warranty statements accompanying **/
/** such products.  Nothing herein should be construed as constituting an **/
/** additional warranty.                                                  **/
/**                                                                       **/
/***************************************************************************/
/********************************************************************************************************************************/
/* Created: 30-Mar-2010 17:25:46 by OpenVMS SDL EV3-3      */
/* Source:  20-OCT-2009 09:48:38 $1$DGA7274:[BACKUP.SRC]BACKSTRUC.SDL;1 */
/********************************************************************************************************************************/
/*** MODULE $BCKCOMMON ***/
#pragma __member_alignment __save
#pragma __nomember_alignment
#define BACKUP$VERSION "V8.4"           /* Version number of BACKUP         */
#define BACKUP$K_OPSYS_VAX 1024         /* Operating system ID              */
#define BACKUP$K_OPSYS_ALPHA 2048       /* Operating system ID              */
#define BACKUP$K_OPSYS_IA64 4096        /* Operating system ID              */
#define BACKUP$K_BACKUP 1               /* Subsystem ID                     */
#define BACKUP$K_DATABLOCK 1            /* Application ID normal blocks     */
#define BACKUP$K_XORBLOCK 2             /* Application ID XOR blocks        */
#define FILESCAN_LOGGING 1              /* Turn on (1) or off (0) internal  */
#define TRUE 1
#define FALSE 0
#define ANSI_LBLSZ 6                    /* ANSI Standard MT label name size */
#define ANSI_BLKSZ 80                   /* ANSI Standard header size        */
#define COPY_BUFF_COUNT 2               /* Default buffer count for disk-to-disk */
#define COPY_BUFF_SIZE 33040            /* Default buffer size for disk-to-disk */
#define SMALL_DISK 4096                 /* Largest disk with no bad block data */
#define LIST_SIZE 4096                  /* Size of listing line             */
#define JOUR_SIZE 4096                  /* Size of journal line             */
#define MAX_RECORD 2048                 /* Maximum length attribute record  */
#define MAX_ATTRS 20                    /* Maximum number of attributes in list */
#define STA_IN_CHAN 131071              /* Pseudo-channel for input         */
#define STA_OUT_CHAN 196607             /* Pseudo-channel for output        */
#define MAX_DCL_STRING_SIZE 1024        /* Max DCL command string size      */
#define STD_PAGE_SIZE 512               /* Standard [VAX] page size (bytes) */
#define MIN_BUFFER_SPACE 6144           /* Minimum reasonable buffer size   */
#define NEXT_TRY_BUFF_FACTOR 2          /* multiply factor for new buffer size */
#define D_K_SCANLVLS 8                  /* ODS-1 directory levels supported */
#define MAX_CTRL_STRING_SIZE 256        /* Max. FAO control string size     */
#define PFL_M_DIR 0x1
#define PFL_M_DESELECT 0x2
#define PFL_M_OPEN 0x4
#define PFL_M_IGNO_INTE 0x8
#define PFL_M_ERROR 0x10
#define PFL_M_HEADONLY 0x20
#define PFL_M_NOPOST 0x40
#define PFL_M_SAVE_ALL 0x80
#define PFL_M_F64DIR 0x100
#define PFL_M_ALIAS 0x200
#define PFL_K_LENGTH 80                 /* length of PFL block              */
#define PFL_C_LENGTH 80                 /* length of PFL block              */
struct PFL {
    char *PFL_A_RESNAME_PTR;            /* Resultant name pointer           */
    char *PFL_A_DIRNAME_PTR;            /* Directory name pointer           */
    char *PFL_A_CVT_RESNAME_PTR;        /* Conversion resultant name pointer */
    char *PFL_A_CVT_DIRNAME_PTR;        /* Conversion directory name pointer */
    char *PFL_A_CVT_DIRDATA_PTR;        /* Conversion directory data pointer */
/**** Note: Old overlay form must be used in FID & DID due to SDL bug       */
/**** that omits the field size symbol in a structured field.               */
    union  {                            /* File ID overlay.                 */
        unsigned short int PFL_W_FID [3]; /* File's FID.                    */
        struct  {
            unsigned short int PFL_W_FID_NUM; /* File ID NUM.               */
            unsigned short int PFL_W_FID_SEQ; /* File ID SEQ.               */
            union  {                    /* File RVN overlay.                */
                unsigned short int PFL_W_FID_RVNW; /* File ID RVN & NMX.    */
                struct  {               /* File ID RVN.                     */
                    unsigned char PFL_B_FID_RVN; /* FID RVN.                */
                    unsigned char PFL_B_FID_NMX; /* FID NMX.                */
                    } PFL_R_FID_RVN_FIELDS;
                } PFL_R_FID_RVN_OVERLAY;
            } PFL_R_FID_FIELDS;
        } PFL_R_FID_OVERLAY;
    union  {
        unsigned short int PFL_W_DID [3]; /* Directory ID.                  */
        struct  {
            unsigned short int PFL_W_DID_NUM; /* File ID of directory.      */
            unsigned short int PFL_W_DID_SEQ; /* DID sequence number.       */
            union  {
                unsigned short int PFL_W_DID_RVNW; /* RVN.                  */
                struct  {
                    unsigned char PFL_B_DID_RVN; /* RVN byte.               */
                    unsigned char PFL_B_DID_NMX; /* NMX for DID.            */
                    } PFL_R_DID_RVN_FIELDS;
                } PFL_R_DID_RVN_OVERLAY;
            } PFL_R_DID_FIELDS;
        } PFL_R_DID_OVERLAY;
    unsigned short int PFL_W_RESNAME_LEN; /* Resultant name length          */
    unsigned short int PFL_W_DIRNAME_LEN; /* Directory name length          */
    unsigned short int PFL_W_CVT_RESNAME_LEN; /* Conversion resultant name length */
    unsigned short int PFL_W_CVT_DIRNAME_LEN; /* Conversion directory name length */
    unsigned int PFL_L_CVT_DIRDATA_LEN; /* Conversion directory data length */
    unsigned int PFL_L_CHANNEL;         /* Channel for access to file.      */
    unsigned int PFL_L_FILESIZE;        /* Size of this file.               */
    unsigned short int PFL_W_REVISION;  /* FI2$W_REVCNT (for access conflict check) */
    unsigned short int PFL_W_S_DATA;
    unsigned int PFL_L_D_UIC;           /* Directory UIC.                   */
    unsigned short int PFL_W_D_FPRO;    /* Directory file protection.       */
    unsigned short int PFL_W_D_VERLIM;  /* Directory version limit.         */
    unsigned int PFL_L_DIR_STATUS;      /* Copy of DIR_STATUS at time of scan. */
    union  {
        unsigned int PFL_L_FLAGS;       /* PFL flags.                       */
        struct  {
            unsigned PFL_V_DIR : 1;     /* True for directories.            */
            unsigned PFL_V_DESELECT : 1; /* File removed from selection.    */
            unsigned PFL_V_OPEN : 1;    /* Set if file is open.             */
            unsigned PFL_V_IGNO_INTE : 1; /* Set if we are to ignore conflicts. */
            unsigned PFL_V_ERROR : 1;   /* Set if there was a read error for the file. */
            unsigned PFL_V_HEADONLY : 1; /* Set if the file's data isn't to be copied. */
            unsigned PFL_V_NOPOST : 1;  /* Set if error occurred, do not post-process this file. */
            unsigned PFL_V_SAVE_ALL : 1; /* Set if [INCR] saving new/renamed dir's files. */
            unsigned PFL_V_F64DIR : 1;  /* Set if file is a Files-64 directory */
            unsigned PFL_V_ALIAS : 1;   /* Set if file is an ALIAS file entry. */
            unsigned PFL_V_FILL_2_ : 6;
            } PFL_R_FILL_1_;
        } PFL_R_FILL_0_;
    int *PFL_A_CHKPT_BUF;               /* Pointer to checkpoint data       */
    struct dsc$descriptor *PFL_A_ALT_FILENAME; /* Ptr to alternate filename */
    } ;
#define DIRSTAT_M_VALID 0x1
#define DIRSTAT_M_DIR_SEL 0x2
#define DIRSTAT_M_SCANNED 0x4
#define DIRSTAT_M_FILE_SEL 0x8
struct PFLDIRSTAT {
    unsigned DIRSTAT_V_VALID : 1;       /* DIR_STATUS is valid              */
    unsigned DIRSTAT_V_DIR_SEL : 1;     /* Directory is selected            */
    unsigned DIRSTAT_V_SCANNED : 1;     /* Directory was scanned            */
    unsigned DIRSTAT_V_FILE_SEL : 1;    /* Files in directory are selected  */
    unsigned DIRSTAT_V_FILL_3_ : 4;
    } ;
#define VVM_M_EOF 0x1
#define VVM_M_EOB 0x2
#define VVM_M_ERROR 0x4
#define VVM_M_COMPLETE 0x8
#define VVM_M_ISSUED 0x10
#define VVM_M_F64DIR 0x20
#define VVM_K_LENGTH 40                 /* length of VVM block              */
#define VVM_C_LENGTH 40                 /* length of VVM block              */
struct VVM {
    struct VVM *VVM_A_VBN_FLINK;        /* Pointer to next VVM, VBN order.  */
    struct VVM *VVM_A_LBN_FLINK;        /* Pointer to next VVM, LBN order.  */
    unsigned int VVM_L_START_LBN;       /* Starting LBN for read.           */
    unsigned int VVM_L_START_VBN;       /* Starting VBN for this extent/read. */
    int *VVM_A_VA;                      /* Destination VA of read.          */
    struct PFL *VVM_A_PFL_PTR;          /* Pointer back to PFL for file data. */
    union  {                            /* IOSB accessible as address or long. */
        unsigned int VVM_L_IOSB [2];
        struct  {
            unsigned int VVM_L_IOSB1;
            unsigned int VVM_L_IOSB2;
            } VVM_R_IOSB_FIELDS;
        } VVM_R_IOSB_OVERLAY;
    unsigned int VVM_L_READ_SIZE;       /* Size of this read.               */
    union  {
        unsigned int VVM_L_FLAGS;       /* Flags for the read status.       */
        struct  {
            unsigned VVM_V_EOF : 1;     /* Set if this is the last read for the file. */
            unsigned VVM_V_EOB : 1;     /* Set if this read ends a buffer.  */
            unsigned VVM_V_ERROR : 1;   /* Set if the read incurred an error. */
            unsigned VVM_V_COMPLETE : 1; /* Set if the QIO completed.       */
            unsigned VVM_V_ISSUED : 1;  /* Set when the QIO is issued.      */
            unsigned VVM_V_F64DIR : 1;  /* Set if file is a Files-64 directory */
            unsigned VVM_V_FILL_6_ : 2;
            } VVM_R_FILL_5_;
        } VVM_R_FILL_4_;
    } ;
#define CPD_K_LENGTH 68                 /* length of CPD block              */
#define CPD_C_LENGTH 68                 /* length of CPD block              */
struct CPD {
    struct CPD *CPD_A_FLINK;            /* Pointer to next CPD buffer.      */
    struct CPD *CPD_A_BLINK;            /* Pointer to last CPD buffer.      */
    unsigned int CPD_L_INPUT_CHAN;      /* Current input channel            */
    int *CPD_A_PROC_LIST;               /* Ptr to INPUT_PROC_LIST           */
    unsigned int CPD_L_DIR_SCANLIMIT [8]; /* Directory queue context        */
    int *CPD_A_INPUT_QUAL;              /* Pointer to input qualifier list  */
    unsigned int CPD_L_FASTBUF_SIZE;    /* Fast buffer size                 */
    unsigned short int CPD_W_COM_FLAGS; /* Current common flags             */
    unsigned short int CPD_W_INPUT_FLAGS; /* Current input file flags       */
    unsigned char CPD_B_FAST_STRUCLEV;  /* Structure level for fast backup  */
    unsigned char CPD_B_FAST_RVN;       /* Current RVN                      */
    unsigned char CPD_B_SETCOUNT;       /* Number of volumes in set         */
    unsigned char CPD_B_LOST_RVN;       /* Current RVN of lost file processing */
    unsigned int CPD_L_LOST_FILENUM;    /* File number of lost file processing */
    } ;
#define FC_S_AREA 8836
struct BCK$FC {
    unsigned char FC_FAB [80];
    unsigned char FC_RAB [68];
    unsigned char FC_NAML [248];
    unsigned char FC_RLF [248];
    unsigned char FC_EXPNAME [4096];
    unsigned char FC_RESNAME [4096];
    } ;
/*                                                                          */
/*  Qualifier Parameter Value Block                                         */
/*                                                                          */
#define QUAL_S_OUTP 52                  /* Output Parameter Block size      */
#define QUAL_S_INPU 68                  /* Input Parameter Block size       */
struct QUALPVB {
    struct QUALPVB *QUAL_NEXT;          /* Pointer to next parameter block (common to all) */
    struct BCK$FC *QUAL_PARA_FC;        /* Parameter file context           */
    struct dsc$descriptor QUAL_EXP_DESC; /* Descriptor for expanded string  */
    struct dsc$descriptor QUAL_DEV_DESC; /* Descriptor for device portion only */
    struct dsc$descriptor QUAL_DVI_DESC; /* Descriptor for NAML$T_DVI string */
    struct dsc$descriptor QUAL_LNM_DESC; /* Descriptor for volume logical name */
    struct dsc$descriptor QUAL_ALT_DESC; /* Descriptor for alternate name   */
/* ( the rename for the file )                                              */
    unsigned int QUAL_ALLOC_CHAN;       /* Device allocation channel        */
    unsigned int QUAL_DEVCHAR2;         /* Second longword for device char  */
    unsigned int QUAL_USE_COUNT;        /* Count of input files from this spec */
    unsigned int QUAL_USE_CHKPT;        /* Cell to checkpoint QUAL_USE_COUNT */
    unsigned QUAL_PAR_FLAGS : 32;       /* Input/Output Parameter Flags     */
    } ;
#define PFLAGS_M_DEV_MOU 0x1
union FILL_7_ {
    unsigned int PFLAGS_L_PFLAGS;
    struct  {
        unsigned PFLAGS_V_DEV_MOU : 1;  /* [STABACKUP] device mounted       */
/* (Used for /LIST of *.* tape savesets.)                                   */
        unsigned PFLAGS_V_FILL_9_ : 7;
        } PFLAGS_R_FILL_8_;
    } ;
/*                                                                          */
/*  Encrypt Key [Parameter] Value Block                                     */
/*                                                                          */
#define QUAL_S_ENCV 12                  /* Encrypt value list item          */
struct ENCPVB {
    struct ENCPVB *QUAL_ENVA_LINK;      /* Link word - Encrypt key value    */
    struct dsc$descriptor QUAL_ENVA_DESC; /* Value string descriptor - Encrypt key value */
    } ;
/*                                                                          */
/*  Exclude Parameter Value Block                                           */
/*                                                                          */
#define QUAL_S_EXCL 12                  /* Exclude value list item size     */
struct EXCLPVB {
    struct EXCLPVB *QUAL_EXCL_NEXT;     /* Pointer to next parameter block (common to all) */
    struct dsc$descriptor QUAL_EXCL_DESC; /* /EXCLUDE value                 */
    } ;
/*                                                                          */
/*  Select Parameter Value Block                                            */
/*                                                                          */
#define QUAL_S_SELE 20                  /* Select value list item size      */
struct SELEPVB {
    struct SELEPVB *QUAL_SELE_NEXT;     /* Pointer to next parameter block (common to all) */
    struct dsc$descriptor QUAL_SELE_DESC; /* /SELECT value                  */
    struct dsc$descriptor QUAL_OUTPUT_DESC; /* the output file name         */
    } ;
/*                                                                          */
/*  Label Parameter Value Block                                             */
/*                                                                          */
#define QUAL_S_LABE 16                  /* Label value list item size       */
struct LABEPVB {
    struct LABEPVB *QUAL_LABE_NEXT;     /* Pointer to next parameter block (common to all) */
    struct dsc$descriptor QUAL_LABE_VALUE; /* /LABEL value                  */
    } ;
/*                                                                          */
/*  Format of Bad Block Descriptor [Header] returned by routine GET_BADBLOCKS. */
/*                                                                          */
#define BAD_S_HEADER 8
struct BADBLK {
    unsigned int BAD_NUMDESC;           /* Number of descriptors            */
    unsigned int BAD_SERIAL;            /* Pack serial number               */
    unsigned int BAD_DESC [2];          /* Origin of descriptors            */
    } ;
/*                                                                          */
/*  Bad Block Descriptor                                                    */
/*                                                                          */
#define BAD_S_DESC 8
struct BADBDSC {
    unsigned int BAD_LBN;               /* LBN                              */
    unsigned int BAD_COUNT;             /* Count                            */
    } ;
/*                                                                          */
/* MAX Number of FID/DID entries in an input_proc_list block.               */
/*                                                                          */
#define REC_MAX_COUNT 64
/*                                                                          */
/*  PROCESSED FILE ID LIST ( INPUT_PROC_LIST ) Entry                        */
/*                                                                          */
#define REC_M_BADVER 0x1
#define REC_M_NOBACK 0x2
#define REC_M_FOPEN 0x4
#define REC_M_ACCESS 0x8
#define REC_S_PROC_FILE 13              /* The length of a FID/DID/FLAGS entry */
struct INPROCBLK {
    union  {
        unsigned char REC_B_FLAGS;
        struct  {
            unsigned REC_V_BADVER : 1;  /* Flag to say verification pass failed */
            unsigned REC_V_NOBACK : 1;  /* Flag to say file marked NOBACKUP */
            unsigned REC_V_FOPEN : 1;   /* Flag to say file open (write access) */
            unsigned REC_V_ACCESS : 1;  /* Flag to say file access conflict */
            unsigned REC_V_FILL_12_ : 4;
            } REC_R_FILL_11_;
        } FILL_10_;
    unsigned short int REC_RECFID [3];  /* File ID                          */
    unsigned short int REC_RECDID [3];  /* Directory ID                     */
    } ;
/*                                                                          */
/*  PROCESSED FILE ID LIST  ( INPUT_PROC_LIST )                             */
/*                                                                          */
#define REC_S_ENTRY 844
struct INPROCLST {
    struct INPROCLST *REC_NEXT;         /* Pointer to next block            */
    struct QUALPVB *REC_QUAL;           /* Value of INPUT_QUAL for this block */
    unsigned short int REC_USED;        /* Count of used entries in this block */
    unsigned short int REC_VOLUME;      /* Volume number                    */
    unsigned short int (*(*REC_FID_BASE)); /* Base of FID/DID entries       */
    } ;
/*                                                                          */
/*		Processed Volume ID (LABEL) List                            */
/*                                                                          */
/*	Field definitions for structure pointed to by OUTPUT_VID_LIST.      */
/*                                                                          */
/*	The Volume ID list (VID) maintains the label/name of each volume in */
/*	an output saveset (or tape volume set if you prefer) as it is       */
/*	processed.  This allows MME routines to lookup a file's volume Id   */
/*	based on the volume's number as stored in the FID structures defined */
/*	in the Processed File ID List (i.e. REC_VOLUME).  The VID consists of */
/*	a singly-linked list of VID blocks.  Each block contains several    */
/*	slots of 12 characters, each containing a volume Id string (except  */
/*	for the last slot which is used as a header/control entry).         */
/*                                                                          */
/*	Additional details about the use of the VID list can be found in    */
/*	module SAVE.B32.                                                    */
/*                                                                          */
/*	VID_ENTRY is the normal, 12 character volume (label) Id.  The other */
/*	fields define a remapping of VID_ENTRY as the header/control entry. */
/*                                                                          */
struct VIDENT {
    unsigned char VID_ENTRY [12];       /* normal VID entry (12 bytes)      */
    } ;
#define VID_S_ENTRY 12                  /* size, in bytes, of an entry/slot */
struct VIDHDR {
    struct VIDHDR *VID_NEXT;            /* pointer to next VID block        */
    unsigned char VID_BLKN;             /* VID block number (0-255)         */
    unsigned char VID_MBZ_1 [3];        /* reserved...mbz (padding)         */
    unsigned int VID_MBZ_2;             /* reserved...mbz (padding)         */
    } ;
#define VID_K_BASIS 16                  /* modulo base                      */
#define VID_K_SLOTS 17                  /* number of slots per VID block    */
#define VID_S_BLOCK 204                 /* size, in bytes, of a VID block   */
#define BCB_S_IDLE 0                    /* idle                             */
#define BCB_S_READ 1                    /* read operation pending           */
#define BCB_S_WRITE 2                   /* write operation pending          */
#define BCB_S_DATA 3                    /* holding data, no I/O pending     */
#define BCB_S_REREAD 4                  /* read on alternate channel        */
#define BCB_DATA_TYPE 0                 /* Data (normal) type               */
#define BCB_XOR_TYPE 1                  /* XOR type                         */
#define BCB_FLAGS_START 44              /* offset used to init. flags       */
#define BCB_M_WRITE_ISSUED 0x1
#define BCB_M_WRITE_REISSUED 0x2
#define BCB_M_WRITE_SYNCH 0x4
#define BCB_M_EIP_EOV 0x8
#define BCB_M_ASSOC_VREAD 0x10
#define BCB_M_FINAL_XOR 0x20
#define BCB_M_NEW_PASS 0x40
#define BCB_M_ENCRYPT 0x80
#define BCB_FLAGS_K_LENGTH 4
#define BCB_LENGTH 64                   /* length of buffer control block   */
struct BCBBLK {
    struct BCBBLK *BCB_FLINK;           /* queue forward link               */
    struct BCBBLK *BCB_BLINK;           /* queue back link                  */
    unsigned short int BCB_SIZE;        /* buffer size                      */
    unsigned char BCB_STATE;            /* buffer state                     */
    unsigned char BCB_TYPE;             /* Purpose (XOR, data)              */
    int *BCB_BUFFER;                    /* buffer address                   */
    int *BCB_RECORD;                    /* current record pointer           */
    unsigned int BCB_BLOCKNUM;          /* disk block number                */
    union  {
        unsigned short int BCB_IOSB [4]; /* I/O status block (base)         */
        struct  {
            unsigned int BCB_STATUS;    /* I/O status longword              */
            unsigned int BCB_STATUS2;   /* second I/O status longword       */
            } IOSBLBLK;
        struct  {
            unsigned short int BCB_IO_STATUS; /* I/O status word            */
            unsigned short int BCB_IO_BCOUNT; /* I/O status byte count      */
            unsigned int BCB_IOSBWBLK_filler;
            } IOSBWBLK;
        } IOSBLKU;
    unsigned int BCB_WRITE_FUNC;        /* Write function for               */
/* asynch writes                                                            */
    int *BCB_SUCC_ACT;                  /* success action routine           */
    int *BCB_FAIL_ACT;                  /* failure action routine           */
    union  {
        unsigned int BCB_L_FLAGS;       /* flags                            */
        struct  {
            unsigned BCB_V_WRITE_ISSUED : 1; /* Flag to indicate write was successfully issued */
            unsigned BCB_V_WRITE_REISSUED : 1; /* Error write reissued      */
            unsigned BCB_V_WRITE_SYNCH : 1; /* Perform the write synchronously */
            unsigned BCB_V_EIP_EOV : 1; /* Do not reissue from ast level during error processing */
            unsigned BCB_V_ASSOC_VREAD : 1; /* At least one virtual read is associated with this buffer */
            unsigned BCB_V_FINAL_XOR : 1; /* This is the final XOR BCB for the volume */
            unsigned BCB_V_NEW_PASS : 1; /* Start of a new file scan pass   */
            unsigned BCB_V_ENCRYPT : 1; /* Flag to indicate buffer is encrypted */
            } BCB_R_FILL_14_;
        } FILL_13_;
/* The following constant definition is required because the FLAGS structure  */
/* and its length are not otherwise declared by SDL.                        */
/*                                                                          */
    struct PFL *BCB_FIRST_PFL;          /* Pointer to first associated PFL  */
    struct PFL *BCB_LAST_PFL;           /* Pointer to last associated PFL   */
    unsigned int BCB_START_VBN;         /* Starting VBN of first file represented in buffer */
    unsigned int BCB_NEXT_VBN;          /* VBN of first file in next buffer */
    } ;
#define BSR_LENGTH 208                  /* Length of BSR area               */
struct BSRBLK {
    struct dsc$descriptor BSR_SSNAME;   /* Descriptor for SSNAME            */
    struct dsc$descriptor BSR_COMMAND;  /* Descriptor for COMMAND           */
    struct dsc$descriptor BSR_COMMENT;  /* Descriptor for COMMENT           */
    struct dsc$descriptor BSR_USERNAME; /* Descriptor for USERNAME          */
    unsigned int BSR_DATE [2];          /* Value of DATE                    */
    struct dsc$descriptor BSR_SYSVER;   /* Descriptor for SYSVER            */
    struct dsc$descriptor BSR_NODENAME; /* Descriptor for NODENAME          */
    struct dsc$descriptor BSR_DRIVEID;  /* Descriptor for DRIVEID           */
    struct dsc$descriptor BSR_BACKVER;  /* Descriptor for BACKVER           */
    struct dsc$descriptor BSR_VOLSETNAM; /* Descriptor for VOLSETNAM        */
    unsigned int BSR_BACKSIZE [2];      /* Value of BACKSIZE                */
    unsigned int BSR_USERUIC;           /* Value of USERUIC                 */
    unsigned int BSR_SIR;               /* Value of SIR                     */
    unsigned int BSR_BLOCKSIZE;         /* Value of BLOCKSIZE               */
    unsigned int BSR_BACKFILES;         /* Value of BACKFILES               */
    unsigned short int BSR_OPSYS;       /* Value of OPSYS                   */
    unsigned short int BSR_XORSIZE;     /* Value of XORSIZE                 */
    unsigned short int BSR_BUFFERS;     /* Value of BUFFERS                 */
    unsigned short int BSR_NVOLS;       /* Value of NVOLS                   */
    unsigned char BSR_CRYPTDATA [24];   /* Value of CRYPTDATA               */
    unsigned char BSR_CRYPTAESDATA [64]; /* Value of CRYPTDATA for AES      */
    struct dsc$descriptor BSR_COMPRESSALGO; /* Descriptor for COMPRESSALGO   */
    } ;
#define VSR_LENGTH 118                  /* Length of VSR area               */
struct VSRBLK {
    struct dsc$descriptor VSR_VSRVOLNAME; /* Descriptor for VOLNAME         */
    struct dsc$descriptor VSR_OWNERNAME; /* Descriptor for OWNERNAME        */
    struct dsc$descriptor VSR_FORMAT;   /* Descriptor for FORMAT            */
    unsigned int VSR_VOLDATE [2];       /* Value of VOLDATE                 */
    unsigned int VSR_TOTSIZE [2];       /* Value of TOTSIZE                 */
    unsigned int VSR_VOLOWNER;          /* Value of VOLOWNER                */
    unsigned int VSR_VOLSIZE;           /* Value of VOLSIZE                 */
    unsigned int VSR_TOTFILES;          /* Value of TOTFILES                */
    unsigned int VSR_MAXFILES;          /* Value of MAXFILES                */
    unsigned int VSR_MAXFILNUM;         /* Value of MAXFILNUM               */
    unsigned int VSR_SERIALNUM;         /* Value of SERIALNUM               */
    union  {
        unsigned short int VSR_VOLSTRUCT; /* Value of VOLSTRUCT             */
        struct  {
            unsigned char VOLSTRUCT_FILL1; /* dummy item to maintain offset */
            unsigned char VSR_STRUCLEV; /* Structure level part of VOLSTRUCT */
            } VSR_FILL_16_;
        } VSR_FILL_15_;
    unsigned short int VSR_RVN;         /* Value of RVN                     */
    unsigned short int VSR_PROTECT;     /* Value of PROTECT                 */
    unsigned short int VSR_FILEPROT;    /* Value of FILEPROT                */
    unsigned short int VSR_RECPROT;     /* Value of RECPROT                 */
    unsigned short int VSR_VOLCHAR;     /* Value of VOLCHAR                 */
    unsigned short int VSR_EXTEND;      /* Value of EXTEND                  */
    unsigned short int VSR_CLUSTER;     /* Value of CLUSTER                 */
    unsigned short int VSR_RESFILES;    /* Value of RESFILES                */
    unsigned char VSR_WINDOW;           /* Value of WINDOW                  */
    unsigned char VSR_LRU_LIM;          /* Value of LRU_LIM                 */
    unsigned int VSR_INDEXLBN;          /* Value of INDEXLBN                */
    struct dsc$descriptor VSR_BOOTBLOCK; /* Descriptor for BOOTBLOCK        */
    unsigned int VSR_RETAINMIN [2];     /* Value of RETAINMIN               */
    unsigned int VSR_RETAINMAX [2];     /* Value of RETAINMAX               */
    unsigned short int VSR_BACKREV;     /* Value of BACKREV.                */
    unsigned int VSR_EXPSIZE;           /* Value of Expansion Size	    */
    } ;
#define PVA_LENGTH 40                   /* Length of PVA area               */
struct PVABLK {
    struct dsc$descriptor PVA_DEVNAM;   /* Descriptor for DEVNAM            */
    struct dsc$descriptor PVA_LABEL;    /* Descriptor for LABEL             */
    struct dsc$descriptor PVA_BADBLOCK; /* Descriptor for BADBLOCK          */
    unsigned int PVA_MAXBLOCK;          /* Value of MAXBLOCK                */
    unsigned int PVA_SERIAL;            /* Value of SERIAL                  */
    unsigned short int PVA_CYLINDERS;   /* Value of CYLINDERS               */
    unsigned char PVA_SECTORS;          /* Value of SECTORS                 */
    unsigned char PVA_TRACKS;           /* Value of TRACKS                  */
    unsigned int PVA_DEVTYP;            /* Value of DEVTYP                  */
    } ;
#define FAR_M_HEADONLY 0x1
#define FAR_LENGTH 200                  /* Length of FAR area               */
struct FARBLK {
    struct dsc$descriptor FAR_FILENAME; /* Descriptor for FILENAME          */
    struct dsc$descriptor FAR_PLACEMENT; /* Descriptor for PLACEMENT        */
    unsigned char FAR_RECATTR [32];     /* Value of RECATTR                 */
    unsigned int FAR_CREDATE [2];       /* Value of CREDATE                 */
    unsigned int FAR_REVDATE [2];       /* Value of REVDATE                 */
    unsigned int FAR_EXPDATE [2];       /* Value of EXPDATE                 */
    unsigned int FAR_BAKDATE [2];       /* Value of BAKDATE                 */
    union  {
        unsigned short int FAR_FARFID [3]; /* Value of FID                  */
        struct  {
            unsigned short int FAR_FID_NUM;
            unsigned short int FAR_FID_SEQ;
            union  {
                unsigned short int FAR_FID_RVNW;
                struct  {
                    unsigned char FAR_FID_RVN;
                    unsigned char FAR_FID_NMX;
                    } FAR_FILL_20_;
                } FAR_FILL_19_;
            } FAR_FILL_18_;
        } FAR_FILL_17_;
    union  {
        unsigned short int FAR_BACKLINK [3]; /* Value of BACKLINK           */
        struct  {
            unsigned short int FAR_DID_NUM;
            unsigned short int FAR_DID_SEQ;
            unsigned short int FAR_DID_RVNW;
            } FAR_FILL_22_;
        } FAR_FILL_21_;
    unsigned int FAR_FILESIZE;          /* Value of FILESIZE                */
    union  {
        unsigned int FAR_UIC;           /* Value of UIC                     */
        struct  {
            unsigned short int FAR_UICMEMBER; /* Member part of UIC         */
            unsigned short int FAR_UICGROUP; /* Group part of UIC           */
            } FAR_FILL_24_;
        } FAR_FILL_23_;
    unsigned int FAR_UCHAR;             /* Value of UCHAR                   */
    unsigned int FAR_BOOTVBN;           /* Value of BOOTVBN for 1st boot image */
    union  {
        unsigned short int FAR_STRUCLEV; /* Value of STRUCLEV               */
        struct  {
            unsigned char FAR_STRUCLEV_FILL1; /* dummy item to maintain offset */
            unsigned char FAR_STRUCLEVB; /* Structure level part of STRUCLEV */
            } FAR_FILL_26_;
        } FAR_FILL_25_;
    unsigned short int FAR_FPRO;        /* Value of FPRO                    */
    unsigned short int FAR_RPRO;        /* Value of RPRO                    */
    unsigned short int FAR_REVISION;    /* Value of REVISION                */
    unsigned int FAR_DIR_UIC;           /* Value of DIR_UIC                 */
    unsigned short int FAR_DIR_FPRO;    /* Value of DIR_FPRO                */
    unsigned char FAR_ACLEVEL;          /* Value of ACLEVEL                 */
    unsigned char FAR_DIR_STATUS;       /* Value of DIR_STATUS              */
    unsigned short int FAR_DIR_VERLIM;  /* Value of DIR_VERLIM              */
    unsigned short int FAR_VERLIMIT;    /* Value of VERLIMIT                */
    struct dsc$descriptor FAR_ACLSEGMENT; /* ACL segment descriptor         */
    unsigned int FAR_HIGHWATER;         /* Value of HIGHWATER               */
    unsigned char FAR_JNL_FLAGS;        /* Value of JNL_FLAGS               */
    unsigned char FAR_RU_ACTIVE;        /* Value of RU_ACTIVE               */
    union  {
        unsigned short int FAR_W_FLAGS;
        struct  {
            unsigned FAR_V_HEADONLY : 1; /* Only the HEADER was saved       */
            unsigned FAR_V_FILL_1 : 15;
            } BIT_FLAGS;
        } FLAGS_OVERLAY;
    unsigned int FAR_BOOTVBN2;          /* Value of BOOTVBN for 2nd boot image */
    unsigned int FAR_GPT_VBN;           /* Value of GPT_VBN for EFI/GPT partition image */
    unsigned int FAR_GPT_TYPE;          /* Value of GPT_TYPE for EFI/GPT partition image */
    unsigned int FAR_ACCDATE [2];       /* ODS5, Access date                */
    unsigned int FAR_ATTDATE [2];       /* ODS5, Attribute change date      */
    unsigned char FAR_LENGTH_HINT [16];
/* ODS5, File length hint                                                   */
    unsigned char FAR_EX_RECATTR [8];
/* ODS5, Extended RMS record attributes                                     */
    unsigned short int FAR_LINKCOUNT;   /* ODS5 (hard) link count           */
    unsigned short int FAR_filler;      /* filler                           */
    } ;
#define ATTBUF_LENGTH 192
#define ACB_S_ENTRY 16                  /* Size of entry                    */
struct STABCKACB {
    struct STABCKACB *ACB_FLINK;        /* Forward link                     */
    struct STABCKACB *ACB_BLINK;        /* Backward link                    */
    unsigned int ACB_COUNT;             /* Block count                      */
    unsigned int ACB_LBN;               /* Logical block number             */
    } ;
#define WCB_M_BLACKHOLE 0x1
#define WCB_S_HEADER 20                 /* Size of header                   */
struct STABWCBHD {
    struct STABWCBHD *WCB_LINK;         /* Link to next block               */
    unsigned int WCB_VBN;               /* In first block only, starting VBN of window */
    unsigned char WCB_SIZE;             /* Number of entries in window block */
    unsigned char WCB_FREE;             /* Number of free entries in window */
    unsigned char WCB_RVN;              /* RVN                              */
    union  {
        unsigned char WCB_B_FLAGS;      /* Flag byte                        */
        struct  {
            unsigned WCB_V_BLACKHOLE : 1; /* Flush write I/Os into this window */
            unsigned WCB_V_FILL_29_ : 7;
            } WCB_R_FILL_28_;
        } FILL_27_;
    unsigned int WCB_CUR_HWM;           /* Current highwater mark for open file */
    unsigned int WCB_SET_HWM;           /* Highwater mark written for open file */
    } ;
#define WCB_S_ENTRY 8                   /* Size of each entry               */
struct STABWCBENT {
    unsigned int WCB_COUNT;             /* Count of blocks                  */
    unsigned int WCB_LBN;               /* LBN of blocks                    */
    } ;
#define VCB_M_OUTPUT 0x1
#define VCB_M_ODS_2 0x2
#define VCB_M_INIT_DONE 0x4
#define VCB_M_SAVESET 0x8
#define VCB_M_NOTVOLSET 0x10
#define VCB_M_ODS_5 0x20
#define VCB_S_ENTRY 72                  /* Size of entry                    */
struct STABCKVCB {
    int *VCB_INDEXF;                    /* Pointer to index file window     */
    unsigned short int VCB_CLUSTER;     /* Cluster factor                   */
    unsigned char VCB_RVN;              /* Relative volume number           */
    union  {
        unsigned char VCB_B_FLAGS;
        struct  {
            unsigned VCB_V_OUTPUT : 1;  /* True if output volume            */
            unsigned VCB_V_ODS_2 : 1;   /* True if ODS-2 volume             */
            unsigned VCB_V_INIT_DONE : 1; /* True if initialization has been done */
            unsigned VCB_V_SAVESET : 1; /* True if saveset volume           */
            unsigned VCB_V_NOTVOLSET : 1; /* Sequential disk volume is not in a set */
            unsigned VCB_V_ODS_5 : 1;   /* True if ODS-5 volume             */
            unsigned VCB_V_FILL_32_ : 2;
            } VCB_R_FILL_31_;
        } FILL_30_;
    unsigned short int VCB_CHAN;        /* Channel number assigned to this RVN */
    unsigned short int VCB_IOCOUNT;     /* Count of pending read/write QIOs */
    unsigned int VCB_BITMAP_LBN;        /* LBN of storage bitmap            */
    int *VCB_IMAP;                      /* Pointer to index file bitmap image */
    unsigned int VCB_IMAP_LBN;          /* LBN of index file bitmap         */
    unsigned short int VCB_INIT_HDRS;   /* Bit mask of initialized headers  */
    unsigned short int VCB_HDR_OFFSET;  /* VBN offset to file headers       */
    unsigned int VCB_MAXFILIDX;         /* Number of bits in index file bitmap */
    struct dsc$descriptor VCB_DEVICE;   /* Descriptor for device name       */
    struct STABCKACB *VCB_ACB_FLINK;    /* Queue header for ACB queue       */
    struct STABCKACB *VCB_ACB_BLINK;    /*                                  */
    int *VCB_FAB;                       /* Pointer to FAB with filespec     */
    unsigned short int VCB_BITMAP_SIZE; /* Storage bitmap size in blocks    */
    unsigned short int VCB_FILLER1_VCB; /* dummy item to maintain offsets   */
    unsigned char VCB_VCBVOLNAME [12];  /* Volume label                     */
    unsigned int VCB_EXPSIZE;           /* Expansion size                          */
    } ;
#define MTL_M_SEQ_DISK 0x1
#define MTL_M_NEW_ACL 0x2
#define MTL_M_NOHWM 0x4
#define MTL_S_ENTRY 52                  /* Size of entry, less VCB pointers */
/*   MTL_VCB(n)=	52+4*(n),0,32,0 %; ! Pointer to VCB for RVN n       */
struct STABCKMTL {
    struct STABCKVCB *MTL_CHAN_1;       /* Pointer to VCB to which each of 2 */
    struct STABCKVCB *MTL_CHAN_2;       /*     channels is assigned         */
    struct STABWCBHD *MTL_WINDOW;       /* Pointer to WCB for accessed file */
    int *MTL_HEADER;                    /* Pointer to header for accessed file */
    int *MTL_ACLFL;                     /* ACL queue                        */
    int *MTL_ACLBL;                     /*   head                           */
    union  {
        unsigned short int MTL_MTLFID [3]; /* File ID of accessed file      */
        struct  {
            unsigned short int MTL_FID_NUM; /*                              */
            unsigned short int MTL_FID_SEQ; /*                              */
            union  {
                unsigned short int MTL_FID_RVNW; /*                         */
                struct  {
                    unsigned char MTL_FID_RVN; /*                           */
                    unsigned char MTL_FID_NMX; /*                           */
                    } MTL_FILL_36_;
                } MTL_FILL_35_;
            } MTL_FILL_34_;
        } MTL_FILL_33_;
    unsigned char MTL_STRUCLEV;         /* Structure level of volume set    */
    unsigned char MTL_SETCOUNT;         /* Count of volumes in volume set   */
    unsigned int MTL_FILESIZE;          /* Size of accessed file            */
    unsigned char MTL_STRUCNAME [12];   /* Volume set name                  */
    unsigned char MTL_RVN_BASE;         /* RVN mounted on first VCB         */
    union  {
        unsigned char MTL_B_FLAGS [3];
        struct  {
            unsigned MTL_V_SEQ_DISK : 1; /* Set if sequential disk volume set */
            unsigned MTL_V_NEW_ACL : 1; /* Set if ACL must be written       */
            unsigned MTL_V_NOHWM : 1;   /* Highwater marking disabled for volume set */
            unsigned MTL_V_FILL_39_ : 5;
            } MTL_R_FILL_38_;
        } FILL_37_;
    } ;
#define D_M_DIR_SCAN 0x1
#define D_M_DIR_MATCHES 0x2
#define D_M_WILD_TERM 0x4
#define D_M_NON_TERM 0x8
#define D_M_DIR_CIRC 0x10
#define DQE_S_ENTRY 84                  /* Size of directory queue entry in bytes */
struct DIRQUEUE {
    struct DIRQUEUE *D_DQE_FLINK;       /* Pointer to next directory queue entry */
    struct DIRQUEUE *D_DQE_BLINK;       /* Pointer to prior directory queue entry */
    int *D_REC;                         /* Pointer to current record        */
    int *D_VER;                         /* Pointer to current version if ODS-2 */
    unsigned int D_BUF_LEN;             /* Length of buffer in bytes        */
    int *D_BUF_ADDR;                    /* Pointer to buffer                */
    unsigned int D_BUF_LIM;             /* Limit of significant part of buffer */
    unsigned int D_VBN;                 /* Next VBN to be read              */
    unsigned int D_DIR_LEN;             /* Length of directory in blocks    */
    unsigned short int D_DIRFID [3];    /* File ID of directory             */
    unsigned short int D_SAV_LEN;       /* Saved length of directory string */
    union  {
        unsigned int D_L_FLAGS;         /* Directory entry flags            */
        struct  {
            unsigned D_V_DIR_SCAN : 1;  /* True if directory file to be scanned */
            unsigned D_V_DIR_MATCHES : 1; /* True if current directory matches */
            unsigned D_V_WILD_TERM : 1; /* True if terminator contains wildcard */
            unsigned D_V_NON_TERM : 1;  /* True if terminator is "*"        */
            unsigned D_V_DIR_CIRC : 1;  /* True if directory file is a circular alias */
            unsigned D_V_FILL_42_ : 3;
            } D_R_FILL_41_;
        } FILL_40_;
    struct dsc$descriptor D_TERM_DESC;  /* Termination string descriptor    */
    struct dsc$descriptor D_NAME_DESC;  /* Current filename string descriptor */
    short int D_TERM_VER;               /* Termination version number       */
    unsigned short int D_FPRO;          /* Directory file protection        */
    unsigned int D_UIC;                 /* Directory file owner             */
    unsigned short int D_VERLIM;        /* Directory default version limit  */
    short int D_VER_COUNT;              /* File version counter (0, -1, ...) */
    int *D_F64DIRBUF;                   /* Pointer to Files-64 directory buffer */
    unsigned int D_F64DIRBUFLEN;        /* Length in bytes of F64DIRBUF     */
    } ;
#define FCE_M_CONVERTED 0x1
#define FCE_M_RELOADED 0x2
#define FCE_M_SYSLOST 0x4
#define FCE_S_ENTRY 40                  /* Size of Filename Conversion Name Entry in bytes */
struct FCE_BLK {
    struct FCE_BLK *FCE_FLINK;          /* Pointer to next Filename Conversion Name Entry */
    struct FCE_BLK *FCE_BLINK;          /* Pointer to prior Filename Conversion Name Entry */
    union  {                            /* Filename Coversion Entry Flags Overlay */
        unsigned short int FCE_FLAGS;   /* Filename Coversion Entry Flags   */
        union  {
            unsigned short int FCE_W_BIT_FLAGS;
            struct  {
                unsigned FCE_V_CONVERTED : 1; /* Filename has been Converted */
                unsigned FCE_V_RELOADED : 1; /* Filename has been Reloaded into the Directory */
                unsigned FCE_V_SYSLOST : 1; /* Filename has been Converted to SYSLOST Directory */
                unsigned FCE_V_FILL_45_ : 5;
                } FCE_R_FILL_44_;
            } FILL_43_;
        } FCE_FLAGS_OVERLAY;
    unsigned char FCE_DIR_FLAGS;        /* Directory Entry Flags            */
    unsigned char FCE_CONV_CTR;         /* Conversion Character Count       */
    unsigned char FCE_ORIG_NAME_LEN;    /* Original File Name Length        */
    unsigned char FCE_ORIG_TYPE_LEN;    /* Original File Type Length        */
    unsigned char FCE_CONV_NAME_LEN;    /* Conversion File Name Length      */
    unsigned char FCE_CONV_TYPE_LEN;    /* Conversion File Type Length      */
    unsigned int FCE_ORIG_NAME_PTR;     /* Original File Name Pointer       */
    unsigned int FCE_ORIG_TYPE_PTR;     /* Original File Type Pointer       */
    unsigned int FCE_CONV_NAME_PTR;     /* Conversion File Name Pointer     */
    unsigned int FCE_CONV_TYPE_PTR;     /* Conversion File Type Pointer     */
    unsigned short int FCE_VERS_LIM;    /* File Name Version Limit          */
    unsigned short int FCE_VERS_LEN;    /* File Name Version Length         */
    unsigned int FCE_VERS_PTR;          /* File Name Version Pointer        */
    } ;
#define DCE_M_CONVERTED 0x1
#define DCE_M_SYSLOST 0x2
#define DCE_S_ENTRY 36                  /* Size of Directoryname Conversion Name Entry in bytes */
struct DCE_BLK {
    struct DCE_BLK *DCE_FLINK;          /* Pointer to next Directoryame Conversion Name Entry */
    struct DCE_BLK *DCE_BLINK;          /* Pointer to prior Directoryname Conversion Name Entry */
    union  {                            /* File ID overlay.                 */
        unsigned short int DCE_FLAGS;   /* File's FID.                      */
        union  {
            unsigned short int DCE_W_BIT_FLAGS;
            struct  {
                unsigned DCE_V_CONVERTED : 1; /* Filename has been Converted */
                unsigned DCE_V_SYSLOST : 1; /* Filename is in SYSLOST Directory */
                unsigned DCE_V_FILL_48_ : 6;
                } DCE_R_FILL_47_;
            } FILL_46_;
        } DCE_FLAGS_OVERLAY;
    unsigned short int DCE_FID [3];     /* Directory Name FID               */
    unsigned short int dce_fill;        /* Filler                           */
    unsigned char DCE_ORIG_NAME_LEN;    /* Directory Original Name Length   */
    unsigned char DCE_CONV_NAME_LEN;    /* Directory Conversion Name Length */
    unsigned int DCE_ORIG_NAME_PTR;     /* Directory Original Name Pointer  */
    unsigned int DCE_CONV_NAME_PTR;     /* Directory Conversion Name Pointer */
    struct FCE_BLK *DCE_FRST_FCE_PTR;   /* The first FCE for this BCB directory record */
    struct FCE_BLK *DCE_LAST_FCE_PTR;   /* The last FCE for this entire directory and/or BCB */
    } ;
#define DQF_S_ENTRY 24                  /* Size of entry in bytes           */
struct DSKQUOTA {
    struct DSKQUOTA *DQF_LLINK;         /* Pointer to entry with lesser UIC */
    struct DSKQUOTA *DQF_RLINK;         /* Pointer to entry with greater UIC */
    unsigned int DQF_UIC;               /* UIC                              */
    unsigned int DQF_USAGE;             /* Usage in blocks                  */
    unsigned int DQF_PERMQUOTA;         /* Permanent disk quota             */
    unsigned int DQF_OVERDRAFT;         /* Overdraft limit                  */
    } ;
#define PLC_S_HDR 10                    /* Length of placement block header */
struct PLCBLK {
    struct PLCBLK *PLC_FLINK;           /* Forward link                     */
    struct PLCBLK *PLC_BLINK;           /* Backward link                    */
    unsigned char PLC_TYPE;             /* Type code                        */
    unsigned char PLC_SIZE;             /* Size of block                    */
    unsigned char (*(*PLC_DATA_START)); /* Data portion                     */
    } ;
#define VBN_S_ENTRY 18                  /* Length of VBN data block         */
struct VBNBLK {
    struct VBNBLK *VBN_FLINK;           /* Forward link                     */
    struct VBNBLK *VBN_BLINK;           /* Backward link                    */
    unsigned char VBN_TYPE;             /* Type code                        */
    unsigned char VBN_SIZE;             /* Size of block                    */
    unsigned int VBN_FIRST;             /* First VBN in range               */
    unsigned int VBN_LAST;              /* Last VBN in range                */
    } ;
/* Max. label string size (disk/tape)                                       */
#define VOL_LABEL_STRING_MAX_SIZE 12
#define VOL_LABEL_MAX_LIST 20           /* Max. (initial) number of labels  */
/* (20*12 bytes) Blockvector size                                           */
/*	    (Initial dynamic size)                                          */
/*                                                                          */
#define VOL_LABEL_LIST_SIZE 240
#define VOLLBL_BLOCK_SIZE 12            /* Label Block Size                 */
struct VOLLBLBLK {
    struct  {
        char VOL_LABEL_STRING [12];     /* Label string                     */
        } LblVector [99];
    } ;
#define TAPE_CHAR_S_LENGTH 8            /* length of P1 User Buffer Structure */
#define TAPE_CHAR_S_MT3_LENGTH 16       /* length of P1 User Buffer Structure */
struct TAPECHARBLK {
    unsigned short int MT3_RESERVED;    /*                                  */
    unsigned short int TAPE_CHAR_BUFFER_SIZE; /*                            */
    unsigned CHARACTERISTICS1 : 32;     /*                                  */
    unsigned XCHARACTERTICS : 32;       /*                                  */
    unsigned short int MT3_TAPE_DENSITY; /*                                 */
    unsigned short int MT3_MUST_BE_ZERO; /*                                 */
    } ;
#define TAPEQ_M_EXPI 0x1
#define TAPEQ_M_LABE 0x2
#define TAPEQ_M_PROT 0x4
#define TAPEQ_M_WREN 0x8
#define TAPEQ_M_MOUN 0x10
#define TAPEQ_M_WRIT 0x20
#define TAPEQ_M_NOVR 0x40
#define TAPEQ_M_VOOO 0x80
#define TAPEQ_M_RVL 0x100
#define TAPEQ_M_NOUSE 0x200
union FILL_49_ {
    unsigned int TAPEQ_L_TAPERRQ;
    struct  {
        unsigned TAPEQ_V_EXPI : 1;      /* Has tape expiration date been met */
        unsigned TAPEQ_V_LABE : 1;      /* Is the tape label correct        */
        unsigned TAPEQ_V_PROT : 1;      /* Is tape protected from access    */
        unsigned TAPEQ_V_WREN : 1;      /* Should tape be write enabled     */
        unsigned TAPEQ_V_MOUN : 1;      /* Should we issue tape mount request */
        unsigned TAPEQ_V_WRIT : 1;      /* Do we want to write onto the tape */
        unsigned TAPEQ_V_NOVR : 1;      /* We want to prevent overwrite of tape */
        unsigned TAPEQ_V_VOOO : 1;      /* Volume was found to be Out Of Order */
        unsigned TAPEQ_V_RVL : 1;       /* Ask for unspecified volume label */
        unsigned TAPEQ_V_NOUSE : 1;     /* Don't use the loaded tape label  */
        unsigned TAPEQ_V_FILL_51_ : 6;
        } TAPEQ_R_FILL_50_;
    } ;
#define CLEAR_ASTLM_EFN 5               /* Wait for $SETIMR                 */
#define OUTSTANDING_WRITE_EFN 6         /* For non-TMSCP support            */
#define V_READ_EFN 20                   /* Event flag for vvm reads         */
#define BUFFER_FREED_EFN 21             /* Event flag set when a buffer is freed */
#define MISC_VM_BLOCK_HDR_SIZE 16       /* VM Block Header Size             */
struct MISCVMBLK {
    struct MISCVMBLK *MISC_VM_FLINK;    /* Misc. VM queue forward link      */
    struct MISCVMBLK *MISC_VM_BLINK;    /* Misc. VM queue backward link     */
    int *MISC_VM_ADDR;                  /* start of block (includes QUAD alignment space) */
    unsigned int MISC_VM_SIZE;          /* Misc. VM block size (bytes)      */
    unsigned char (*(*MISC_VM_USE_VM)); /* Start of Misc. VM usable data    */
    } ;
struct EVNTCALBCK {
    unsigned int Event_Callback_addr [46]; /* (each) Event Type Callback    */
    } ;
#define QUAL_S_AREA 248                 /* Length of the qualifiers block   */
#define COM_FLAGS_START 706             /* defined for COM_FLAGS init.      */
#define COM_M_EOV 0x1
#define COM_M_STANDALONE 0x2
#define COM_M_FILESEEN 0x4
#define COM_M_VERIFYING 0x8
#define COM_M_FAIL_RSTRT 0x10
#define COM_M_CONTINUE 0x20
#define COM_M_DSBL_CHKPT 0x40
#define COM_M_DSBL_RSTRT 0x80
#define COM_M_INTERACT 0x100
#define COM_M_TAPE_CACHE 0x200
#define COM_M_SEEN_FILE_OR_VBN 0x400
#define COM_M_SAV_SAV 0x800
#define COM_M_ERROR_IN_PROG 0x1000
#define COM_M_MME_EXISTS 0x2000
#define COM_M_LABEL_OVERWRITE 0x4000
#define COM_M_SS_EOV 0x8000
#define COM_FLAGS_K_LENGTH 2            /* defined for COM_FLAGS init.      */
#define COM_M_CVT_REST_ODS5_ODS2 0x1
#define COM_M_CVT_SAVE_ODS5_ODS2 0x2
#define COM_M_CVT_SAVE_SKIP_SYSLOST 0x4
#define COM_M_SNAPDISK 0x8
#define COM_M_MTD_SUPPORTED 0x10
#define COM_M_DO_MME_END 0x20
#define COM_M_HARDLINKS 0x40
#define COM_M_ODISK_FOREIGN 0x80
#define COM_M_ODISK_DFS 0x100
#define COM_M_WR_DATA_TS 0x200
#define INPUT_BEG 900                   /* Beginning of input context       */
#define INPUT_FLAGS_START 904           /* defined for COM_FLAGS init.      */
#define INPUT_M_OPEN 0x1
#define INPUT_M_EOV_IN_PROG 0x2
#define INPUT_M_EOV_SAVING 0x4
#define INPUT_M_ON_RVN 0x8
#define INPUT_M_IGNO_INTE 0x10
#define INPUT_M_SAVE_OK 0x20
#define INPUT_M_WILDSAVE 0x40
#define INPUT_M_REWOUND 0x80
#define INPUT_M_SSFOUND 0x100
#define INPUT_M_ALIAS 0x200
#define INPUT_M_SPAN_OVER 0x400
#define INPUT_M_INPUT_PHASE 0x800
#define INPUT_M_BSR_FOUND 0x1000
#define INPUT_M_COMPRESS_BCB_PRESENT 0x2000
#define INPUT_FLAGS_K_LENGTH 4          /* defined for COM_FLAGS init.      */
#define INPUT_HDR_BEG 952               /* Beginning of header data         */
#define INPUTCTX_HDR_SIZE 120
#define INPUTCTX_SIZE 172
#define OUTPUT_BEG 1100                 /* Beginning of output context      */
#define OUTPUT_M_OPEN 0x1
#define OUTPUT_M_FIRST 0x2
#define OUTPUT_M_LAST 0x4
#define OUTPUT_M_INCR_DIR 0x8
#define OUTPUT_M_IMPLICIT 0x10
#define OUTPUT_M_ACL_ERROR 0x20
#define OUTPUT_M_ACL_FIRST_TIME 0x40
#define OUTPUT_M_DIR_OPEN 0x80
#define OUTPUT_M_NONSEQ_IN 0x100
#define OUTPUT_M_SKIP_ALIAS 0x200
#define OUTPUT_M_ALIAS_OPEN 0x400
#define OUTPUTCTX_SIZE 236              /* End of output context            */
#define FASTCTX_VOL_BEG 1396            /* Beginning of per-volume information */
#define FASTCTX_VOL_SIZE 32             /* End of per-volume information    */
#define MAP_M_JOURNAL_ENTRY 0x1
#define MAP_M_LOST_FILES 0x2
#define RESTART_M_RESTARTING 0x1
#define RESTART_M_ON_RVN 0x2
#define RESTART_M_CLEAR_AST 0x4
#define DIR_BEG 1544                    /* Beginning of context             */
#define DIR_M_IMAGE_SCAN 0x1
#define DIR_M_SCAN_FAILED 0x2
#define DIR_M_HARD_STOP 0x4
#define DIR_M_SCANNED_DIRS 0x8
#define DIR_M_INITIAL 0x10
#define DIR_M_ROOT_MFD 0x20
#define D_STAT_M_VALID 0x1
#define D_STAT_M_DIR_SEL 0x2
#define D_STAT_M_SCANNED 0x4
#define D_STAT_M_FILE_SEL 0x8
#define DIRCTX_SIZE 104                 /* End of context                   */
#define FCECTX_BEG 1648                 /* Beginning of Conversion Context  */
#define FCE_M_HOLD_FRST 0x1
#define FCECTX_SIZE 44                  /* End of Conversion Context        */
#define DCECTX_BEG 1692                 /* Beginning of Conversion Context  */
#define DCE_M_DIRECTORY 0x1
#define DCE_M_MFD_ISRT 0x2
#define DCE_M_MFD_READ 0x4
#define DCE_M_MFD_CONV 0x8
#define DCE_M_MFD_PCVT 0x10
#define DCECTX_SIZE 20                  /* End of Conversion Context        */
#define INCR_M_SKIP_DIR 0x1
#define INCR_M_SAVE_ALL_DIR 0x2
#define INCR_M_DISABLE_SAVE_ALL 0x4
#define CHK_FLAGS_START 2748
/* define an offset for clearing the following structure                    */
#define CHK_FLAGS_M_F11 0x10000
#define CHK_FLAGS_M_SAV 0x20000
#define CHK_FLAGS_M_SAVE_SET 0x40000
#define CHK_FLAGS_M_SRCH_LIST 0x80000
#define CHK_FLAGS_M_SMFS 0x100000
#define CHK_FLAGS_M_DRVCLS_MISUSED 0x1000000
#define CHK_FLAGS_K_LENGTH 4
/* define a length for clearing the above structure                         */
#define BCK$$_S_COMMON_AREA 2798        /* Size of the Common Area          */
struct BCK_COMMON_DATA {
/*  OBSOLETE (BASE POINTER NO LONGER NEEDED).                               */
/*                                                                          */
/*   ! Marker for base of area.                                             */
/*                                                                          */
/*    GLOBAL_BASE	    address dimension *;                            */
/*                                                                          */
    int *FREE_LIST [2];                 /* Free queue header                */
    int *INPUT_WAIT [2];                /* Input pending queue header       */
    int *REREAD_WAIT [2];               /* Re-read pending queue header     */
    int *OUTPUT_WAIT [2];               /* Output ready for issue queue header */
    int *OUTPUT_ISSUED [2];             /* Output issued queue header       */
    int *XOR_LIST [2];                  /* Q header of buffers for XOR.     */
    int *ASYNCH_WORK [2];               /* Asynch work queue header         */
    struct MISCVMBLK *MISC_VM_LIST [2]; /* Q header of misc. VM (must be free'd) */
    unsigned int JPI_PID;               /* JPI$_PID                         */
    unsigned int JPI_UIC;               /* JPI$_UIC                         */
    unsigned int JPI_DATE [2];          /* $GETTIM                          */
    struct dsc$descriptor JPI_NODE_DESC; /* Translation of SYS$NODE         */
    unsigned int JPI_CURPRIV [2];       /* Current process privileges       */
    unsigned char JPI_USERNAME [12];    /* JPI$_USERNAME                    */
    unsigned int JPI_ASTLM;             /* AST limit from GETJPI.           */
    unsigned int JPI_BIOLM;             /* Buffered IO limit.               */
    unsigned int JPI_FILCNT;            /* Open file limit.                 */
    unsigned int JPI_WSQUOTA;           /* Working set quota.               */
    unsigned int JPI_PGFLQUOTA;         /* Page file quota.                 */
    unsigned int JPI_WSSIZE;            /* Current working set size.        */
    unsigned char JPI_PARSE_STYLE_PERM; /* Current Process Parse Style Property */
    unsigned char JPI_CASE_LOOKUP_PERM; /* Current Process Case Lookup Property */
    unsigned short int JPI_FILLER;      /* filler                           */
    unsigned int JPI_JOBTYPE;           /* Current process job type.        */
    unsigned int ADJ_WSSIZE;            /* Adjusted working set size (after $ADJWSL) */
    unsigned int SYI_VERSION;           /* SYI$_VERSION                     */
    unsigned int SYI_SID;               /* SYI$_SID                         */
    unsigned int SYI_CHANNELCNT;        /* SYI$_CHANNELCNT                  */
    unsigned int SYI_PAGE_SIZE;         /* SYI$_PAGE_SIZE                   */
    unsigned int CTRL_T_CHAN;           /* Channel to trap ^T.              */
    unsigned int CTRL_T_TOTBLK;         /* Total size                       */
    unsigned int CTRL_T_TIME [2];       /* Time of last CTRL-T              */
    unsigned int CTRL_T_PREVSEQ;        /* SEQ at last CTRL-T               */
    unsigned int CTRL_T_PREVSEC;        /* Estimated seconds remaining at last CTRL-T */
    int *RWSV_HOLD_LIST [2];            /* Queue header for error rewrites or held I/Os for volume switches */
    int *RWSV_ERRORS_LIST [2];          /* Queue header for output error rewrites */
    unsigned int RWSV_CRC16 [16];       /* CRC-16 polynomial table          */
    unsigned int RWSV_AUTODIN [16];     /* AUTODIN-II polynomial table      */
    unsigned char RWSV_FILESET_ID [8];  /* File set identifier              */
    unsigned char RWSV_VOLUME_ID [12];  /* Volume identifier                */
    unsigned short int RWSV_VOL_NUMBER; /* Save set volume number           */
    unsigned short int RWSV_SEG_NUMBER; /* File section number              */
    unsigned int RWSV_FILE_NUMBER;      /* File sequence number             */
    int *RWSV_SAVE_QUAL;                /* Pointer to save set qualifiers block */
    int *RWSV_SAVE_FC;                  /* Pointer to saveset File Context (FC) */
    unsigned int RWSV_CHAN;             /* Channel assigned to save set medium */
    int *RWSV_XOR_BCB;                  /* Pointer to BCB for XOR block     */
    unsigned int RWSV_IN_SEQ;           /* Input block sequence number      */
    unsigned int RWSV_IN_SEQ_0;         /* RWSV_IN_SEQ at start of reel     */
    unsigned int RWSV_IN_XOR_SEQ;       /* Sequence number of last XOR block */
    unsigned char RWSV_IN_XOR_RFA [6];  /* RFA of last XOR block            */
    unsigned char RWSV_LOOKAHEAD;       /* Buffer count from summary record */
    unsigned char RWSV_XORSIZE;         /* XOR group size from summary record */
    unsigned int RWSV_IN_GROUP_SIZE;    /* XOR group size of save set       */
    unsigned short int RWSV_IN_ERRORS;  /* Count of input errors            */
    unsigned short int RWSV_IN_XORUSE;  /* Count of XOR recoveries performed */
    int *RWSV_IN_ORGERR [2];            /* Original STS/STV of a train of loses */
    unsigned int RWSV_IN_VBN;           /* Current VBN in save set file     */
    unsigned int RWSV_IN_VBN_0;         /* Saved input VBN                  */
    unsigned int RWSV_ALLOC;            /* Number of blocks available in save set file */
    unsigned int RWSV_EOF;              /* End of file VBN if save set file */
    unsigned int RWSV_OUT_SEQ;          /* Output block sequence number     */
    unsigned int RWSV_OUT_VBN;          /* Output VBN                       */
    unsigned int RWSV_OUT_BLOCK_COUNT;  /* Count of blocks on output tape   */
    unsigned short int RWSV_OUT_ERRORS; /* Count of output errors           */
    unsigned short int RWSV_SEQ_ERRORS; /* Count of consecutive input errors */
    unsigned short int RWSV_READ_FIRST_BLOCK; /* Flag for reading first block of saveset */
    unsigned short int RWSV_REMOVE_FLAG; /* Flag to remove entry from INPUT_WAIT */
    unsigned char RWSV_OUT_GROUP_COUNT; /* Count of blocks in output XOR group */
    unsigned short int RWSV_HOLD_COUNT; /* Count of blocks on rwsv_hold_list */
    unsigned char rwsv_end_filler;      /* quadword align the start of next block */
/*                                                                          */
/* Qualifier block structure (database)                                     */
/*                                                                          */
    struct  {
        struct QUALPVB *QUAL_A_INPU_LIST; /* Input parameters               */
        struct QUALPVB *QUAL_A_OUTP_LIST; /* Output parameters              */
        unsigned QUAL_V_ALIAS : 1;      /* /ALIAS                           */
        unsigned QUAL_V_ANAL : 1;       /* /ANALYZE                         */
        unsigned QUAL_V_ASSI : 1;       /* /ASSIST for mounts               */
        unsigned QUAL_V_BACK : 1;       /* /BACKUP                          */
        unsigned QUAL_V_BEFO : 1;       /* /BEFORE                          */
        unsigned QUAL_V_BEFO_BACK : 1;  /* /BEFORE=BACKUP                   */
        unsigned QUAL_V_BLOC : 1;       /* /BLOCK_SIZE                      */
        unsigned QUAL_V_BUFF : 1;       /* /BUFFER_COUNT                    */
        unsigned QUAL_V_COMM : 1;       /* /COMMENT                         */
        unsigned QUAL_V_COMP : 1;       /* /COMPARE                         */
        unsigned QUAL_V_CONF : 1;       /* /CONFIRM                         */
        unsigned QUAL_V_CONV : 1;       /* /CONVERT                         */
        unsigned QUAL_V_CRC : 1;        /* /CRC                             */
        unsigned QUAL_V_CREA : 1;       /* /CREATED                         */
        unsigned QUAL_V_DCL_INTERFACE : 1; /* API invoked from DCL main     */
        unsigned QUAL_V_DELE : 1;       /* /DELETE                          */
        unsigned QUAL_V_DENS : 1;       /* /DENSITY                         */
        unsigned QUAL_V_DISP_KEEP : 1;  /* /DISPOSITION=KEEP     (MME)      */
        unsigned QUAL_V_DISP_RELE : 1;  /* /DISPOSITION=RELEASE  (MME)      */
        unsigned QUAL_V_EXACT : 1;      /* /EXACT_ORDER                     */
        unsigned QUAL_V_EXCL : 1;       /* /EXCLUDE                         */
        unsigned QUAL_V_EXPI : 1;       /* /EXPIRED                         */
        unsigned QUAL_V_FAST : 1;       /* /FAST                            */
        unsigned QUAL_V_FILEMERGE : 1;  /* Standalone file merge            */
        unsigned QUAL_V_FULL : 1;       /* /FULL                            */
        unsigned QUAL_V_GROU : 1;       /* /GROUP_SIZE                      */
        unsigned QUAL_V_IDRVCLS_VALID : 1; /* Drive class processed/valid (input) */
        unsigned QUAL_V_IF11 : 1;       /* Input is Files-11 or physical    */
        unsigned QUAL_V_IGNO_ACCESS : 1; /* /IGNORE=ACCESSIBILITY           */
        unsigned QUAL_V_IGNO_INTE : 1;  /* /IGNORE=INTERLOCK                */
        unsigned QUAL_V_IGNO_LABE : 1;  /* /IGNORE=LABEL_PROCESSING.        */
        unsigned QUAL_V_IGNO_NOBA : 1;  /* /IGNORE=NOBACKUP                 */
        unsigned QUAL_V_IMAG : 1;       /* /IMAGE                           */
        unsigned QUAL_V_INCR : 1;       /* /INCREMENTAL                     */
        unsigned QUAL_V_INIT : 1;       /* /INITIALIZE                      */
        unsigned QUAL_V_INTE : 1;       /* /INTERCHANGE                     */
        unsigned QUAL_V_ISAV : 1;       /* Input is save set                */
        unsigned QUAL_V_I_CART : 1;     /* /CARTRIDGE on input  (MME)       */
        unsigned QUAL_V_I_CAR_CARTMED : 1; /*    MEDIA_NAME specified on input */
        unsigned QUAL_V_I_CAR_CARTNAM : 1; /*    NAME specified on input    */
        unsigned QUAL_V_I_CAR_CARTSID : 1; /*    SIDE specified on input    */
        unsigned QUAL_V_I_DRVCLS : 1;   /* /DRIVE_CLASS on input  (MME)     */
        unsigned QUAL_V_I_OWNE : 1;     /* /OWNER_UIC on input  (MME)       */
        unsigned QUAL_V_I_OWN_WGRP : 1; /*    Wildcard group                */
        unsigned QUAL_V_I_OWN_WMEM : 1; /*     Wildcard member              */
        unsigned QUAL_V_I_SAVE : 1;     /* /SAVE_SET on input               */
        unsigned QUAL_V_I_SMFS : 1;     /* SMFS Device on Input             */
        unsigned QUAL_V_JOUR : 1;       /* /JOURNAL                         */
        unsigned QUAL_V_LABE : 1;       /* /LABEL                           */
        unsigned QUAL_V_LIST : 1;       /* /LIST                            */
        unsigned QUAL_V_LOG : 1;        /* /LOG                             */
        unsigned QUAL_V_MEDIA_COMPACTN : 1; /* /MEDIA_FORMAT=COMPACTION  (MME)   */
        unsigned QUAL_V_MEDIA_FORMAT : 1; /* /MEDIA_FORMAT             (MME)   */
        unsigned QUAL_V_MODI : 1;       /* /MODIFIED                        */
        unsigned QUAL_V_NEWV : 1;       /* /NEW_VERSION                     */
        unsigned QUAL_V_MT3_DENSITY : 1; /* /DENSITY qual for Multiple Tape Density support */
        unsigned QUAL_V_ODRVCLS_VALID : 1; /* Drive class processed/valid (output) */
        unsigned QUAL_V_OF11 : 1;       /* Output is Files-11 or physical   */
        unsigned QUAL_V_OSAV : 1;       /* Output is save set               */
        unsigned QUAL_V_OVER : 1;       /* /OVERLAY                         */
        unsigned QUAL_V_O_CART : 1;     /* /CARTRIDGE on output  (MME)      */
        unsigned QUAL_V_O_CAR_CARTMED : 1; /*    MEDIA_NAME specified on output */
        unsigned QUAL_V_O_CAR_CARTNAM : 1; /*    NAME specified on output   */
        unsigned QUAL_V_O_CAR_CARTSID : 1; /*    SIDE specified on output   */
        unsigned QUAL_V_O_DRVCLS : 1;   /* /DRIVE_CLASS on output  (MME)    */
        unsigned QUAL_V_O_OWNE : 1;     /* /OWNER_UIC on output             */
        unsigned QUAL_V_O_OWN_DEFA : 1; /*     =DEFAULT                     */
        unsigned QUAL_V_O_OWN_ORIG : 1; /*     =ORIGINAL                    */
        unsigned QUAL_V_O_OWN_PARE : 1; /*     =PARENT                      */
        unsigned QUAL_V_O_OWN_UIC : 1;  /*     =[g,m]                       */
        unsigned QUAL_V_O_SAVE : 1;     /* /SAVE_SET on output              */
        unsigned QUAL_V_O_SMFS : 1;     /* SMFS Device on Output            */
        unsigned QUAL_V_PHYS : 1;       /* /PHYSICAL                        */
        unsigned QUAL_V_PROT : 1;       /* /PROTECTION on output            */
        unsigned QUAL_V_RECO : 1;       /* /RECORD                          */
        unsigned QUAL_V_RELEASE_TAPE : 1; /* /RELEASE_TAPE                  */
        unsigned QUAL_V_REPL : 1;       /* /REPLACE                         */
        unsigned QUAL_V_REWI : 1;       /* /REWIND                          */
        unsigned QUAL_V_SCRA : 1;       /* /SCRATCH specified  (MME)        */
        unsigned QUAL_V_SCR_ASGN_BASE : 1; /*    ASSIGNMENT_UNIT=BASE_CARTRIDGE */
        unsigned QUAL_V_SCR_ASGN_COMP : 1; /*                   =COMPOUND_CARTRIDGE */
        unsigned QUAL_V_SCR_ASGN_PRES : 1; /*                   =PREASSIGNED_SIDE */
        unsigned QUAL_V_SCR_ASGN_SIDE : 1; /*                   =SIDE       */
        unsigned QUAL_V_SCR_COLL : 1;   /*    COLLECTION name specified     */
        unsigned QUAL_V_SCR_LOCA : 1;   /*    LOCATION name specified       */
        unsigned QUAL_V_SCR_MEDI : 1;   /*    MEDIA_NAME specified          */
        unsigned QUAL_V_SELE : 1;       /* /SELECT                          */
        unsigned QUAL_V_SINC : 1;       /* /SINCE                           */
        unsigned QUAL_V_SINC_BACK : 1;  /* /SINCE=BACKUP                    */
        unsigned QUAL_V_SNAPSHOT : 1;   /* /SNAPSHOT (SnapDisk)             */
        unsigned QUAL_V_SLS : 1;        /* /STORAGE_LIBRARY                 */
        unsigned QUAL_V_SS_ENCRYP : 1;  /* /ENCRYPT save set                */
        unsigned QUAL_V_SS_FILE : 1;    /* Save set is a disk file          */
        unsigned QUAL_V_TAPE_EXPI : 1;  /* Expiration date present          */
        unsigned QUAL_V_TRUN : 1;       /* /TRUNCATE                        */
        unsigned QUAL_V_UNSHELVE : 1;   /* /UNSHELVE (File Shelving support) */
        unsigned QUAL_V_VERI : 1;       /* /VERIFY                          */
        unsigned QUAL_V_VOLU : 1;       /* /VOLUME                          */
        unsigned QUAL_V_RELEASE_NOUNLOAD : 1; /* /RELEASE_TAPE=NOUNLOAD     */
        unsigned QUAL_V_PRESHELVED : 1; /* /PRESHELVED                      */
        unsigned QUAL_V_FILES_SELECTED_IN : 1; /* /FILES_SELECTED           */
        unsigned QUAL_V_INPUT_FILES_IN : 1; /* /INPUT_FILES                 */
        unsigned QUAL_V_HSMOPTIONS_IN : 1; /* /HSMOPTIONS in                */
        unsigned QUAL_V_HSMOPTIONS_OUT : 1; /* /HSMOPTIONS out              */
        unsigned QUAL_V_HSMHEADER_ONLY : 1; /* /HSMHEADER_ONLY              */
        unsigned QUAL_V_CRYPT_AESALG : 1; /* AES algorithm requested        */
        unsigned QUAL_V_IGNO_LIMIT : 1; /* /IGNORE=LIMIT                    */
        unsigned QUAL_V_DVE_LIMIT : 1;  /* /LIMIT                           */
        unsigned QUAL_V_DVE_SIZE : 1;   /* /SIZE                            */
        unsigned QUAL_V_IO_LOAD : 1;    /* /IO_LOAD                         */
        unsigned QUAL_V_PROGRESS : 1;   /* /PROGRESS                        */
        unsigned QUAL_V_REPAIR : 1;     /* /REPAIR                          */
        unsigned QUAL_V_DATA_FORMAT : 1; /* /DATA_FORMAT                    */
        unsigned QUAL_V_DATA_FORMAT_COMPRESS : 1; /* /DATA_FORMAT=COMPRESS  */
        unsigned QUAL_V_NOCONV : 1;
        unsigned QUAL_V_WIND_FULL : 1;  /*  /WINDOW=FULL                    */
        unsigned QUAL_V_WIND_LIMI : 1;  /* /WINDOW=LIMITED                  */
        unsigned QUAL_v_quaflags_fill : 10; /* longword-align next field    */
        unsigned QUAL_V_FILL_72_ : 1;
        unsigned int QUAL_l_quaflags2_fill;
        unsigned int QUAL_Q_BEFO_VALUE [2]; /* /BEFORE quadword time value  */
        struct dsc$descriptor QUAL_R_COMM_DESC; /* /COMMENT descriptor      */
        unsigned int QUAL_Q_SINC_VALUE [2]; /* /SINCE quadword time value   */
        struct dsc$descriptor QUAL_R_CMD_DESC; /* Command line descriptor   */
        struct EXCLPVB *QUAL_A_EXCL_LIST; /* /EXCLUDE list head             */
        int *QUAL_A_JOUR_FC;            /* /JOURNAL file context            */
        int *QUAL_A_LIST_FC;            /* /LIST file context               */
        union  {
            unsigned int QUAL_I_OWN_VALU; /* /OWNER_UIC value on input      */
            struct  {
                unsigned short int QUAL_I_OWN_MEM; /*	Member portion      */
                unsigned short int QUAL_I_OWN_GRP; /*	Group portion       */
                } QUAL_R_I_OWNUIC_FLDS;
            } QUAL_R_I_OWNER_UIC;
        union  {
            unsigned int QUAL_O_OWN_VALU; /* /OWNER_UIC value on output     */
            struct  {
                unsigned short int QUAL_O_OWN_MEM; /*	Member portion      */
                unsigned short int QUAL_O_OWN_GRP; /*	Group portion       */
                } QUAL_R_O_OWNUIC_FLDS;
            } QUAL_R_O_OWNER_UIC;
        struct SELEPVB *QUAL_A_SELE_LIST; /* /SELECT list head              */
        unsigned short int QUAL_W_BLOC_VALUE; /* /BLOCK_SIZE value          */
        unsigned short int QUAL_w_fill_bloc_val2; /* dummy item to maintain offsets */
        unsigned int QUAL_L_MT3_DENS_VALUE; /* /MEDIA_FORMAT=(DENSITY=value) */
        unsigned char QUAL_B_DENS_VALUE; /* /DENSITY value                  */
        unsigned char QUAL_B_GROU_VALUE; /* /GROUP_SIZE value               */
        unsigned char QUAL_B_VOLU_VALUE; /* /VOLUME value                   */
        unsigned char QUAL_B_OPERATION_TYPE; /* Current BACKUP operation type  */
        struct VOLLBLBLK *QUAL_A_LABEL_LIST; /* /LABEL vector pointer - was list head */
        unsigned char QUAL_B_LABEL_LIST_SIZE; /* number of labels in the label vector */
        unsigned char QUAL_B_LABEL_LIST_MAX_SIZE; /* max. items the label vector holds */
        unsigned char QUAL_b_fill_label_val2 [2]; /* filler, longword alignment */
        unsigned short int QUAL_W_PROT_VALUE; /* /PROTECTION value          */
        unsigned short int QUAL_w_fill_prot_val2; /* dummy item to maintain offsets */
        struct ENCPVB *QUAL_A_CRYP_VLIST; /* Pointer to list of key values  */
        struct dsc$descriptor QUAL_R_CRYP_USERKEY; /* Descriptor for user specified key */
        struct dsc$descriptor QUAL_R_CRYP_USERALG; /* Descriptor for user specified algorithn */
        unsigned int QUAL_Q_TAPE_VALUE [2]; /* /TAPE_EXPIRATION value       */
        struct dsc$descriptor QUAL_R_COLL_NAME; /* /SCRATCH=COLLECTION descriptor */
        struct dsc$descriptor QUAL_R_MEDI_NAME; /* /SCRATCH=MEDIA_NAME descriptor */
        struct dsc$descriptor QUAL_R_LOCA_NAME; /* /SCRATCH=LOCATION descriptor */
        struct dsc$descriptor QUAL_R_ICART_NAME; /* /CARTRIDGE=NAME descriptor (input) */
        struct dsc$descriptor QUAL_R_ICART_MEDI; /* /CARTRIDGE=MEDIA_NAME descriptor (input) */
        struct dsc$descriptor QUAL_R_OCART_NAME; /* /CARTRIDGE=NAME descriptor (output) */
        struct dsc$descriptor QUAL_R_OCART_MEDI; /* /CARTRIDGE=MEDIA_NAME descriptor (output) */
        struct dsc$descriptor QUAL_R_IDRVCLS_NM; /* /DRIVE_CLASS descriptor (input) */
        struct dsc$descriptor QUAL_R_ODRVCLS_NM; /* /DRIVE_CLASS descriptor (output) */
        unsigned int QUAL_L_ICART_VALU; /* /CARTRIDGE=SIDE value (input)    */
        unsigned int QUAL_L_OCART_VALU; /* /CARTRIDGE=SIDE value (output)   */
        struct EVNTCALBCK *QUAL_A_CALLBACK_ADR; /* routine for handling messages, errors, etc.  */
        unsigned int QUAL_L_CTX_HANDLE; /* BACKUP operation instance identifier */
        unsigned int QUAL_L_DVE_LIMIT;  /* User provided volume expansion size limit */
        unsigned int QUAL_L_DVE_SIZE;   /* User provided logical volume size  */
        unsigned int QUAL_L_IO_LOAD;    /* User provider read AST threads   */
        unsigned int QUAL_L_PROGRESS;   /* User provided progress interval  */
        struct dsc$descriptor QUAL_R_DATA_COMP; /* Descriptor for user specified compression algorithn */
        } qual_block;
/* Qualifier database                                                       */
    struct dsc$descriptor COM_SSNAME;   /* Descriptor for save set name     */
    unsigned short int COM_VALID_TYPES; /* BITVECTOR[16], Bit mask of valid input record types */
    struct  {                           /* Common flags                     */
        unsigned COM_V_EOV : 1;         /* Output save medium is at end     */
        unsigned COM_V_STANDALONE : 1;  /* This is the standalone version   */
        unsigned COM_V_FILESEEN : 1;    /* At least one file processed      */
        unsigned COM_V_VERIFYING : 1;   /* Verify pass in progress          */
        unsigned COM_V_FAIL_RSTRT : 1;  /* Reel restart failed to find file */
        unsigned COM_V_CONTINUE : 1;    /* Continue despite high error rate */
        unsigned COM_V_DSBL_CHKPT : 1;  /* Checkpoint can not be requested  */
/*   since operation is not restartable                                     */
        unsigned COM_V_DSBL_RSTRT : 1;  /* Checkpoint was requested while   */
/*   DSBL_CHKPT was set                                                     */
        unsigned COM_V_INTERACT : 1;    /* SYS$COMMAND is a terminal        */
        unsigned COM_V_TAPE_CACHE : 1;  /* Caching tape drive               */
        unsigned COM_V_SEEN_FILE_OR_VBN : 1; /* Flag to say that we have built a file-header. */
        unsigned COM_V_SAV_SAV : 1;     /* Save-set to save-set copy requested */
        unsigned COM_V_ERROR_IN_PROG : 1; /* Note that error recovery is in progress */
        unsigned COM_V_MME_EXISTS : 1;  /* An MME subsystem is defined/running */
        unsigned COM_V_LABEL_OVERWRITE : 1; /* First tape_volume label overwrite needed. */
        unsigned COM_V_SS_EOV : 1;      /* Started Saveset in EOT/EOV region. */
        } FLAGS;
    unsigned short int COM_BUFF_COUNT;  /* Count of buffers in pool         */
    unsigned short int COM_TOTAL_BUFF;  /* Count of buffers allowed.        */
    unsigned short int COM_SIMULT_BUFF; /* Number of buffers in read pass.  */
    unsigned char COM_I_SETCOUNT;       /* Input volume set count           */
    unsigned char COM_O_SETCOUNT;       /* Output volume set count          */
    unsigned char COM_I_STRUCNAME [12]; /* Input volume set name            */
    unsigned int COM_O_BSRDATE [2];     /* Date of backup from summary record */
    unsigned char COM_O_STRUCNAME [12]; /* Output volume set name           */
    unsigned char ALT_SSNAME [32];      /* Storage for alternate save set name */
    unsigned char INPUT_FUNC;           /* IO$_READVBLK or IO$_READLBLK     */
    unsigned char INPUT_RTYPE;          /* BRH$K_VBN or BRH$K_LBN           */
    unsigned char OUTPUT_FUNC;          /* IO$_WRITEVBLK or IO$_WRITELBLK   */
    unsigned char FAST_STRUCLEV;        /* Structure level of input volume set */
    unsigned char SEARCH_BI_ACE [50];   /*BBLOCK[ACE$S_RMSJNL],                */
/* Block to hold the rms BI journal ACE.                                    */
    unsigned char SEARCH_AI_ACE [50];   /*BBLOCK[ACE$S_RMSJNL],             */
/* Block to hold the rms AI journal ACE.                                    */
    union  {
        unsigned int COM_L_FLAGS2;      /* Common flags 2                   */
        struct  {
            unsigned COM_V_CVT_REST_ODS5_ODS2 : 1; /* Restore Convert of ODS-5 Filenames to ODS-2 */
            unsigned COM_V_CVT_SAVE_ODS5_ODS2 : 1; /* Save Convert of ODS-5 Filenames to ODS-2 */
            unsigned COM_V_CVT_SAVE_SKIP_SYSLOST : 1; /* Device Desc is a concealed logical so skip SYSLOST */
            unsigned COM_V_SNAPDISK : 1; /* Input device is SnapDisk [SD$]  */
/*   (use [SD$] BACKUP date for comparisions)                               */
            unsigned COM_V_MTD_SUPPORTED : 1; /* MTD device detected.       */
            unsigned COM_V_DO_MME_END : 1; /* Must do MME clean-up          */
            unsigned COM_V_HARDLINKS : 1; /* Volume HARDLINK status         */
            unsigned COM_V_ODISK_FOREIGN : 1; /* Ouput disk is mounted foreign */
            unsigned COM_V_ODISK_DFS : 1; /* Ouput disk is a DFS device     */
            unsigned COM_V_WR_DATA_TS : 1; /* In write data tape state      */
            unsigned COM_V_FILL_73_ : 6;
            } COM_R_FILL_53_;
        } FILL_52_;
    int *FIRST_BCB;                     /* First BCB after EOV is detected. */
    unsigned int PHYS_EOV_IN_PROG;      /* INITIAL(0),   ! Indate end of volume on physical save */
    unsigned int EXH_FINAL_STATUS;      /* INITIAL(0),   ! Exit handler's final status value */
    unsigned int INPUT_CHAN;            /* Input channel                    */
    union  {
        unsigned int INPUT_L_FLAGS;     /* Input flag bits                  */
        struct  {
            unsigned INPUT_V_OPEN : 1;  /* Input file is open               */
            unsigned INPUT_V_EOV_IN_PROG : 1; /* EOV processing in progress */
            unsigned INPUT_V_EOV_SAVING : 1; /* SAVE_BLOCKS in progress     */
            unsigned INPUT_V_ON_RVN : 1; /* Blocks exist on RVN selected by */
/*    /VOLUME qualifier                                                     */
            unsigned INPUT_V_IGNO_INTE : 1; /* Ignore file access conflict  */
            unsigned INPUT_V_SAVE_OK : 1; /* No errors occurred during save */
            unsigned INPUT_V_WILDSAVE : 1; /* Wild card save set given      */
            unsigned INPUT_V_REWOUND : 1; /* Input tape rewound for wildcards */
            unsigned INPUT_V_SSFOUND : 1; /* Input save set found (only for wildcards) */
            unsigned INPUT_V_ALIAS : 1; /* Input file is an alias entry     */
            unsigned INPUT_V_SPAN_OVER : 1; /* Tape span-over               */
            unsigned INPUT_V_INPUT_PHASE : 1; /* Input phase                */
            unsigned INPUT_V_BSR_FOUND : 1; /* Indication for BSR found     */
            unsigned INPUT_V_COMPRESS_BCB_PRESENT : 1; /* Bit that controls reading of next compressed BCB from disk */
            unsigned INPUT_V_FILL_74_ : 2;
            } INPUT_R_FILL_55_;
        } FILL_54_;
    int *INPUT_FAB;                     /* Pointer to input FAB             */
    int *INPUT_NAML;                    /* Pointer to input NAML block      */
    struct BCBBLK *INPUT_BCB;           /* Pointer to input BCB             */
    struct QUALPVB *INPUT_QUAL;         /* Pointer to input qualifiers block */
    struct BADBLK *INPUT_BAD;           /* Pointer to input bad block data  */
    unsigned int INPUT_BLOCK;           /* Current input block number       */
    unsigned int INPUT_MAXBLOCK;        /* Maximum input block number       */
    struct dsc$descriptor INPUT_NAMEDESC; /* Descriptor for input file name */
    unsigned char INPUT_STATBLK [8];    /* Statistics block                 */
    unsigned int INPUT_CREDATE [2];     /* Creation date                    */
    unsigned int INPUT_REVDATE [2];     /* Revision date                    */
    unsigned int INPUT_EXPDATE [2];     /* Expiration date                  */
    unsigned int INPUT_BAKDATE [2];     /* Backup date                      */
    unsigned int INPUT_ACCDATE [2];     /* ODS5, Access date                */
    unsigned int INPUT_ATTDATE [2];     /* ODS5, Attribute change date      */
    unsigned char INPUT_EX_RECATTR [8];
/* ODS5, Extended RMS record attributes                                     */
    unsigned char INPUT_LENGTH_HINT [16];
/* (NT/FAT) File length hint                                                */
    unsigned int INPUT_MEDIA_ID;        /* Media id of input device         */
    unsigned char INPUT_FILEOWNER [4];  /* File owner UIC                   */
    unsigned char INPUT_FILECHAR [4];   /* File characteristics             */
    unsigned char INPUT_RECATTR [32];   /* Record attributes                */
    unsigned short int INPUT_LINKCOUNT; /* ODS5 (hard) link count           */
    unsigned short int INPUT_FILLER;    /* filler                           */
    struct INPROCBLK *INPUT_PROC_LIST;  /* List of processed file ID's      */
    struct PLCBLK *INPUT_PLACEMENT [2]; /* List head for placement data     */
    struct VBNBLK *INPUT_VBN_LIST [2];  /* List head for VBN data           */
    unsigned short int INPUT_PLACE_LEN; /* Length of placement data as attribute */
    unsigned short int fill_input_blk;  /* Filler, longword alignment       */
    unsigned int INPUT_EXPSIZE;
    unsigned int OUTPUT_CHAN;           /* Output channel                   */
    union  {
        unsigned short int OUTPUT_W_OUTPUT_FLAGS; /* Output flag bits       */
        struct  {
            unsigned OUTPUT_V_OPEN : 1; /* Output file is open              */
            unsigned OUTPUT_V_FIRST : 1; /* Verifying first block           */
            unsigned OUTPUT_V_LAST : 1; /* Verifying last block             */
            unsigned OUTPUT_V_INCR_DIR : 1; /* Special /INCREMENTAL directory scan */
            unsigned OUTPUT_V_IMPLICIT : 1; /* Output file implicitly opened */
            unsigned OUTPUT_V_ACL_ERROR : 1; /* Error occurred processing ACL */
            unsigned OUTPUT_V_ACL_FIRST_TIME : 1; /* First time through processing ACL */
            unsigned OUTPUT_V_DIR_OPEN : 1; /* An output directory is open  */
            unsigned OUTPUT_V_NONSEQ_IN : 1; /* Input saveset is not sequential */
            unsigned OUTPUT_V_SKIP_ALIAS : 1; /* Skip current [alias] file for output */
            unsigned OUTPUT_V_ALIAS_OPEN : 1; /* Skip current [alias] file for output */
            unsigned OUTPUT_V_FILL_75_ : 5;
            } OUTPUT_R_FILL_57_;
        } FILL_56_;
    unsigned short int fill_output_flgs2; /* Filler, longword alignment     */
    int *OUTPUT_FAB;                    /* Pointer to output FAB            */
    int *OUTPUT_NAML;                   /* Pointer to output NAML block     */
    struct BCBBLK *OUTPUT_BCB;          /* Pointer to output BCB            */
    struct QUALPVB *OUTPUT_QUAL;        /* Pointer to output qualifiers block */
    struct BADBLK *OUTPUT_BAD;          /* Pointer to output bad block data */
    unsigned int OUTPUT_BLOCK;          /* Current output block number      */
    unsigned int OUTPUT_MAXBLOCK;       /* Maximum output block number      */
    union  {
        unsigned int DGMQ_OUTPUT_DEVGEOM [2]; /* Output device geometry     */
        struct  {
            unsigned char DGM_SECTORS;  /* DIB$B_SECTORS                    */
            unsigned char DGM_TRACKS;   /* DIB$B_TRACKS                     */
            unsigned short int DGM_CYLINDERS; /* DIB$W_CYLINDER             */
            unsigned int DGM_MAXBLOCK;  /* DIB$L_MAXBLOCK                   */
            } DGMR_FILL_59_;
        } FILL_58_;
    unsigned char OUTPUT_ATTBUF [192];  /*BBLOCK[ATTBUF_LENGTH],	! Values from attribute record */
    struct VIDHDR *OUTPUT_VID_LIST;     /* List of processed volume ID's    */
    unsigned int OUTPUT_INDEX_EFBLK;    /* Where in INDEXF the EFBLK should be, if /NOINIT was selected */
    unsigned int OUTPUT_GPT_BOOTADDR;   /* LBN of EFI/GPT boot partition file */
    unsigned int OUTPUT_GPT_BOOTSIZE;   /* EFI/GPT boot partition file size */
    unsigned int OUTPUT_GPT_DIAGADDR;   /* LBN of EFI/GPT diagnostic partition file */
    unsigned int OUTPUT_GPT_DIAGSIZE;   /* EFI/GPT diagnostic partition file size */
    unsigned int LIST_TOTFILES;         /* Listing -- total files           */
    unsigned int LIST_TOTSIZE;          /* Listing -- total size            */
    int *VERIFY_FC;                     /* Pointer to verification File Context (FC) */
    unsigned int VERIFY_USE_COUNT;      /* Use count for current VERIFY_QUAL */
    struct QUALPVB *VERIFY_QUAL;        /* Corresponding input qualifier block */
    struct BCBBLK *COMPARE_BCB;         /* BCB for compare buffer           */
    int *FAST_BUFFER;                   /* Pointer to index file buffer     */
    unsigned int FAST_BUFFER_SIZE;      /* Size of index file buffer        */
    unsigned char FAST_RVN;             /* RVN of current MFD               */
    unsigned char FAST_SCANNING;        /*                                  */
    unsigned short int DIR_VERLIMIT;    /* File version limit               */
    int *FAST_IMAP_SIZE;                /* Number of blocks in index file bitmap */
    int *FAST_IMAP;                     /* Bitmap of valid and selected files */
    int *FAST_HDR_OFFSET;               /* VBN offset to file header        */
    int *FAST_BOOT_LBN;                 /* LBN of 1st boot file             */
    int *FAST_BOOT_LBN2;                /* LBN OF 2nd boot file             */
    int *FAST_GPT_PRESENT;              /* TRUE if Itanium/EFI/GPT on input volume */
    int *FAST_GPT_BOOT_LBN;             /* LBN of EFI/GPT boot partition file */
    int *FAST_GPT_DIAG_LBN;             /* LBN of EFI/GPT diagnostic partition file */
    struct PFL *CURRENT_PFL;            /* Current PFL for file scan/map.   */
    struct PFL *PFL_LIST;               /* Header for file data.            */
    union  {
        unsigned char MAP_B_PHASE;      /* Bit mask to indicate start of mapping phase */
        struct  {
            unsigned MAP_V_JOURNAL_ENTRY : 1; /* Offset into NEW_MAP_PHASE  */
            unsigned MAP_V_LOST_FILES : 1; /* Processing lost files - NEW_MAP_PHASE */
            unsigned MAP_V_FILL_76_ : 6;
            } MAP_R_FILL_61_;
        } FILL_60_;
    unsigned char fill_phase_flgs2 [3]; /* Filler, longword alignment       */
    struct VVM *VVM_LIST [2];           /* VVM listhead.                    */
    struct VVM *VVM_FREE_LIST [2];      /* Listhead of free VVMs.           */
    unsigned int VVM_LBN_HEADER;        /* VVM list - LBN pointer.          */
    unsigned int MEGA_BUFFER_SUPPORT;   /* The output device is capable of  */
    unsigned int CLEAR_ASTLM_DELTA [2];
/*  handling the new buffer scheme.                                         */
    unsigned char *JOUR_BUFFER;         /* Journal buffer                   */
    char *JOUR_DIR;                     /* Current directory string         */
    unsigned int JOUR_HIBLK;            /* Highest allocated block          */
    unsigned int JOUR_EFBLK;            /* End of file block                */
    unsigned int JOUR_INBLK;            /* Current input block              */
    unsigned short int JOUR_DIR_POS;    /* Offset in JOUR_DIR for segmented  */
/* directory names                                                          */
    unsigned short int JOUR_FFBYTE;     /* End of file byte                 */
    unsigned short int JOUR_INBYTE;     /* Current input byte               */
    unsigned short int JOUR_STRUCT_LEV; /* Current journal struture level   */
    unsigned char JOUR_COUNT;           /* XOR byte count context           */
    unsigned char JOUR_REVERSE;         /* True if reading backward         */
    unsigned short int JOUR_EXSZ;       /* Default file extention size.     */
    int *CHKPT_HIGH_SP;                 /* High value of SP for saved portion */
    int *CHKPT_LOW_SP;                  /* Low value of SP for saved portion */
    int *CHKPT_STACK;                   /* Pointer to save area for stack   */
    int *CHKPT_VARS;                    /* Pointer to save area for variables */
    unsigned int CHKPT_STATUS;          /* Failure status of a re-access    */
    int *CHKPT_LIST [2];                /* Q header of buffers for checkpoint data. */
    int *CHKPT_EOV_DATA [2];            /* Storage for EOV checkpoint context */
    union  {
        unsigned char RESTART_B_IN_PROGRESS; /*BITVECTOR[8], ! Indicates a restart has taken place */
        struct  {
            unsigned RESTART_V_RESTARTING : 1; /* Restart is taking place   */
            unsigned RESTART_V_ON_RVN : 1; /* Restart took place on the RVN */
            unsigned RESTART_V_CLEAR_AST : 1; /* Restarting - must clear AST */
            unsigned RESTART_V_FILL_77_ : 5;
            } RESTART_R_FILL_63_;
        } FILL_62_;
    unsigned char PARTIAL_MAPPING;      /* Signal partial mapping after restart  */
    unsigned short int fill_pmap_flg2;  /* Filler, longword alignment       */
    unsigned int DIR_CHAN;              /* Channel assigned to device       */
    int *DIR_NAML;                      /* Pointer to name block            */
    struct dsc$descriptor DIR_SEL_DIR;  /* Descriptor for selection directory */
    struct dsc$descriptor DIR_SEL_NTV;  /* Descriptor for selection n.t;v   */
    struct dsc$descriptor *DIR_DEV_DESC; /* Descriptor for device           */
    unsigned char DIR_STRUCLEV;         /* Structure level of directory     */
    unsigned short int DIR_LEVELS;      /* Current number of active levels  */
    union  {
        unsigned char DIR_B_FLAGS;      /* Flag bits                        */
        struct  {
            unsigned DIR_V_IMAGE_SCAN : 1; /* Image mode scan               */
            unsigned DIR_V_SCAN_FAILED : 1; /* Previous scan failed         */
            unsigned DIR_V_HARD_STOP : 1; /* Immediate return on terminator */
            unsigned DIR_V_SCANNED_DIRS : 1; /* Return scanned directories  */
            unsigned DIR_V_INITIAL : 1; /* Initial call                     */
            unsigned DIR_V_ROOT_MFD : 1; /* Scan root MFD only              */
            unsigned DIR_V_FILL_78_ : 2;
            } DIR_R_FILL_65_;
        } FILL_64_;
    union  {
        unsigned char D_STAT_B_STATUS;  /* DIR_STATUS - Directory status flags */
        struct  {
            unsigned D_STAT_V_VALID : 1; /* DIR_STATUS is valid             */
            unsigned D_STAT_V_DIR_SEL : 1; /* Directory is selected         */
            unsigned D_STAT_V_SCANNED : 1; /* Directory was scanned         */
            unsigned D_STAT_V_FILE_SEL : 1; /* Files in directory are selected */
            unsigned D_STAT_V_FILL_79_ : 4;
            } D_STAT_R_FILL_67_;
        } FILL_66_;
    unsigned char DIR_FILLER_01 [7];    /* Filler for Quadword Alignment    */
    struct dsc$descriptor DIR_PATH_DESC; /* Current directory path descriptor */
    struct DIRQUEUE *DQE_LIVE_HDR [2];  /* Live directory queue entry list  */
    struct DIRQUEUE *DQE_FREE_HDR [2];  /* Free directory queue entry list  */
    struct DIRQUEUE *DQE_SAVE_PTR;      /* Saved directory queue entry pointer */
    int DIR_SEL_LATEST;                 /* Latest version selector          */
    unsigned int DIR_SCANLIMIT [8];     /* ODS-1 directory scan limits      */
    struct FCE_BLK *FCE_LIVE_HDR [2];   /* Live Filename Conversion Entry list */
    struct FCE_BLK *FCE_FREE_HDR [2];   /* Free Filename Conversion Entry list */
    union  {                            /* File Name Context Flags Overlay. */
        unsigned short int FCE_CTX_FLAGS; /* File's FID.                    */
        union  {
            unsigned short int FCE_W_BIT_FLAGS;
            struct  {
                unsigned FCE_V_HOLD_FRST : 1; /* Hold First Filename's Sorted Order */
                unsigned FCE_V_FILL_80_ : 7;
                } FCE_R_FILL_69_;
            } FILL_68_;
        } FCE_CTX_FLAGS_OVERLAY;
    unsigned short int fce_ctx_fill;    /* Filler                           */
    int *FCE_CONV_CTX;                  /* Filename Conversion Context      */
    struct FCE_BLK *FCE_FRST_PTR;       /* Address of First Conversion Entry for this Directory */
    struct FCE_BLK *FCE_REST_PTR;       /* Address of the Restored Conversion Entry for this Directory */
    struct FCE_BLK *FCE_LAST_PTR;       /* Address of Last Conversion Entry for this Directory */
    struct FCE_BLK *FCE_PREV_LAST_PTR;  /* Address of the Previous Directory's Last FCE Entry */
    unsigned int FCE_SYSLOST_CTR;       /* Filename Conversion SYSLOST counter */
    struct DCE_BLK *DCE_LIVE_HDR [2];   /* Live Directoryname Conversion Entry list */
    struct DCE_BLK *DCE_FREE_HDR [2];   /* Free Directoryname Conversion Entry list */
    union  {                            /* File Name Context Flags Overlay. */
        unsigned short int DCE_CTX_FLAGS; /* File's FID.                    */
        union  {
            unsigned short int DCE_W_BIT_FLAGS;
            struct  {
                unsigned DCE_V_DIRECTORY : 1; /* Directory File Entries being processed */
                unsigned DCE_V_MFD_ISRT : 1; /* MFD has been inserted       */
                unsigned DCE_V_MFD_READ : 1; /* MFD summary has been read   */
                unsigned DCE_V_MFD_CONV : 1; /* MFD contents have been converted */
                unsigned DCE_V_MFD_PCVT : 1; /* MFD contents have been preconverted */
                unsigned DCE_V_FILL_81_ : 3;
                } DCE_R_FILL_71_;
            } FILL_70_;
        } DCE_CTX_FLAGS_OVERLAY;
    unsigned short int dce_ctx_fill;    /* Filler                           */
    struct STABCKMTL *INPUT_MTL;        /* Pointer to input MTL entry       */
    struct STABCKMTL *OUTPUT_MTL;       /* Pointer to output MTL entry      */
    struct STABCKMTL *CURRENT_MTL;      /* Pointer to MTL for current operation */
    struct STABCKVCB *CURRENT_VCB;      /* Pointer to VCB for current operation */
    struct STABWCBHD *CURRENT_WCB;      /* Pointer to WCB for current operation */
    struct dsc$descriptor RESNAME_DESC; /* Descriptor for RSA in STA_DISMOUNT_OU */
    unsigned short int DQF_QUOTA_FID [3]; /* File ID of quota file          */
    unsigned short int fill_dqfquotafid; /* maintain longword alignment     */
    int *DQF_ROOT;                      /* Root of quota table              */
    unsigned int DQF_COUNT;             /* Count of entries in quota table  */
    int *QUEUE_HEADERS [6];             /* Queue headers for:               */
/*	    Allocated disk extents                                          */
/*	    Required extents                                                */
/*	    Used extension file IDs                                         */
    unsigned int SYSDISK_CHAN;          /* Standalone backup system disk channel. */
    int *LOCK_RANGE [2];                /* Pair of addresses for WS lock.   */
    int *ACL_BUFFER;                    /* Pointer to the ACL to save       */
    struct dsc$descriptor ACL_FIB_DESCR; /* FIB descriptor                  */
    unsigned int ACL_LENGTH;            /* Size of the entire ACL           */
    unsigned char ACL_FIB [96];         /*BBLOCK [FIB$C_LENGTH],  FIB storage */
    unsigned int SAVESET_ENCR;          /* flag(s)                          */
    int *CRYP_IN_CONTEXT;               /* Pointer to encrypt context for input ss */
    int *CRYP_OU_CONTEXT;               /* Pointer to output encrypt context */
    int *CRYP_DA_CONTEXT;               /* Pointer to datakey encryption context */
    unsigned char CRYP_AES_DATA_ENCIV [16]; /* Copy of IV for AES encryption of savesets */
    unsigned char CRYP_DATA_ENCIV [8];  /* Copy of IV for encryption of savesets */
    unsigned char CRYP_DATA_CODE [4];   /*BBLOCK [4],	! Saveset encryption algorithm code */
    unsigned char CRYP_DATA_KEY [8];    /*BBLOCK [8] ! Saveset data key     */
    unsigned char CRYP_DATA_IV [8];     /*BBLOCK [8] ! Saveset encryption IV */
    unsigned int CRYP_DATA_CKSM;        /* Checksum for code,key, and iv    */
    char CRYP_AES_DATA_CODE [2];        /*BBLOCK [4],	! Saveset encryption algorithm code */
    unsigned char CRYP_AES_DATA_KEY [32]; /*BBLOCK [32] ! Saveset data key  */
    unsigned char CRYP_AES_DATA_IV [16]; /*BBLOCK [16] ! Saveset encryption IV */
    unsigned int CRYP_AES_DATA_CKSM;    /* Checksum for code,key, and iv    */
    unsigned char CRYP_AES_FILLER [10]; /* Filler to 16 bytes boundry       */
    int *COMPRESS_BUFFER_ADDR;          /* Pointer to the compression buffer */
    int COMPRESS_BUFFER_LEN;            /* Length of compression buffer     */
    unsigned int COMPRESS_ALG;          /* Compression algorithm            */
    unsigned int COMPRESS_BCB_ORG_SIZE; /* BCB size before compression      */
    unsigned int COMPRESS_HEADER;       /* Header already compressed        */
    char *COMPRESS_TMP_BUFFER_ADDR;     /* Pointer to temporary compression buffer */
    char *COMPRESS_INT_BUFFER_ADDR;     /* Pointer to output compression buffer */
    int COMPRESS_TMP_BUFFER_LEN;
    int COMPRESS_INT_BUFFER_LEN;        /* Total length of compressed buffer */
    unsigned char LOST_FILES_RVN;       /* Current RVN for lost files processing */
    unsigned char fill_lostfilervn [3]; /* Maintain longword alignment      */
    unsigned int LOST_FILES_FNUM;       /* Current file number for lost files processing */
    unsigned char INCR_FIB [96];        /*BBLOCK [FIB$C_LENGTH], FIB for wildcarding */
    unsigned char INCR_RESNAME [252];   /*VECTOR[ATR$S_ASCNAME,BYTE], Resultant String */
    unsigned char fill_incrresname [2]; /* Maintain longword alignment      */
    unsigned int INCR_RESNAME_SIZE;     /* Size of entire resultant string  */
    unsigned int INCR_NTS;              /* Size of "name.type" portion      */
    unsigned int INCR_VER;              /* Binary version number            */
    unsigned short int INCR_BACKLINK [3]; /* Backlink                       */
    unsigned short int fill_incrbacklink; /* Maintain longword alignment    */
    unsigned int INCR_FILECHAR;         /* Characteristics of disk file     */
    unsigned int INCR_BAKDATE [2];      /* Backup date                      */
    struct dsc$descriptor INCR_DIR_DEV_DESC; /* Descriptor for special dir. dev. */
    struct dsc$descriptor INCR_DIR_PATH_DESC; /* Descriptor for special dir. */
    unsigned char INCR_HEADER_FILENAME [252];
/*VECTOR[ATR$S_ASCNAME,BYTE], Filename in the header                        */
    struct  {                           /* Incremental processing flags (save and restore) */
        unsigned INCR_V_SKIP_DIR : 1;   /* Skip saveset dir/files           */
        unsigned INCR_V_SAVE_ALL_DIR : 1; /* Save all subdir's/related files of a dir. */
        unsigned INCR_V_DISABLE_SAVE_ALL : 1; /* DISABLE the above flag.    */
        unsigned INCR_v_incr_flags_filler1 : 13; /* longword-align next field */
        } INCR_FLAGS;
    struct VIDHDR *CURRENT_VID;         /* Pointer to VID block being processed */
    unsigned int EXH_CTRL_BLK [4];      /* Exit handler control block       */
    struct  {
        unsigned short int CHK_FLAGS_W_COUNT;
        unsigned CHK_FLAGS_V_F11 : 1;
        unsigned CHK_FLAGS_V_SAV : 1;
        unsigned CHK_FLAGS_V_SAVE_SET : 1;
        unsigned CHK_FLAGS_V_SRCH_LIST : 1;
        unsigned CHK_FLAGS_V_SMFS : 1;  /* True if SMFS device found        */
        unsigned CHK_FLAGS_v_fill_chkflags1 : 3; /* BYTE-align next bit/flag */
        unsigned CHK_FLAGS_V_DRVCLS_MISUSED : 1; /* (formerly CHK_QUALS[CHK_DRVCLS_MISUSED] */
        unsigned CHK_FLAGS_v_fill_chkquals1 : 7; /* Maintain longword alignment */
        } CMDCHKFLG;
    unsigned int MAPPING_NEW_FILE;      /* Begin mapping a new file         */
    unsigned int EXTENT_VBN;            /* Starting VBN of this extent      */
    unsigned int STILL_ADJUSTING;       /* Indicate first pass through mapping pointers */
    unsigned int EXIT_STATUS;           /* Image exit status                */
    unsigned int EOV_XOR_WRITTEN;       /* Note that an XOR block has       */
/* already been written at the                                              */
/* end of volume.                                                           */
    unsigned int OUTSTANDING_WRITE_COUNT; /* INITIAL(0),                    */
/* Count of outstanding writes for non-TMSCP support                        */
    unsigned int UCB_ADDR;              /* address of saveset device's UCB  */
    unsigned int MCB_ADDR;              /* address of MCB for saveset device */
    unsigned int SNAPDISK_BACKUP [2];   /* BACKUP date (returned from sd$getdisk routine) */
/* Store VMSCOMMON.DIR FID                                                  */
    unsigned short int VMSCOMMON_FID_NUM; /* FILE NUMBER                    */
    unsigned short int VMSCOMMON_FID_SEQ; /* FILE SEQUENCE NUMBER           */
    unsigned char VMSCOMMON_FID_RVN;    /* SHORT FORM RVN                   */
    unsigned char VMSCOMMON_FID_NMX;    /* EXTENDED FILE NUMBER             */
    } ;
#define BTC_K_CONSIDER 1                /* Consider a file                  */
#define BTC_K_REJECT 2                  /* Reject a file                    */
#define BTC_K_ALRFAST 3                 /* Already chosen on bitmap.        */
#define BTC_K_MAPPED 4                  /* Mapped by scanner.               */
#define BTC_K_CHOSEN 5                  /* File is now chosen.              */
#define BCK_K_BLOCK_SIZE_MIN 2048
#define BCK_K_BLOCK_SIZE_MAX 65535
#define BCK_K_GROUP_SIZE_MIN 0
#define BCK_K_GROUP_SIZE_MAX 100
#define BCK_K_TAPE_DENS_800 800
#define BCK_K_TAPE_DENS_833 833
#define BCK_K_TAPE_DENS_1600 1600
#define BCK_K_TAPE_DENS_62500 6250
#define BCK_K_VOLUME_NUM_MIN 1
#define BCK_K_VOLUME_NUM_MAX 255
#define BCK_K_IO_LOAD_DEFAULT 8
#define CTRL_T$K_RESTORE_MSG 0
#define CTRL_T$K_SAVE_MSG 1
#define CTRL_T$K_SAVEINACTIVE_MSG 2
#define CTRL_T$K_COMPARE_MSG 3
#define CTRL_T$K_LOGFILE 1
#define COMPRESS$K_DEFLATE 0
#define COMPRESS$K_UNSUPPORTED 1
#define BCK_K_FILE_VERLIMIT_MAX 32767
#define BCK_K_FILCNT_OVERHEAD 10
#define BCK$INPUT_PHASE 1
#define BCK$VERIFY_PHASE 2
#define BCK$POSTPROCESSING_PHASE 3
#define BCK$COMPRESS_HEADER 0
#define BCK$COMPRESS_FIX 1
#define BCK$COMPRESS_VAR 0
#define BCK$COMPRESS_SUMMARY_WRITE 1
#define BCK$COMPRESS_SUMMARY_READ 0
#define BCK$COMPRESS_MAX_ALGO 16
 
#pragma __member_alignment __restore
