! 
! *************************************************************************
! *                                                                       *
! *  Copyright 2010, Hewlett-Packard Development Company, L.P.           *
! *                                                                       *
! * Confidential computer software.  Valid license from HP and/or         *
! * its subsidiaries required for possession, use, or copying.            *
! *                                                                       *
! * Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *
! * Computer Software Documentation, and Technical Data for Commercial    *
! * Items are licensed to the U.S. Government under vendor's standard     *
! * commercial license.                                                   *
! *                                                                       *
! * Neither HP nor any of its subsidiaries shall be liable for technical  *
! * or editorial errors or omissions contained herein.  The information   *
! * in this document is provided "as is" without warranty of any kind and *
! * is subject to change without notice.  The warranties for HP products  *
! * are set forth in the express limited warranty statements accompanying *
! * such products.  Nothing herein should be construed as constituting an *
! * additional warranty.                                                  *
! *                                                                       *
! *************************************************************************
! ********************************************************************************************************************************
!  Created: 30-Mar-2010 17:25:52 by OpenVMS SDL EV3-3      
!  Source:  20-OCT-2009 09:48:38 $1$DGA7274:[BACKUP.SRC]BACKSTRUC.SDL;1 
! ********************************************************************************************************************************
 
!*** MODULE $BCKCOMMON ***
!DEC$ OPTIONS/ALIGN=(RECORDS=PACKED,COMMONS=PACKED)/NOWARN
	CHARACTER*(*) BACKUP$VERSION
	PARAMETER (BACKUP$VERSION = 'V8.4'//CHAR(0))  !  Version number of BACKUP
	PARAMETER BACKUP$K_OPSYS_VAX = '00000400'X  !  Operating system ID
	PARAMETER BACKUP$K_OPSYS_ALPHA = '00000800'X  !  Operating system ID
	PARAMETER BACKUP$K_OPSYS_IA64 = '00001000'X  !  Operating system ID
	PARAMETER BACKUP$K_BACKUP = '00000001'X	 !  Subsystem ID
	PARAMETER BACKUP$K_DATABLOCK = '00000001'X  !  Application ID normal blocks
	PARAMETER BACKUP$K_XORBLOCK = '00000002'X  !  Application ID XOR blocks
	PARAMETER FILESCAN_LOGGING = '00000001'X  !  Turn on (1) or off (0) internal
	PARAMETER TRUE = '00000001'X
	PARAMETER FALSE = '00000000'X
	PARAMETER ANSI_LBLSZ = '00000006'X	 !  ANSI Standard MT label name size
	PARAMETER ANSI_BLKSZ = '00000050'X	 !  ANSI Standard header size
	PARAMETER COPY_BUFF_COUNT = '00000002'X	 !  Default buffer count for disk-to-disk
	PARAMETER COPY_BUFF_SIZE = '00008110'X	 !  Default buffer size for disk-to-disk
	PARAMETER SMALL_DISK = '00001000'X	 !  Largest disk with no bad block data
	PARAMETER LIST_SIZE = '00001000'X	 !  Size of listing line
	PARAMETER JOUR_SIZE = '00001000'X	 !  Size of journal line 
	PARAMETER MAX_RECORD = '00000800'X	 !  Maximum length attribute record
	PARAMETER MAX_ATTRS = '00000014'X	 !  Maximum number of attributes in list
	PARAMETER STA_IN_CHAN = '0001FFFF'X	 !  Pseudo-channel for input
	PARAMETER STA_OUT_CHAN = '0002FFFF'X	 !  Pseudo-channel for output
	PARAMETER MAX_DCL_STRING_SIZE = '00000400'X  !  Max DCL command string size
	PARAMETER STD_PAGE_SIZE = '00000200'X	 !  Standard [VAX] page size (bytes)
	PARAMETER MIN_BUFFER_SPACE = '00001800'X  !  Minimum reasonable buffer size
	PARAMETER NEXT_TRY_BUFF_FACTOR = '00000002'X  !  multiply factor for new buffer size
	PARAMETER D_K_SCANLVLS = '00000008'X	 !  ODS-1 directory levels supported
	PARAMETER MAX_CTRL_STRING_SIZE = '00000100'X  !  Max. FAO control string size
	PARAMETER PFL_M_DIR = '00000001'X
	PARAMETER PFL_M_DESELECT = '00000002'X
	PARAMETER PFL_M_OPEN = '00000004'X
	PARAMETER PFL_M_IGNO_INTE = '00000008'X
	PARAMETER PFL_M_ERROR = '00000010'X
	PARAMETER PFL_M_HEADONLY = '00000020'X
	PARAMETER PFL_M_NOPOST = '00000040'X
	PARAMETER PFL_M_SAVE_ALL = '00000080'X
	PARAMETER PFL_M_F64DIR = '00000100'X
	PARAMETER PFL_M_ALIAS = '00000200'X
	PARAMETER PFL_K_LENGTH = '00000050'X	 !  length of PFL block
	PARAMETER PFL_C_LENGTH = '00000050'X	 !  length of PFL block
	STRUCTURE /PFL/
	    INTEGER*4 PFL_A_RESNAME_PTR		 !  Resultant name pointer
	    INTEGER*4 PFL_A_DIRNAME_PTR		 !  Directory name pointer
	    INTEGER*4 PFL_A_CVT_RESNAME_PTR		 !  Conversion resultant name pointer
	    INTEGER*4 PFL_A_CVT_DIRNAME_PTR		 !  Conversion directory name pointer
	    INTEGER*4 PFL_A_CVT_DIRDATA_PTR		 !  Conversion directory data pointer
 ! *** Note: Old overlay form must be used in FID & DID due to SDL bug
 ! *** that omits the field size symbol in a structured field.
	    UNION
	        MAP
	        INTEGER*2 PFL_W_FID(1:3)		 !  File's FID.
	        END MAP
	        MAP
	            INTEGER*2 PFL_W_FID_NUM			 !  File ID NUM.
	            INTEGER*2 PFL_W_FID_SEQ			 !  File ID SEQ.
	            UNION
	                MAP
	                INTEGER*2 PFL_W_FID_RVNW		 !  File ID RVN & NMX.
	                END MAP
	                MAP
	                    BYTE      PFL_B_FID_RVN			 !  FID RVN.
	                    BYTE      PFL_B_FID_NMX			 !  FID NMX.
	                END MAP
	            END UNION
	        END MAP
	    END UNION
	    UNION
	        MAP
	        INTEGER*2 PFL_W_DID(1:3)		 !  Directory ID.
	        END MAP
	        MAP
	            INTEGER*2 PFL_W_DID_NUM			 !  File ID of directory.
	            INTEGER*2 PFL_W_DID_SEQ			 !  DID sequence number.
	            UNION
	                MAP
	                INTEGER*2 PFL_W_DID_RVNW		 !  RVN.
	                END MAP
	                MAP
	                    BYTE      PFL_B_DID_RVN			 !  RVN byte.
	                    BYTE      PFL_B_DID_NMX			 !  NMX for DID.
	                END MAP
	            END UNION
	        END MAP
	    END UNION
	    INTEGER*2 PFL_W_RESNAME_LEN		 !  Resultant name length
	    INTEGER*2 PFL_W_DIRNAME_LEN		 !  Directory name length
	    INTEGER*2 PFL_W_CVT_RESNAME_LEN		 !  Conversion resultant name length
	    INTEGER*2 PFL_W_CVT_DIRNAME_LEN		 !  Conversion directory name length
	    INTEGER*4 PFL_L_CVT_DIRDATA_LEN		 !  Conversion directory data length
	    INTEGER*4 PFL_L_CHANNEL			 !  Channel for access to file.
	    INTEGER*4 PFL_L_FILESIZE		 !  Size of this file.
	    INTEGER*2 PFL_W_REVISION		 !  FI2$W_REVCNT (for access conflict check)
	    INTEGER*2 PFL_W_S_DATA
	    INTEGER*4 PFL_L_D_UIC			 !  Directory UIC.
	    INTEGER*2 PFL_W_D_FPRO			 !  Directory file protection.
	    INTEGER*2 PFL_W_D_VERLIM		 !  Directory version limit.
	    INTEGER*4 PFL_L_DIR_STATUS		 !  Copy of DIR_STATUS at time of scan.
	    UNION
	        MAP
	        INTEGER*4 PFL_L_FLAGS			 !  PFL flags.
	        END MAP
	        MAP
	            PARAMETER PFL_S_DIR = 1
	            PARAMETER PFL_V_DIR = 0			 !  True for directories.
	            PARAMETER PFL_S_DESELECT = 1
	            PARAMETER PFL_V_DESELECT = 1		 !  File removed from selection.
	            PARAMETER PFL_S_OPEN = 1
	            PARAMETER PFL_V_OPEN = 2		 !  Set if file is open.
	            PARAMETER PFL_S_IGNO_INTE = 1
	            PARAMETER PFL_V_IGNO_INTE = 3		 !  Set if we are to ignore conflicts.
	            PARAMETER PFL_S_ERROR = 1
	            PARAMETER PFL_V_ERROR = 4		 !  Set if there was a read error for the file.
	            PARAMETER PFL_S_HEADONLY = 1
	            PARAMETER PFL_V_HEADONLY = 5		 !  Set if the file's data isn't to be copied.
	            PARAMETER PFL_S_NOPOST = 1
	            PARAMETER PFL_V_NOPOST = 6		 !  Set if error occurred, do not post-process this file.
	            PARAMETER PFL_S_SAVE_ALL = 1
	            PARAMETER PFL_V_SAVE_ALL = 7		 !  Set if [INCR] saving new/renamed dir's files.
	            PARAMETER PFL_S_F64DIR = 1
	            PARAMETER PFL_V_F64DIR = 8		 !  Set if file is a Files-64 directory
	            PARAMETER PFL_S_ALIAS = 1
	            PARAMETER PFL_V_ALIAS = 9		 !  Set if file is an ALIAS file entry.
	        BYTE %FILL (2)
	        END MAP
	    END UNION
	    INTEGER*4 PFL_A_CHKPT_BUF		 !  Pointer to checkpoint data
	    INTEGER*4 PFL_A_ALT_FILENAME		 !  Ptr to alternate filename
	END STRUCTURE	! PFL
	PARAMETER DIRSTAT_M_VALID = '00000001'X
	PARAMETER DIRSTAT_M_DIR_SEL = '00000002'X
	PARAMETER DIRSTAT_M_SCANNED = '00000004'X
	PARAMETER DIRSTAT_M_FILE_SEL = '00000008'X
	STRUCTURE /PFLDIRSTAT/
	    PARAMETER DIRSTAT_S_VALID = 1
	    PARAMETER DIRSTAT_V_VALID = 0		 !  DIR_STATUS is valid
	    PARAMETER DIRSTAT_S_DIR_SEL = 1
	    PARAMETER DIRSTAT_V_DIR_SEL = 1		 !  Directory is selected
	    PARAMETER DIRSTAT_S_SCANNED = 1
	    PARAMETER DIRSTAT_V_SCANNED = 2		 !  Directory was scanned
	    PARAMETER DIRSTAT_S_FILE_SEL = 1
	    PARAMETER DIRSTAT_V_FILE_SEL = 3	 !  Files in directory are selected
	BYTE %FILL (1)
	END STRUCTURE	! PFLDIRSTAT
	PARAMETER VVM_M_EOF = '00000001'X
	PARAMETER VVM_M_EOB = '00000002'X
	PARAMETER VVM_M_ERROR = '00000004'X
	PARAMETER VVM_M_COMPLETE = '00000008'X
	PARAMETER VVM_M_ISSUED = '00000010'X
	PARAMETER VVM_M_F64DIR = '00000020'X
	PARAMETER VVM_K_LENGTH = '00000028'X	 !  length of VVM block
	PARAMETER VVM_C_LENGTH = '00000028'X	 !  length of VVM block
	STRUCTURE /VVM/
	    INTEGER*4 VVM_A_VBN_FLINK		 !  Pointer to next VVM, VBN order.
	    INTEGER*4 VVM_A_LBN_FLINK		 !  Pointer to next VVM, LBN order.
	    INTEGER*4 VVM_L_START_LBN		 !  Starting LBN for read.
	    INTEGER*4 VVM_L_START_VBN		 !  Starting VBN for this extent/read.
	    INTEGER*4 VVM_A_VA			 !  Destination VA of read.
	    INTEGER*4 VVM_A_PFL_PTR			 !  Pointer back to PFL for file data.
	    UNION
	        MAP
	        INTEGER*4 VVM_L_IOSB(1:2)
	        END MAP
	        MAP
	            INTEGER*4 VVM_L_IOSB1
	            INTEGER*4 VVM_L_IOSB2
	        END MAP
	    END UNION
	    INTEGER*4 VVM_L_READ_SIZE		 !  Size of this read.
	    UNION
	        MAP
	        INTEGER*4 VVM_L_FLAGS			 !  Flags for the read status.
	        END MAP
	        MAP
	            PARAMETER VVM_S_EOF = 1
	            PARAMETER VVM_V_EOF = 0			 !  Set if this is the last read for the file.
	            PARAMETER VVM_S_EOB = 1
	            PARAMETER VVM_V_EOB = 1			 !  Set if this read ends a buffer.
	            PARAMETER VVM_S_ERROR = 1
	            PARAMETER VVM_V_ERROR = 2		 !  Set if the read incurred an error.
	            PARAMETER VVM_S_COMPLETE = 1
	            PARAMETER VVM_V_COMPLETE = 3		 !  Set if the QIO completed.
	            PARAMETER VVM_S_ISSUED = 1
	            PARAMETER VVM_V_ISSUED = 4		 !  Set when the QIO is issued.
	            PARAMETER VVM_S_F64DIR = 1
	            PARAMETER VVM_V_F64DIR = 5		 !  Set if file is a Files-64 directory
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	END STRUCTURE	! VVM
	PARAMETER CPD_K_LENGTH = '00000044'X	 !  length of CPD block
	PARAMETER CPD_C_LENGTH = '00000044'X	 !  length of CPD block
	STRUCTURE /CPD/
	    INTEGER*4 CPD_A_FLINK			 !  Pointer to next CPD buffer.
	    INTEGER*4 CPD_A_BLINK			 !  Pointer to last CPD buffer.
	    INTEGER*4 CPD_L_INPUT_CHAN		 !  Current input channel
	    INTEGER*4 CPD_A_PROC_LIST		 !  Ptr to INPUT_PROC_LIST
	    INTEGER*4 CPD_L_DIR_SCANLIMIT(1:8)	 !  Directory queue context
	    INTEGER*4 CPD_A_INPUT_QUAL		 !  Pointer to input qualifier list
	    INTEGER*4 CPD_L_FASTBUF_SIZE		 !  Fast buffer size
	    INTEGER*2 CPD_W_COM_FLAGS		 !  Current common flags
	    INTEGER*2 CPD_W_INPUT_FLAGS		 !  Current input file flags
	    BYTE      CPD_B_FAST_STRUCLEV		 !  Structure level for fast backup
	    BYTE      CPD_B_FAST_RVN		 !  Current RVN 
	    BYTE      CPD_B_SETCOUNT		 !  Number of volumes in set
	    BYTE      CPD_B_LOST_RVN		 !  Current RVN of lost file processing
	    INTEGER*4 CPD_L_LOST_FILENUM		 !  File number of lost file processing
	END STRUCTURE	! CPD
	PARAMETER FC_S_AREA = '00002284'X
	STRUCTURE /BCK$FC/
	    BYTE      FC_FAB(1:80)
	    BYTE      FC_RAB(1:68)
	    BYTE      FC_NAML(1:248)
	    BYTE      FC_RLF(1:248)
	    BYTE      FC_EXPNAME(1:4096)
	    BYTE      FC_RESNAME(1:4096)
	END STRUCTURE	! BCK$FC
 ! 
 !   Qualifier Parameter Value Block
 ! 
	PARAMETER QUAL_S_OUTP = '00000034'X	 !  Output Parameter Block size
	PARAMETER QUAL_S_INPU = '00000044'X	 !  Input Parameter Block size
	STRUCTURE /QUALPVB/
	    INTEGER*4 QUAL_NEXT			 !  Pointer to next parameter block (common to all)
	    INTEGER*4 QUAL_PARA_FC			 !  Parameter file context
	    RECORD /dsc$descriptor/ QUAL_EXP_DESC	 !  Descriptor for expanded string
	    RECORD /dsc$descriptor/ QUAL_DEV_DESC	 !  Descriptor for device portion only
	    RECORD /dsc$descriptor/ QUAL_DVI_DESC	 !  Descriptor for NAML$T_DVI string
	    RECORD /dsc$descriptor/ QUAL_LNM_DESC	 !  Descriptor for volume logical name
	    RECORD /dsc$descriptor/ QUAL_ALT_DESC	 !  Descriptor for alternate name
 !  ( the rename for the file )
	    INTEGER*4 QUAL_ALLOC_CHAN		 !  Device allocation channel
	    INTEGER*4 QUAL_DEVCHAR2			 !  Second longword for device char
	    INTEGER*4 QUAL_USE_COUNT		 !  Count of input files from this spec
	    INTEGER*4 QUAL_USE_CHKPT		 !  Cell to checkpoint QUAL_USE_COUNT
	    PARAMETER QUALS_PAR_FLAGS = 32
	    PARAMETER QUALV_PAR_FLAGS = 512
	    BYTE %FILL (4)				 !  Input/Output Parameter Flags
	END STRUCTURE	! QUALPVB
	PARAMETER PFLAGS_M_DEV_MOU = '00000001'X
	STRUCTURE /BCKCOMMON$$FILL_7_/
	UNION
	    MAP
	    INTEGER*4 %FILL
	    END MAP
	    MAP
	        PARAMETER PFLAGS_S_DEV_MOU = 1
	        PARAMETER PFLAGS_V_DEV_MOU = 0		 !  [STABACKUP] device mounted
 !  (Used for /LIST of *.* tape savesets.)
	    BYTE %FILL (1)
	    END MAP
	END UNION
	END STRUCTURE	! BCKCOMMON$$FILL_7_
 ! 
 !   Encrypt Key [Parameter] Value Block
 ! 
	PARAMETER QUAL_S_ENCV = '0000000C'X	 !  Encrypt value list item
	STRUCTURE /ENCPVB/
	    INTEGER*4 QUAL_ENVA_LINK		 !  Link word - Encrypt key value 
	    RECORD /dsc$descriptor/ QUAL_ENVA_DESC	 !  Value string descriptor - Encrypt key value
	END STRUCTURE	! ENCPVB
 ! 
 !   Exclude Parameter Value Block
 ! 
	PARAMETER QUAL_S_EXCL = '0000000C'X	 !  Exclude value list item size
	STRUCTURE /EXCLPVB/
	    INTEGER*4 QUAL_EXCL_NEXT		 !  Pointer to next parameter block (common to all)
	    RECORD /dsc$descriptor/ QUAL_EXCL_DESC	 !  /EXCLUDE value
	END STRUCTURE	! EXCLPVB
 ! 
 !   Select Parameter Value Block
 ! 
	PARAMETER QUAL_S_SELE = '00000014'X	 !  Select value list item size
	STRUCTURE /SELEPVB/
	    INTEGER*4 QUAL_SELE_NEXT		 !  Pointer to next parameter block (common to all)
	    RECORD /dsc$descriptor/ QUAL_SELE_DESC	 !  /SELECT value
	    RECORD /dsc$descriptor/ QUAL_OUTPUT_DESC  !  the output file name
	END STRUCTURE	! SELEPVB
 ! 
 !   Label Parameter Value Block
 ! 
	PARAMETER QUAL_S_LABE = '00000010'X	 !  Label value list item size
	STRUCTURE /LABEPVB/
	    INTEGER*4 QUAL_LABE_NEXT		 !  Pointer to next parameter block (common to all)
	    RECORD /dsc$descriptor/ QUAL_LABE_VALUE	 !  /LABEL value
	END STRUCTURE	! LABEPVB
 ! 
 !   Format of Bad Block Descriptor [Header] returned by routine GET_BADBLOCKS.
 ! 
	PARAMETER BAD_S_HEADER = '00000008'X
	STRUCTURE /BADBLK/
	    INTEGER*4 BAD_NUMDESC			 !  Number of descriptors
	    INTEGER*4 BAD_SERIAL			 !  Pack serial number
	    INTEGER*4 BAD_DESC(2)			 !  Origin of descriptors
	END STRUCTURE	! BADBLK
 ! 
 !   Bad Block Descriptor
 ! 
	PARAMETER BAD_S_DESC = '00000008'X
	STRUCTURE /BADBDSC/
	    INTEGER*4 BAD_LBN			 !  LBN
	    INTEGER*4 BAD_COUNT			 !  Count
	END STRUCTURE	! BADBDSC
 ! 
 !  MAX Number of FID/DID entries in an input_proc_list block.
 ! 
	PARAMETER REC_MAX_COUNT = '00000040'X
 ! 
 !   PROCESSED FILE ID LIST ( INPUT_PROC_LIST ) Entry 
 ! 
	PARAMETER REC_M_BADVER = '00000001'X
	PARAMETER REC_M_NOBACK = '00000002'X
	PARAMETER REC_M_FOPEN = '00000004'X
	PARAMETER REC_M_ACCESS = '00000008'X
	PARAMETER REC_S_PROC_FILE = '0000000D'X	 !  The length of a FID/DID/FLAGS entry
	STRUCTURE /INPROCBLK/
	    UNION
	        MAP
	        BYTE      %FILL
	        END MAP
	        MAP
	            PARAMETER REC_S_BADVER = 1
	            PARAMETER REC_V_BADVER = 0		 !  Flag to say verification pass failed
	            PARAMETER REC_S_NOBACK = 1
	            PARAMETER REC_V_NOBACK = 1		 !  Flag to say file marked NOBACKUP
	            PARAMETER REC_S_FOPEN = 1
	            PARAMETER REC_V_FOPEN = 2		 !  Flag to say file open (write access)
	            PARAMETER REC_S_ACCESS = 1
	            PARAMETER REC_V_ACCESS = 3		 !  Flag to say file access conflict
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    INTEGER*2 REC_RECFID(1:3)		 !  File ID
	    INTEGER*2 REC_RECDID(1:3)		 !  Directory ID
	END STRUCTURE	! INPROCBLK
 ! 
 !   PROCESSED FILE ID LIST  ( INPUT_PROC_LIST )
 ! 
	PARAMETER REC_S_ENTRY = '0000034C'X
	STRUCTURE /INPROCLST/
	    INTEGER*4 REC_NEXT			 !  Pointer to next block
	    INTEGER*4 REC_QUAL			 !  Value of INPUT_QUAL for this block
	    INTEGER*2 REC_USED			 !  Count of used entries in this block
	    INTEGER*2 REC_VOLUME			 !  Volume number
	    INTEGER*4 REC_FID_BASE			 !  Base of FID/DID entries
	END STRUCTURE	! INPROCLST
 ! 
 ! 		Processed Volume ID (LABEL) List
 ! 
 ! 	Field definitions for structure pointed to by OUTPUT_VID_LIST.
 ! 
 ! 	The Volume ID list (VID) maintains the label/name of each volume in
 ! 	an output saveset (or tape volume set if you prefer) as it is
 ! 	processed.  This allows MME routines to lookup a file's volume Id
 ! 	based on the volume's number as stored in the FID structures defined
 ! 	in the Processed File ID List (i.e. REC_VOLUME).  The VID consists of
 ! 	a singly-linked list of VID blocks.  Each block contains several
 ! 	slots of 12 characters, each containing a volume Id string (except
 ! 	for the last slot which is used as a header/control entry).
 ! 
 ! 	Additional details about the use of the VID list can be found in
 ! 	module SAVE.B32.
 ! 
 ! 	VID_ENTRY is the normal, 12 character volume (label) Id.  The other
 ! 	fields define a remapping of VID_ENTRY as the header/control entry.
 ! 
	STRUCTURE /VIDENT/
	    BYTE      VID_ENTRY(1:12)		 !  normal VID entry (12 bytes)
	END STRUCTURE	! VIDENT
	PARAMETER VID_S_ENTRY = '0000000C'X	 !  size, in bytes, of an entry/slot
	STRUCTURE /VIDHDR/
	    INTEGER*4 VID_NEXT			 !  pointer to next VID block
	    BYTE      VID_BLKN			 !  VID block number (0-255)
	    BYTE      VID_MBZ_1(1:3)		 !  reserved...mbz (padding)
	    INTEGER*4 VID_MBZ_2			 !  reserved...mbz (padding)
	END STRUCTURE	! VIDHDR
	PARAMETER VID_K_BASIS = '00000010'X	 !  modulo base
	PARAMETER VID_K_SLOTS = '00000011'X	 !  number of slots per VID block
	PARAMETER VID_S_BLOCK = '000000CC'X	 !  size, in bytes, of a VID block
	PARAMETER BCB_S_IDLE = '00000000'X	 !  idle
	PARAMETER BCB_S_READ = '00000001'X	 !  read operation pending
	PARAMETER BCB_S_WRITE = '00000002'X	 !  write operation pending
	PARAMETER BCB_S_DATA = '00000003'X	 !  holding data, no I/O pending
	PARAMETER BCB_S_REREAD = '00000004'X	 !  read on alternate channel
	PARAMETER BCB_DATA_TYPE = '00000000'X	 !  Data (normal) type
	PARAMETER BCB_XOR_TYPE = '00000001'X	 !  XOR type
	PARAMETER BCB_FLAGS_START = '0000002C'X	 !  offset used to init. flags
	PARAMETER BCB_M_WRITE_ISSUED = '00000001'X
	PARAMETER BCB_M_WRITE_REISSUED = '00000002'X
	PARAMETER BCB_M_WRITE_SYNCH = '00000004'X
	PARAMETER BCB_M_EIP_EOV = '00000008'X
	PARAMETER BCB_M_ASSOC_VREAD = '00000010'X
	PARAMETER BCB_M_FINAL_XOR = '00000020'X
	PARAMETER BCB_M_NEW_PASS = '00000040'X
	PARAMETER BCB_M_ENCRYPT = '00000080'X
	PARAMETER BCB_FLAGS_K_LENGTH = '00000004'X
	PARAMETER BCB_LENGTH = '00000040'X	 !  length of buffer control block
	STRUCTURE /BCBBLK/
	    INTEGER*4 BCB_FLINK			 !  queue forward link
	    INTEGER*4 BCB_BLINK			 !  queue back link
	    INTEGER*2 BCB_SIZE			 !  buffer size
	    BYTE      BCB_STATE			 !  buffer state
	    BYTE      BCB_TYPE			 !  Purpose (XOR, data)
	    INTEGER*4 BCB_BUFFER			 !  buffer address
	    INTEGER*4 BCB_RECORD			 !  current record pointer
	    INTEGER*4 BCB_BLOCKNUM			 !  disk block number
	    UNION
	        MAP
	        INTEGER*2 BCB_IOSB(1:4)			 !  I/O status block (base)
	        END MAP
	        MAP
	            INTEGER*4 BCB_STATUS			 !  I/O status longword
	            INTEGER*4 BCB_STATUS2			 !  second I/O status longword
	        END MAP
	        MAP
	            INTEGER*2 BCB_IO_STATUS			 !  I/O status word
	            INTEGER*2 BCB_IO_BCOUNT			 !  I/O status byte count
	            INTEGER*4 BCB_IOSBWBLK_filler
	        END MAP
	    END UNION
	    INTEGER*4 BCB_WRITE_FUNC		 !  Write function for
 !  asynch writes
	    INTEGER*4 BCB_SUCC_ACT			 !  success action routine
	    INTEGER*4 BCB_FAIL_ACT			 !  failure action routine
	    UNION
	        MAP
	        INTEGER*4 %FILL				 !  flags
	        END MAP
	        MAP
	            PARAMETER BCB_S_WRITE_ISSUED = 1
	            PARAMETER BCB_V_WRITE_ISSUED = 0	 !  Flag to indicate write was successfully issued
	            PARAMETER BCB_S_WRITE_REISSUED = 1
	            PARAMETER BCB_V_WRITE_REISSUED = 1	 !  Error write reissued
	            PARAMETER BCB_S_WRITE_SYNCH = 1
	            PARAMETER BCB_V_WRITE_SYNCH = 2		 !  Perform the write synchronously
	            PARAMETER BCB_S_EIP_EOV = 1
	            PARAMETER BCB_V_EIP_EOV = 3		 !  Do not reissue from ast level during error processing
	            PARAMETER BCB_S_ASSOC_VREAD = 1
	            PARAMETER BCB_V_ASSOC_VREAD = 4		 !  At least one virtual read is associated with this 
	            PARAMETER BCB_S_FINAL_XOR = 1
	            PARAMETER BCB_V_FINAL_XOR = 5		 !  This is the final XOR BCB for the volume
	            PARAMETER BCB_S_NEW_PASS = 1
	            PARAMETER BCB_V_NEW_PASS = 6		 !  Start of a new file scan pass
	            PARAMETER BCB_S_ENCRYPT = 1
	            PARAMETER BCB_V_ENCRYPT = 7
	            BYTE %FILL (1)				 !  Flag to indicate buffer is encrypted
	        END MAP
	    END UNION
 !  The following constant definition is required because the FLAGS structure 
 !  and its length are not otherwise declared by SDL.
 ! 
	    INTEGER*4 BCB_FIRST_PFL			 !  Pointer to first associated PFL
	    INTEGER*4 BCB_LAST_PFL			 !  Pointer to last associated PFL
	    INTEGER*4 BCB_START_VBN			 !  Starting VBN of first file represented in buffer
	    INTEGER*4 BCB_NEXT_VBN			 !  VBN of first file in next buffer
	END STRUCTURE	! BCBBLK
	PARAMETER BSR_LENGTH = '000000D0'X	 !  Length of BSR area
	STRUCTURE /BSRBLK/
	    RECORD /dsc$descriptor/ BSR_SSNAME	 !  Descriptor for SSNAME
	    RECORD /dsc$descriptor/ BSR_COMMAND	 !  Descriptor for COMMAND
	    RECORD /dsc$descriptor/ BSR_COMMENT	 !  Descriptor for COMMENT
	    RECORD /dsc$descriptor/ BSR_USERNAME	 !  Descriptor for USERNAME
	    INTEGER*4 BSR_DATE(2)			 !  Value of DATE
	    RECORD /dsc$descriptor/ BSR_SYSVER	 !  Descriptor for SYSVER
	    RECORD /dsc$descriptor/ BSR_NODENAME	 !  Descriptor for NODENAME
	    RECORD /dsc$descriptor/ BSR_DRIVEID	 !  Descriptor for DRIVEID
	    RECORD /dsc$descriptor/ BSR_BACKVER	 !  Descriptor for BACKVER
	    RECORD /dsc$descriptor/ BSR_VOLSETNAM	 !  Descriptor for VOLSETNAM
	    INTEGER*4 BSR_BACKSIZE(2)		 !  Value of BACKSIZE
	    INTEGER*4 BSR_USERUIC			 !  Value of USERUIC
	    INTEGER*4 BSR_SIR			 !  Value of SIR
	    INTEGER*4 BSR_BLOCKSIZE			 !  Value of BLOCKSIZE
	    INTEGER*4 BSR_BACKFILES			 !  Value of BACKFILES
	    INTEGER*2 BSR_OPSYS			 !  Value of OPSYS
	    INTEGER*2 BSR_XORSIZE			 !  Value of XORSIZE
	    INTEGER*2 BSR_BUFFERS			 !  Value of BUFFERS
	    INTEGER*2 BSR_NVOLS			 !  Value of NVOLS
	    BYTE      BSR_CRYPTDATA(1:24)		 !  Value of CRYPTDATA
	    BYTE      BSR_CRYPTAESDATA(1:64)	 !  Value of CRYPTDATA for AES
	    RECORD /dsc$descriptor/ BSR_COMPRESSALGO  !  Descriptor for COMPRESSALGO  
	END STRUCTURE	! BSRBLK
	PARAMETER VSR_LENGTH = '00000076'X	 !  Length of VSR area
	STRUCTURE /VSRBLK/
	    RECORD /dsc$descriptor/ VSR_VSRVOLNAME	 !  Descriptor for VOLNAME
	    RECORD /dsc$descriptor/ VSR_OWNERNAME	 !  Descriptor for OWNERNAME
	    RECORD /dsc$descriptor/ VSR_FORMAT	 !  Descriptor for FORMAT
	    INTEGER*4 VSR_VOLDATE(2)		 !  Value of VOLDATE
	    INTEGER*4 VSR_TOTSIZE(2)		 !  Value of TOTSIZE
	    INTEGER*4 VSR_VOLOWNER			 !  Value of VOLOWNER
	    INTEGER*4 VSR_VOLSIZE			 !  Value of VOLSIZE
	    INTEGER*4 VSR_TOTFILES			 !  Value of TOTFILES
	    INTEGER*4 VSR_MAXFILES			 !  Value of MAXFILES
	    INTEGER*4 VSR_MAXFILNUM			 !  Value of MAXFILNUM
	    INTEGER*4 VSR_SERIALNUM			 !  Value of SERIALNUM
	    UNION
	        MAP
	        INTEGER*2 VSR_VOLSTRUCT			 !  Value of VOLSTRUCT
	        END MAP
	        MAP
	            BYTE      VOLSTRUCT_FILL1		 !  dummy item to maintain offset
	            BYTE      VSR_STRUCLEV			 !  Structure level part of VOLSTRUCT
	        END MAP
	    END UNION
	    INTEGER*2 VSR_RVN			 !  Value of RVN
	    INTEGER*2 VSR_PROTECT			 !  Value of PROTECT
	    INTEGER*2 VSR_FILEPROT			 !  Value of FILEPROT
	    INTEGER*2 VSR_RECPROT			 !  Value of RECPROT
	    INTEGER*2 VSR_VOLCHAR			 !  Value of VOLCHAR
	    INTEGER*2 VSR_EXTEND			 !  Value of EXTEND
	    INTEGER*2 VSR_CLUSTER			 !  Value of CLUSTER
	    INTEGER*2 VSR_RESFILES			 !  Value of RESFILES
	    BYTE      VSR_WINDOW			 !  Value of WINDOW
	    BYTE      VSR_LRU_LIM			 !  Value of LRU_LIM
	    INTEGER*4 VSR_INDEXLBN			 !  Value of INDEXLBN
	    RECORD /dsc$descriptor/ VSR_BOOTBLOCK	 !  Descriptor for BOOTBLOCK
	    INTEGER*4 VSR_RETAINMIN(2)		 !  Value of RETAINMIN
	    INTEGER*4 VSR_RETAINMAX(2)		 !  Value of RETAINMAX
	    INTEGER*2 VSR_BACKREV			 !  Value of BACKREV.
	    INTEGER*4 VSR_EXPSIZE			 !  Value of Expansion Size	
	END STRUCTURE	! VSRBLK
	PARAMETER PVA_LENGTH = '00000028'X	 !  Length of PVA area
	STRUCTURE /PVABLK/
	    RECORD /dsc$descriptor/ PVA_DEVNAM	 !  Descriptor for DEVNAM
	    RECORD /dsc$descriptor/ PVA_LABEL	 !  Descriptor for LABEL
	    RECORD /dsc$descriptor/ PVA_BADBLOCK	 !  Descriptor for BADBLOCK
	    INTEGER*4 PVA_MAXBLOCK			 !  Value of MAXBLOCK
	    INTEGER*4 PVA_SERIAL			 !  Value of SERIAL
	    INTEGER*2 PVA_CYLINDERS			 !  Value of CYLINDERS
	    BYTE      PVA_SECTORS			 !  Value of SECTORS
	    BYTE      PVA_TRACKS			 !  Value of TRACKS
	    INTEGER*4 PVA_DEVTYP			 !  Value of DEVTYP
	END STRUCTURE	! PVABLK
	PARAMETER FAR_M_HEADONLY = '00000001'X
	PARAMETER FAR_LENGTH = '000000C8'X	 !  Length of FAR area
	STRUCTURE /FARBLK/
	    RECORD /dsc$descriptor/ FAR_FILENAME	 !  Descriptor for FILENAME
	    RECORD /dsc$descriptor/ FAR_PLACEMENT	 !  Descriptor for PLACEMENT
	    BYTE      FAR_RECATTR(1:32)		 !  Value of RECATTR
	    INTEGER*4 FAR_CREDATE(2)		 !  Value of CREDATE
	    INTEGER*4 FAR_REVDATE(2)		 !  Value of REVDATE
	    INTEGER*4 FAR_EXPDATE(2)		 !  Value of EXPDATE
	    INTEGER*4 FAR_BAKDATE(2)		 !  Value of BAKDATE
	    UNION
	        MAP
	        INTEGER*2 FAR_FARFID(1:3)		 !  Value of FID
	        END MAP
	        MAP
	            INTEGER*2 FAR_FID_NUM
	            INTEGER*2 FAR_FID_SEQ
	            UNION
	                MAP
	                INTEGER*2 FAR_FID_RVNW
	                END MAP
	                MAP
	                    BYTE      FAR_FID_RVN
	                    BYTE      FAR_FID_NMX
	                END MAP
	            END UNION
	        END MAP
	    END UNION
	    UNION
	        MAP
	        INTEGER*2 FAR_BACKLINK(1:3)		 !  Value of BACKLINK
	        END MAP
	        MAP
	            INTEGER*2 FAR_DID_NUM
	            INTEGER*2 FAR_DID_SEQ
	            INTEGER*2 FAR_DID_RVNW
	        END MAP
	    END UNION
	    INTEGER*4 FAR_FILESIZE			 !  Value of FILESIZE
	    UNION
	        MAP
	        INTEGER*4 FAR_UIC			 !  Value of UIC
	        END MAP
	        MAP
	            INTEGER*2 FAR_UICMEMBER			 !  Member part of UIC
	            INTEGER*2 FAR_UICGROUP			 !  Group part of UIC
	        END MAP
	    END UNION
	    INTEGER*4 FAR_UCHAR			 !  Value of UCHAR
	    INTEGER*4 FAR_BOOTVBN			 !  Value of BOOTVBN for 1st boot image
	    UNION
	        MAP
	        INTEGER*2 FAR_STRUCLEV			 !  Value of STRUCLEV
	        END MAP
	        MAP
	            BYTE      FAR_STRUCLEV_FILL1		 !  dummy item to maintain offset
	            BYTE      FAR_STRUCLEVB			 !  Structure level part of STRUCLEV
	        END MAP
	    END UNION
	    INTEGER*2 FAR_FPRO			 !  Value of FPRO
	    INTEGER*2 FAR_RPRO			 !  Value of RPRO
	    INTEGER*2 FAR_REVISION			 !  Value of REVISION
	    INTEGER*4 FAR_DIR_UIC			 !  Value of DIR_UIC
	    INTEGER*2 FAR_DIR_FPRO			 !  Value of DIR_FPRO
	    BYTE      FAR_ACLEVEL			 !  Value of ACLEVEL
	    BYTE      FAR_DIR_STATUS		 !  Value of DIR_STATUS
	    INTEGER*2 FAR_DIR_VERLIM		 !  Value of DIR_VERLIM
	    INTEGER*2 FAR_VERLIMIT			 !  Value of VERLIMIT
	    RECORD /dsc$descriptor/ FAR_ACLSEGMENT	 !  ACL segment descriptor
	    INTEGER*4 FAR_HIGHWATER			 !  Value of HIGHWATER
	    BYTE      FAR_JNL_FLAGS			 !  Value of JNL_FLAGS
	    BYTE      FAR_RU_ACTIVE			 !  Value of RU_ACTIVE
	    UNION
	        MAP
	        INTEGER*2 FAR_W_FLAGS
	        END MAP
	        MAP
	            PARAMETER FAR_S_HEADONLY = 1
	            PARAMETER FAR_V_HEADONLY = 0		 !  Only the HEADER was saved
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    INTEGER*4 FAR_BOOTVBN2			 !  Value of BOOTVBN for 2nd boot image
	    INTEGER*4 FAR_GPT_VBN			 !  Value of GPT_VBN for EFI/GPT partition image
	    INTEGER*4 FAR_GPT_TYPE			 !  Value of GPT_TYPE for EFI/GPT partition image
	    INTEGER*4 FAR_ACCDATE(2)		 !  ODS5, Access date
	    INTEGER*4 FAR_ATTDATE(2)		 !  ODS5, Attribute change date
	    BYTE      FAR_LENGTH_HINT(1:16)
 !  ODS5, File length hint
	    BYTE      FAR_EX_RECATTR(1:8)
 !  ODS5, Extended RMS record attributes
	    INTEGER*2 FAR_LINKCOUNT			 !  ODS5 (hard) link count
	    INTEGER*2 FAR_filler			 !  filler
	END STRUCTURE	! FARBLK
	PARAMETER ATTBUF_LENGTH = '000000C0'X
	PARAMETER ACB_S_ENTRY = '00000010'X	 !  Size of entry
	STRUCTURE /STABCKACB/
	    INTEGER*4 ACB_FLINK			 !  Forward link
	    INTEGER*4 ACB_BLINK			 !  Backward link
	    INTEGER*4 ACB_COUNT			 !  Block count
	    INTEGER*4 ACB_LBN			 !  Logical block number
	END STRUCTURE	! STABCKACB
	PARAMETER WCB_M_BLACKHOLE = '00000001'X
	PARAMETER WCB_S_HEADER = '00000014'X	 !  Size of header
	STRUCTURE /STABWCBHD/
	    INTEGER*4 WCB_LINK			 !  Link to next block
	    INTEGER*4 WCB_VBN			 !  In first block only, starting VBN of window
	    BYTE      WCB_SIZE			 !  Number of entries in window block
	    BYTE      WCB_FREE			 !  Number of free entries in window
	    BYTE      WCB_RVN			 !  RVN
	    UNION
	        MAP
	        BYTE      WCB_B_FLAGS			 !  Flag byte
	        END MAP
	        MAP
	            PARAMETER WCB_S_BLACKHOLE = 1
	            PARAMETER WCB_V_BLACKHOLE = 0		 !  Flush write I/Os into this window
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    INTEGER*4 WCB_CUR_HWM			 !  Current highwater mark for open file
	    INTEGER*4 WCB_SET_HWM			 !  Highwater mark written for open file
	END STRUCTURE	! STABWCBHD
	PARAMETER WCB_S_ENTRY = '00000008'X	 !  Size of each entry
	STRUCTURE /STABWCBENT/
	    INTEGER*4 WCB_COUNT			 !  Count of blocks
	    INTEGER*4 WCB_LBN			 !  LBN of blocks
	END STRUCTURE	! STABWCBENT
	PARAMETER VCB_M_OUTPUT = '00000001'X
	PARAMETER VCB_M_ODS_2 = '00000002'X
	PARAMETER VCB_M_INIT_DONE = '00000004'X
	PARAMETER VCB_M_SAVESET = '00000008'X
	PARAMETER VCB_M_NOTVOLSET = '00000010'X
	PARAMETER VCB_M_ODS_5 = '00000020'X
	PARAMETER VCB_S_ENTRY = '00000048'X	 !  Size of entry
	STRUCTURE /STABCKVCB/
	    INTEGER*4 VCB_INDEXF			 !  Pointer to index file window
	    INTEGER*2 VCB_CLUSTER			 !  Cluster factor
	    BYTE      VCB_RVN			 !  Relative volume number
	    UNION
	        MAP
	        BYTE      VCB_B_FLAGS
	        END MAP
	        MAP
	            PARAMETER VCB_S_OUTPUT = 1
	            PARAMETER VCB_V_OUTPUT = 0		 !  True if output volume
	            PARAMETER VCB_S_ODS_2 = 1
	            PARAMETER VCB_V_ODS_2 = 1		 !  True if ODS-2 volume
	            PARAMETER VCB_S_INIT_DONE = 1
	            PARAMETER VCB_V_INIT_DONE = 2		 !  True if initialization has been done
	            PARAMETER VCB_S_SAVESET = 1
	            PARAMETER VCB_V_SAVESET = 3		 !  True if saveset volume
	            PARAMETER VCB_S_NOTVOLSET = 1
	            PARAMETER VCB_V_NOTVOLSET = 4		 !  Sequential disk volume is not in a set
	            PARAMETER VCB_S_ODS_5 = 1
	            PARAMETER VCB_V_ODS_5 = 5		 !  True if ODS-5 volume
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    INTEGER*2 VCB_CHAN			 !  Channel number assigned to this RVN
	    INTEGER*2 VCB_IOCOUNT			 !  Count of pending read/write QIOs
	    INTEGER*4 VCB_BITMAP_LBN		 !  LBN of storage bitmap
	    INTEGER*4 VCB_IMAP			 !  Pointer to index file bitmap image
	    INTEGER*4 VCB_IMAP_LBN			 !  LBN of index file bitmap
	    INTEGER*2 VCB_INIT_HDRS			 !  Bit mask of initialized headers
	    INTEGER*2 VCB_HDR_OFFSET		 !  VBN offset to file headers
	    INTEGER*4 VCB_MAXFILIDX			 !  Number of bits in index file bitmap
	    RECORD /dsc$descriptor/ VCB_DEVICE	 !  Descriptor for device name
	    INTEGER*4 VCB_ACB_FLINK			 !  Queue header for ACB queue
	    INTEGER*4 VCB_ACB_BLINK			 ! 
	    INTEGER*4 VCB_FAB			 !  Pointer to FAB with filespec
	    INTEGER*2 VCB_BITMAP_SIZE		 !  Storage bitmap size in blocks
	    INTEGER*2 VCB_FILLER1_VCB		 !  dummy item to maintain offsets
	    BYTE      VCB_VCBVOLNAME(1:12)		 !  Volume label
	    INTEGER*4 VCB_EXPSIZE			 !  Expansion size                         
	END STRUCTURE	! STABCKVCB
	PARAMETER MTL_M_SEQ_DISK = '00000001'X
	PARAMETER MTL_M_NEW_ACL = '00000002'X
	PARAMETER MTL_M_NOHWM = '00000004'X
	PARAMETER MTL_S_ENTRY = '00000034'X	 !  Size of entry, less VCB pointers
 !    MTL_VCB(n)=	52+4*(n),0,32,0 %; ! Pointer to VCB for RVN n
	STRUCTURE /STABCKMTL/
	    INTEGER*4 MTL_CHAN_1			 !  Pointer to VCB to which each of 2
	    INTEGER*4 MTL_CHAN_2			 !      channels is assigned
	    INTEGER*4 MTL_WINDOW			 !  Pointer to WCB for accessed file
	    INTEGER*4 MTL_HEADER			 !  Pointer to header for accessed file
	    INTEGER*4 MTL_ACLFL			 !  ACL queue
	    INTEGER*4 MTL_ACLBL			 !    head
	    UNION
	        MAP
	        INTEGER*2 MTL_MTLFID(1:3)		 !  File ID of accessed file
	        END MAP
	        MAP
	            INTEGER*2 MTL_FID_NUM			 ! 
	            INTEGER*2 MTL_FID_SEQ			 ! 
	            UNION
	                MAP
	                INTEGER*2 MTL_FID_RVNW			 ! 
	                END MAP
	                MAP
	                    BYTE      MTL_FID_RVN			 ! 
	                    BYTE      MTL_FID_NMX			 ! 
	                END MAP
	            END UNION
	        END MAP
	    END UNION
	    BYTE      MTL_STRUCLEV			 !  Structure level of volume set
	    BYTE      MTL_SETCOUNT			 !  Count of volumes in volume set
	    INTEGER*4 MTL_FILESIZE			 !  Size of accessed file
	    BYTE      MTL_STRUCNAME(1:12)		 !  Volume set name
	    BYTE      MTL_RVN_BASE			 !  RVN mounted on first VCB
	    UNION
	        MAP
	        BYTE      %FILL(1:3)
	        END MAP
	        MAP
	            PARAMETER MTL_S_SEQ_DISK = 1
	            PARAMETER MTL_V_SEQ_DISK = 0		 !  Set if sequential disk volume set
	            PARAMETER MTL_S_NEW_ACL = 1
	            PARAMETER MTL_V_NEW_ACL = 1		 !  Set if ACL must be written
	            PARAMETER MTL_S_NOHWM = 1
	            PARAMETER MTL_V_NOHWM = 2		 !  Highwater marking disabled for volume set
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	END STRUCTURE	! STABCKMTL
	PARAMETER D_M_DIR_SCAN = '00000001'X
	PARAMETER D_M_DIR_MATCHES = '00000002'X
	PARAMETER D_M_WILD_TERM = '00000004'X
	PARAMETER D_M_NON_TERM = '00000008'X
	PARAMETER D_M_DIR_CIRC = '00000010'X
	PARAMETER DQE_S_ENTRY = '00000054'X	 !  Size of directory queue entry in bytes
	STRUCTURE /DIRQUEUE/
	    INTEGER*4 D_DQE_FLINK			 !  Pointer to next directory queue entry
	    INTEGER*4 D_DQE_BLINK			 !  Pointer to prior directory queue entry
	    INTEGER*4 D_REC				 !  Pointer to current record
	    INTEGER*4 D_VER				 !  Pointer to current version if ODS-2
	    INTEGER*4 D_BUF_LEN			 !  Length of buffer in bytes
	    INTEGER*4 D_BUF_ADDR			 !  Pointer to buffer
	    INTEGER*4 D_BUF_LIM			 !  Limit of significant part of buffer
	    INTEGER*4 D_VBN				 !  Next VBN to be read
	    INTEGER*4 D_DIR_LEN			 !  Length of directory in blocks
	    INTEGER*2 D_DIRFID(1:3)			 !  File ID of directory
	    INTEGER*2 D_SAV_LEN			 !  Saved length of directory string
	    UNION
	        MAP
	        INTEGER*4 %FILL				 !  Directory entry flags
	        END MAP
	        MAP
	            PARAMETER D_S_DIR_SCAN = 1
	            PARAMETER D_V_DIR_SCAN = 0		 !  True if directory file to be scanned
	            PARAMETER D_S_DIR_MATCHES = 1
	            PARAMETER D_V_DIR_MATCHES = 1		 !  True if current directory matches
	            PARAMETER D_S_WILD_TERM = 1
	            PARAMETER D_V_WILD_TERM = 2		 !  True if terminator contains wildcard
	            PARAMETER D_S_NON_TERM = 1
	            PARAMETER D_V_NON_TERM = 3		 !  True if terminator is "*"
	            PARAMETER D_S_DIR_CIRC = 1
	            PARAMETER D_V_DIR_CIRC = 4		 !  True if directory file is a circular alias
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    RECORD /dsc$descriptor/ D_TERM_DESC	 !  Termination string descriptor
	    RECORD /dsc$descriptor/ D_NAME_DESC	 !  Current filename string descriptor
	    INTEGER*2 D_TERM_VER			 !  Termination version number
	    INTEGER*2 D_FPRO			 !  Directory file protection
	    INTEGER*4 D_UIC				 !  Directory file owner
	    INTEGER*2 D_VERLIM			 !  Directory default version limit
	    INTEGER*2 D_VER_COUNT			 !  File version counter (0, -1, ...)
	    INTEGER*4 D_F64DIRBUF			 !  Pointer to Files-64 directory buffer
	    INTEGER*4 D_F64DIRBUFLEN		 !  Length in bytes of F64DIRBUF
	END STRUCTURE	! DIRQUEUE
	PARAMETER FCE_M_CONVERTED = '00000001'X
	PARAMETER FCE_M_RELOADED = '00000002'X
	PARAMETER FCE_M_SYSLOST = '00000004'X
	PARAMETER FCE_S_ENTRY = '00000028'X	 !  Size of Filename Conversion Name Entry in bytes
	STRUCTURE /FCE_BLK/
	    INTEGER*4 FCE_FLINK			 !  Pointer to next Filename Conversion Name Entry
	    INTEGER*4 FCE_BLINK			 !  Pointer to prior Filename Conversion Name Entry
	    UNION
	        MAP
	        INTEGER*2 FCE_FLAGS			 !  Filename Coversion Entry Flags
	        END MAP
	        MAP
	        UNION
	            MAP
	            INTEGER*2 %FILL
	            END MAP
	            MAP
	                PARAMETER FCE_S_CONVERTED = 1
	                PARAMETER FCE_V_CONVERTED = 0		 !  Filename has been Converted
	                PARAMETER FCE_S_RELOADED = 1
	                PARAMETER FCE_V_RELOADED = 1		 !  Filename has been Reloaded into the Directory
	                PARAMETER FCE_S_SYSLOST = 1
	                PARAMETER FCE_V_SYSLOST = 2		 !  Filename has been Converted to SYSLOST Directory
	            BYTE %FILL (1)
	            END MAP
	        END UNION
	        END MAP
	    END UNION
	    BYTE      FCE_DIR_FLAGS			 !  Directory Entry Flags
	    BYTE      FCE_CONV_CTR			 !  Conversion Character Count
	    BYTE      FCE_ORIG_NAME_LEN		 !  Original File Name Length
	    BYTE      FCE_ORIG_TYPE_LEN		 !  Original File Type Length
	    BYTE      FCE_CONV_NAME_LEN		 !  Conversion File Name Length
	    BYTE      FCE_CONV_TYPE_LEN		 !  Conversion File Type Length
	    INTEGER*4 FCE_ORIG_NAME_PTR		 !  Original File Name Pointer
	    INTEGER*4 FCE_ORIG_TYPE_PTR		 !  Original File Type Pointer
	    INTEGER*4 FCE_CONV_NAME_PTR		 !  Conversion File Name Pointer
	    INTEGER*4 FCE_CONV_TYPE_PTR		 !  Conversion File Type Pointer
	    INTEGER*2 FCE_VERS_LIM			 !  File Name Version Limit
	    INTEGER*2 FCE_VERS_LEN			 !  File Name Version Length
	    INTEGER*4 FCE_VERS_PTR			 !  File Name Version Pointer
	END STRUCTURE	! FCE_BLK
	PARAMETER DCE_M_CONVERTED = '00000001'X
	PARAMETER DCE_M_SYSLOST = '00000002'X
	PARAMETER DCE_S_ENTRY = '00000024'X	 !  Size of Directoryname Conversion Name Entry in bytes
	STRUCTURE /DCE_BLK/
	    INTEGER*4 DCE_FLINK			 !  Pointer to next Directoryame Conversion Name Entry
	    INTEGER*4 DCE_BLINK			 !  Pointer to prior Directoryname Conversion Name Entry
	    UNION
	        MAP
	        INTEGER*2 DCE_FLAGS			 !  File's FID.
	        END MAP
	        MAP
	        UNION
	            MAP
	            INTEGER*2 %FILL
	            END MAP
	            MAP
	                PARAMETER DCE_S_CONVERTED = 1
	                PARAMETER DCE_V_CONVERTED = 0		 !  Filename has been Converted
	                PARAMETER DCE_S_SYSLOST = 1
	                PARAMETER DCE_V_SYSLOST = 1		 !  Filename is in SYSLOST Directory
	            BYTE %FILL (1)
	            END MAP
	        END UNION
	        END MAP
	    END UNION
	    INTEGER*2 DCE_FID(1:3)			 !  Directory Name FID
	    INTEGER*2 dce_fill			 !  Filler
	    BYTE      DCE_ORIG_NAME_LEN		 !  Directory Original Name Length
	    BYTE      DCE_CONV_NAME_LEN		 !  Directory Conversion Name Length
	    INTEGER*4 DCE_ORIG_NAME_PTR		 !  Directory Original Name Pointer
	    INTEGER*4 DCE_CONV_NAME_PTR		 !  Directory Conversion Name Pointer
	    INTEGER*4 DCE_FRST_FCE_PTR		 !  The first FCE for this BCB directory record
	    INTEGER*4 DCE_LAST_FCE_PTR		 !  The last FCE for this entire directory and/or BCB
	END STRUCTURE	! DCE_BLK
	PARAMETER DQF_S_ENTRY = '00000018'X	 !  Size of entry in bytes
	STRUCTURE /DSKQUOTA/
	    INTEGER*4 DQF_LLINK			 !  Pointer to entry with lesser UIC
	    INTEGER*4 DQF_RLINK			 !  Pointer to entry with greater UIC
	    INTEGER*4 DQF_UIC			 !  UIC
	    INTEGER*4 DQF_USAGE			 !  Usage in blocks
	    INTEGER*4 DQF_PERMQUOTA			 !  Permanent disk quota
	    INTEGER*4 DQF_OVERDRAFT			 !  Overdraft limit
	END STRUCTURE	! DSKQUOTA
	PARAMETER PLC_S_HDR = '0000000A'X	 !  Length of placement block header
	STRUCTURE /PLCBLK/
	    INTEGER*4 PLC_FLINK			 !  Forward link
	    INTEGER*4 PLC_BLINK			 !  Backward link
	    BYTE      PLC_TYPE			 !  Type code
	    BYTE      PLC_SIZE			 !  Size of block
	    INTEGER*4 PLC_DATA_START		 !  Data portion
	END STRUCTURE	! PLCBLK
	PARAMETER VBN_S_ENTRY = '00000012'X	 !  Length of VBN data block
	STRUCTURE /VBNBLK/
	    INTEGER*4 VBN_FLINK			 !  Forward link
	    INTEGER*4 VBN_BLINK			 !  Backward link
	    BYTE      VBN_TYPE			 !  Type code
	    BYTE      VBN_SIZE			 !  Size of block
	    INTEGER*4 VBN_FIRST			 !  First VBN in range
	    INTEGER*4 VBN_LAST			 !  Last VBN in range
	END STRUCTURE	! VBNBLK
 !  Max. label string size (disk/tape)
	PARAMETER VOL_LABEL_STRING_MAX_SIZE = '0000000C'X
	PARAMETER VOL_LABEL_MAX_LIST = '00000014'X  !  Max. (initial) number of labels
 !  (20*12 bytes) Blockvector size
 ! 	    (Initial dynamic size)
 ! 
	PARAMETER VOL_LABEL_LIST_SIZE = '000000F0'X
	PARAMETER VOLLBL_BLOCK_SIZE = '0000000C'X  !  Label Block Size
	STRUCTURE /VOLLBLBLK/
	        CHARACTER*12 VOL_LABEL_STRING		 !  Label string
	END STRUCTURE	! VOLLBLBLK
	PARAMETER TAPE_CHAR_S_LENGTH = '00000008'X  !  length of P1 User Buffer Structure
	PARAMETER TAPE_CHAR_S_MT3_LENGTH = '00000010'X  !  length of P1 User Buffer Structure
	STRUCTURE /TAPECHARBLK/
	    INTEGER*2 MT3_RESERVED			 !  
	    INTEGER*2 TAPE_CHAR_BUFFER_SIZE		 !  
	    PARAMETER S_CHARACTERISTICS1 = 32
	    PARAMETER V_CHARACTERISTICS1 = 32	 !  
	    PARAMETER S_XCHARACTERTICS = 32
	    PARAMETER V_XCHARACTERTICS = 64
	    BYTE %FILL (8)				 !  
	    INTEGER*2 MT3_TAPE_DENSITY		 !  
	    INTEGER*2 MT3_MUST_BE_ZERO		 !  
	END STRUCTURE	! TAPECHARBLK
	PARAMETER TAPEQ_M_EXPI = '00000001'X
	PARAMETER TAPEQ_M_LABE = '00000002'X
	PARAMETER TAPEQ_M_PROT = '00000004'X
	PARAMETER TAPEQ_M_WREN = '00000008'X
	PARAMETER TAPEQ_M_MOUN = '00000010'X
	PARAMETER TAPEQ_M_WRIT = '00000020'X
	PARAMETER TAPEQ_M_NOVR = '00000040'X
	PARAMETER TAPEQ_M_VOOO = '00000080'X
	PARAMETER TAPEQ_M_RVL = '00000100'X
	PARAMETER TAPEQ_M_NOUSE = '00000200'X
	STRUCTURE /BCKCOMMON$$FILL_49_/
	UNION
	    MAP
	    INTEGER*4 TAPEQ_L_TAPERRQ
	    END MAP
	    MAP
	        PARAMETER TAPEQ_S_EXPI = 1
	        PARAMETER TAPEQ_V_EXPI = 0		 !  Has tape expiration date been met
	        PARAMETER TAPEQ_S_LABE = 1
	        PARAMETER TAPEQ_V_LABE = 1		 !  Is the tape label correct
	        PARAMETER TAPEQ_S_PROT = 1
	        PARAMETER TAPEQ_V_PROT = 2		 !  Is tape protected from access
	        PARAMETER TAPEQ_S_WREN = 1
	        PARAMETER TAPEQ_V_WREN = 3		 !  Should tape be write enabled
	        PARAMETER TAPEQ_S_MOUN = 1
	        PARAMETER TAPEQ_V_MOUN = 4		 !  Should we issue tape mount request
	        PARAMETER TAPEQ_S_WRIT = 1
	        PARAMETER TAPEQ_V_WRIT = 5		 !  Do we want to write onto the tape
	        PARAMETER TAPEQ_S_NOVR = 1
	        PARAMETER TAPEQ_V_NOVR = 6		 !  We want to prevent overwrite of tape
	        PARAMETER TAPEQ_S_VOOO = 1
	        PARAMETER TAPEQ_V_VOOO = 7		 !  Volume was found to be Out Of Order
	        PARAMETER TAPEQ_S_RVL = 1
	        PARAMETER TAPEQ_V_RVL = 8		 !  Ask for unspecified volume label
	        PARAMETER TAPEQ_S_NOUSE = 1
	        PARAMETER TAPEQ_V_NOUSE = 9		 !  Don't use the loaded tape label
	    BYTE %FILL (2)
	    END MAP
	END UNION
	END STRUCTURE	! BCKCOMMON$$FILL_49_
	PARAMETER CLEAR_ASTLM_EFN = '00000005'X	 !  Wait for $SETIMR
	PARAMETER OUTSTANDING_WRITE_EFN = '00000006'X  !  For non-TMSCP support
	PARAMETER V_READ_EFN = '00000014'X	 !  Event flag for vvm reads
	PARAMETER BUFFER_FREED_EFN = '00000015'X  !  Event flag set when a buffer is freed
	PARAMETER MISC_VM_BLOCK_HDR_SIZE = '00000010'X  !  VM Block Header Size
	STRUCTURE /MISCVMBLK/
	    INTEGER*4 MISC_VM_FLINK			 !  Misc. VM queue forward link
	    INTEGER*4 MISC_VM_BLINK			 !  Misc. VM queue backward link
	    INTEGER*4 MISC_VM_ADDR			 !  start of block (includes QUAD alignment space)
	    INTEGER*4 MISC_VM_SIZE			 !  Misc. VM block size (bytes)
	    INTEGER*4 MISC_VM_USE_VM		 !  Start of Misc. VM usable data
	END STRUCTURE	! MISCVMBLK
	STRUCTURE /EVNTCALBCK/
	    INTEGER*4 Event_Callback_addr(1:46)	 !  (each) Event Type Callback 
	END STRUCTURE	! EVNTCALBCK
	PARAMETER QUAL_S_AREA = '000000F8'X	 !  Length of the qualifiers block
	PARAMETER COM_FLAGS_START = '000002C2'X	 !  defined for COM_FLAGS init.
	PARAMETER COM_M_EOV = '00000001'X
	PARAMETER COM_M_STANDALONE = '00000002'X
	PARAMETER COM_M_FILESEEN = '00000004'X
	PARAMETER COM_M_VERIFYING = '00000008'X
	PARAMETER COM_M_FAIL_RSTRT = '00000010'X
	PARAMETER COM_M_CONTINUE = '00000020'X
	PARAMETER COM_M_DSBL_CHKPT = '00000040'X
	PARAMETER COM_M_DSBL_RSTRT = '00000080'X
	PARAMETER COM_M_INTERACT = '00000100'X
	PARAMETER COM_M_TAPE_CACHE = '00000200'X
	PARAMETER COM_M_SEEN_FILE_OR_VBN = '00000400'X
	PARAMETER COM_M_SAV_SAV = '00000800'X
	PARAMETER COM_M_ERROR_IN_PROG = '00001000'X
	PARAMETER COM_M_MME_EXISTS = '00002000'X
	PARAMETER COM_M_LABEL_OVERWRITE = '00004000'X
	PARAMETER COM_M_SS_EOV = '00008000'X
	PARAMETER COM_FLAGS_K_LENGTH = '00000002'X  !  defined for COM_FLAGS init.
	PARAMETER COM_M_CVT_REST_ODS5_ODS2 = '00000001'X
	PARAMETER COM_M_CVT_SAVE_ODS5_ODS2 = '00000002'X
	PARAMETER COM_M_CVT_SAVE_SKIP_SYSLOST = '00000004'X
	PARAMETER COM_M_SNAPDISK = '00000008'X
	PARAMETER COM_M_MTD_SUPPORTED = '00000010'X
	PARAMETER COM_M_DO_MME_END = '00000020'X
	PARAMETER COM_M_HARDLINKS = '00000040'X
	PARAMETER COM_M_ODISK_FOREIGN = '00000080'X
	PARAMETER COM_M_ODISK_DFS = '00000100'X
	PARAMETER COM_M_WR_DATA_TS = '00000200'X
	PARAMETER INPUT_BEG = '00000384'X	 !  Beginning of input context
	PARAMETER INPUT_FLAGS_START = '00000388'X  !  defined for COM_FLAGS init.
	PARAMETER INPUT_M_OPEN = '00000001'X
	PARAMETER INPUT_M_EOV_IN_PROG = '00000002'X
	PARAMETER INPUT_M_EOV_SAVING = '00000004'X
	PARAMETER INPUT_M_ON_RVN = '00000008'X
	PARAMETER INPUT_M_IGNO_INTE = '00000010'X
	PARAMETER INPUT_M_SAVE_OK = '00000020'X
	PARAMETER INPUT_M_WILDSAVE = '00000040'X
	PARAMETER INPUT_M_REWOUND = '00000080'X
	PARAMETER INPUT_M_SSFOUND = '00000100'X
	PARAMETER INPUT_M_ALIAS = '00000200'X
	PARAMETER INPUT_M_SPAN_OVER = '00000400'X
	PARAMETER INPUT_M_INPUT_PHASE = '00000800'X
	PARAMETER INPUT_M_BSR_FOUND = '00001000'X
	PARAMETER INPUT_M_COMPRESS_BCB_PRESENT = '00002000'X
	PARAMETER INPUT_FLAGS_K_LENGTH = '00000004'X  !  defined for COM_FLAGS init.
	PARAMETER INPUT_HDR_BEG = '000003B8'X	 !  Beginning of header data
	PARAMETER INPUTCTX_HDR_SIZE = '00000078'X
	PARAMETER INPUTCTX_SIZE = '000000AC'X
	PARAMETER OUTPUT_BEG = '0000044C'X	 !  Beginning of output context
	PARAMETER OUTPUT_M_OPEN = '00000001'X
	PARAMETER OUTPUT_M_FIRST = '00000002'X
	PARAMETER OUTPUT_M_LAST = '00000004'X
	PARAMETER OUTPUT_M_INCR_DIR = '00000008'X
	PARAMETER OUTPUT_M_IMPLICIT = '00000010'X
	PARAMETER OUTPUT_M_ACL_ERROR = '00000020'X
	PARAMETER OUTPUT_M_ACL_FIRST_TIME = '00000040'X
	PARAMETER OUTPUT_M_DIR_OPEN = '00000080'X
	PARAMETER OUTPUT_M_NONSEQ_IN = '00000100'X
	PARAMETER OUTPUT_M_SKIP_ALIAS = '00000200'X
	PARAMETER OUTPUT_M_ALIAS_OPEN = '00000400'X
	PARAMETER OUTPUTCTX_SIZE = '000000EC'X	 !  End of output context
	PARAMETER FASTCTX_VOL_BEG = '00000574'X	 !  Beginning of per-volume information
	PARAMETER FASTCTX_VOL_SIZE = '00000020'X  !  End of per-volume information
	PARAMETER MAP_M_JOURNAL_ENTRY = '00000001'X
	PARAMETER MAP_M_LOST_FILES = '00000002'X
	PARAMETER RESTART_M_RESTARTING = '00000001'X
	PARAMETER RESTART_M_ON_RVN = '00000002'X
	PARAMETER RESTART_M_CLEAR_AST = '00000004'X
	PARAMETER DIR_BEG = '00000608'X		 !  Beginning of context
	PARAMETER DIR_M_IMAGE_SCAN = '00000001'X
	PARAMETER DIR_M_SCAN_FAILED = '00000002'X
	PARAMETER DIR_M_HARD_STOP = '00000004'X
	PARAMETER DIR_M_SCANNED_DIRS = '00000008'X
	PARAMETER DIR_M_INITIAL = '00000010'X
	PARAMETER DIR_M_ROOT_MFD = '00000020'X
	PARAMETER D_STAT_M_VALID = '00000001'X
	PARAMETER D_STAT_M_DIR_SEL = '00000002'X
	PARAMETER D_STAT_M_SCANNED = '00000004'X
	PARAMETER D_STAT_M_FILE_SEL = '00000008'X
	PARAMETER DIRCTX_SIZE = '00000068'X	 !  End of context
	PARAMETER FCECTX_BEG = '00000670'X	 !  Beginning of Conversion Context
	PARAMETER FCE_M_HOLD_FRST = '00000001'X
	PARAMETER FCECTX_SIZE = '0000002C'X	 !  End of Conversion Context
	PARAMETER DCECTX_BEG = '0000069C'X	 !  Beginning of Conversion Context
	PARAMETER DCE_M_DIRECTORY = '00000001'X
	PARAMETER DCE_M_MFD_ISRT = '00000002'X
	PARAMETER DCE_M_MFD_READ = '00000004'X
	PARAMETER DCE_M_MFD_CONV = '00000008'X
	PARAMETER DCE_M_MFD_PCVT = '00000010'X
	PARAMETER DCECTX_SIZE = '00000014'X	 !  End of Conversion Context
	PARAMETER INCR_M_SKIP_DIR = '00000001'X
	PARAMETER INCR_M_SAVE_ALL_DIR = '00000002'X
	PARAMETER INCR_M_DISABLE_SAVE_ALL = '00000004'X
	PARAMETER CHK_FLAGS_START = '00000ABC'X
 !  define an offset for clearing the following structure 
	PARAMETER CHK_FLAGS_M_F11 = '00010000'X
	PARAMETER CHK_FLAGS_M_SAV = '00020000'X
	PARAMETER CHK_FLAGS_M_SAVE_SET = '00040000'X
	PARAMETER CHK_FLAGS_M_SRCH_LIST = '00080000'X
	PARAMETER CHK_FLAGS_M_SMFS = '00100000'X
	PARAMETER CHK_FLAGS_M_DRVCLS_MISUSED = '01000000'X
	PARAMETER CHK_FLAGS_K_LENGTH = '00000004'X
 !  define a length for clearing the above structure 
	PARAMETER BCK$$_S_COMMON_AREA = '00000AEE'X  !  Size of the Common Area
	STRUCTURE /BCK_COMMON_DATA/
 !   OBSOLETE (BASE POINTER NO LONGER NEEDED).
 ! 
 !    ! Marker for base of area.
 ! 
 !     GLOBAL_BASE	    address dimension *;
 ! 
	    INTEGER*4 FREE_LIST(1:2)		 !  Free queue header
	    INTEGER*4 INPUT_WAIT(1:2)		 !  Input pending queue header
	    INTEGER*4 REREAD_WAIT(1:2)		 !  Re-read pending queue header
	    INTEGER*4 OUTPUT_WAIT(1:2)		 !  Output ready for issue queue header
	    INTEGER*4 OUTPUT_ISSUED(1:2)		 !  Output issued queue header
	    INTEGER*4 XOR_LIST(1:2)			 !  Q header of buffers for XOR.
	    INTEGER*4 ASYNCH_WORK(1:2)		 !  Asynch work queue header
	    INTEGER*4 MISC_VM_LIST(1:2)		 !  Q header of misc. VM (must be free'd)
	    INTEGER*4 JPI_PID			 !  JPI$_PID
	    INTEGER*4 JPI_UIC			 !  JPI$_UIC
	    INTEGER*4 JPI_DATE(2)			 !  $GETTIM
	    RECORD /dsc$descriptor/ JPI_NODE_DESC	 !  Translation of SYS$NODE
	    INTEGER*4 JPI_CURPRIV(2)		 !  Current process privileges
	    BYTE      JPI_USERNAME(1:12)		 !  JPI$_USERNAME
	    INTEGER*4 JPI_ASTLM			 !  AST limit from GETJPI.
	    INTEGER*4 JPI_BIOLM			 !  Buffered IO limit.
	    INTEGER*4 JPI_FILCNT			 !  Open file limit.
	    INTEGER*4 JPI_WSQUOTA			 !  Working set quota.
	    INTEGER*4 JPI_PGFLQUOTA			 !  Page file quota.
	    INTEGER*4 JPI_WSSIZE			 !  Current working set size.
	    BYTE      JPI_PARSE_STYLE_PERM		 !  Current Process Parse Style Property
	    BYTE      JPI_CASE_LOOKUP_PERM		 !  Current Process Case Lookup Property
	    INTEGER*2 JPI_FILLER			 !  filler
	    INTEGER*4 JPI_JOBTYPE			 !  Current process job type.
	    INTEGER*4 ADJ_WSSIZE			 !  Adjusted working set size (after $ADJWSL)
	    INTEGER*4 SYI_VERSION			 !  SYI$_VERSION
	    INTEGER*4 SYI_SID			 !  SYI$_SID
	    INTEGER*4 SYI_CHANNELCNT		 !  SYI$_CHANNELCNT
	    INTEGER*4 SYI_PAGE_SIZE			 !  SYI$_PAGE_SIZE
	    INTEGER*4 CTRL_T_CHAN			 !  Channel to trap ^T.
	    INTEGER*4 CTRL_T_TOTBLK			 !  Total size 
	    INTEGER*4 CTRL_T_TIME(2)		 !  Time of last CTRL-T
	    INTEGER*4 CTRL_T_PREVSEQ		 !  SEQ at last CTRL-T
	    INTEGER*4 CTRL_T_PREVSEC		 !  Estimated seconds remaining at last CTRL-T
	    INTEGER*4 RWSV_HOLD_LIST(1:2)		 !  Queue header for error rewrites or held I/Os for volume swit
					!  Queue header for error rewrites or held I/Os for volume swi
	    INTEGER*4 RWSV_ERRORS_LIST(1:2)		 !  Queue header for output error rewrites
	    INTEGER*4 RWSV_CRC16(1:16)		 !  CRC-16 polynomial table
	    INTEGER*4 RWSV_AUTODIN(1:16)		 !  AUTODIN-II polynomial table
	    BYTE      RWSV_FILESET_ID(1:8)		 !  File set identifier
	    BYTE      RWSV_VOLUME_ID(1:12)		 !  Volume identifier
	    INTEGER*2 RWSV_VOL_NUMBER		 !  Save set volume number
	    INTEGER*2 RWSV_SEG_NUMBER		 !  File section number
	    INTEGER*4 RWSV_FILE_NUMBER		 !  File sequence number
	    INTEGER*4 RWSV_SAVE_QUAL		 !  Pointer to save set qualifiers block
	    INTEGER*4 RWSV_SAVE_FC			 !  Pointer to saveset File Context (FC)
	    INTEGER*4 RWSV_CHAN			 !  Channel assigned to save set medium
	    INTEGER*4 RWSV_XOR_BCB			 !  Pointer to BCB for XOR block
	    INTEGER*4 RWSV_IN_SEQ			 !  Input block sequence number
	    INTEGER*4 RWSV_IN_SEQ_0			 !  RWSV_IN_SEQ at start of reel
	    INTEGER*4 RWSV_IN_XOR_SEQ		 !  Sequence number of last XOR block
	    BYTE      RWSV_IN_XOR_RFA(1:6)		 !  RFA of last XOR block
	    BYTE      RWSV_LOOKAHEAD		 !  Buffer count from summary record
	    BYTE      RWSV_XORSIZE			 !  XOR group size from summary record
	    INTEGER*4 RWSV_IN_GROUP_SIZE		 !  XOR group size of save set
	    INTEGER*2 RWSV_IN_ERRORS		 !  Count of input errors
	    INTEGER*2 RWSV_IN_XORUSE		 !  Count of XOR recoveries performed
	    INTEGER*4 RWSV_IN_ORGERR(1:2)		 !  Original STS/STV of a train of loses
	    INTEGER*4 RWSV_IN_VBN			 !  Current VBN in save set file
	    INTEGER*4 RWSV_IN_VBN_0			 !  Saved input VBN
	    INTEGER*4 RWSV_ALLOC			 !  Number of blocks available in save set file
	    INTEGER*4 RWSV_EOF			 !  End of file VBN if save set file
	    INTEGER*4 RWSV_OUT_SEQ			 !  Output block sequence number
	    INTEGER*4 RWSV_OUT_VBN			 !  Output VBN
	    INTEGER*4 RWSV_OUT_BLOCK_COUNT		 !  Count of blocks on output tape
	    INTEGER*2 RWSV_OUT_ERRORS		 !  Count of output errors
	    INTEGER*2 RWSV_SEQ_ERRORS		 !  Count of consecutive input errors
	    INTEGER*2 RWSV_READ_FIRST_BLOCK		 !  Flag for reading first block of saveset
	    INTEGER*2 RWSV_REMOVE_FLAG		 !  Flag to remove entry from INPUT_WAIT
	    BYTE      RWSV_OUT_GROUP_COUNT		 !  Count of blocks in output XOR group
	    INTEGER*2 RWSV_HOLD_COUNT		 !  Count of blocks on rwsv_hold_list
	    BYTE      rwsv_end_filler		 !  quadword align the start of next block
 ! 
 !  Qualifier block structure (database)
 ! 
	        INTEGER*4 QUAL_A_INPU_LIST		 !  Input parameters
	        INTEGER*4 QUAL_A_OUTP_LIST		 !  Output parameters
	        PARAMETER QUAL_S_ALIAS = 1
	        PARAMETER QUAL_V_ALIAS = 64		 !  /ALIAS
	        PARAMETER QUAL_S_ANAL = 1
	        PARAMETER QUAL_V_ANAL = 65		 !  /ANALYZE
	        PARAMETER QUAL_S_ASSI = 1
	        PARAMETER QUAL_V_ASSI = 66		 !  /ASSIST for mounts
	        PARAMETER QUAL_S_BACK = 1
	        PARAMETER QUAL_V_BACK = 67		 !  /BACKUP
	        PARAMETER QUAL_S_BEFO = 1
	        PARAMETER QUAL_V_BEFO = 68		 !  /BEFORE
	        PARAMETER QUAL_S_BEFO_BACK = 1
	        PARAMETER QUAL_V_BEFO_BACK = 69		 !  /BEFORE=BACKUP
	        PARAMETER QUAL_S_BLOC = 1
	        PARAMETER QUAL_V_BLOC = 70		 !  /BLOCK_SIZE
	        PARAMETER QUAL_S_BUFF = 1
	        PARAMETER QUAL_V_BUFF = 71		 !  /BUFFER_COUNT
	        PARAMETER QUAL_S_COMM = 1
	        PARAMETER QUAL_V_COMM = 72		 !  /COMMENT
	        PARAMETER QUAL_S_COMP = 1
	        PARAMETER QUAL_V_COMP = 73		 !  /COMPARE
	        PARAMETER QUAL_S_CONF = 1
	        PARAMETER QUAL_V_CONF = 74		 !  /CONFIRM
	        PARAMETER QUAL_S_CONV = 1
	        PARAMETER QUAL_V_CONV = 75		 !  /CONVERT
	        PARAMETER QUAL_S_CRC = 1
	        PARAMETER QUAL_V_CRC = 76		 !  /CRC
	        PARAMETER QUAL_S_CREA = 1
	        PARAMETER QUAL_V_CREA = 77		 !  /CREATED
	        PARAMETER QUAL_S_DCL_INTERFACE = 1
	        PARAMETER QUAL_V_DCL_INTERFACE = 78	 !  API invoked from DCL main 
	        PARAMETER QUAL_S_DELE = 1
	        PARAMETER QUAL_V_DELE = 79		 !  /DELETE
	        PARAMETER QUAL_S_DENS = 1
	        PARAMETER QUAL_V_DENS = 80		 !  /DENSITY
	        PARAMETER QUAL_S_DISP_KEEP = 1
	        PARAMETER QUAL_V_DISP_KEEP = 81		 !  /DISPOSITION=KEEP     (MME)  
	        PARAMETER QUAL_S_DISP_RELE = 1
	        PARAMETER QUAL_V_DISP_RELE = 82		 !  /DISPOSITION=RELEASE  (MME)  
	        PARAMETER QUAL_S_EXACT = 1
	        PARAMETER QUAL_V_EXACT = 83		 !  /EXACT_ORDER
	        PARAMETER QUAL_S_EXCL = 1
	        PARAMETER QUAL_V_EXCL = 84		 !  /EXCLUDE
	        PARAMETER QUAL_S_EXPI = 1
	        PARAMETER QUAL_V_EXPI = 85		 !  /EXPIRED
	        PARAMETER QUAL_S_FAST = 1
	        PARAMETER QUAL_V_FAST = 86		 !  /FAST
	        PARAMETER QUAL_S_FILEMERGE = 1
	        PARAMETER QUAL_V_FILEMERGE = 87		 !  Standalone file merge
	        PARAMETER QUAL_S_FULL = 1
	        PARAMETER QUAL_V_FULL = 88		 !  /FULL
	        PARAMETER QUAL_S_GROU = 1
	        PARAMETER QUAL_V_GROU = 89		 !  /GROUP_SIZE
	        PARAMETER QUAL_S_IDRVCLS_VALID = 1
	        PARAMETER QUAL_V_IDRVCLS_VALID = 90	 !  Drive class processed/valid (input)
	        PARAMETER QUAL_S_IF11 = 1
	        PARAMETER QUAL_V_IF11 = 91		 !  Input is Files-11 or physical
	        PARAMETER QUAL_S_IGNO_ACCESS = 1
	        PARAMETER QUAL_V_IGNO_ACCESS = 92	 !  /IGNORE=ACCESSIBILITY
	        PARAMETER QUAL_S_IGNO_INTE = 1
	        PARAMETER QUAL_V_IGNO_INTE = 93		 !  /IGNORE=INTERLOCK
	        PARAMETER QUAL_S_IGNO_LABE = 1
	        PARAMETER QUAL_V_IGNO_LABE = 94		 !  /IGNORE=LABEL_PROCESSING.
	        PARAMETER QUAL_S_IGNO_NOBA = 1
	        PARAMETER QUAL_V_IGNO_NOBA = 95		 !  /IGNORE=NOBACKUP
	        PARAMETER QUAL_S_IMAG = 1
	        PARAMETER QUAL_V_IMAG = 96		 !  /IMAGE
	        PARAMETER QUAL_S_INCR = 1
	        PARAMETER QUAL_V_INCR = 97		 !  /INCREMENTAL
	        PARAMETER QUAL_S_INIT = 1
	        PARAMETER QUAL_V_INIT = 98		 !  /INITIALIZE
	        PARAMETER QUAL_S_INTE = 1
	        PARAMETER QUAL_V_INTE = 99		 !  /INTERCHANGE
	        PARAMETER QUAL_S_ISAV = 1
	        PARAMETER QUAL_V_ISAV = 100		 !  Input is save set
	        PARAMETER QUAL_S_I_CART = 1
	        PARAMETER QUAL_V_I_CART = 101		 !  /CARTRIDGE on input  (MME)
	        PARAMETER QUAL_S_I_CAR_CARTMED = 1
	        PARAMETER QUAL_V_I_CAR_CARTMED = 102	 !     MEDIA_NAME specified on input
	        PARAMETER QUAL_S_I_CAR_CARTNAM = 1
	        PARAMETER QUAL_V_I_CAR_CARTNAM = 103	 !     NAME specified on input
	        PARAMETER QUAL_S_I_CAR_CARTSID = 1
	        PARAMETER QUAL_V_I_CAR_CARTSID = 104	 !     SIDE specified on input
	        PARAMETER QUAL_S_I_DRVCLS = 1
	        PARAMETER QUAL_V_I_DRVCLS = 105		 !  /DRIVE_CLASS on input  (MME)  
	        PARAMETER QUAL_S_I_OWNE = 1
	        PARAMETER QUAL_V_I_OWNE = 106		 !  /OWNER_UIC on input  (MME)  
	        PARAMETER QUAL_S_I_OWN_WGRP = 1
	        PARAMETER QUAL_V_I_OWN_WGRP = 107	 !     Wildcard group
	        PARAMETER QUAL_S_I_OWN_WMEM = 1
	        PARAMETER QUAL_V_I_OWN_WMEM = 108	 !      Wildcard member
	        PARAMETER QUAL_S_I_SAVE = 1
	        PARAMETER QUAL_V_I_SAVE = 109		 !  /SAVE_SET on input
	        PARAMETER QUAL_S_I_SMFS = 1
	        PARAMETER QUAL_V_I_SMFS = 110		 !  SMFS Device on Input
	        PARAMETER QUAL_S_JOUR = 1
	        PARAMETER QUAL_V_JOUR = 111		 !  /JOURNAL
	        PARAMETER QUAL_S_LABE = 1
	        PARAMETER QUAL_V_LABE = 112		 !  /LABEL
	        PARAMETER QUAL_S_LIST = 1
	        PARAMETER QUAL_V_LIST = 113		 !  /LIST
	        PARAMETER QUAL_S_LOG = 1
	        PARAMETER QUAL_V_LOG = 114		 !  /LOG
	        PARAMETER QUAL_S_MEDIA_COMPACTN = 1
	        PARAMETER QUAL_V_MEDIA_COMPACTN = 115	 !  /MEDIA_FORMAT=COMPACTION  (MME)  
	        PARAMETER QUAL_S_MEDIA_FORMAT = 1
	        PARAMETER QUAL_V_MEDIA_FORMAT = 116	 !  /MEDIA_FORMAT             (MME)  
	        PARAMETER QUAL_S_MODI = 1
	        PARAMETER QUAL_V_MODI = 117		 !  /MODIFIED
	        PARAMETER QUAL_S_NEWV = 1
	        PARAMETER QUAL_V_NEWV = 118		 !  /NEW_VERSION
	        PARAMETER QUAL_S_MT3_DENSITY = 1
	        PARAMETER QUAL_V_MT3_DENSITY = 119	 !  /DENSITY qual for Multiple Tape Density support
	        PARAMETER QUAL_S_ODRVCLS_VALID = 1
	        PARAMETER QUAL_V_ODRVCLS_VALID = 120	 !  Drive class processed/valid (output)
	        PARAMETER QUAL_S_OF11 = 1
	        PARAMETER QUAL_V_OF11 = 121		 !  Output is Files-11 or physical
	        PARAMETER QUAL_S_OSAV = 1
	        PARAMETER QUAL_V_OSAV = 122		 !  Output is save set
	        PARAMETER QUAL_S_OVER = 1
	        PARAMETER QUAL_V_OVER = 123		 !  /OVERLAY
	        PARAMETER QUAL_S_O_CART = 1
	        PARAMETER QUAL_V_O_CART = 124		 !  /CARTRIDGE on output  (MME)  
	        PARAMETER QUAL_S_O_CAR_CARTMED = 1
	        PARAMETER QUAL_V_O_CAR_CARTMED = 125	 !     MEDIA_NAME specified on output
	        PARAMETER QUAL_S_O_CAR_CARTNAM = 1
	        PARAMETER QUAL_V_O_CAR_CARTNAM = 126	 !     NAME specified on output
	        PARAMETER QUAL_S_O_CAR_CARTSID = 1
	        PARAMETER QUAL_V_O_CAR_CARTSID = 127	 !     SIDE specified on output
	        PARAMETER QUAL_S_O_DRVCLS = 1
	        PARAMETER QUAL_V_O_DRVCLS = 128		 !  /DRIVE_CLASS on output  (MME)  
	        PARAMETER QUAL_S_O_OWNE = 1
	        PARAMETER QUAL_V_O_OWNE = 129		 !  /OWNER_UIC on output
	        PARAMETER QUAL_S_O_OWN_DEFA = 1
	        PARAMETER QUAL_V_O_OWN_DEFA = 130	 !      =DEFAULT
	        PARAMETER QUAL_S_O_OWN_ORIG = 1
	        PARAMETER QUAL_V_O_OWN_ORIG = 131	 !      =ORIGINAL
	        PARAMETER QUAL_S_O_OWN_PARE = 1
	        PARAMETER QUAL_V_O_OWN_PARE = 132	 !      =PARENT
	        PARAMETER QUAL_S_O_OWN_UIC = 1
	        PARAMETER QUAL_V_O_OWN_UIC = 133	 !      =[g,m]
	        PARAMETER QUAL_S_O_SAVE = 1
	        PARAMETER QUAL_V_O_SAVE = 134		 !  /SAVE_SET on output
	        PARAMETER QUAL_S_O_SMFS = 1
	        PARAMETER QUAL_V_O_SMFS = 135		 !  SMFS Device on Output
	        PARAMETER QUAL_S_PHYS = 1
	        PARAMETER QUAL_V_PHYS = 136		 !  /PHYSICAL
	        PARAMETER QUAL_S_PROT = 1
	        PARAMETER QUAL_V_PROT = 137		 !  /PROTECTION on output
	        PARAMETER QUAL_S_RECO = 1
	        PARAMETER QUAL_V_RECO = 138		 !  /RECORD
	        PARAMETER QUAL_S_RELEASE_TAPE = 1
	        PARAMETER QUAL_V_RELEASE_TAPE = 139	 !  /RELEASE_TAPE
	        PARAMETER QUAL_S_REPL = 1
	        PARAMETER QUAL_V_REPL = 140		 !  /REPLACE
	        PARAMETER QUAL_S_REWI = 1
	        PARAMETER QUAL_V_REWI = 141		 !  /REWIND
	        PARAMETER QUAL_S_SCRA = 1
	        PARAMETER QUAL_V_SCRA = 142		 !  /SCRATCH specified  (MME)  
	        PARAMETER QUAL_S_SCR_ASGN_BASE = 1
	        PARAMETER QUAL_V_SCR_ASGN_BASE = 143	 !     ASSIGNMENT_UNIT=BASE_CARTRIDGE
	        PARAMETER QUAL_S_SCR_ASGN_COMP = 1
	        PARAMETER QUAL_V_SCR_ASGN_COMP = 144	 !                    =COMPOUND_CARTRIDGE
	        PARAMETER QUAL_S_SCR_ASGN_PRES = 1
	        PARAMETER QUAL_V_SCR_ASGN_PRES = 145	 !                    =PREASSIGNED_SIDE
	        PARAMETER QUAL_S_SCR_ASGN_SIDE = 1
	        PARAMETER QUAL_V_SCR_ASGN_SIDE = 146	 !                    =SIDE
	        PARAMETER QUAL_S_SCR_COLL = 1
	        PARAMETER QUAL_V_SCR_COLL = 147		 !     COLLECTION name specified
	        PARAMETER QUAL_S_SCR_LOCA = 1
	        PARAMETER QUAL_V_SCR_LOCA = 148		 !     LOCATION name specified
	        PARAMETER QUAL_S_SCR_MEDI = 1
	        PARAMETER QUAL_V_SCR_MEDI = 149		 !     MEDIA_NAME specified
	        PARAMETER QUAL_S_SELE = 1
	        PARAMETER QUAL_V_SELE = 150		 !  /SELECT
	        PARAMETER QUAL_S_SINC = 1
	        PARAMETER QUAL_V_SINC = 151		 !  /SINCE
	        PARAMETER QUAL_S_SINC_BACK = 1
	        PARAMETER QUAL_V_SINC_BACK = 152	 !  /SINCE=BACKUP
	        PARAMETER QUAL_S_SNAPSHOT = 1
	        PARAMETER QUAL_V_SNAPSHOT = 153		 !  /SNAPSHOT (SnapDisk)
	        PARAMETER QUAL_S_SLS = 1
	        PARAMETER QUAL_V_SLS = 154		 !  /STORAGE_LIBRARY
	        PARAMETER QUAL_S_SS_ENCRYP = 1
	        PARAMETER QUAL_V_SS_ENCRYP = 155	 !  /ENCRYPT save set
	        PARAMETER QUAL_S_SS_FILE = 1
	        PARAMETER QUAL_V_SS_FILE = 156		 !  Save set is a disk file
	        PARAMETER QUAL_S_TAPE_EXPI = 1
	        PARAMETER QUAL_V_TAPE_EXPI = 157	 !  Expiration date present
	        PARAMETER QUAL_S_TRUN = 1
	        PARAMETER QUAL_V_TRUN = 158		 !  /TRUNCATE
	        PARAMETER QUAL_S_UNSHELVE = 1
	        PARAMETER QUAL_V_UNSHELVE = 159		 !  /UNSHELVE (File Shelving support)
	        PARAMETER QUAL_S_VERI = 1
	        PARAMETER QUAL_V_VERI = 160		 !  /VERIFY
	        PARAMETER QUAL_S_VOLU = 1
	        PARAMETER QUAL_V_VOLU = 161		 !  /VOLUME
	        PARAMETER QUAL_S_RELEASE_NOUNLOAD = 1
	        PARAMETER QUAL_V_RELEASE_NOUNLOAD = 162	 !  /RELEASE_TAPE=NOUNLOAD
	        PARAMETER QUAL_S_PRESHELVED = 1
	        PARAMETER QUAL_V_PRESHELVED = 163	 !  /PRESHELVED
	        PARAMETER QUAL_S_FILES_SELECTED_IN = 1
	        PARAMETER QUAL_V_FILES_SELECTED_IN = 164  !  /FILES_SELECTED
	        PARAMETER QUAL_S_INPUT_FILES_IN = 1
	        PARAMETER QUAL_V_INPUT_FILES_IN = 165	 !  /INPUT_FILES
	        PARAMETER QUAL_S_HSMOPTIONS_IN = 1
	        PARAMETER QUAL_V_HSMOPTIONS_IN = 166	 !  /HSMOPTIONS in
	        PARAMETER QUAL_S_HSMOPTIONS_OUT = 1
	        PARAMETER QUAL_V_HSMOPTIONS_OUT = 167	 !  /HSMOPTIONS out
	        PARAMETER QUAL_S_HSMHEADER_ONLY = 1
	        PARAMETER QUAL_V_HSMHEADER_ONLY = 168	 !  /HSMHEADER_ONLY
	        PARAMETER QUAL_S_CRYPT_AESALG = 1
	        PARAMETER QUAL_V_CRYPT_AESALG = 169	 !  AES algorithm requested
	        PARAMETER QUAL_S_IGNO_LIMIT = 1
	        PARAMETER QUAL_V_IGNO_LIMIT = 170	 !  /IGNORE=LIMIT
	        PARAMETER QUAL_S_DVE_LIMIT = 1
	        PARAMETER QUAL_V_DVE_LIMIT = 171	 !  /LIMIT
	        PARAMETER QUAL_S_DVE_SIZE = 1
	        PARAMETER QUAL_V_DVE_SIZE = 172		 !  /SIZE
	        PARAMETER QUAL_S_IO_LOAD = 1
	        PARAMETER QUAL_V_IO_LOAD = 173		 !  /IO_LOAD
	        PARAMETER QUAL_S_PROGRESS = 1
	        PARAMETER QUAL_V_PROGRESS = 174		 !  /PROGRESS
	        PARAMETER QUAL_S_REPAIR = 1
	        PARAMETER QUAL_V_REPAIR = 175		 !  /REPAIR
	        PARAMETER QUAL_S_DATA_FORMAT = 1
	        PARAMETER QUAL_V_DATA_FORMAT = 176	 !  /DATA_FORMAT
	        PARAMETER QUAL_S_DATA_FORMAT_COMPRESS = 1
	        PARAMETER QUAL_V_DATA_FORMAT_COMPRESS = 177  !  /DATA_FORMAT=COMPRESS
	        PARAMETER QUAL_S_NOCONV = 1
	        PARAMETER QUAL_V_NOCONV = 178
	        PARAMETER QUAL_S_WIND_FULL = 1
	        PARAMETER QUAL_V_WIND_FULL = 179	 !   /WINDOW=FULL
	        PARAMETER QUAL_S_WIND_LIMI = 1
	        PARAMETER QUAL_V_WIND_LIMI = 180	 !  /WINDOW=LIMITED
	        PARAMETER QUAL_S_quaflags_fill = 10
	        PARAMETER QUAL_V_quaflags_fill = 181	 !  longword-align next field
	        INTEGER*4 QUAL_l_quaflags2_fill
	        INTEGER*4 QUAL_Q_BEFO_VALUE(2)		 !  /BEFORE quadword time value
	        RECORD /dsc$descriptor/ QUAL_R_COMM_DESC  !  /COMMENT descriptor
	        INTEGER*4 QUAL_Q_SINC_VALUE(2)		 !  /SINCE quadword time value
	        RECORD /dsc$descriptor/ QUAL_R_CMD_DESC	 !  Command line descriptor
	        INTEGER*4 QUAL_A_EXCL_LIST		 !  /EXCLUDE list head
	        INTEGER*4 QUAL_A_JOUR_FC		 !  /JOURNAL file context
	        INTEGER*4 QUAL_A_LIST_FC		 !  /LIST file context
	        UNION
	            MAP
	            INTEGER*4 QUAL_I_OWN_VALU		 !  /OWNER_UIC value on input
	            BYTE %FILL (16)
	            END MAP
	            MAP
	                INTEGER*2 QUAL_I_OWN_MEM		 ! 	Member portion
	                INTEGER*2 QUAL_I_OWN_GRP		 ! 	Group portion
	            END MAP
	        END UNION
	        UNION
	            MAP
	            INTEGER*4 QUAL_O_OWN_VALU		 !  /OWNER_UIC value on output
	            END MAP
	            MAP
	                INTEGER*2 QUAL_O_OWN_MEM		 ! 	Member portion
	                INTEGER*2 QUAL_O_OWN_GRP		 ! 	Group portion
	            END MAP
	        END UNION
	        INTEGER*4 QUAL_A_SELE_LIST		 !  /SELECT list head
	        INTEGER*2 QUAL_W_BLOC_VALUE		 !  /BLOCK_SIZE value
	        INTEGER*2 QUAL_w_fill_bloc_val2		 !  dummy item to maintain offsets
	        INTEGER*4 QUAL_L_MT3_DENS_VALUE		 !  /MEDIA_FORMAT=(DENSITY=value)
	        BYTE      QUAL_B_DENS_VALUE		 !  /DENSITY value
	        BYTE      QUAL_B_GROU_VALUE		 !  /GROUP_SIZE value
	        BYTE      QUAL_B_VOLU_VALUE		 !  /VOLUME value
	        BYTE      QUAL_B_OPERATION_TYPE		 !  Current BACKUP operation type 
	        INTEGER*4 QUAL_A_LABEL_LIST		 !  /LABEL vector pointer - was list head
	        BYTE      QUAL_B_LABEL_LIST_SIZE	 !  number of labels in the label vector
	        BYTE      QUAL_B_LABEL_LIST_MAX_SIZE	 !  max. items the label vector holds
	        BYTE      QUAL_b_fill_label_val2(1:2)	 !  filler, longword alignment
	        INTEGER*2 QUAL_W_PROT_VALUE		 !  /PROTECTION value
	        INTEGER*2 QUAL_w_fill_prot_val2		 !  dummy item to maintain offsets
	        INTEGER*4 QUAL_A_CRYP_VLIST		 !  Pointer to list of key values
	        RECORD /dsc$descriptor/ QUAL_R_CRYP_USERKEY  !  Descriptor for user specified key
	        RECORD /dsc$descriptor/ QUAL_R_CRYP_USERALG  !  Descriptor for user specified algorithn
	        INTEGER*4 QUAL_Q_TAPE_VALUE(2)		 !  /TAPE_EXPIRATION value
	        RECORD /dsc$descriptor/ QUAL_R_COLL_NAME  !  /SCRATCH=COLLECTION descriptor
	        RECORD /dsc$descriptor/ QUAL_R_MEDI_NAME  !  /SCRATCH=MEDIA_NAME descriptor
	        RECORD /dsc$descriptor/ QUAL_R_LOCA_NAME  !  /SCRATCH=LOCATION descriptor
	        RECORD /dsc$descriptor/ QUAL_R_ICART_NAME  !  /CARTRIDGE=NAME descriptor (input)
	        RECORD /dsc$descriptor/ QUAL_R_ICART_MEDI  !  /CARTRIDGE=MEDIA_NAME descriptor (input)
	        RECORD /dsc$descriptor/ QUAL_R_OCART_NAME  !  /CARTRIDGE=NAME descriptor (output)
	        RECORD /dsc$descriptor/ QUAL_R_OCART_MEDI  !  /CARTRIDGE=MEDIA_NAME descriptor (output)
	        RECORD /dsc$descriptor/ QUAL_R_IDRVCLS_NM  !  /DRIVE_CLASS descriptor (input)
	        RECORD /dsc$descriptor/ QUAL_R_ODRVCLS_NM  !  /DRIVE_CLASS descriptor (output)
	        INTEGER*4 QUAL_L_ICART_VALU		 !  /CARTRIDGE=SIDE value (input)
	        INTEGER*4 QUAL_L_OCART_VALU		 !  /CARTRIDGE=SIDE value (output)
	        INTEGER*4 QUAL_A_CALLBACK_ADR		 !  routine for handling messages, errors, etc. 
	        INTEGER*4 QUAL_L_CTX_HANDLE		 !  BACKUP operation instance identifier
	        INTEGER*4 QUAL_L_DVE_LIMIT		 !  User provided volume expansion size limit
	        INTEGER*4 QUAL_L_DVE_SIZE		 !  User provided logical volume size 
	        INTEGER*4 QUAL_L_IO_LOAD		 !  User provider read AST threads
	        INTEGER*4 QUAL_L_PROGRESS		 !  User provided progress interval
	        RECORD /dsc$descriptor/ QUAL_R_DATA_COMP  !  Descriptor for user specified compression algo
 !  Qualifier database
	    RECORD /dsc$descriptor/ COM_SSNAME	 !  Descriptor for save set name
	    INTEGER*2 COM_VALID_TYPES		 !  BITVECTOR[16], Bit mask of valid input record types
	        PARAMETER COM_S_EOV = 1
	        PARAMETER COM_V_EOV = 0			 !  Output save medium is at end
	        PARAMETER COM_S_STANDALONE = 1
	        PARAMETER COM_V_STANDALONE = 1		 !  This is the standalone version
	        PARAMETER COM_S_FILESEEN = 1
	        PARAMETER COM_V_FILESEEN = 2		 !  At least one file processed
	        PARAMETER COM_S_VERIFYING = 1
	        PARAMETER COM_V_VERIFYING = 3		 !  Verify pass in progress
	        PARAMETER COM_S_FAIL_RSTRT = 1
	        PARAMETER COM_V_FAIL_RSTRT = 4		 !  Reel restart failed to find file
	        PARAMETER COM_S_CONTINUE = 1
	        PARAMETER COM_V_CONTINUE = 5		 !  Continue despite high error rate
	        PARAMETER COM_S_DSBL_CHKPT = 1
	        PARAMETER COM_V_DSBL_CHKPT = 6		 !  Checkpoint can not be requested
 !    since operation is not restartable
	        PARAMETER COM_S_DSBL_RSTRT = 1
	        PARAMETER COM_V_DSBL_RSTRT = 7		 !  Checkpoint was requested while
 !    DSBL_CHKPT was set
	        PARAMETER COM_S_INTERACT = 1
	        PARAMETER COM_V_INTERACT = 8		 !  SYS$COMMAND is a terminal
	        PARAMETER COM_S_TAPE_CACHE = 1
	        PARAMETER COM_V_TAPE_CACHE = 9		 !  Caching tape drive
	        PARAMETER COM_S_SEEN_FILE_OR_VBN = 1
	        PARAMETER COM_V_SEEN_FILE_OR_VBN = 10	 !  Flag to say that we have built a file-header.
	        PARAMETER COM_S_SAV_SAV = 1
	        PARAMETER COM_V_SAV_SAV = 11		 !  Save-set to save-set copy requested
	        PARAMETER COM_S_ERROR_IN_PROG = 1
	        PARAMETER COM_V_ERROR_IN_PROG = 12	 !  Note that error recovery is in progress
	        PARAMETER COM_S_MME_EXISTS = 1
	        PARAMETER COM_V_MME_EXISTS = 13		 !  An MME subsystem is defined/running
	        PARAMETER COM_S_LABEL_OVERWRITE = 1
	        PARAMETER COM_V_LABEL_OVERWRITE = 14	 !  First tape_volume label overwrite needed.
	        PARAMETER COM_S_SS_EOV = 1
	        PARAMETER COM_V_SS_EOV = 15
	        BYTE %FILL (2)				 !  Started Saveset in EOT/EOV region.
	    INTEGER*2 COM_BUFF_COUNT		 !  Count of buffers in pool
	    INTEGER*2 COM_TOTAL_BUFF		 !  Count of buffers allowed.
	    INTEGER*2 COM_SIMULT_BUFF		 !  Number of buffers in read pass.
	    BYTE      COM_I_SETCOUNT		 !  Input volume set count
	    BYTE      COM_O_SETCOUNT		 !  Output volume set count
	    BYTE      COM_I_STRUCNAME(1:12)		 !  Input volume set name
	    INTEGER*4 COM_O_BSRDATE(2)		 !  Date of backup from summary record
	    BYTE      COM_O_STRUCNAME(1:12)		 !  Output volume set name
	    BYTE      ALT_SSNAME(1:32)		 !  Storage for alternate save set name
	    BYTE      INPUT_FUNC			 !  IO$_READVBLK or IO$_READLBLK
	    BYTE      INPUT_RTYPE			 !  BRH$K_VBN or BRH$K_LBN
	    BYTE      OUTPUT_FUNC			 !  IO$_WRITEVBLK or IO$_WRITELBLK
	    BYTE      FAST_STRUCLEV			 !  Structure level of input volume set
	    BYTE      SEARCH_BI_ACE(1:50)		 ! BBLOCK[ACE$S_RMSJNL],               
 !  Block to hold the rms BI journal ACE.
	    BYTE      SEARCH_AI_ACE(1:50)		 ! BBLOCK[ACE$S_RMSJNL],
 !  Block to hold the rms AI journal ACE.
	    UNION
	        MAP
	        INTEGER*4 %FILL				 !  Common flags 2
	        END MAP
	        MAP
	            PARAMETER COM_S_CVT_REST_ODS5_ODS2 = 1
	            PARAMETER COM_V_CVT_REST_ODS5_ODS2 = 0	 !  Restore Convert of ODS-5 Filenames to ODS-2
	            PARAMETER COM_S_CVT_SAVE_ODS5_ODS2 = 1
	            PARAMETER COM_V_CVT_SAVE_ODS5_ODS2 = 1	 !  Save Convert of ODS-5 Filenames to ODS-2
	            PARAMETER COM_S_CVT_SAVE_SKIP_SYSLOST = 1
	            PARAMETER COM_V_CVT_SAVE_SKIP_SYSLOST = 2  !  Device Desc is a concealed logical so ski
	            PARAMETER COM_S_SNAPDISK = 1
	            PARAMETER COM_V_SNAPDISK = 3		 !  Input device is SnapDisk [SD$]
 !    (use [SD$] BACKUP date for comparisions)
	            PARAMETER COM_S_MTD_SUPPORTED = 1
	            PARAMETER COM_V_MTD_SUPPORTED = 4	 !  MTD device detected.
	            PARAMETER COM_S_DO_MME_END = 1
	            PARAMETER COM_V_DO_MME_END = 5		 !  Must do MME clean-up
	            PARAMETER COM_S_HARDLINKS = 1
	            PARAMETER COM_V_HARDLINKS = 6		 !  Volume HARDLINK status
	            PARAMETER COM_S_ODISK_FOREIGN = 1
	            PARAMETER COM_V_ODISK_FOREIGN = 7	 !  Ouput disk is mounted foreign
	            PARAMETER COM_S_ODISK_DFS = 1
	            PARAMETER COM_V_ODISK_DFS = 8		 !  Ouput disk is a DFS device
	            PARAMETER COM_S_WR_DATA_TS = 1
	            PARAMETER COM_V_WR_DATA_TS = 9		 !  In write data tape state
	        BYTE %FILL (2)
	        END MAP
	    END UNION
	    INTEGER*4 FIRST_BCB			 !  First BCB after EOV is detected.
	    INTEGER*4 PHYS_EOV_IN_PROG		 !  INITIAL(0),   ! Indate end of volume on physical save
	    INTEGER*4 EXH_FINAL_STATUS		 !  INITIAL(0),   ! Exit handler's final status value
	    INTEGER*4 INPUT_CHAN			 !  Input channel
	    UNION
	        MAP
	        INTEGER*4 INPUT_L_FLAGS			 !  Input flag bits
	        END MAP
	        MAP
	            PARAMETER INPUT_S_OPEN = 1
	            PARAMETER INPUT_V_OPEN = 0		 !  Input file is open
	            PARAMETER INPUT_S_EOV_IN_PROG = 1
	            PARAMETER INPUT_V_EOV_IN_PROG = 1	 !  EOV processing in progress
	            PARAMETER INPUT_S_EOV_SAVING = 1
	            PARAMETER INPUT_V_EOV_SAVING = 2	 !  SAVE_BLOCKS in progress
	            PARAMETER INPUT_S_ON_RVN = 1
	            PARAMETER INPUT_V_ON_RVN = 3		 !  Blocks exist on RVN selected by
 !     /VOLUME qualifier
	            PARAMETER INPUT_S_IGNO_INTE = 1
	            PARAMETER INPUT_V_IGNO_INTE = 4		 !  Ignore file access conflict
	            PARAMETER INPUT_S_SAVE_OK = 1
	            PARAMETER INPUT_V_SAVE_OK = 5		 !  No errors occurred during save
	            PARAMETER INPUT_S_WILDSAVE = 1
	            PARAMETER INPUT_V_WILDSAVE = 6		 !  Wild card save set given
	            PARAMETER INPUT_S_REWOUND = 1
	            PARAMETER INPUT_V_REWOUND = 7		 !  Input tape rewound for wildcards
	            PARAMETER INPUT_S_SSFOUND = 1
	            PARAMETER INPUT_V_SSFOUND = 8		 !  Input save set found (only for wildcards)
	            PARAMETER INPUT_S_ALIAS = 1
	            PARAMETER INPUT_V_ALIAS = 9		 !  Input file is an alias entry
	            PARAMETER INPUT_S_SPAN_OVER = 1
	            PARAMETER INPUT_V_SPAN_OVER = 10	 !  Tape span-over 
	            PARAMETER INPUT_S_INPUT_PHASE = 1
	            PARAMETER INPUT_V_INPUT_PHASE = 11	 !  Input phase
	            PARAMETER INPUT_S_BSR_FOUND = 1
	            PARAMETER INPUT_V_BSR_FOUND = 12	 !  Indication for BSR found
	            PARAMETER INPUT_S_COMPRESS_BCB_PRESENT = 1
	            PARAMETER INPUT_V_COMPRESS_BCB_PRESENT = 13  !  Bit that controls reading of next compr
	        BYTE %FILL (2)
	        END MAP
	    END UNION
	    INTEGER*4 INPUT_FAB			 !  Pointer to input FAB
	    INTEGER*4 INPUT_NAML			 !  Pointer to input NAML block
	    INTEGER*4 INPUT_BCB			 !  Pointer to input BCB
	    INTEGER*4 INPUT_QUAL			 !  Pointer to input qualifiers block
	    INTEGER*4 INPUT_BAD			 !  Pointer to input bad block data
	    INTEGER*4 INPUT_BLOCK			 !  Current input block number
	    INTEGER*4 INPUT_MAXBLOCK		 !  Maximum input block number
	    RECORD /dsc$descriptor/ INPUT_NAMEDESC	 !  Descriptor for input file name
	    BYTE      INPUT_STATBLK(1:8)		 !  Statistics block
	    INTEGER*4 INPUT_CREDATE(2)		 !  Creation date
	    INTEGER*4 INPUT_REVDATE(2)		 !  Revision date
	    INTEGER*4 INPUT_EXPDATE(2)		 !  Expiration date
	    INTEGER*4 INPUT_BAKDATE(2)		 !  Backup date
	    INTEGER*4 INPUT_ACCDATE(2)		 !  ODS5, Access date
	    INTEGER*4 INPUT_ATTDATE(2)		 !  ODS5, Attribute change date
	    BYTE      INPUT_EX_RECATTR(1:8)
 !  ODS5, Extended RMS record attributes 
	    BYTE      INPUT_LENGTH_HINT(1:16)
 !  (NT/FAT) File length hint
	    INTEGER*4 INPUT_MEDIA_ID		 !  Media id of input device
	    BYTE      INPUT_FILEOWNER(1:4)		 !  File owner UIC
	    BYTE      INPUT_FILECHAR(1:4)		 !  File characteristics
	    BYTE      INPUT_RECATTR(1:32)		 !  Record attributes
	    INTEGER*2 INPUT_LINKCOUNT		 !  ODS5 (hard) link count
	    INTEGER*2 INPUT_FILLER			 !  filler
	    INTEGER*4 INPUT_PROC_LIST		 !  List of processed file ID's
	    INTEGER*4 INPUT_PLACEMENT(1:2)		 !  List head for placement data
	    INTEGER*4 INPUT_VBN_LIST(1:2)		 !  List head for VBN data
	    INTEGER*2 INPUT_PLACE_LEN		 !  Length of placement data as attribute
	    INTEGER*2 fill_input_blk		 !  Filler, longword alignment
	    INTEGER*4 INPUT_EXPSIZE
	    INTEGER*4 OUTPUT_CHAN			 !  Output channel
	    UNION
	        MAP
	        INTEGER*2 OUTPUT_W_OUTPUT_FLAGS		 !  Output flag bits
	        END MAP
	        MAP
	            PARAMETER OUTPUT_S_OPEN = 1
	            PARAMETER OUTPUT_V_OPEN = 0		 !  Output file is open
	            PARAMETER OUTPUT_S_FIRST = 1
	            PARAMETER OUTPUT_V_FIRST = 1		 !  Verifying first block
	            PARAMETER OUTPUT_S_LAST = 1
	            PARAMETER OUTPUT_V_LAST = 2		 !  Verifying last block
	            PARAMETER OUTPUT_S_INCR_DIR = 1
	            PARAMETER OUTPUT_V_INCR_DIR = 3		 !  Special /INCREMENTAL directory scan
	            PARAMETER OUTPUT_S_IMPLICIT = 1
	            PARAMETER OUTPUT_V_IMPLICIT = 4		 !  Output file implicitly opened
	            PARAMETER OUTPUT_S_ACL_ERROR = 1
	            PARAMETER OUTPUT_V_ACL_ERROR = 5	 !  Error occurred processing ACL
	            PARAMETER OUTPUT_S_ACL_FIRST_TIME = 1
	            PARAMETER OUTPUT_V_ACL_FIRST_TIME = 6	 !  First time through processing ACL
	            PARAMETER OUTPUT_S_DIR_OPEN = 1
	            PARAMETER OUTPUT_V_DIR_OPEN = 7		 !  An output directory is open
	            PARAMETER OUTPUT_S_NONSEQ_IN = 1
	            PARAMETER OUTPUT_V_NONSEQ_IN = 8	 !  Input saveset is not sequential
	            PARAMETER OUTPUT_S_SKIP_ALIAS = 1
	            PARAMETER OUTPUT_V_SKIP_ALIAS = 9	 !  Skip current [alias] file for output
	            PARAMETER OUTPUT_S_ALIAS_OPEN = 1
	            PARAMETER OUTPUT_V_ALIAS_OPEN = 10	 !  Skip current [alias] file for output
	        BYTE %FILL (2)
	        END MAP
	    END UNION
	    INTEGER*2 fill_output_flgs2		 !  Filler, longword alignment
	    INTEGER*4 OUTPUT_FAB			 !  Pointer to output FAB
	    INTEGER*4 OUTPUT_NAML			 !  Pointer to output NAML block
	    INTEGER*4 OUTPUT_BCB			 !  Pointer to output BCB
	    INTEGER*4 OUTPUT_QUAL			 !  Pointer to output qualifiers block
	    INTEGER*4 OUTPUT_BAD			 !  Pointer to output bad block data
	    INTEGER*4 OUTPUT_BLOCK			 !  Current output block number
	    INTEGER*4 OUTPUT_MAXBLOCK		 !  Maximum output block number
	    UNION
	        MAP
	        INTEGER*4 DGMQ_OUTPUT_DEVGEOM(2)	 !  Output device geometry
	        END MAP
	        MAP
	            BYTE      DGM_SECTORS			 !  DIB$B_SECTORS
	            BYTE      DGM_TRACKS			 !  DIB$B_TRACKS
	            INTEGER*2 DGM_CYLINDERS			 !  DIB$W_CYLINDER
	            INTEGER*4 DGM_MAXBLOCK			 !  DIB$L_MAXBLOCK
	        END MAP
	    END UNION
	    BYTE      OUTPUT_ATTBUF(1:192)		 ! BBLOCK[ATTBUF_LENGTH],	! Values from attribute record
	    INTEGER*4 OUTPUT_VID_LIST		 !  List of processed volume ID's
	    INTEGER*4 OUTPUT_INDEX_EFBLK		 !  Where in INDEXF the EFBLK should be, if /NOINIT was selected
	    INTEGER*4 OUTPUT_GPT_BOOTADDR		 !  LBN of EFI/GPT boot partition file
	    INTEGER*4 OUTPUT_GPT_BOOTSIZE		 !  EFI/GPT boot partition file size
	    INTEGER*4 OUTPUT_GPT_DIAGADDR		 !  LBN of EFI/GPT diagnostic partition file
	    INTEGER*4 OUTPUT_GPT_DIAGSIZE		 !  EFI/GPT diagnostic partition file size
	    INTEGER*4 LIST_TOTFILES			 !  Listing -- total files
	    INTEGER*4 LIST_TOTSIZE			 !  Listing -- total size
	    INTEGER*4 VERIFY_FC			 !  Pointer to verification File Context (FC)
	    INTEGER*4 VERIFY_USE_COUNT		 !  Use count for current VERIFY_QUAL
	    INTEGER*4 VERIFY_QUAL			 !  Corresponding input qualifier block
	    INTEGER*4 COMPARE_BCB			 !  BCB for compare buffer
	    INTEGER*4 FAST_BUFFER			 !  Pointer to index file buffer
	    INTEGER*4 FAST_BUFFER_SIZE		 !  Size of index file buffer
	    BYTE      FAST_RVN			 !  RVN of current MFD
	    BYTE      FAST_SCANNING			 !  
	    INTEGER*2 DIR_VERLIMIT			 !  File version limit
	    INTEGER*4 FAST_IMAP_SIZE		 !  Number of blocks in index file bitmap
	    INTEGER*4 FAST_IMAP			 !  Bitmap of valid and selected files
	    INTEGER*4 FAST_HDR_OFFSET		 !  VBN offset to file header
	    INTEGER*4 FAST_BOOT_LBN			 !  LBN of 1st boot file
	    INTEGER*4 FAST_BOOT_LBN2		 !  LBN OF 2nd boot file
	    INTEGER*4 FAST_GPT_PRESENT		 !  TRUE if Itanium/EFI/GPT on input volume
	    INTEGER*4 FAST_GPT_BOOT_LBN		 !  LBN of EFI/GPT boot partition file
	    INTEGER*4 FAST_GPT_DIAG_LBN		 !  LBN of EFI/GPT diagnostic partition file
	    INTEGER*4 CURRENT_PFL			 !  Current PFL for file scan/map.
	    INTEGER*4 PFL_LIST			 !  Header for file data.
	    UNION
	        MAP
	        BYTE      MAP_B_PHASE			 !  Bit mask to indicate start of mapping phase
	        END MAP
	        MAP
	            PARAMETER MAP_S_JOURNAL_ENTRY = 1
	            PARAMETER MAP_V_JOURNAL_ENTRY = 0	 !  Offset into NEW_MAP_PHASE
	            PARAMETER MAP_S_LOST_FILES = 1
	            PARAMETER MAP_V_LOST_FILES = 1		 !  Processing lost files - NEW_MAP_PHASE
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    BYTE      fill_phase_flgs2(1:3)		 !  Filler, longword alignment
	    INTEGER*4 VVM_LIST(1:2)			 !  VVM listhead.
	    INTEGER*4 VVM_FREE_LIST(1:2)		 !  Listhead of free VVMs.
	    INTEGER*4 VVM_LBN_HEADER		 !  VVM list - LBN pointer.
	    INTEGER*4 MEGA_BUFFER_SUPPORT		 !  The output device is capable of 
	    INTEGER*4 CLEAR_ASTLM_DELTA(2)
 !   handling the new buffer scheme.
	    INTEGER*4 JOUR_BUFFER			 !  Journal buffer
	    INTEGER*4 JOUR_DIR			 !  Current directory string
	    INTEGER*4 JOUR_HIBLK			 !  Highest allocated block
	    INTEGER*4 JOUR_EFBLK			 !  End of file block
	    INTEGER*4 JOUR_INBLK			 !  Current input block
	    INTEGER*2 JOUR_DIR_POS			 !  Offset in JOUR_DIR for segmented 
 !  directory names
	    INTEGER*2 JOUR_FFBYTE			 !  End of file byte
	    INTEGER*2 JOUR_INBYTE			 !  Current input byte
	    INTEGER*2 JOUR_STRUCT_LEV		 !  Current journal struture level
	    BYTE      JOUR_COUNT			 !  XOR byte count context
	    BYTE      JOUR_REVERSE			 !  True if reading backward
	    INTEGER*2 JOUR_EXSZ			 !  Default file extention size.
	    INTEGER*4 CHKPT_HIGH_SP			 !  High value of SP for saved portion
	    INTEGER*4 CHKPT_LOW_SP			 !  Low value of SP for saved portion
	    INTEGER*4 CHKPT_STACK			 !  Pointer to save area for stack
	    INTEGER*4 CHKPT_VARS			 !  Pointer to save area for variables
	    INTEGER*4 CHKPT_STATUS			 !  Failure status of a re-access
	    INTEGER*4 CHKPT_LIST(1:2)		 !  Q header of buffers for checkpoint data.
	    INTEGER*4 CHKPT_EOV_DATA(1:2)		 !  Storage for EOV checkpoint context
	    UNION
	        MAP
	        BYTE      %FILL				 ! BITVECTOR[8], ! Indicates a restart has taken place
	        END MAP
	        MAP
	            PARAMETER RESTART_S_RESTARTING = 1
	            PARAMETER RESTART_V_RESTARTING = 0	 !  Restart is taking place
	            PARAMETER RESTART_S_ON_RVN = 1
	            PARAMETER RESTART_V_ON_RVN = 1		 !  Restart took place on the RVN
	            PARAMETER RESTART_S_CLEAR_AST = 1
	            PARAMETER RESTART_V_CLEAR_AST = 2	 !  Restarting - must clear AST
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    BYTE      PARTIAL_MAPPING		 !  Signal partial mapping after restart 
	    INTEGER*2 fill_pmap_flg2		 !  Filler, longword alignment
	    INTEGER*4 DIR_CHAN			 !  Channel assigned to device
	    INTEGER*4 DIR_NAML			 !  Pointer to name block
	    RECORD /dsc$descriptor/ DIR_SEL_DIR	 !  Descriptor for selection directory
	    RECORD /dsc$descriptor/ DIR_SEL_NTV	 !  Descriptor for selection n.t;v
	    INTEGER*4 DIR_DEV_DESC			 !  Descriptor for device
	    BYTE      DIR_STRUCLEV			 !  Structure level of directory
	    INTEGER*2 DIR_LEVELS			 !  Current number of active levels
	    UNION
	        MAP
	        BYTE      DIR_B_FLAGS			 !  Flag bits
	        END MAP
	        MAP
	            PARAMETER DIR_S_IMAGE_SCAN = 1
	            PARAMETER DIR_V_IMAGE_SCAN = 0		 !  Image mode scan
	            PARAMETER DIR_S_SCAN_FAILED = 1
	            PARAMETER DIR_V_SCAN_FAILED = 1		 !  Previous scan failed
	            PARAMETER DIR_S_HARD_STOP = 1
	            PARAMETER DIR_V_HARD_STOP = 2		 !  Immediate return on terminator
	            PARAMETER DIR_S_SCANNED_DIRS = 1
	            PARAMETER DIR_V_SCANNED_DIRS = 3	 !  Return scanned directories
	            PARAMETER DIR_S_INITIAL = 1
	            PARAMETER DIR_V_INITIAL = 4		 !  Initial call
	            PARAMETER DIR_S_ROOT_MFD = 1
	            PARAMETER DIR_V_ROOT_MFD = 5		 !  Scan root MFD only
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    UNION
	        MAP
	        BYTE      D_STAT_B_STATUS		 !  DIR_STATUS - Directory status flags
	        END MAP
	        MAP
	            PARAMETER D_STAT_S_VALID = 1
	            PARAMETER D_STAT_V_VALID = 0		 !  DIR_STATUS is valid
	            PARAMETER D_STAT_S_DIR_SEL = 1
	            PARAMETER D_STAT_V_DIR_SEL = 1		 !  Directory is selected
	            PARAMETER D_STAT_S_SCANNED = 1
	            PARAMETER D_STAT_V_SCANNED = 2		 !  Directory was scanned
	            PARAMETER D_STAT_S_FILE_SEL = 1
	            PARAMETER D_STAT_V_FILE_SEL = 3		 !  Files in directory are selected
	        BYTE %FILL (1)
	        END MAP
	    END UNION
	    BYTE      DIR_FILLER_01(1:7)		 !  Filler for Quadword Alignment
	    RECORD /dsc$descriptor/ DIR_PATH_DESC	 !  Current directory path descriptor
	    INTEGER*4 DQE_LIVE_HDR(1:2)		 !  Live directory queue entry list
	    INTEGER*4 DQE_FREE_HDR(1:2)		 !  Free directory queue entry list
	    INTEGER*4 DQE_SAVE_PTR			 !  Saved directory queue entry pointer
	    INTEGER*4 DIR_SEL_LATEST		 !  Latest version selector
	    INTEGER*4 DIR_SCANLIMIT(1:8)		 !  ODS-1 directory scan limits
	    INTEGER*4 FCE_LIVE_HDR(1:2)		 !  Live Filename Conversion Entry list
	    INTEGER*4 FCE_FREE_HDR(1:2)		 !  Free Filename Conversion Entry list
	    UNION
	        MAP
	        INTEGER*2 FCE_CTX_FLAGS			 !  File's FID.
	        END MAP
	        MAP
	        UNION
	            MAP
	            INTEGER*2 %FILL
	            END MAP
	            MAP
	                PARAMETER FCE_S_HOLD_FRST = 1
	                PARAMETER FCE_V_HOLD_FRST = 0		 !  Hold First Filename's Sorted Order
	            BYTE %FILL (1)
	            END MAP
	        END UNION
	        END MAP
	    END UNION
	    INTEGER*2 fce_ctx_fill			 !  Filler
	    INTEGER*4 FCE_CONV_CTX			 !  Filename Conversion Context
	    INTEGER*4 FCE_FRST_PTR			 !  Address of First Conversion Entry for this Directory
	    INTEGER*4 FCE_REST_PTR			 !  Address of the Restored Conversion Entry for this Directory
	    INTEGER*4 FCE_LAST_PTR			 !  Address of Last Conversion Entry for this Directory
	    INTEGER*4 FCE_PREV_LAST_PTR		 !  Address of the Previous Directory's Last FCE Entry
	    INTEGER*4 FCE_SYSLOST_CTR		 !  Filename Conversion SYSLOST counter
	    INTEGER*4 DCE_LIVE_HDR(1:2)		 !  Live Directoryname Conversion Entry list
	    INTEGER*4 DCE_FREE_HDR(1:2)		 !  Free Directoryname Conversion Entry list
	    UNION
	        MAP
	        INTEGER*2 DCE_CTX_FLAGS			 !  File's FID.
	        END MAP
	        MAP
	        UNION
	            MAP
	            INTEGER*2 %FILL
	            END MAP
	            MAP
	                PARAMETER DCE_S_DIRECTORY = 1
	                PARAMETER DCE_V_DIRECTORY = 0		 !  Directory File Entries being processed
	                PARAMETER DCE_S_MFD_ISRT = 1
	                PARAMETER DCE_V_MFD_ISRT = 1		 !  MFD has been inserted
	                PARAMETER DCE_S_MFD_READ = 1
	                PARAMETER DCE_V_MFD_READ = 2		 !  MFD summary has been read 
	                PARAMETER DCE_S_MFD_CONV = 1
	                PARAMETER DCE_V_MFD_CONV = 3		 !  MFD contents have been converted
	                PARAMETER DCE_S_MFD_PCVT = 1
	                PARAMETER DCE_V_MFD_PCVT = 4		 !  MFD contents have been preconverted
	            BYTE %FILL (1)
	            END MAP
	        END UNION
	        END MAP
	    END UNION
	    INTEGER*2 dce_ctx_fill			 !  Filler
	    INTEGER*4 INPUT_MTL			 !  Pointer to input MTL entry
	    INTEGER*4 OUTPUT_MTL			 !  Pointer to output MTL entry
	    INTEGER*4 CURRENT_MTL			 !  Pointer to MTL for current operation
	    INTEGER*4 CURRENT_VCB			 !  Pointer to VCB for current operation
	    INTEGER*4 CURRENT_WCB			 !  Pointer to WCB for current operation
	    RECORD /dsc$descriptor/ RESNAME_DESC	 !  Descriptor for RSA in STA_DISMOUNT_OU
	    INTEGER*2 DQF_QUOTA_FID(1:3)		 !  File ID of quota file
	    INTEGER*2 fill_dqfquotafid		 !  maintain longword alignment
	    INTEGER*4 DQF_ROOT			 !  Root of quota table
	    INTEGER*4 DQF_COUNT			 !  Count of entries in quota table
	    INTEGER*4 QUEUE_HEADERS(1:6)		 !  Queue headers for:
 ! 	    Allocated disk extents
 ! 	    Required extents
 ! 	    Used extension file IDs
	    INTEGER*4 SYSDISK_CHAN			 !  Standalone backup system disk channel.
	    INTEGER*4 LOCK_RANGE(1:2)		 !  Pair of addresses for WS lock.
	    INTEGER*4 ACL_BUFFER			 !  Pointer to the ACL to save
	    RECORD /dsc$descriptor/ ACL_FIB_DESCR	 !  FIB descriptor
	    INTEGER*4 ACL_LENGTH			 !  Size of the entire ACL
	    BYTE      ACL_FIB(1:96)			 ! BBLOCK [FIB$C_LENGTH],  FIB storage
	    INTEGER*4 SAVESET_ENCR			 !  flag(s)
	    INTEGER*4 CRYP_IN_CONTEXT		 !  Pointer to encrypt context for input ss
	    INTEGER*4 CRYP_OU_CONTEXT		 !  Pointer to output encrypt context
	    INTEGER*4 CRYP_DA_CONTEXT		 !  Pointer to datakey encryption context
	    BYTE      CRYP_AES_DATA_ENCIV(1:16)	 !  Copy of IV for AES encryption of savesets
	    BYTE      CRYP_DATA_ENCIV(1:8)		 !  Copy of IV for encryption of savesets
	    BYTE      CRYP_DATA_CODE(1:4)		 ! BBLOCK [4],	! Saveset encryption algorithm code
	    BYTE      CRYP_DATA_KEY(1:8)		 ! BBLOCK [8] ! Saveset data key
	    BYTE      CRYP_DATA_IV(1:8)		 ! BBLOCK [8] ! Saveset encryption IV
	    INTEGER*4 CRYP_DATA_CKSM		 !  Checksum for code,key, and iv
	    BYTE      CRYP_AES_DATA_CODE(1:2)	 ! BBLOCK [4],	! Saveset encryption algorithm code
	    BYTE      CRYP_AES_DATA_KEY(1:32)	 ! BBLOCK [32] ! Saveset data key
	    BYTE      CRYP_AES_DATA_IV(1:16)	 ! BBLOCK [16] ! Saveset encryption IV
	    INTEGER*4 CRYP_AES_DATA_CKSM		 !  Checksum for code,key, and iv
	    BYTE      CRYP_AES_FILLER(1:10)		 !  Filler to 16 bytes boundry
	    INTEGER*4 COMPRESS_BUFFER_ADDR		 !  Pointer to the compression buffer
	    INTEGER*4 COMPRESS_BUFFER_LEN		 !  Length of compression buffer
	    INTEGER*4 COMPRESS_ALG			 !  Compression algorithm 
	    INTEGER*4 COMPRESS_BCB_ORG_SIZE		 !  BCB size before compression
	    INTEGER*4 COMPRESS_HEADER		 !  Header already compressed
	    INTEGER*4 COMPRESS_TMP_BUFFER_ADDR	 !  Pointer to temporary compression buffer
	    INTEGER*4 COMPRESS_INT_BUFFER_ADDR	 !  Pointer to output compression buffer
	    INTEGER*4 COMPRESS_TMP_BUFFER_LEN
	    INTEGER*4 COMPRESS_INT_BUFFER_LEN	 !  Total length of compressed buffer
	    BYTE      LOST_FILES_RVN		 !  Current RVN for lost files processing
	    BYTE      fill_lostfilervn(1:3)		 !  Maintain longword alignment
	    INTEGER*4 LOST_FILES_FNUM		 !  Current file number for lost files processing
	    BYTE      INCR_FIB(1:96)		 ! BBLOCK [FIB$C_LENGTH], FIB for wildcarding
	    BYTE      INCR_RESNAME(1:252)		 ! VECTOR[ATR$S_ASCNAME,BYTE], Resultant String
	    BYTE      fill_incrresname(1:2)		 !  Maintain longword alignment
	    INTEGER*4 INCR_RESNAME_SIZE		 !  Size of entire resultant string
	    INTEGER*4 INCR_NTS			 !  Size of "name.type" portion
	    INTEGER*4 INCR_VER			 !  Binary version number
	    INTEGER*2 INCR_BACKLINK(1:3)		 !  Backlink
	    INTEGER*2 fill_incrbacklink		 !  Maintain longword alignment
	    INTEGER*4 INCR_FILECHAR			 !  Characteristics of disk file
	    INTEGER*4 INCR_BAKDATE(2)		 !  Backup date
	    RECORD /dsc$descriptor/ INCR_DIR_DEV_DESC  !  Descriptor for special dir. dev.
	    RECORD /dsc$descriptor/ INCR_DIR_PATH_DESC  !  Descriptor for special dir.
	    BYTE      INCR_HEADER_FILENAME(1:252)
 ! VECTOR[ATR$S_ASCNAME,BYTE], Filename in the header
	        PARAMETER INCR_S_SKIP_DIR = 1
	        PARAMETER INCR_V_SKIP_DIR = 0		 !  Skip saveset dir/files
	        PARAMETER INCR_S_SAVE_ALL_DIR = 1
	        PARAMETER INCR_V_SAVE_ALL_DIR = 1	 !  Save all subdir's/related files of a dir.
	        PARAMETER INCR_S_DISABLE_SAVE_ALL = 1
	        PARAMETER INCR_V_DISABLE_SAVE_ALL = 2	 !  DISABLE the above flag.
	        PARAMETER INCR_S_incr_flags_filler1 = 13
	        PARAMETER INCR_V_incr_flags_filler1 = 3
	        BYTE %FILL (2)				 !  longword-align next field
	    INTEGER*4 CURRENT_VID			 !  Pointer to VID block being processed
	    INTEGER*4 EXH_CTRL_BLK(1:4)		 !  Exit handler control block
	        INTEGER*2 CHK_FLAGS_W_COUNT
	        PARAMETER CHK_FLAGS_S_F11 = 1
	        PARAMETER CHK_FLAGS_V_F11 = 16
	        PARAMETER CHK_FLAGS_S_SAV = 1
	        PARAMETER CHK_FLAGS_V_SAV = 17
	        PARAMETER CHK_FLAGS_S_SAVE_SET = 1
	        PARAMETER CHK_FLAGS_V_SAVE_SET = 18
	        PARAMETER CHK_FLAGS_S_SRCH_LIST = 1
	        PARAMETER CHK_FLAGS_V_SRCH_LIST = 19
	        PARAMETER CHK_FLAGS_S_SMFS = 1
	        PARAMETER CHK_FLAGS_V_SMFS = 20		 !  True if SMFS device found
	        PARAMETER CHK_FLAGS_S_fill_chkflags1 = 3
	        PARAMETER CHK_FLAGS_V_fill_chkflags1 = 21  !  BYTE-align next bit/flag
	        PARAMETER CHK_FLAGS_S_DRVCLS_MISUSED = 1
	        PARAMETER CHK_FLAGS_V_DRVCLS_MISUSED = 24  !  (formerly CHK_QUALS[CHK_DRVCLS_MISUSED]
	        PARAMETER CHK_FLAGS_S_fill_chkquals1 = 7
	        PARAMETER CHK_FLAGS_V_fill_chkquals1 = 25
	        BYTE %FILL (2)				 !  Maintain longword alignment
	    INTEGER*4 MAPPING_NEW_FILE		 !  Begin mapping a new file
	    INTEGER*4 EXTENT_VBN			 !  Starting VBN of this extent
	    INTEGER*4 STILL_ADJUSTING		 !  Indicate first pass through mapping pointers
	    INTEGER*4 EXIT_STATUS			 !  Image exit status
	    INTEGER*4 EOV_XOR_WRITTEN		 !  Note that an XOR block has
 !  already been written at the
 !  end of volume.
	    INTEGER*4 OUTSTANDING_WRITE_COUNT	 !  INITIAL(0),
 !  Count of outstanding writes for non-TMSCP support
	    INTEGER*4 UCB_ADDR			 !  address of saveset device's UCB
	    INTEGER*4 MCB_ADDR			 !  address of MCB for saveset device
	    INTEGER*4 SNAPDISK_BACKUP(2)		 !  BACKUP date (returned from sd$getdisk routine)
 !  Store VMSCOMMON.DIR FID
	    INTEGER*2 VMSCOMMON_FID_NUM		 !  FILE NUMBER
	    INTEGER*2 VMSCOMMON_FID_SEQ		 !  FILE SEQUENCE NUMBER
	    BYTE      VMSCOMMON_FID_RVN		 !  SHORT FORM RVN
	    BYTE      VMSCOMMON_FID_NMX		 !  EXTENDED FILE NUMBER
	END STRUCTURE	! BCK_COMMON_DATA
	PARAMETER BTC_K_CONSIDER = '00000001'X	 !  Consider a file
	PARAMETER BTC_K_REJECT = '00000002'X	 !  Reject a file
	PARAMETER BTC_K_ALRFAST = '00000003'X	 !  Already chosen on bitmap.
	PARAMETER BTC_K_MAPPED = '00000004'X	 !  Mapped by scanner.
	PARAMETER BTC_K_CHOSEN = '00000005'X	 !  File is now chosen.
	PARAMETER BCK_K_BLOCK_SIZE_MIN = '00000800'X
	PARAMETER BCK_K_BLOCK_SIZE_MAX = '0000FFFF'X
	PARAMETER BCK_K_GROUP_SIZE_MIN = '00000000'X
	PARAMETER BCK_K_GROUP_SIZE_MAX = '00000064'X
	PARAMETER BCK_K_TAPE_DENS_800 = '00000320'X
	PARAMETER BCK_K_TAPE_DENS_833 = '00000341'X
	PARAMETER BCK_K_TAPE_DENS_1600 = '00000640'X
	PARAMETER BCK_K_TAPE_DENS_62500 = '0000186A'X
	PARAMETER BCK_K_VOLUME_NUM_MIN = '00000001'X
	PARAMETER BCK_K_VOLUME_NUM_MAX = '000000FF'X
	PARAMETER BCK_K_IO_LOAD_DEFAULT = '00000008'X
	PARAMETER CTRL_T$K_RESTORE_MSG = '00000000'X
	PARAMETER CTRL_T$K_SAVE_MSG = '00000001'X
	PARAMETER CTRL_T$K_SAVEINACTIVE_MSG = '00000002'X
	PARAMETER CTRL_T$K_COMPARE_MSG = '00000003'X
	PARAMETER CTRL_T$K_LOGFILE = '00000001'X
	PARAMETER COMPRESS$K_DEFLATE = '00000000'X
	PARAMETER COMPRESS$K_UNSUPPORTED = '00000001'X
	PARAMETER BCK_K_FILE_VERLIMIT_MAX = '00007FFF'X
	PARAMETER BCK_K_FILCNT_OVERHEAD = '0000000A'X
	PARAMETER BCK$INPUT_PHASE = '00000001'X
	PARAMETER BCK$VERIFY_PHASE = '00000002'X
	PARAMETER BCK$POSTPROCESSING_PHASE = '00000003'X
	PARAMETER BCK$COMPRESS_HEADER = '00000000'X
	PARAMETER BCK$COMPRESS_FIX = '00000001'X
	PARAMETER BCK$COMPRESS_VAR = '00000000'X
	PARAMETER BCK$COMPRESS_SUMMARY_WRITE = '00000001'X
	PARAMETER BCK$COMPRESS_SUMMARY_READ = '00000000'X
	PARAMETER BCK$COMPRESS_MAX_ALGO = '00000010'X
!DEC$ END OPTIONS
