$ !
$ ! Command procedure for setting up execution environment for ACMEUTIL.
$ !
$ !
$ ! ACMEUTIL is a DCL level utility program for executing $ACM[W] based
$ ! authentication and changepassword requests.
$ !
$ ! Command syntax and (currently supported) qualifiers:
$ !
$ !	ACMEUTIL AUTHENTICATE
$ !	    /[NO]DEBUG
$ !	    /[NO]DIALGOUE[=([NO]INPUT,[NO]ECHO)]
$ !	    /DOMAIN=domain
$ !	    /FLAGS=(ACQUIRE_CREDENTIALS, COPY_PERSONA, DEFAULT_PRINCIPAL,
$ !		    FOREIGN_POLICY_HINTS, MERGE_PERSONA, NOAUDIT,
$ !		    NOAUTHORIZATION, OVERRIDE_MAPPING, TIMEOUT, UCS
$ !		    )
$ !	    /LOGON_TYPE[=NETWORK|BATCH|LOCAL|DIALUP|REMOTE]
$ !	    /PASSWORD=("current_password1"[,"current_password2"])
$ !	    /PERSONA[=(COPY,MERGE)]
$ !	    /PRINCIPAL=principal
$ !	    /TIMEOUT_INTERVALS[=t] (0 < t < 300)
$ !	    /[NO]TRACE
$ !
$ !	ACMEUTIL CHANGE
$ !	    /[NO]DEBUG
$ !	    /[NO]DIALGOUE[=([NO]INPUT,[NO]ECHO)]
$ !	    /DOMAIN=domain
$ !	    /FLAGS=(DEFAULT_PRINCIPAL, NOAUDIT, TIMEOUT, UCS)
$ !	    /LOGON_TYPE[=LOCAL|DIALUP|REMOTE]
$ !	    /NEW_PASSWORD=("new_password1"[,"new_password2"])
$ !	    /NEW_PASSWORD_FLAGS=(password1[,password2])
$ !	    /PASSWORD=("current_password1"[,"current_password2"])
$ !	    /PRINCIPAL=principal
$ !	    /TIMEOUT_INTERVALS[=t] (0 < t < 300)
$ !	    /[NO]TRACE
$ !
$ !
$ ! Notes:
$ !
$ !	/LOGON_TYPE passes a ACME$_LOGON_TYPE item; without an explicit
$ !	    value defaults to LOCAL
$ !
$ !	/PERSONA sets the ACQUIRE_CREDENTIALS modifier flag; the COPY and
$ !	    MERGE keywords set the respective modifief flag; MERGE without
$ !	    COPY will attempt to bind any non-VMS credentials acquired to
$ !	    the process' natural persona (aka ACM_MERGE)
$ !
$ !	/DIALOGUE passes a CONTEXT parameter and DIALOGUE_SUPPORT item; the
$ !	     INPUT and NOECHO keywords set the respective capabilities flag
$ !
$ !	/NEW_PASSWORD or /NEW_PASSWORD_FLAGS is used when setting new 
$ !		password1 and/or password2.
$ !
$ !	   /NEW_PASSWORD=(new_password1[,new_password2]) is to specify
$ !		actual string(s) for the new password(s).  This qualifier can
$ !		be used in the dialogue request as well as in the non-dialogue
$ !		mode.
$ !
$ !	   /NEW_PASSWORD_FLAGS=(password1[,password2]) is to indicate
$ !		which password (password1 or/and password2) will be updated in
$ !		the dialogue request mode.  This qualifier is only for the
$ !		dialogue request mode (can't be used in the non-dialogue mode).
$ !
$ !	   /NEW_PASSWORD & /NEW_PASSWORD_FLAGS cannot be used at the
$ !		same time.
$ !
$ !	/FLAGS=TIMEOUT and /TIMEOUT_INTERVAL=t are used to set a timeout value.
$ !		The default timeout value is 30 seconds (when /FLAGS=TIMEOUT
$ !		or /FLAGS=TIMEOUT/TIMEOUT_INTERVAL is specified).
$ !		To set a specific timeout internal value (0 < t <= 300),
$ !		the format is /FLAGS=TIMEOUT/TIMEOUT_INTERVAL=t.  For 
$ !		example, /FLAGS=TIMEOUT/TIMEOUT_INTERVAL=50 is to set 
$ !		50 seconds of the timeout value.
$ !
$ !	/FLAGS=UCS is not supported (i.e. not working) in this version.
$ !
$   ProcSpec    = F$ENVIRONMENT( "PROCEDURE" )
$   ProcDev     = F$PARSE( ProcSpec,,, "DEVICE", "SYNTAX_ONLY" )
$   ProcDir     = F$PARSE( ProcSpec,,, "DIRECTORY", "SYNTAX_ONLY" )
$   DEFINE ACME$TOOLS 'ProcDev''ProcDir'
$   SET COMMAND ACME$TOOLS:ACMEUTIL
$   DEFINE DBG$IMAGE_DSF_PATH ACME$TOOLS
