#pragma	module RAD_EXT_AUTH	"RAD_EXT_AUTH-1-X"

/*
**++
**  FACILITY:  RADIUS-VMS
**
**  MODULE DESCRIPTION:
**
**      External module for performing authentication 
**	for RADIUS-VMS server, it is used as an addition to a 
**	standard RADIUS-VMS authentication. 
**
**  AUTHORS:
**
**      Copyright  Ruslan R. Laishev 2000
**
**  CREATION DATE:  11-MAR-2000
**
**  DESIGN ISSUES:
**
**      This module supposed to contains external user-written pocedures
**	are called from RADIUS-VMS server.
**
**	N.B	Since RADIUS-VMS server is a DEC Threads application, you should
**		write thread safe code for the AUTHORIZE routine, using
**		reenterancy or the syncronization technics.
**
**	N.B.	The INIT & CLEANUP routines is called when all auth-threads is not ran.
**
**	N.B.	RADIUS-VMS makes hardcoded references to event flags 19-22.
**
**	To build this module (ALPHA):
**	
**	$CC/PREFFIX=ALL	RAD_EXT_AUTH.C/REENTRANCY=MULTITHREAD
**	$LINK/SHARE RAD_EXT_AUTH.OBJ,SYS$INPUT:/OPT
**	SYMBOL_VECTOR=(INIT=PROCEDURE,AUTHORIZE=PROCEDURE,CLEANUP=PROCEDURE)
**	<ctrl/Z>
**
**	To build this module (VAX):
**	$CC/PREFFIX=ALL  RAD_EXT_AUTH.C
**	$LINK/SHARE RAD_EXT_AUTH.OBJ,SYS$INPUT:/OPT
**	UNIVERSAL=INIT,AUTHENTICATE,AUTHORIZE,CLEANUP
**	<ctrl/Z>
**
**
**	DEFINE/SYSTEM/EXEC	RADIUS_EXT_AUTH	dev:[dir]RAD_EXT_AUTH.EXE
**
**	Add entry into a RADIUS_USERS:
**	DEFAULT3	Auth-Type = Extern
**
**  MODIFICATION HISTORY:
**
**      {@tbs@}...
**--
*/


/*
**
**  INCLUDE FILES
**
*/

#include	<stdlib.h>
#include	<stdio.h>
#include	<ssdef.h>

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Initializes the context used by this module. Called before 
**	auth-treads started.
**
**	If you do not need to maintain any context between calls to your
**	AUTHORIZE routines, it is OK to simply
**	set the context pointer to NULL. If you do this, your CLEANUP
**	routine will never be called.
**
**  FORMAL PARAMETERS:
**
**      context:	address of a pointer to the allocated context
**	
**  RETURN VALUE:
**
**	VMS condition value
**
**--
*/
int	INIT	(void	**context)
{
	printf("\n+++ INIT +++\n");
	(*context) = NULL;
	return	SS$_NORMAL;
}



/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Performs an authorization of user with a given username/password pair
**
**  FORMAL PARAMETERS:
**
**      context:	address of a pointer to the allocated context
**	user:		address of an username character string
**	userlen:	length of the username
**	client:		address of a client name
**	clientlen:	length of the client name
**	sess_tmo:	storage for Session-Timeout value
**	pass:		password string
**	passlen:	length of the password string
**	called_id:	Called-Station-Id string
**	called_id_len:	length of the Called-Station-Id string
**	calling_id:	Calling-Station-Id string
**	calling_id_len:	length of the Calling-Station-Id string
**
**
**  RETURN VALUE:
**	sess_tmo:	Session-Timeout value
**      1 = login is failed
**	0 = login was successful
**
**--
*/
int	AUTHORIZE	(void	**context,
			char	*user,
			short	 userlen,
			char	*client,
			short	 clientlen,
			int	*sess_tmo,
			char	*pass,
			short	 passlen,
			char	*called_id,
			short	 called_id_len,
			char	*calling_id,
			short	 calling_id_len
			)
{
	printf("\n+++ AUTHORIZE +++\n");
	return	0;
}

/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Cleans up the context allocated in the INIT routine.  Not called
**	if the INIT routine set the context to NULL.
**
**  FORMAL PARAMETERS:
**
**      context:	address of a pointer to the allocated context
**
**  RETURN VALUE:
**
**      VMS condition code
**--
*/
int	CLEANUP		(void	**context)
{
	printf("\n+++ CLEANUP +++\n");
	return	SS$_NORMAL;
}
