#pragma	module RAD_EXT_ACCT	"RAD_EXT_ACCT-1-X"

/*
**++
**  FACILITY:  RADIUS-VMS
**
**  MODULE DESCRIPTION:
**
**      External module for processing an accounting for RADIUS-VMS server.
**
**  AUTHORS:
**
**      Copyright  Ruslan R. Laishev 2000
**
**  CREATION DATE:  11-MAR-2000
**
**  DESIGN ISSUES:
**
**      This module supposed to contains external user-written pocedures
**	are called from RADIUS-VMS server.
**
**	N.B.	Since RADIUS-VMS server is a DEC Threads application, you should
**		write thread safe code for the ACCOUNTING routine, using
**		reenterancy or the syncronization technics.
**
**	N.B.	The INIT & CLEANUP routines is called when all auth-threads is not ran.
**
**	N.B.	RADIUS-VMS makes hardcoded references to event flags 19-22.
**
**	To build this module (ALPHA):
**	
**	$CC/PREFFIX=ALL	RAD_EXT_ACCT.C/REENTRANCY=MULTITHREAD
**	$LINK/SHARE RAD_EXT_ACCT.OBJ,SYS$INPUT:/OPT
**	SYMBOL_VECTOR=(INIT=PROCEDURE,ACCOUNTING=PROCEDURE,CLEANUP=PROCEDURE)
**	<ctrl/Z>
**
**	To build this module (VAX):
**	$CC/PREFFIX=ALL  RAD_EXT_ACCT.C
**	$LINK/SHARE RAD_EXT_ACCT.OBJ,SYS$INPUT:/OPT
**	UNIVERSAL=INIT,ACCOUNTING,CLEANUP
**	<ctrl/Z>
**
**
**	DEFINE/SYSTEM/EXEC	RADIUS_EXT_ACCT	dev:[dir]RAD_EXT_ACCT.EXE
**
**  MODIFICATION HISTORY:
**
**      {@tbs@}...
**--
*/


/*
**
**  INCLUDE FILES
**
*/

#include	<stdlib.h>
#include	<stdio.h>
#include	<ssdef.h>


/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Initializes the context used by this module.
**
**	If you do not need to maintain any context between calls to your
**	ACCOUNTING routines, it is OK to simply
**	set the context pointer to NULL. If you do this, your CLEANUP
**	routine will never be called.
**
**  FORMAL PARAMETERS:
**
**      context:	address of a pointer to the allocated context
**	
**  RETURN VALUE:
**
**	VMS condition value
**
**--
*/
int	INIT	(void	**context)
{
	printf("\n--- INIT ---\n");
	(*context) = NULL;
	return	SS$_NORMAL;
}


/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Processing the accounting information.
**
**  FORMAL PARAMETERS:
**
**      context:	address of a pointer to the allocated context
**	user:		address of an username character string,ASCIZ
**	sess_id:	session ID
**	proto:		protocol name (PPP,Telnet etc.), ASCIZ 
**	nas_ip_name:	NAS IP name or IP address character string
**	nas_ip_namelen:	length of the nas-ip_name string
**	nas_port_t:	NAS port type character string,ASCIZ
**	nas_port:	NAS port ID
**	frmd_info:	Frammed-IP character string,ASCIZ
**	in_bytes:	a number of bytes transffered to the user
**	out_bytes:	a number of bytes transffered from the user
**	start_time:	a login time in VMS binary format
**	end_time:	a loggout time in VMS binary format
**	speed:		connection speed
**	account:	an account given from a RADIUS_CONFIG,ASCIZ
**
**  RETURN VALUE:
**
**	0 = OK
**	1 = OK skip accounting actions in the RADIUS-VMS
**--
*/
int	ACCOUNTING	(void	**context,
			char	*user,
			int	sess_id,
                        char	*proto,
                        char	*nas_ip_name,
                        short	nas_ip_namelen,
                        char	*nas_port_t,
                        int	nas_port,
                        char    *frmd_info,
                        int      in_bytes,
                        int      out_bytes,
                        int     *start_time,
                        int     *end_time,
                        int      term_status,
			int	 speed,
                        char    *acc
			)
{
	printf("\n--- ACCOUNTING ---\n");

	return	0;
}


/*
**++
**  FUNCTIONAL DESCRIPTION:
**
**      Cleans up the context allocated in the INIT routine.  Not called
**	if the INIT routine set the context to NULL.
**
**  FORMAL PARAMETERS:
**
**      context:	address of a pointer to the allocated context
**
**  RETURN VALUE:
**
**      VMS condition code
**--
*/
int	CLEANUP		(void	**context)
{
	printf("\n--- CLEANUP ---\n");
	return	SS$_NORMAL;
}
