 #include "includes.h"    struct	{ 	int	 prot;  	char	*name; 	} prots [] = { * 	{PROTOCOL_CORE,"PC NETWORK PROGRAM 1.0"},/ 	{PROTOCOL_COREPLUS,"MICROSOFT NETWORKS 1.03"}, - 	{PROTOCOL_LANMAN1,"MICROSOFT NETWORKS 3.0"},   	{PROTOCOL_LANMAN1,"LANMAN1.0"},  	{PROTOCOL_LANMAN2,"LM1.2X002"}, 	{PROTOCOL_LANMAN2,"Samba"}, 	{PROTOCOL_NT1,"NT LM 0.12"},   	{PROTOCOL_NT1,"NT LANMAN 1.0"}, 	{-1,NULL}};  M /****************************************************************************  initialise a client structure M ****************************************************************************/ * BOOL cli_initialise(struct cli_state *cli) { + 	if ( cli->initialised ) cli_shutdown(cli);    	memset(cli, 0, sizeof(*cli)); 	cli->fd = -1; 	cli->cnum = -1; 	cli->pid = getpid();  	cli->mid = 1; 	cli->uid = getuid();  	cli->protocol = PROTOCOL_NT1; 	cli->timeout = 20000; 	cli->bufsize = 0x10000;" 	cli->max_xmit = cli->bufsize - 4;, 	cli->outbuf = (char *)malloc(cli->bufsize);+ 	cli->inbuf = (char *)malloc(cli->bufsize); 1 	if ( !cli->outbuf || !cli->inbuf ) return False;  	cli->initialised = 1;  
 	return True;  }   M /****************************************************************************  open the client sockets M ****************************************************************************/ G BOOL cli_connect(struct cli_state *cli, char *host, struct in_addr *ip)  {   $ 	printf("IP = %s\n",inet_ntoa(*ip)); 	strcpy(cli->desthost, host); K 	if ( 0 > (cli->fd = open_socket_out(SOCK_STREAM, ip, 139, cli->timeout)) )  		return	False;   
 	return True;  }   M /****************************************************************************    send a session requestM ****************************************************************************/ J BOOL cli_session_request(struct cli_state *cli, char *host, int name_type, 			 char *myname)  { 
 fstring dest;  char	*p; int len = 4;( 	/* send a session request (RFC 1002) */   	strcpy(dest,host);     	p = strchr(dest,'.'); 	if (p) *p = 0;    	strcpy(cli->desthost, dest);   " 	/* put in the destination name */ 	p = cli->outbuf+len;  	name_mangle(dest,p,name_type);  	len += name_len(p);   	/* and my name */ 	p = cli->outbuf+len;  	name_mangle(myname,p,0);  	len += name_len(p);   	/* setup the packet length */ 	_smb_setlen(cli->outbuf,len); 	CVAL(cli->outbuf,0) = 0x81;   	send_smb(cli->fd,cli->outbuf); * 	syslog(LOG_ERR,"Sent session request\n");  : 	if (!client_receive_smb(cli->fd,cli->inbuf,cli->timeout)) 		return False;   " 	if (CVAL(cli->inbuf,0) != 0x82) {" 		cli->error = CVAL(cli->inbuf,0); 		return False;  	} 	return(True); }   M /**************************************************************************** ! setup basics in a outgoing packet M ****************************************************************************/ 3 static void cli_setup_packet(struct cli_state *cli)  { % 	SSVAL(cli->outbuf,smb_pid,cli->pid); % 	SSVAL(cli->outbuf,smb_uid,cli->uid); % 	SSVAL(cli->outbuf,smb_mid,cli->mid); % 	if (cli->protocol > PROTOCOL_CORE) { ! 		SCVAL(cli->outbuf,smb_flg,0x8); " 		SSVAL(cli->outbuf,smb_flg2,0x1); 	} }   M /****************************************************************************  send a negprot commandM ****************************************************************************/ ' BOOL cli_negprot(struct cli_state *cli)  { 	 	char *p;  	int numprots;
 	int plength;    	bzero(cli->outbuf,smb_size);   ! 	/* setup the protocol strings */  	for (plength=0,numprots=0; B 	     prots[numprots].name && prots[numprots].prot<=cli->protocol; 	     numprots++) , 		plength += strlen(prots[numprots].name)+2;     ) 	set_message(cli->outbuf,0,plength,True);    	p = smb_buf(cli->outbuf); 	for (numprots=0; B 	     prots[numprots].name && prots[numprots].prot<=cli->protocol; 	     numprots++) {  		*p++ = 2; ! 		strcpy(p,prots[numprots].name);  		p += strlen(p) + 1;  	}  ( 	CVAL(cli->outbuf,smb_com) = SMBnegprot; 	cli_setup_packet(cli);   " 	CVAL(smb_buf(cli->outbuf),0) = 2;   	send_smb(cli->fd,cli->outbuf); : 	if (!client_receive_smb(cli->fd,cli->inbuf,cli->timeout)) 		return False;    	show_msg(cli->inbuf);  ' 	if (CVAL(cli->inbuf,smb_rcls) != 0 ||  4 	    ((int)SVAL(cli->inbuf,smb_vwv0) >= numprots)) { 		return(False); 	}  7 	cli->protocol = prots[SVAL(cli->inbuf,smb_vwv0)].prot;     ) 	if (cli->protocol >= PROTOCOL_NT1) {      		/* NT protocol */ , 		cli->sec_mode = CVAL(cli->inbuf,smb_vwv1);. 		cli->max_xmit = IVAL(cli->inbuf,smb_vwv3+1);- 		cli->sesskey = IVAL(cli->inbuf,smb_vwv7+1); 5 		cli->serverzone = SVALS(cli->inbuf,smb_vwv15+1)*60; % 		/* this time arrives in real GMT */ @ 		cli->servertime = interpret_long_date(cli->inbuf+smb_vwv11+1);. 		memcpy(cli->cryptkey,smb_buf(cli->inbuf),8);& 		if (IVAL(cli->inbuf,smb_vwv9+1) & 1) 			cli->readbraw_supported =  * 				cli->writebraw_supported = True;      0 	} else if (cli->protocol >= PROTOCOL_LANMAN1) {, 		cli->sec_mode = SVAL(cli->inbuf,smb_vwv1);, 		cli->max_xmit = SVAL(cli->inbuf,smb_vwv2);+ 		cli->sesskey = IVAL(cli->inbuf,smb_vwv6); 3 		cli->serverzone = SVALS(cli->inbuf,smb_vwv10)*60; 7 		/* this time is converted to GMT by make_unix_date */ 8 		cli->servertime = make_unix_date(cli->inbuf+smb_vwv8);E 		cli->readbraw_supported = ((SVAL(cli->inbuf,smb_vwv5) & 0x1) != 0); F 		cli->writebraw_supported = ((SVAL(cli->inbuf,smb_vwv5) & 0x2) != 0);. 		memcpy(cli->cryptkey,smb_buf(cli->inbuf),8);	 	} else {  		/* the old core protocol */  		cli->sec_mode = 0;) 		cli->serverzone = TimeDiff(time(NULL));  	}  
 	return True;  }     M /****************************************************************************  send a session setupM ****************************************************************************/ . BOOL cli_session_setup(struct cli_state *cli,  		       char *user,  ! 		       char *pass, int passlen, % 		       char *ntpass, int ntpasslen,  		       char *workgroup)  { 	 	char *p;  	fstring pword;   & 	if (cli->protocol < PROTOCOL_LANMAN1) 		return True;  ! 	if (passlen > sizeof(pword)-1) {  		return False;  	}  E         if(((passlen == 0) || (passlen == 1)) && (pass[0] == '\0')) { %           /* Null session connect. */            pword[0] = '\0';         } else {5           if ((cli->sec_mode & 2) && passlen != 24) {              passlen = 24; L             SMBencrypt((uchar *)pass,(uchar *)cli->cryptkey,(uchar *)pword);           } else {)             memcpy(pword, pass, passlen);            } 	         }   @ 	/* if in share level security then don't send a password now */: 	if (!(cli->sec_mode & 1)) {strcpy(pword, "");passlen=1;}   # 	/* send a session setup command */  	bzero(cli->outbuf,smb_size);   $ 	if (cli->protocol < PROTOCOL_NT1) {> 		set_message(cli->outbuf,10,1 + strlen(user) + passlen,True);, 		CVAL(cli->outbuf,smb_com) = SMBsesssetupX; 		cli_setup_packet(cli);  $ 		CVAL(cli->outbuf,smb_vwv0) = 0xFF;, 		SSVAL(cli->outbuf,smb_vwv2,cli->max_xmit);  		SSVAL(cli->outbuf,smb_vwv3,2);  		SSVAL(cli->outbuf,smb_vwv4,1);+ 		SIVAL(cli->outbuf,smb_vwv5,cli->sesskey); & 		SSVAL(cli->outbuf,smb_vwv7,passlen); 		p = smb_buf(cli->outbuf);  		memcpy(p,pword,passlen); 		p += passlen;  		strcpy(p,user);  		strupper(p);	 	} else { % 		set_message(cli->outbuf,13,0,True); , 		CVAL(cli->outbuf,smb_com) = SMBsesssetupX; 		cli_setup_packet(cli); 		$ 		CVAL(cli->outbuf,smb_vwv0) = 0xFF;* 		SSVAL(cli->outbuf,smb_vwv2,BUFFER_SIZE);  		SSVAL(cli->outbuf,smb_vwv3,2);' 		SSVAL(cli->outbuf,smb_vwv4,cli->pid); + 		SIVAL(cli->outbuf,smb_vwv5,cli->sesskey); & 		SSVAL(cli->outbuf,smb_vwv7,passlen);( 		SSVAL(cli->outbuf,smb_vwv8,ntpasslen); 		p = smb_buf(cli->outbuf);  		memcpy(p,pword,passlen);  " 		p += SVAL(cli->outbuf,smb_vwv7); 		memcpy(p,ntpass,ntpasslen); " 		p += SVAL(cli->outbuf,smb_vwv8); 		strcpy(p,user);  		strupper(p); 		p = skip_string(p,1);  		strcpy(p,workgroup); 		strupper(p); 		p = skip_string(p,1); ( 		strcpy(p,"Unix");p = skip_string(p,1);) 		strcpy(p,"Samba");p = skip_string(p,1); E 		set_message(cli->outbuf,13,PTR_DIFF(p,smb_buf(cli->outbuf)),False);  	}  $       send_smb(cli->fd,cli->outbuf);?       if (!client_receive_smb(cli->fd,cli->inbuf,cli->timeout))  	      return False;         show_msg(cli->inbuf);   +       if (CVAL(cli->inbuf,smb_rcls) != 0) {  	      return False;       }   ,       /* use the returned uid from now on */*       cli->uid = SVAL(cli->inbuf,smb_uid);         return True; }   M /****************************************************************************  send a tconXM ****************************************************************************/ + BOOL cli_send_tconX(struct cli_state *cli,  6 		    char *share, char *dev, char *pass, int passlen) {  	fstring fullshare, pword;	 	char *p;  	bzero(cli->outbuf,smb_size);  	bzero(cli->inbuf,smb_size);   	if (cli->sec_mode & 1) {  		passlen = 1; 		pass = ""; 	}  5 	if ((cli->sec_mode & 2) && *pass && passlen != 24) {  		passlen = 24; B 		SMBencrypt((uchar *)pass,(uchar *)cli->cryptkey,(uchar *)pword);	 	} else {  		memcpy(pword, pass, passlen);  	}   	sprintf(fullshare, ' 		 "\\\\%s\\%s", cli->desthost, share);    	set_message(cli->outbuf,4, : 		    2 + strlen(fullshare) + passlen + strlen(dev),True);& 	CVAL(cli->outbuf,smb_com) = SMBtconX; 	cli_setup_packet(cli);   " 	SSVAL(cli->outbuf,smb_vwv0,0xFF);% 	SSVAL(cli->outbuf,smb_vwv3,passlen);    	p = smb_buf(cli->outbuf); 	memcpy(p,pword,passlen);  	p += passlen; 	strcpy(p,fullshare);  	p = skip_string(p,1); 	strcpy(p,dev);    	SCVAL(cli->inbuf,smb_rcls, 1);    	send_smb(cli->fd,cli->outbuf); : 	if (!client_receive_smb(cli->fd,cli->inbuf,cli->timeout)) 		return False;   & 	if (CVAL(cli->inbuf,smb_rcls) != 0) { 		return False;  	}  & 	cli->cnum = SVAL(cli->inbuf,smb_tid);
 	return True;  }   M /**************************************************************************** $   send a SMB trans or trans2 requestO   ****************************************************************************/ 1 static BOOL cli_send_trans(struct cli_state *cli, 0 			   int trans, char *name, int fid, int flags,A 			   char *data,char *param,uint16 *setup, int ldata,int lparam, 1 			   int lsetup,int mdata,int mparam,int msetup)  {  	int i;  	int this_ldata,this_lparam; 	int tot_data=0,tot_param=0; 	char *outdata,*outparam; 	 	char *p;   E 	this_lparam = MIN(lparam,cli->max_xmit - (500+lsetup*2)); /* hack */ D 	this_ldata = MIN(ldata,cli->max_xmit - (500+lsetup*2+this_lparam));   	bzero(cli->outbuf,smb_size); + 	set_message(cli->outbuf,14+lsetup,0,True); # 	CVAL(cli->outbuf,smb_com) = trans; ' 	SSVAL(cli->outbuf,smb_tid, cli->cnum);  	cli_setup_packet(cli);   H 	outparam = smb_buf(cli->outbuf)+(trans==SMBtrans ? strlen(name)+1 : 3);  	outdata = outparam+this_lparam;   	/* primary request */3 	SSVAL(cli->outbuf,smb_tpscnt,lparam);	/* tpscnt */ 2 	SSVAL(cli->outbuf,smb_tdscnt,ldata);	/* tdscnt */3 	SSVAL(cli->outbuf,smb_mprcnt,mparam);	/* mprcnt */ 2 	SSVAL(cli->outbuf,smb_mdrcnt,mdata);	/* mdrcnt */3 	SCVAL(cli->outbuf,smb_msrcnt,msetup);	/* msrcnt */ 0 	SSVAL(cli->outbuf,smb_flags,flags);	/* flags */1 	SIVAL(cli->outbuf,smb_timeout,0);		/* timeout */ 6 	SSVAL(cli->outbuf,smb_pscnt,this_lparam);	/* pscnt */K 	SSVAL(cli->outbuf,smb_psoff,smb_offset(outparam,cli->outbuf)); /* psoff */ 5 	SSVAL(cli->outbuf,smb_dscnt,this_ldata);	/* dscnt */ J 	SSVAL(cli->outbuf,smb_dsoff,smb_offset(outdata,cli->outbuf)); /* dsoff */3 	SCVAL(cli->outbuf,smb_suwcnt,lsetup);	/* suwcnt */ & 	for (i=0;i<lsetup;i++)		/* setup[] */, 		SSVAL(cli->outbuf,smb_setup+i*2,setup[i]); 	p = smb_buf(cli->outbuf); 	if (trans==SMBtrans) {   		strcpy(p,name);			/* name[] */	 	} else { ) 		*p++ = 0;  /* put in a null smb_name */ 0 		*p++ = 'D'; *p++ = ' ';	/* observed in OS/2 */ 	}! 	if (this_lparam)			/* param[] */ % 		memcpy(outparam,param,this_lparam);  	if (this_ldata)			/* data[] */ " 		memcpy(outdata,data,this_ldata);4 	set_message(cli->outbuf,14+lsetup,		/* wcnt, bcc */? 		    PTR_DIFF(outdata+this_ldata,smb_buf(cli->outbuf)),False);    	show_msg(cli->outbuf);  	send_smb(cli->fd,cli->outbuf);   2 	if (this_ldata < ldata || this_lparam < lparam) {  		/* receive interim response */> 		if (!client_receive_smb(cli->fd,cli->inbuf,cli->timeout) || ' 		    CVAL(cli->inbuf,smb_rcls) != 0) {  			return(False); 	 		}          		tot_data = this_ldata; 		tot_param = this_lparam; 		3 		while (tot_data < ldata || tot_param < lparam)  { F 			this_lparam = MIN(lparam-tot_param,cli->max_xmit - 500); /* hack */F 			this_ldata = MIN(ldata-tot_data,cli->max_xmit - (500+this_lparam));  7 			set_message(cli->outbuf,trans==SMBtrans?8:9,0,True); H 			CVAL(cli->outbuf,smb_com) = trans==SMBtrans ? SMBtranss : SMBtranss2; 			 # 			outparam = smb_buf(cli->outbuf); " 			outdata = outparam+this_lparam; 			  			/* secondary request */5 			SSVAL(cli->outbuf,smb_tpscnt,lparam);	/* tpscnt */ 4 			SSVAL(cli->outbuf,smb_tdscnt,ldata);	/* tdscnt */9 			SSVAL(cli->outbuf,smb_spscnt,this_lparam);	/* pscnt */ N 			SSVAL(cli->outbuf,smb_spsoff,smb_offset(outparam,cli->outbuf)); /* psoff */9 			SSVAL(cli->outbuf,smb_spsdisp,tot_param);	/* psdisp */ 8 			SSVAL(cli->outbuf,smb_sdscnt,this_ldata);	/* dscnt */M 			SSVAL(cli->outbuf,smb_sdsoff,smb_offset(outdata,cli->outbuf)); /* dsoff */ 8 			SSVAL(cli->outbuf,smb_sdsdisp,tot_data);	/* dsdisp */ 			if (trans==SMBtrans2)0 				SSVALS(cli->outbuf,smb_sfid,fid);		/* fid */# 			if (this_lparam)			/* param[] */ ' 				memcpy(outparam,param,this_lparam); ! 			if (this_ldata)			/* data[] */ $ 				memcpy(outdata,data,this_ldata);? 			set_message(cli->outbuf,trans==SMBtrans?8:9, /* wcnt, bcc */ A 				    PTR_DIFF(outdata+this_ldata,smb_buf(cli->outbuf)),False);  			  			show_msg(cli->outbuf); ! 			send_smb(cli->fd,cli->outbuf);  			  			tot_data += this_ldata; 			tot_param += this_lparam; 		}  	}   	return(True); }   M /**************************************************************************** H   receive a SMB trans or trans2 response allocating the necessary memoryO   ****************************************************************************/ 4 static BOOL cli_receive_trans(struct cli_state *cli,! 			      int trans,int *data_len, 2 			      int *param_len, char **data,char **param) {  	int total_data=0; 	int total_param=0;  	int this_data,this_param; 	  	*data_len = *param_len = 0; 	 : 	if (!client_receive_smb(cli->fd,cli->inbuf,cli->timeout)) 		return False;    	show_msg(cli->inbuf); 	  	/* sanity check */ ) 	if (CVAL(cli->inbuf,smb_com) != trans) { > 		syslog(LOG_ERR,"Expected %s response, got command 0x%02x\n",, 			 trans==SMBtrans?"SMBtrans":"SMBtrans2",  			 CVAL(cli->inbuf,smb_com)); 		return(False); 	}$ 	if (CVAL(cli->inbuf,smb_rcls) != 0) 		return(False);   	/* parse out the lengths */* 	total_data = SVAL(cli->inbuf,smb_tdrcnt);+ 	total_param = SVAL(cli->inbuf,smb_tprcnt);    	/* allocate it */# 	*data = Realloc(*data,total_data); & 	*param = Realloc(*param,total_param);  
 	while (1)  { ) 		this_data = SVAL(cli->inbuf,smb_drcnt); * 		this_param = SVAL(cli->inbuf,smb_prcnt);  + 		if (this_data + *data_len > total_data || . 		    this_param + *param_len > total_param) {: 			syslog(LOG_ERR,"Data overflow in cli_receive_trans\n"); 			return False; 		}    		if (this_data). 			memcpy(*data + SVAL(cli->inbuf,smb_drdisp),< 			       smb_base(cli->inbuf) + SVAL(cli->inbuf,smb_droff), 			       this_data);  		if (this_param) / 			memcpy(*param + SVAL(cli->inbuf,smb_prdisp), < 			       smb_base(cli->inbuf) + SVAL(cli->inbuf,smb_proff), 			       this_param); 		*data_len += this_data;  		*param_len += this_param;   < 		/* parse out the total lengths again - they can shrink! */+ 		total_data = SVAL(cli->inbuf,smb_tdrcnt); , 		total_param = SVAL(cli->inbuf,smb_tprcnt); 		; 		if (total_data <= *data_len && total_param <= *param_len) 	 			break;  		; 		if (!client_receive_smb(cli->fd,cli->inbuf,cli->timeout))  			return False;   		show_msg(cli->inbuf);  		 		/* sanity check */* 		if (CVAL(cli->inbuf,smb_com) != trans) {? 			syslog(LOG_ERR,"Expected %s response, got command 0x%02x\n", - 				 trans==SMBtrans?"SMBtrans":"SMBtrans2",   				 CVAL(cli->inbuf,smb_com));  			return(False);  		} % 		if (CVAL(cli->inbuf,smb_rcls) != 0)  			return(False);  	} 	  	return(True); }   M /**************************************************************************** # Send a SamOEMChangePassword commandmM ****************************************************************************/R  S BOOL cli_oem_change_password(struct cli_state *cli, char *user, char *new_password,R0                              char *old_password) {.!   char param[16+sizeof(fstring)];"   char data[532];"   char *p = param;   fstring upper_case_old_pw;   fstring upper_case_new_pw;    unsigned char old_pw_hash[16];    unsigned char new_pw_hash[16];   int data_len;    int param_len = 0;(   int new_pw_len = strlen(new_password);   char *rparam = NULL;   char *rdata = NULL;(   int rprcnt, rdrcnt;      cli->error = -1;  )   if(strlen(user) >= sizeof(fstring)-1) { Q     syslog(LOG_ERR,"cli_oem_change_password: user name %s is too long.\n", user);      return False;e   })     if(new_pw_len > 512) {]     syslog(LOG_ERR,"cli_oem_change_password: new password for user %s is too long.\n", user);c     return False;*   }o  5   SSVAL(p,0,214); /* SamOEMChangePassword command. */z	   p += 2;    strcpy(p, "zsT");>   p = skip_string(p,1);c   strcpy(p, "B516B16");r   p = skip_string(p,1);*   strcpy(p,user);*   p = skip_string(p,1);*   SSVAL(p,0,532);*	   p += 2;n      param_len = PTR_DIFF(p,param);     /*    * Now setup the data area.*    */*#   memset(data, '\0', sizeof(data));r1   strcpy( &data[512 - new_pw_len], new_password);    SIVAL(data, 512, new_pw_len);n     /*0    * Get the Lanman hash of the old password, we)    * use this as the key to SamOEMHash().,    */i=   memset(upper_case_old_pw, '\0', sizeof(upper_case_old_pw));**   strcpy(upper_case_old_pw, old_password);   strupper(upper_case_old_pw);1   E_P16((uchar *)upper_case_old_pw, old_pw_hash);*  I   SamOEMhash( (unsigned char *)data, (unsigned char *)old_pw_hash, True);c     /* t1    * Now place the old password hash in the data.e    */ =   memset(upper_case_new_pw, '\0', sizeof(upper_case_new_pw));e*   strcpy(upper_case_new_pw, new_password);   strupper(upper_case_new_pw);  1   E_P16((uchar *)upper_case_new_pw, new_pw_hash);u  @   E_old_pw_hash( new_pw_hash, old_pw_hash, (uchar *)&data[516]);     data_len = 532;l     1   if(cli_send_trans(cli,SMBtrans,PIPE_LANMAN,0,0,f!                  data,param,NULL, (                  data_len , param_len,0,#                  0,2,0) == False) {fc     syslog(LOG_ERR,"cli_oem_change_password: Failed to send password change for user %s\n", user );o     return False;i   }l  J   if(cli_receive_trans(cli,SMBtrans, &rdrcnt, &rprcnt, &rdata, &rparam)) {     if(rparam)"       cli->error = SVAL(rparam,0);   }b  
   if (rparam)F     free(rparam);(   if (rdata)     free(rdata);     return (cli->error == 0);* }*  M /***************************************************************************** shutdown a client structure*M ****************************************************************************/i( void cli_shutdown(struct cli_state *cli) { $ 	if (cli->outbuf) free(cli->outbuf);" 	if (cli->inbuf) free(cli->inbuf);# 	if (cli->fd != -1) close(cli->fd);_ 	memset(cli, 0, sizeof(*cli)); }l  M /*****************************************************************************#   return a description of the error*M ****************************************************************************/*' char *cli_errstr(struct cli_state *cli)O {c 	return smb_errstr(cli->inbuf);  }   