 /*<  * entities.c : implementation for the XML entities handking  *1  * See Copyright for the status of this software.   *  * Daniel.Veillard@w3.org   */    #ifdef WIN32 #include "win32config.h" #else  #include "config.h"  #endif   #include <stdio.h> #include <string.h>  #ifdef HAVE_STDLIB_H #include <stdlib.h>  #endif #include <libxml/xmlmemory.h>  #include <libxml/entities.h> #include <libxml/parser.h>  D #define DEBUG_ENT_REF /* debugging of cross entities dependancies */J #define ENTITY_HASH_SIZE 256 /* modify xmlEntityComputeHash accordingly */   /*  * xmlEntityComputeHash:  *0  * Computes the hash value for this given entity  */  int + xmlEntityComputeHash(const xmlChar *name) { E     register const unsigned char *cur = (const unsigned char *) name; #     register unsigned char val = 0;        if (name == NULL) 
 	return(val);      while (*cur) val += *cur++;      return(val); }    /*  * The XML predefined entities.   */   ! struct xmlPredefinedEntityValue {      const char *name;      const char *value; };? struct xmlPredefinedEntityValue xmlPredefinedEntityValues[] = {      { "lt", "<" },     { "gt", ">" },     { "apos", "'" },     { "quot", "\"" },      { "amp", "&" } };   /*B  * TODO: !!!!!!! This is GROSS, allocation of a 256 entry hash for/  *               a fixed number of 4 elements !   */ 1 xmlEntitiesTablePtr xmlPredefinedEntities = NULL;    /*-  * xmlFreeEntity : clean-up an entity record.   */ ) void xmlFreeEntity(xmlEntityPtr entity) {      if (entity == NULL) return;        if (entity->children) # 	xmlFreeNodeList(entity->children);      if (entity->name != NULL)   	xmlFree((char *) entity->name);#     if (entity->ExternalID != NULL) -         xmlFree((char *) entity->ExternalID); !     if (entity->SystemID != NULL) +         xmlFree((char *) entity->SystemID);      if (entity->URI != NULL)&         xmlFree((char *) entity->URI);      if (entity->content != NULL)*         xmlFree((char *) entity->content);     if (entity->orig != NULL) '         xmlFree((char *) entity->orig);  #ifdef WITH_EXTRA_ENT_DETECT!     if (entity->entTab != NULL) {  	int i;   $ 	for (i = 0; i < entity->entNr; i++)  	    xmlFree(entity->entTab[i]); 	xmlFree(entity->entTab);      }  #endif*     memset(entity, -1, sizeof(xmlEntity));     xmlFree(entity); }    /*>  * xmlAddEntity : register a new entity for an entities table.  */  static xmlEntityPtr F xmlAddEntity(xmlEntitiesTablePtr table, const xmlChar *name, int type,6 	  const xmlChar *ExternalID, const xmlChar *SystemID, 	  const xmlChar *content) { #ifndef ENTITY_HASH_SIZE
     int i; #endif
     int hash;      xmlEntityPtr ret;        if (name == NULL)  	return(NULL); #ifdef ENTITY_HASH_SIZE &     hash = xmlEntityComputeHash(name);     ret = table->table[hash];      while (ret != NULL) { $ 	if (xmlStrEqual(ret->name, name)) { 	    /* G 	     * The entity is already defined in this Dtd, the spec says to NOT 5 	     * override it ... Is it worth a Warning ??? !!! : 	     * Not having a cprinting context this seems hard ... 	     */4 	    if (((type == XML_INTERNAL_PARAMETER_ENTITY) ||5 	         (type == XML_EXTERNAL_PARAMETER_ENTITY)) && : 	        ((ret->etype == XML_INTERNAL_PARAMETER_ENTITY) ||9 	         (ret->etype == XML_EXTERNAL_PARAMETER_ENTITY)))  		return(NULL); 	 	    else 4 	    if (((type != XML_INTERNAL_PARAMETER_ENTITY) &&5 	         (type != XML_EXTERNAL_PARAMETER_ENTITY)) && : 	        ((ret->etype != XML_INTERNAL_PARAMETER_ENTITY) &&9 	         (ret->etype != XML_EXTERNAL_PARAMETER_ENTITY)))  		return(NULL);  	} 	ret = ret->nexte;     }  #else ,     for (i = 0;i < table->nb_entities;i++) {         ret = table->table[i];$ 	if (xmlStrEqual(ret->name, name)) { 	    /* G 	     * The entity is already defined in this Dtd, the spec says to NOT 5 	     * override it ... Is it worth a Warning ??? !!! : 	     * Not having a cprinting context this seems hard ... 	     */4 	    if (((type == XML_INTERNAL_PARAMETER_ENTITY) ||5 	         (type == XML_EXTERNAL_PARAMETER_ENTITY)) && : 	        ((ret->etype == XML_INTERNAL_PARAMETER_ENTITY) ||9 	         (ret->etype == XML_EXTERNAL_PARAMETER_ENTITY)))  		return(NULL); 	 	    else 4 	    if (((type != XML_INTERNAL_PARAMETER_ENTITY) &&5 	         (type != XML_EXTERNAL_PARAMETER_ENTITY)) && : 	        ((ret->etype != XML_INTERNAL_PARAMETER_ENTITY) &&9 	         (ret->etype != XML_EXTERNAL_PARAMETER_ENTITY)))  		return(NULL);  	}     } 4     if (table->nb_entities >= table->max_entities) {
         /* 	 * need more elements.  	 */ 	table->max_entities *= 2;! 	table->table = (xmlEntityPtr *)   	    xmlRealloc(table->table, 5 		       table->max_entities * sizeof(xmlEntityPtr));  	if (table->table == NULL) { 	    perror("realloc failed"); 	    return(NULL); 	}     }  #endif6     ret = (xmlEntityPtr) xmlMalloc(sizeof(xmlEntity));     if (ret == NULL) {2 	fprintf(stderr, "xmlAddEntity: out of memory\n"); 	return(NULL);     } &     memset(ret, 0, sizeof(xmlEntity));      ret->type = XML_ENTITY_DECL; #ifdef ENTITY_HASH_SIZE $     ret->nexte = table->table[hash];     table->table[hash] = ret;  #else +     table->table[table->nb_entities] = ret;  #endif       /*      * fill the structure.      */       ret->name = xmlStrdup(name);&     ret->etype = (xmlEntityType) type;     if (ExternalID != NULL) ) 	ret->ExternalID = xmlStrdup(ExternalID);      if (SystemID != NULL) % 	ret->SystemID = xmlStrdup(SystemID);      if (content != NULL) {)         ret->length = xmlStrlen(content); 1 	ret->content = xmlStrndup(content, ret->length); 
      } else {          ret->length = 0;         ret->content = NULL;     } ;     ret->URI = NULL; /* to be computed by the layer knowing  			the defining entity */      ret->orig = NULL;      table->nb_entities++;        return(ret); }    /** #  * xmlInitializePredefinedEntities:   *"  * Set up the predefined entities.  */ , void xmlInitializePredefinedEntities(void) {
     int i;     xmlChar name[50];      xmlChar value[50];     const char *in;      xmlChar *out;   .     if (xmlPredefinedEntities != NULL) return;  5     xmlPredefinedEntities = xmlCreateEntitiesTable(); 7     for (i = 0;i < sizeof(xmlPredefinedEntityValues) /  >                    sizeof(xmlPredefinedEntityValues[0]);i++) {/         in = xmlPredefinedEntityValues[i].name;  	out = &name[0];& 	for (;(*out++ = (xmlChar) *in);)in++;0         in = xmlPredefinedEntityValues[i].value; 	out = &value[0]; & 	for (;(*out++ = (xmlChar) *in);)in++;G         xmlAddEntity(xmlPredefinedEntities, (const xmlChar *) &name[0], 9 	             XML_INTERNAL_PREDEFINED_ENTITY, NULL, NULL,  		     &value[0]);     }  }    /**    * xmlCleanupPredefinedEntities:  *,  * Cleanup up the predefined entities table.  */ ) void xmlCleanupPredefinedEntities(void) { .     if (xmlPredefinedEntities == NULL) return;  0     xmlFreeEntitiesTable(xmlPredefinedEntities);!     xmlPredefinedEntities = NULL;  }    /**   * xmlGetPredefinedEntity:  * @name:  the entity name  *3  * Check whether this name is an predefined entity.   *,  * Returns NULL if not, othervise the entity  */  xmlEntityPtr- xmlGetPredefinedEntity(const xmlChar *name) { 
     int i;     xmlEntityPtr cur;   &     if (xmlPredefinedEntities == NULL)*         xmlInitializePredefinedEntities(); #ifdef ENTITY_HASH_SIZE #     i = xmlEntityComputeHash(name); *     cur = xmlPredefinedEntities->table[i];     while (cur != NULL) { " 	if (xmlStrEqual(cur->name, name)) 	    return(cur);  	cur = cur->nexte;     }  #else <     for (i = 0;i < xmlPredefinedEntities->nb_entities;i++) {' 	cur = xmlPredefinedEntities->table[i]; / 	if (xmlStrEqual(cur->name, name)) return(cur);      }  #endif     return(NULL);  }    /**   * xmlAddDtdEntity:   * @doc:  the document  * @name:  the entity name-  * @type:  the entity type XML_xxx_yyy_ENTITY 4  * @ExternalID:  the entity external ID if available0  * @SystemID:  the entity system ID if available   * @content:  the entity content  *?  * Register a new entity for this document DTD external subset.   *;  * Returns a pointer to the entity or NULL in case of error   */  xmlEntityPtr= xmlAddDtdEntity(xmlDocPtr doc, const xmlChar *name, int type, < 	        const xmlChar *ExternalID, const xmlChar *SystemID, 		const xmlChar *content) {      xmlEntitiesTablePtr table;     xmlEntityPtr ret;      xmlDtdPtr dtd;       if (doc == NULL) {         fprintf(stderr, - 	        "xmlAddDtdEntity: doc == NULL !\n");  	return(NULL);     } !     if (doc->extSubset == NULL) {          fprintf(stderr, B 	        "xmlAddDtdEntity: document without external subset !\n"); 	return(NULL);     }      dtd = doc->extSubset; 0     table = (xmlEntitiesTablePtr) dtd->entities;     if (table == NULL) {)         table = xmlCreateEntitiesTable();  	dtd->entities = table;      } I     ret = xmlAddEntity(table, name, type, ExternalID, SystemID, content); "     if (ret == NULL) return(NULL);       /*      * Link it to the Dtd       */      ret->parent = dtd;     ret->doc = dtd->doc;     if (dtd->last == NULL) {. 	dtd->children = dtd->last = (xmlNodePtr) ret;     } else {+         dtd->last->next = (xmlNodePtr) ret;  	ret->prev = dtd->last;  	dtd->last = (xmlNodePtr) ret;     }      return(ret); }    /**   * xmlAddDocEntity:   * @doc:  the document  * @name:  the entity name-  * @type:  the entity type XML_xxx_yyy_ENTITY 4  * @ExternalID:  the entity external ID if available0  * @SystemID:  the entity system ID if available   * @content:  the entity content  *+  * Register a new entity for this document.   *;  * Returns a pointer to the entity or NULL in case of error   */  xmlEntityPtr= xmlAddDocEntity(xmlDocPtr doc, const xmlChar *name, int type, < 	        const xmlChar *ExternalID, const xmlChar *SystemID," 	        const xmlChar *content) {     xmlEntitiesTablePtr table;     xmlEntityPtr ret;      xmlDtdPtr dtd;       if (doc == NULL) {         fprintf(stderr, 2 	        "xmlAddDocEntity: document is NULL !\n"); 	return(NULL);     } !     if (doc->intSubset == NULL) {          fprintf(stderr, B 	        "xmlAddDtdEntity: document without internal subset !\n"); 	return(NULL);     }      dtd = doc->intSubset; ;     table = (xmlEntitiesTablePtr) doc->intSubset->entities;      if (table == NULL) {)         table = xmlCreateEntitiesTable(); " 	doc->intSubset->entities = table;     } I     ret = xmlAddEntity(table, name, type, ExternalID, SystemID, content); "     if (ret == NULL) return(NULL);       /*      * Link it to the Dtd       */      ret->parent = dtd;     ret->doc = dtd->doc;     if (dtd->last == NULL) {. 	dtd->children = dtd->last = (xmlNodePtr) ret;     } else {$ 	dtd->last->next = (xmlNodePtr) ret; 	ret->prev = dtd->last;  	dtd->last = (xmlNodePtr) ret;     }      return(ret); }    #ifdef WITH_EXTRA_ENT_DETECT /**   * xmlEntityCheckReference:   * @ent:  an existing entity)  * @to:  the entity name it's referencing   *K  * Function to keep track of references and detect cycles (well formedness  
  * errors !).   *F  * Returns: 0 if Okay, -1 in case of general error, 1 in case of loop   *      detection.  */  int > xmlEntityCheckReference(xmlEntityPtr ent, const xmlChar *to) {
     int i;     xmlDocPtr doc;        if (ent == NULL) return(-1);     if (to == NULL) return(-1);        doc = ent->doc;       if (doc == NULL) return(-1);   #ifdef DEBUG_ENT_REFA     printf("xmlEntityCheckReference(%s to %s)\n", ent->name, to);  #endif         /*      * Do a recursive checking      */ $     for (i = 0;i < ent->entNr;i++) { 	xmlEntityPtr indir = NULL;   % 	if (xmlStrEqual(to, ent->entTab[i]))  	    return(1);    	switch (ent->etype) {-             case XML_INTERNAL_GENERAL_ENTITY: 4             case XML_EXTERNAL_GENERAL_PARSED_ENTITY:/ 		indir = xmlGetDocEntity(doc, ent->entTab[i]);  		break;/             case XML_INTERNAL_PARAMETER_ENTITY: /             case XML_EXTERNAL_PARAMETER_ENTITY: / 		indir = xmlGetDtdEntity(doc, ent->entTab[i]);  		break;0             case XML_INTERNAL_PREDEFINED_ENTITY:6             case XML_EXTERNAL_GENERAL_UNPARSED_ENTITY: 		break; 	}- 	if (xmlEntityCheckReference(indir, to) == 1)  	    return(1);      }      return(0); }    /**   * xmlEntityAddReference:   * @ent:  an existing entity)  * @to:  the entity name it's referencing   *D  * Function to register reuse of an existing entity from a (new) oneG  * Used to keep track of references and detect cycles (well formedness  
  * errors !).   *F  * Returns: 0 if Okay, -1 in case of general error, 1 in case of loop   *      detection.  */  int < xmlEntityAddReference(xmlEntityPtr ent, const xmlChar *to) {
     int i;     xmlDocPtr doc;     xmlEntityPtr indir = NULL;        if (ent == NULL) return(-1);     if (to == NULL) return(-1);        doc = ent->doc;       if (doc == NULL) return(-1);   #ifdef DEBUG_ENT_REF?     printf("xmlEntityAddReference(%s to %s)\n", ent->name, to);  #endif     if (ent->entTab == NULL) { 	ent->entNr = 0; 	ent->entMax = 5; G 	ent->entTab = (xmlChar **) xmlMalloc(ent->entMax * sizeof(xmlChar *));  	if (ent->entTab == NULL) { A 	    fprintf(stderr, "xmlEntityAddReference: out of memory !\n");  	    return(-1); 	}     }   $     for (i = 0;i < ent->entNr;i++) {% 	if (xmlStrEqual(to, ent->entTab[i]))  	    return(0);      }        /*      * Do a recursive checking      */        switch (ent->etype) { " 	case XML_INTERNAL_GENERAL_ENTITY:) 	case XML_EXTERNAL_GENERAL_PARSED_ENTITY: & 	    indir = xmlGetDocEntity(doc, to); 	    break; $ 	case XML_INTERNAL_PARAMETER_ENTITY:$ 	case XML_EXTERNAL_PARAMETER_ENTITY:& 	    indir = xmlGetDtdEntity(doc, to); 	    break; % 	case XML_INTERNAL_PREDEFINED_ENTITY: + 	case XML_EXTERNAL_GENERAL_UNPARSED_ENTITY:  	    break;      }      if ((indir != NULL) &&2 	(xmlEntityCheckReference(indir, ent->name) == 1)) 	return(1);        /*      * Add this to the list       */ $     if (ent->entMax <= ent->entNr) { 	ent->entMax *= 2;3 	ent->entTab = (xmlChar **) xmlRealloc(ent->entTab, A 		                              ent->entMax * sizeof(xmlChar *));  	if (ent->entTab == NULL) { A 	    fprintf(stderr, "xmlEntityAddReference: out of memory !\n");  	    return(-1); 	}     } .     ent->entTab[ent->entNr++] = xmlStrdup(to);     return(0); }  #endif     /**   * xmlGetEntityFromTable:   * @table:  an entity table   * @name:  the entity name+  * @parameter:  look for parameter entities   *$  * Do an entity lookup in the table.8  * returns the corresponding parameter entity, if found.  *  B  * Returns A pointer to the entity structure or NULL if not found.  */  xmlEntityPtrE xmlGetEntityFromTable(xmlEntitiesTablePtr table, const xmlChar *name,  	              int parameter) {      xmlEntityPtr cur;  #ifdef ENTITY_HASH_SIZE 
     int hash;   &     hash = xmlEntityComputeHash(name);     cur = table->table[hash];      while (cur != NULL) {  	switch (cur->etype) {( 	    case XML_INTERNAL_PARAMETER_ENTITY:( 	    case XML_EXTERNAL_PARAMETER_ENTITY:4 		if ((parameter) && (xmlStrEqual(cur->name, name))) 		    return(cur);
 	    default: 5 		if ((!parameter) && (xmlStrEqual(cur->name, name)))  		    return(cur); 	} 	cur = cur->nexte;     }  #else 
     int i;  ,     for (i = 0;i < table->nb_entities;i++) { 	cur = table->table[i];  	switch (cur->etype) {( 	    case XML_INTERNAL_PARAMETER_ENTITY:( 	    case XML_EXTERNAL_PARAMETER_ENTITY:4 		if ((parameter) && (xmlStrEqual(cur->name, name))) 		    return(cur);
 	    default: 5 		if ((!parameter) && (xmlStrEqual(cur->name, name)))  		    return(cur); 	}     }  #endif     return(NULL);  }    /**   * xmlGetParameterEntity: -  * @doc:  the document referencing the entity   * @name:  the entity name  *?  * Do an entity lookup in the internal and external subsets and 8  * returns the corresponding parameter entity, if found.  *  B  * Returns A pointer to the entity structure or NULL if not found.  */  xmlEntityPtr; xmlGetParameterEntity(xmlDocPtr doc, const xmlChar *name) {      xmlEntitiesTablePtr table;     xmlEntityPtr ret;   I     if ((doc->intSubset != NULL) && (doc->intSubset->entities != NULL)) { 8 	table = (xmlEntitiesTablePtr) doc->intSubset->entities;- 	ret = xmlGetEntityFromTable(table, name, 1);  	if (ret != NULL)  	    return(ret);      } I     if ((doc->extSubset != NULL) && (doc->extSubset->entities != NULL)) { 8 	table = (xmlEntitiesTablePtr) doc->extSubset->entities;/ 	return(xmlGetEntityFromTable(table, name, 1));      }      return(NULL);  }    /**   * xmlGetDtdEntity: -  * @doc:  the document referencing the entity   * @name:  the entity name  *7  * Do an entity lookup in the Dtd entity hash table and .  * returns the corresponding entity, if found.  *  B  * Returns A pointer to the entity structure or NULL if not found.  */  xmlEntityPtr5 xmlGetDtdEntity(xmlDocPtr doc, const xmlChar *name) {      xmlEntitiesTablePtr table;  I     if ((doc->extSubset != NULL) && (doc->extSubset->entities != NULL)) { 8 	table = (xmlEntitiesTablePtr) doc->extSubset->entities;/ 	return(xmlGetEntityFromTable(table, name, 0));      }      return(NULL);  }    /**   * xmlGetDocEntity: -  * @doc:  the document referencing the entity   * @name:  the entity name  *<  * Do an entity lookup in the document entity hash table and>  * returns the corrsponding entity, otherwise a lookup is done"  * in the predefined entities too.  *  B  * Returns A pointer to the entity structure or NULL if not found.  */  xmlEntityPtr5 xmlGetDocEntity(xmlDocPtr doc, const xmlChar *name) {      xmlEntityPtr cur;      xmlEntitiesTablePtr table;       if (doc != NULL) {F 	if ((doc->intSubset != NULL) && (doc->intSubset->entities != NULL)) {< 	    table = (xmlEntitiesTablePtr) doc->intSubset->entities;1 	    cur = xmlGetEntityFromTable(table, name, 0);  	    if (cur != NULL)  		return(cur); 	}F 	if ((doc->extSubset != NULL) && (doc->extSubset->entities != NULL)) {< 	    table = (xmlEntitiesTablePtr) doc->extSubset->entities;1 	    cur = xmlGetEntityFromTable(table, name, 0);  	    if (cur != NULL)  		return(cur); 	}     } &     if (xmlPredefinedEntities == NULL)*         xmlInitializePredefinedEntities();"     table = xmlPredefinedEntities;2     return(xmlGetEntityFromTable(table, name, 0)); }    /*A  * [2] Char ::= #x9 | #xA | #xD | [#x20-#xD7FF] | [#xE000-#xFFFD] (  *                  | [#x10000-#x10FFFF]I  * any Unicode character, excluding the surrogate blocks, FFFE, and FFFF.   */  #define IS_CHAR(c)							\;     (((c) == 0x09) || ((c) == 0x0a) || ((c) == 0x0d) ||			\ ;      (((c) >= 0x20) && ((c) != 0xFFFE) && ((c) != 0xFFFF)))    /*F  * A buffer used for converting entities to their equivalent and back.  */  static int buffer_size = 0;  static xmlChar *buffer = NULL;   int growBuffer(void) {     buffer_size *= 2; K     buffer = (xmlChar *) xmlRealloc(buffer, buffer_size * sizeof(xmlChar));      if (buffer == NULL) { !         perror("realloc failed");  	return(-1);     }      return(0); }      /**   * xmlEncodeEntities: ,  * @doc:  the document containing the string'  * @input:  A string to convert to XML.   *F  * Do a global encoding of a string, replacing the predefined entitiesE  * and non ASCII values with their entities and CharRef counterparts.   *L  * TODO: remove xmlEncodeEntities, once we are not afraid of breaking binary  *       compatibility  *A  * People must migrate their code to xmlEncodeEntitiesReentrant ! 6  * This routine will issue a warning when encountered.  *  ?  * Returns A newly allocated string with the substitution done.   */  const xmlChar * 8 xmlEncodeEntities(xmlDocPtr doc, const xmlChar *input) {     const xmlChar *cur = input;      xmlChar *out = buffer;     static int warning = 1;      int html = 0;          if (warning) {A     fprintf(stderr, "Deprecated API xmlEncodeEntities() used\n"); L     fprintf(stderr, "   change code to use xmlEncodeEntitiesReentrant()\n");     warning = 0;     }   $     if (input == NULL) return(NULL);     if (doc != NULL)5         html = (doc->type == XML_HTML_DOCUMENT_NODE);        if (buffer == NULL) {          buffer_size = 1000; F         buffer = (xmlChar *) xmlMalloc(buffer_size * sizeof(xmlChar)); 	if (buffer == NULL) { 	    perror("malloc failed");              return(NULL);  	} 	out = buffer;     }      while (*cur != '\0') {/         if (out - buffer > buffer_size - 100) {  	    int index = out - buffer;   	    growBuffer(); 	    out = &buffer[index]; 	}   	/* B 	 * By default one have to encode at least '<', '>', '"' and '&' ! 	 */ 	if (*cur == '<') {  	    *out++ = '&'; 	    *out++ = 'l'; 	    *out++ = 't'; 	    *out++ = ';'; 	} else if (*cur == '>') { 	    *out++ = '&'; 	    *out++ = 'g'; 	    *out++ = 't'; 	    *out++ = ';'; 	} else if (*cur == '&') { 	    *out++ = '&'; 	    *out++ = 'a'; 	    *out++ = 'm'; 	    *out++ = 'p'; 	    *out++ = ';'; 	} else if (*cur == '"') { 	    *out++ = '&'; 	    *out++ = 'q'; 	    *out++ = 'u'; 	    *out++ = 'o'; 	    *out++ = 't'; 	    *out++ = ';';( 	} else if ((*cur == '\'') && (!html)) { 	    *out++ = '&'; 	    *out++ = 'a'; 	    *out++ = 'p'; 	    *out++ = 'o'; 	    *out++ = 's'; 	    *out++ = ';';0 	} else if (((*cur >= 0x20) && (*cur < 0x80)) ||: 	    (*cur == '\n') || (*cur == '\r') || (*cur == '\t')) { 	    /* ! 	     * default case, just copy !  	     */ 	    *out++ = *cur;  #ifndef USE_UTF_8 7 	} else if ((sizeof(xmlChar) == 1) && (*cur >= 0x80)) {  	    char buf[10], *ptr;   #ifdef HAVE_SNPRINTF/ 	    snprintf(buf, sizeof(buf), "&#%d;", *cur);  #else ! 	    sprintf(buf, "&#%d;", *cur);  #endif%             buf[sizeof(buf) - 1] = 0;              ptr = buf;' 	    while (*ptr != 0) *out++ = *ptr++;  #endif 	} else if (IS_CHAR(*cur)) { 	    char buf[10], *ptr;   #ifdef HAVE_SNPRINTF/ 	    snprintf(buf, sizeof(buf), "&#%d;", *cur);  #else ! 	    sprintf(buf, "&#%d;", *cur);  #endif%             buf[sizeof(buf) - 1] = 0;              ptr = buf;' 	    while (*ptr != 0) *out++ = *ptr++;  	} #if 0  	else {  	    /* 0 	     * default case, this is not a valid char ! 	     * Skip it... 	     */I 	    fprintf(stderr, "xmlEncodeEntities: invalid char %d\n", (int) *cur);  	} #endif 	cur++;      }      *out++ = 0;      return(buffer);  }    /*)  * Macro used to grow the current buffer.   */ & #define growBufferReentrant() {						\     buffer_size *= 2;							\      buffer = (xmlChar *)						\ :     		xmlRealloc(buffer, buffer_size * sizeof(xmlChar));	\      if (buffer == NULL) {						\  	perror("realloc failed");					\ 	return(NULL);							\     }									\  }      /**   * xmlEncodeEntitiesReentrant:,  * @doc:  the document containing the string'  * @input:  A string to convert to XML.   *F  * Do a global encoding of a string, replacing the predefined entitiesE  * and non ASCII values with their entities and CharRef counterparts. G  * Contrary to xmlEncodeEntities, this routine is reentrant, and result   * must be deallocated.   *?  * Returns A newly allocated string with the substitution done.   */ 	 xmlChar * A xmlEncodeEntitiesReentrant(xmlDocPtr doc, const xmlChar *input) {      const xmlChar *cur = input;      xmlChar *buffer = NULL;      xmlChar *out = NULL;     int buffer_size = 0;     int html = 0;   $     if (input == NULL) return(NULL);     if (doc != NULL)5         html = (doc->type == XML_HTML_DOCUMENT_NODE);        /*&      * allocate an translation buffer.      */      buffer_size = 1000; B     buffer = (xmlChar *) xmlMalloc(buffer_size * sizeof(xmlChar));     if (buffer == NULL) {  	perror("malloc failed");  	return(NULL);     }      out = buffer;        while (*cur != '\0') {/         if (out - buffer > buffer_size - 100) {  	    int index = out - buffer;   	    growBufferReentrant();  	    out = &buffer[index]; 	}   	/* B 	 * By default one have to encode at least '<', '>', '"' and '&' ! 	 */ 	if (*cur == '<') {  	    *out++ = '&'; 	    *out++ = 'l'; 	    *out++ = 't'; 	    *out++ = ';'; 	} else if (*cur == '>') { 	    *out++ = '&'; 	    *out++ = 'g'; 	    *out++ = 't'; 	    *out++ = ';'; 	} else if (*cur == '&') { 	    *out++ = '&'; 	    *out++ = 'a'; 	    *out++ = 'm'; 	    *out++ = 'p'; 	    *out++ = ';'; 	} else if (*cur == '"') { 	    *out++ = '&'; 	    *out++ = 'q'; 	    *out++ = 'u'; 	    *out++ = 'o'; 	    *out++ = 't'; 	    *out++ = ';'; #if 0 ( 	} else if ((*cur == '\'') && (!html)) { 	    *out++ = '&'; 	    *out++ = 'a'; 	    *out++ = 'p'; 	    *out++ = 'o'; 	    *out++ = 's'; 	    *out++ = ';'; #endif0 	} else if (((*cur >= 0x20) && (*cur < 0x80)) ||: 	    (*cur == '\n') || (*cur == '\r') || (*cur == '\t')) { 	    /* ! 	     * default case, just copy !  	     */ 	    *out++ = *cur;  	} else if (*cur >= 0x80) { - 	    if ((doc->encoding != NULL) || (html)) {  		/*3 		 * Bjrn Reese <br@sseusa.com> provided the patch  	        xmlChar xc;! 	        xc = (*cur & 0x3F) << 6;  	        if (cur[1] != 0) {  		    xc += *(++cur) & 0x3F; 		    *out++ = xc; 	        } else  		 */  		    *out++ = *cur;
 	    } else {  		/*# 		 * We assume we have UTF-8 input.  		 */  		char buf[10], *ptr;  		int val = 0, l = 1;    		if (*cur < 0xC0) { 		    fprintf(stderr, 9 			    "xmlEncodeEntitiesReentrant : input not UTF-8\n"); 7 		    doc->encoding = xmlStrdup(BAD_CAST "ISO-8859-1");  #ifdef HAVE_SNPRINTF0 		    snprintf(buf, sizeof(buf), "&#%d;", *cur); #else " 		    sprintf(buf, "&#%d;", *cur); #endif 		    buf[sizeof(buf) - 1] = 0;  		    ptr = buf;( 		    while (*ptr != 0) *out++ = *ptr++; 		    continue;  		} else if (*cur < 0xE0) { *                     val = (cur[0]) & 0x1F; 		    val <<= 6; 		    val |= (cur[1]) & 0x3F;  		    l = 2; 		} else if (*cur < 0xF0) { *                     val = (cur[0]) & 0x0F; 		    val <<= 6; 		    val |= (cur[1]) & 0x3F;  		    val <<= 6; 		    val |= (cur[2]) & 0x3F;  		    l = 3; 		} else if (*cur < 0xF8) { *                     val = (cur[0]) & 0x07; 		    val <<= 6; 		    val |= (cur[1]) & 0x3F;  		    val <<= 6; 		    val |= (cur[2]) & 0x3F;  		    val <<= 6; 		    val |= (cur[3]) & 0x3F;  		    l = 4; 		} $ 		if ((l == 1) || (!IS_CHAR(val))) { 		    fprintf(stderr, 7 			"xmlEncodeEntitiesReentrant : char out of range\n"); 7 		    doc->encoding = xmlStrdup(BAD_CAST "ISO-8859-1");  #ifdef HAVE_SNPRINTF0 		    snprintf(buf, sizeof(buf), "&#%d;", *cur); #else " 		    sprintf(buf, "&#%d;", *cur); #endif 		    buf[sizeof(buf) - 1] = 0;  		    ptr = buf;( 		    while (*ptr != 0) *out++ = *ptr++; 		    cur++; 		    continue;  		}  		/*> 		 * We could do multiple things here. Just save as a char ref 		 */  #ifdef HAVE_SNPRINTF, 		snprintf(buf, sizeof(buf), "&#x%X;", val); #else  		sprintf(buf, "&#x%X;", val); #endif 		buf[sizeof(buf) - 1] = 0;  		ptr = buf;$ 		while (*ptr != 0) *out++ = *ptr++; 		cur += l;  		continue;  	    } 	} else if (IS_CHAR(*cur)) { 	    char buf[10], *ptr;   #ifdef HAVE_SNPRINTF/ 	    snprintf(buf, sizeof(buf), "&#%d;", *cur);  #else ! 	    sprintf(buf, "&#%d;", *cur);  #endif 	    buf[sizeof(buf) - 1] = 0;             ptr = buf;' 	    while (*ptr != 0) *out++ = *ptr++;  	} #if 0  	else {  	    /* 0 	     * default case, this is not a valid char ! 	     * Skip it... 	     */I 	    fprintf(stderr, "xmlEncodeEntities: invalid char %d\n", (int) *cur);  	} #endif 	cur++;      }      *out++ = 0;      return(buffer);  }    /**   * xmlEncodeSpecialChars: ,  * @doc:  the document containing the string'  * @input:  A string to convert to XML.   *F  * Do a global encoding of a string, replacing the predefined entities=  * this routine is reentrant, and result must be deallocated.   *?  * Returns A newly allocated string with the substitution done.   */ 	 xmlChar * < xmlEncodeSpecialChars(xmlDocPtr doc, const xmlChar *input) {     const xmlChar *cur = input;      xmlChar *buffer = NULL;      xmlChar *out = NULL;     int buffer_size = 0;     int html = 0;   $     if (input == NULL) return(NULL);     if (doc != NULL)5         html = (doc->type == XML_HTML_DOCUMENT_NODE);        /*&      * allocate an translation buffer.      */      buffer_size = 1000; B     buffer = (xmlChar *) xmlMalloc(buffer_size * sizeof(xmlChar));     if (buffer == NULL) {  	perror("malloc failed");  	return(NULL);     }      out = buffer;        while (*cur != '\0') {.         if (out - buffer > buffer_size - 10) { 	    int index = out - buffer;   	    growBufferReentrant();  	    out = &buffer[index]; 	}   	/* B 	 * By default one have to encode at least '<', '>', '"' and '&' ! 	 */ 	if (*cur == '<') {  	    *out++ = '&'; 	    *out++ = 'l'; 	    *out++ = 't'; 	    *out++ = ';'; 	} else if (*cur == '>') { 	    *out++ = '&'; 	    *out++ = 'g'; 	    *out++ = 't'; 	    *out++ = ';'; 	} else if (*cur == '&') { 	    *out++ = '&'; 	    *out++ = 'a'; 	    *out++ = 'm'; 	    *out++ = 'p'; 	    *out++ = ';'; 	} else if (*cur == '"') { 	    *out++ = '&'; 	    *out++ = 'q'; 	    *out++ = 'u'; 	    *out++ = 'o'; 	    *out++ = 't'; 	    *out++ = ';';	 	} else {  	    /* = 	     * Works because on UTF-8, all extended sequences cannot + 	     * result in bytes in the ASCII range.  	     */ 	    *out++ = *cur;  	} 	cur++;      }      *out++ = 0;      return(buffer);  }    /**   * xmlCreateEntitiesTable:  *6  * create and initialize an empty entities hash table.  *I  * Returns the xmlEntitiesTablePtr just created or NULL in case of error.   */  xmlEntitiesTablePtr  xmlCreateEntitiesTable(void) {     xmlEntitiesTablePtr ret;        ret = (xmlEntitiesTablePtr) -          xmlMalloc(sizeof(xmlEntitiesTable));      if (ret == NULL) {K         fprintf(stderr, "xmlCreateEntitiesTable : xmlMalloc(%ld) failed\n", ) 	        (long)sizeof(xmlEntitiesTable));          return(NULL);      }      ret->nb_entities = 0;  #ifdef ENTITY_HASH_SIZE )     ret->max_entities = ENTITY_HASH_SIZE; "     ret->table = (xmlEntityPtr *) =          xmlMalloc(ret->max_entities * sizeof(xmlEntityPtr));      if (ret == NULL) {K         fprintf(stderr, "xmlCreateEntitiesTable : xmlMalloc(%ld) failed\n", 9 	        ret->max_entities * (long)sizeof(xmlEntityPtr));  	xmlFree(ret);         return(NULL);      } D     memset(ret->table, 0, ret->max_entities * sizeof(xmlEntityPtr)); #else /     ret->max_entities = XML_MIN_ENTITIES_TABLE; "     ret->table = (xmlEntityPtr *) =          xmlMalloc(ret->max_entities * sizeof(xmlEntityPtr));      if (ret == NULL) {K         fprintf(stderr, "xmlCreateEntitiesTable : xmlMalloc(%ld) failed\n", 9 	        ret->max_entities * (long)sizeof(xmlEntityPtr));  	xmlFree(ret);         return(NULL);      }  #endif     return(ret); }    /**   * xmlFreeEntitiesTable:  * @table:  An entity table   *8  * Deallocate the memory used by an entities hash table.  */  void1 xmlFreeEntitiesTable(xmlEntitiesTablePtr table) { 
     int i; #ifdef ENTITY_HASH_SIZE      xmlEntityPtr cur, next;  #endif       if (table == NULL) return;   #ifdef ENTITY_HASH_SIZE *     for (i = 0;i < ENTITY_HASH_SIZE;i++) { 	cur = table->table[i];  	while (cur != NULL) { 	    next = cur->nexte;  	    xmlFreeEntity(cur); 	    cur = next; 	}     }  #else ,     for (i = 0;i < table->nb_entities;i++) {'         xmlFreeEntity(table->table[i]);      }  #endif     xmlFree(table->table);     xmlFree(table);  }    /**   * xmlCopyEntity:   * @ent:  An entity   *  * Build a copy of an entity  *  ;  * Returns the new xmlEntitiesPtr or NULL in case of error.   */  xmlEntityPtr! xmlCopyEntity(xmlEntityPtr ent) {      xmlEntityPtr cur;   6     cur = (xmlEntityPtr) xmlMalloc(sizeof(xmlEntity));     if (cur == NULL) {5 	fprintf(stderr, "xmlCopyEntity: out of memory !\n");  	return(NULL);     } &     memset(cur, 0, sizeof(xmlEntity));!     cur->type = XML_ELEMENT_DECL;        cur->etype = ent->etype;     if (ent->name != NULL)" 	cur->name = xmlStrdup(ent->name);      if (ent->ExternalID != NULL). 	cur->ExternalID = xmlStrdup(ent->ExternalID);     if (ent->SystemID != NULL)* 	cur->SystemID = xmlStrdup(ent->SystemID);     if (ent->content != NULL) ( 	cur->content = xmlStrdup(ent->content);     if (ent->orig != NULL)" 	cur->orig = xmlStrdup(ent->orig);     return(cur); }    /**   * xmlCopyEntitiesTable:  * @table:  An entity table   *#  * Build a copy of an entity table.   *  @  * Returns the new xmlEntitiesTablePtr or NULL in case of error.  */  xmlEntitiesTablePtr 1 xmlCopyEntitiesTable(xmlEntitiesTablePtr table) {      xmlEntitiesTablePtr ret;     xmlEntityPtr cur, ent;
     int i;  D     ret = (xmlEntitiesTablePtr) xmlMalloc(sizeof(xmlEntitiesTable));     if (ret == NULL) {C         fprintf(stderr, "xmlCopyEntitiesTable: out of memory !\n");  	return(NULL);     }  #ifdef ENTITY_HASH_SIZE >     ret->table = (xmlEntityPtr *) xmlMalloc(ENTITY_HASH_SIZE *B                                             sizeof(xmlEntityPtr));     if (ret->table == NULL) { C         fprintf(stderr, "xmlCopyEntitiesTable: out of memory !\n");  	xmlFree(ret); 	return(NULL);     }  #else A     ret->table = (xmlEntityPtr *) xmlMalloc(table->max_entities * B                                             sizeof(xmlEntityPtr));     if (ret->table == NULL) { C         fprintf(stderr, "xmlCopyEntitiesTable: out of memory !\n");  	xmlFree(ret); 	return(NULL);     }  #endif,     ret->max_entities = table->max_entities;*     ret->nb_entities = table->nb_entities;*     for (i = 0;i < ret->nb_entities;i++) { 	ent = table->table[i];  	if (ent == NULL)  	    cur = NULL; 	else  	    cur = xmlCopyEntity(ent); 	ret->table[i] = cur;  #ifdef ENTITY_HASH_SIZE  	ent = ent->nexte;) 	while ((ent != NULL) && (cur != NULL)) { ,             cur->nexte = xmlCopyEntity(ent); 	    cur = cur->nexte; 	} #endif     }      return(ret); }    /**   * xmlDumpEntityDecl:   * @buf:  An XML buffer.  * @ent:  An entity table   *J  * This will dump the content of the entity table as an XML DTD definition  */  void7 xmlDumpEntityDecl(xmlBufferPtr buf, xmlEntityPtr ent) {      switch (ent->etype) { " 	case XML_INTERNAL_GENERAL_ENTITY:* 	    xmlBufferWriteChar(buf, "<!ENTITY ");( 	    xmlBufferWriteCHAR(buf, ent->name);" 	    xmlBufferWriteChar(buf, " "); 	    if (ent->orig != NULL) - 		xmlBufferWriteQuotedString(buf, ent->orig); 	 	    else 0 		xmlBufferWriteQuotedString(buf, ent->content);$ 	    xmlBufferWriteChar(buf, ">\n"); 	    break; ) 	case XML_EXTERNAL_GENERAL_PARSED_ENTITY: * 	    xmlBufferWriteChar(buf, "<!ENTITY ");( 	    xmlBufferWriteCHAR(buf, ent->name);# 	    if (ent->ExternalID != NULL) { ' 		 xmlBufferWriteChar(buf, " PUBLIC "); 4 		 xmlBufferWriteQuotedString(buf, ent->ExternalID);  		 xmlBufferWriteChar(buf, " ");2 		 xmlBufferWriteQuotedString(buf, ent->SystemID);
 	    } else { ' 		 xmlBufferWriteChar(buf, " SYSTEM "); 2 		 xmlBufferWriteQuotedString(buf, ent->SystemID); 	    }$ 	    xmlBufferWriteChar(buf, ">\n"); 	    break; + 	case XML_EXTERNAL_GENERAL_UNPARSED_ENTITY: * 	    xmlBufferWriteChar(buf, "<!ENTITY ");( 	    xmlBufferWriteCHAR(buf, ent->name);# 	    if (ent->ExternalID != NULL) { ' 		 xmlBufferWriteChar(buf, " PUBLIC "); 4 		 xmlBufferWriteQuotedString(buf, ent->ExternalID);  		 xmlBufferWriteChar(buf, " ");2 		 xmlBufferWriteQuotedString(buf, ent->SystemID);
 	    } else { ' 		 xmlBufferWriteChar(buf, " SYSTEM "); 2 		 xmlBufferWriteQuotedString(buf, ent->SystemID); 	    }7 	    if (ent->content != NULL) { /* Should be true ! */ % 		xmlBufferWriteChar(buf, " NDATA ");  		if (ent->orig != NULL)) 		    xmlBufferWriteCHAR(buf, ent->orig);  		else, 		    xmlBufferWriteCHAR(buf, ent->content); 	    }$ 	    xmlBufferWriteChar(buf, ">\n"); 	    break; $ 	case XML_INTERNAL_PARAMETER_ENTITY:, 	    xmlBufferWriteChar(buf, "<!ENTITY % ");( 	    xmlBufferWriteCHAR(buf, ent->name);" 	    xmlBufferWriteChar(buf, " "); 	    if (ent->orig == NULL) 0 		xmlBufferWriteQuotedString(buf, ent->content);	 	    else - 		xmlBufferWriteQuotedString(buf, ent->orig); $ 	    xmlBufferWriteChar(buf, ">\n"); 	    break; $ 	case XML_EXTERNAL_PARAMETER_ENTITY:, 	    xmlBufferWriteChar(buf, "<!ENTITY % ");( 	    xmlBufferWriteCHAR(buf, ent->name);# 	    if (ent->ExternalID != NULL) { ' 		 xmlBufferWriteChar(buf, " PUBLIC "); 4 		 xmlBufferWriteQuotedString(buf, ent->ExternalID);  		 xmlBufferWriteChar(buf, " ");2 		 xmlBufferWriteQuotedString(buf, ent->SystemID);
 	    } else { ' 		 xmlBufferWriteChar(buf, " SYSTEM "); 2 		 xmlBufferWriteQuotedString(buf, ent->SystemID); 	    }$ 	    xmlBufferWriteChar(buf, ">\n"); 	    break; 	 	default:  	    fprintf(stderr,6 		"xmlDumpEntitiesTable: internal: unknown type %d\n", 		    ent->etype);     }  }    /**   * xmlDumpEntitiesTable:  * @buf:  An XML buffer.  * @table:  An entity table   *J  * This will dump the content of the entity table as an XML DTD definition  */  voidC xmlDumpEntitiesTable(xmlBufferPtr buf, xmlEntitiesTablePtr table) { 
     int i;     xmlEntityPtr cur;        if (table == NULL) return;   #ifdef ENTITY_HASH_SIZE *     for (i = 0;i < ENTITY_HASH_SIZE;i++) {         cur = table->table[i]; 	while (cur != NULL) {! 	    xmlDumpEntityDecl(buf, cur);  	    cur = cur->nexte; 	}     }  #else ,     for (i = 0;i < table->nb_entities;i++) {         cur = table->table[i]; 	xmlDumpEntityDecl(buf, cur);      }  #endif } 