/*	27-SEP-2000	RRL	Initial coding.

	VMS:

	Build:
	$MMK<CR>
	or
	$MMS<CR>

	$ remuser="sa"
	$ rempassword="coolzyzop"
	$ remserver="micro.sux.net"
	
	$ run isql
	ISQL> select * from customer where username = 'laishev'<CR>
	....
	ISQL>  Exit
	$
*/

#include	<stdio.h>
#include	<tds.h>
#include	<tdsconvert.h>
#include	<common.h>


char	out_col_names	(
		TDSSOCKET  *tds
			)
{
int	col;

	for ( col = 0;col < tds->res_info->num_cols;col++)
		printf(" %s ",tds->res_info->columns[col]->column_name);
	printf("\n");

}
void	out_row_values	(
		TDSSOCKET  *tds
			)
{
int	col,type,offset,size,null;
char *	row;
void *	value;
char	buf [ 256 ];
TDS_INT	status;

	row	= tds->res_info->current_row;

	for ( col = 0;col < tds->res_info->num_cols;col++)
		{
		buf[0]	= '\0';
		type	= tds->res_info->columns[col]->column_type;
		size	= tds->res_info->columns[col]->column_size;
		offset	= tds->res_info->columns[col]->column_offset;
		value	= (row+offset);

		if ( tds_get_null(tds->res_info->current_row, col) )
			{
			printf(" (Null) ");
			continue;
			}

		type	= tds_get_conversion_type(type,size);
		tds_convert(type,value,size,SYBVARCHAR,buf,sizeof(buf));

		switch (type)
			{
			case	SYBVARCHAR:
			case	SYBTEXT:
			case	SYBNVARCHAR:
				printf(" \"%s\" ",buf);
				break;
			default:
				printf(" %s ",buf);
			}
		}

	printf("\n");
}

void	main	(void)
{
TDSLOGIN *login;
TDSSOCKET *tds;
int	rc,i;

char	sql_text[1024];

	login = tds_alloc_login();
	tds_set_passwd(login,getenv("REMPASSWORD"));
	tds_set_user(login,getenv("REMUSER"));
	tds_set_app(login,"ISQL");
	tds_set_host(login,"LocalHost");
	tds_set_library(login,"Library");
	tds_set_server(login,getenv("REMSERVER"));
	tds_set_charset(login,"iso_1");
	tds_set_language(login,"us_english");
	tds_set_packet(login,8192);

	if ( !(tds = tds_connect(login)) )
		{
		printf("Login failed.\n");
		exit(1);
		}

	while ( 1 )
		{
		printf("\nISQL> ");
		sql_text[0] = '\0';
		if ( !gets(sql_text) )
			break;

		if ( !strlen(sql_text) )
			continue;

		tds_submit_query(tds,sql_text);
		 
		while ( TDS_NO_MORE_RESULTS != (rc = tds_process_result_tokens(tds)) )
			{
			if ( !tds->res_info )
				continue;

			out_col_names(tds);
			while ( TDS_SUCCEED == (rc = tds_process_row_tokens(tds)) ) 
				out_row_values(tds);

			}
		if ( tds->rows_affected )
			printf("--------------------------\nSQL:%u row affected/selected\n",tds->rows_affected);
		}
}
