/* $Id: rusconv.c,v 1.1 2000/01/12 09:15:54 valent Exp $
*
*			    
*
*		:
*			rusconv <input file> [<output_file>] /cf=<NCS conversion function> 
*									/ext=<default output file' extension>
*
*		 /ext   backward-  
*		dostodec, dectodos, etc.
*
*
*	11.01.2000	 . 	
*
*
*/

#include <starlet.h>
#include <lib$routines.h>
#include <ncs$routines.h>
#include <ssdef.h>
#include <stsdef.h>
#include <libdef.h>
#include <descrip.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ints.h>
#include <ctype.h>
#include <clidef.h>
#include <climsgdef.h>
#include <cli$routines.h>
#include <fscndef.h>
#include <rms.h>

#pragma message disable (READONLYEXT, ALIGNEXT, GLOBALEXT, ADDRCONSTEXT)

#define RUSCONV_DEF_OUT_EXT		".rconv"

struct fscn_item
	{
	short Len;
	short Code;
	void *Addr;
	};

int ParseCmdString ();
int DisplayError (void *ptr, int a, int b, int Status);

globalvalue RUSCONV_CLD;

char iFname[80] = "", oFname[80] = "", DefExt[50] = "", CFname[80] = "";
char iRec[32768];
char Verb[] = "rusconv";

struct FAB iFab, oFab;
struct RAB iRab, oRab;

main ()
	{
	int Status, RetLen;
	unsigned long CFid;
	struct dsc$descriptor tDesc = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};
	struct dsc$descriptor tDesc1 = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};
	struct fscn_item FscnList[] = {
		{0, FSCN$_DEVICE, NULL},
		{0, FSCN$_DIRECTORY, NULL},
		{0, FSCN$_NAME, NULL},
		{0, 0, NULL}
	};
//	$DESCRIPTOR (LibDesc, "DISK$ATM_PRG:[HOME.ATMVALENT.WRK.CONV]test.nlb");

	Status = ParseCmdString ();
	if (!(Status & STS$M_SUCCESS))
		exit (Status);

	tDesc.dsc$a_pointer = CFname;
	tDesc.dsc$w_length = strlen (CFname);
	Status = ncs$get_cf (&CFid, &tDesc, NULL);
	if (!(Status & STS$M_SUCCESS))
		{
		printf ("\nError processing conversion function '%s'", CFname);
		DisplayError (NULL, 0, 0, Status);
		exit (Status);
		};

	iFab = cc$rms_fab;
	oFab = cc$rms_fab;
	iRab = cc$rms_rab;
	oRab = cc$rms_rab;
    
	iFab.fab$b_fac = FAB$M_GET;
	iFab.fab$l_fna = iFname;
	iFab.fab$b_fns = strlen (iFname);
	
	iRab.rab$l_fab = &iFab;
	iRab.rab$b_rac = RAB$C_SEQ;

	Status = sys$open (&iFab);
	if (!(Status & STS$M_SUCCESS))
		{
		printf ("\nError opening file %s, sts: %X, stv: %X", 
				iFname, iFab.fab$l_sts, iFab.fab$l_stv);
		DisplayError (NULL, 0, 0, Status);
		exit (Status);
		};
	Status = sys$connect (&iRab);
	if (!(Status & STS$M_SUCCESS))
		{
		printf ("\nError connecting to file %s, sts: %X, stv: %X", 
				iFname, iRab.rab$l_sts, iRab.rab$l_stv);
		DisplayError (NULL, 0, 0, Status);
		sys$close (&iFab);
		exit (Status);
		};
	iRab.rab$l_ubf = iRec;
	iRab.rab$w_usz = sizeof (iRec);

//		     ,     
//		
	if (!strlen (oFname))
		{
		tDesc.dsc$a_pointer = iFname;
		tDesc.dsc$w_length = strlen (iFname);
		Status = sys$filescan (&tDesc, FscnList, NULL, NULL, NULL);
		if (!(Status & STS$M_SUCCESS))
			{
			printf ("\nError parsing input file specification");
			DisplayError (NULL, 0, 0, Status);
			exit (Status);
			}
		if (!FscnList[0].Addr)
			{
			if (!FscnList[1].Addr)
				FscnList[0].Addr = FscnList[2].Addr;
			else
				FscnList[0].Addr = FscnList[1].Addr;
			}
		memset (oFname, 0, sizeof (oFname));
		memcpy (oFname, FscnList[0].Addr, 
					FscnList[0].Len + FscnList[1].Len + FscnList[2].Len);
		if (strlen (DefExt))
			strcat (oFname, DefExt);
		else
			strcat (oFname, RUSCONV_DEF_OUT_EXT);
		}

	oFab.fab$b_fac = FAB$M_PUT;
	oFab.fab$l_fna = oFname;
	oFab.fab$b_fns = strlen (oFname);
	oFab.fab$l_alq = iFab.fab$l_alq;
	oFab.fab$l_fop |= iFab.fab$l_fop & FAB$M_CBT;
	oFab.fab$l_fop |= iFab.fab$l_fop & FAB$M_CTG;
	oFab.fab$w_mrs = iFab.fab$w_mrs;
	oFab.fab$b_org = FAB$C_SEQ;
	oFab.fab$b_rfm = iFab.fab$b_rfm;
	oFab.fab$b_rat = iFab.fab$b_rat;
	
	oRab.rab$l_fab = &oFab;
	oRab.rab$b_rac = RAB$C_SEQ;

	Status = sys$create (&oFab);
	if (!(Status & STS$M_SUCCESS))
		{
		printf ("\nError opening file %s, sts: %X, stv: %X", 
				iFname, oFab.fab$l_sts, oFab.fab$l_stv);
		DisplayError (NULL, 0, 0, Status);
		exit (Status);
		};
	Status = sys$connect (&oRab);
	if (!(Status & STS$M_SUCCESS))
		{
		printf ("\nError connecting to file %s, sts: %X, stv: %X", 
				iFname, oRab.rab$l_sts, oRab.rab$l_stv);
		DisplayError (NULL, 0, 0, Status);
		sys$close (&oFab);
		exit (Status);
		};

	tDesc.dsc$a_pointer = iRec;
	while (TRUE)
		{
		Status = sys$get (&iRab);
		if (!(Status & STS$M_SUCCESS))
			{
			if (Status != RMS$_EOF)
				{
				printf ("\nError reading input file");
				DisplayError (NULL, 0, 0, Status);
				}
			break;
			}
		tDesc.dsc$w_length = iRab.rab$w_rsz;
		RetLen = 0;
		Status = ncs$convert (&CFid, &tDesc, &tDesc1, &RetLen);
		if (!(Status & STS$M_SUCCESS))
			{
			printf ("\nError converting string");
			DisplayError (NULL, 0, 0, Status);
			break;
			}


		oRab.rab$l_rbf = tDesc1.dsc$a_pointer;
		oRab.rab$w_rsz = tDesc1.dsc$w_length;
//		oRab.rab$w_rsz = RetLen;
		Status = sys$put (&oRab);
		if (!(Status & STS$M_SUCCESS))
			{
			printf ("\nError writing output file");
			DisplayError (NULL, 0, 0, Status);
			break;
			}
		}

	Status = ncs$end_cf (&CFid);
	Status = sys$close (&oFab);
	Status = sys$close (&iFab);
	}


int ParseCmdString ()
	{
	int Status, RetLen, Idx;
	char Entity[128];
	$DESCRIPTOR (EntDesc, Entity);
	struct dsc$descriptor CmdDesc = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};

	strcpy (Entity, "$LINE");
	EntDesc.dsc$w_length = strlen (Entity);
	Status = cli$get_value (&EntDesc, &CmdDesc, &RetLen);
	if (!(Status & STS$M_SUCCESS))
		{
		printf ("\nError during 'cli$get_value'");
		DisplayError (NULL, 0, 0, Status);
		return (Status);
		}

	for (Idx = 0; (Idx < CmdDesc.dsc$w_length) && 
					(CmdDesc.dsc$a_pointer[Idx] != ' ') &&
					(CmdDesc.dsc$a_pointer[Idx] != '/'); Idx++)
		{
		CmdDesc.dsc$a_pointer[Idx] = (Idx < strlen (Verb))? Verb[Idx]: ' ';
		}

	Status = cli$dcl_parse (&CmdDesc, RUSCONV_CLD, 0, 0, 0);
	if (!(Status & STS$M_SUCCESS))
		{
		printf ("\nError during 'cli$dcl_parse'");
		DisplayError (NULL, 0, 0, Status);
		return (Status);
		}

	strcpy (Entity, "P1");
	EntDesc.dsc$w_length = strlen (Entity);
	Status = cli$get_value (&EntDesc, &CmdDesc, &RetLen);
	if (!(Status & STS$M_SUCCESS))
		{
		printf ("\nError during 'cli$get_value'");
		DisplayError (NULL, 0, 0, Status);
		return (Status);
		}
	memcpy (iFname, CmdDesc.dsc$a_pointer, CmdDesc.dsc$w_length);
	iFname[CmdDesc.dsc$w_length] = 0;

	strcpy (Entity, "P2");
	EntDesc.dsc$w_length = strlen (Entity);
	Status = cli$present (&EntDesc);
	if (Status & STS$M_SUCCESS)
		{
		Status = cli$get_value (&EntDesc, &CmdDesc, &RetLen);
		if (!(Status & STS$M_SUCCESS))
			{
			printf ("\nError during 'cli$get_value'");
			DisplayError (NULL, 0, 0, Status);
			return (Status);
			}
		memcpy (oFname, CmdDesc.dsc$a_pointer, CmdDesc.dsc$w_length);
		oFname[CmdDesc.dsc$w_length] = 0;
		}

	strcpy (Entity, "EXT");
	EntDesc.dsc$w_length = strlen (Entity);
	Status = cli$present (&EntDesc);
	if (Status & STS$M_SUCCESS)
		{
		Status = cli$get_value (&EntDesc, &CmdDesc, &RetLen);
		if (!(Status & STS$M_SUCCESS))
			{
			printf ("\nError during 'cli$get_value'");
			DisplayError (NULL, 0, 0, Status);
			return (Status);
			}
		DefExt[0] = '.';
		memcpy (&DefExt[1], CmdDesc.dsc$a_pointer, CmdDesc.dsc$w_length);
		DefExt[CmdDesc.dsc$w_length+1] = 0;
		}

	strcpy (Entity, "CF");
	EntDesc.dsc$w_length = strlen (Entity);
	Status = cli$present (&EntDesc);
	if (Status & STS$M_SUCCESS)
		{
		Status = cli$get_value (&EntDesc, &CmdDesc, &RetLen);
		if (!(Status & STS$M_SUCCESS))
			{
			printf ("\nError during 'cli$get_value'");
			DisplayError (NULL, 0, 0, Status);
			return (Status);
			}
		memcpy (CFname, CmdDesc.dsc$a_pointer, CmdDesc.dsc$w_length);
		CFname[CmdDesc.dsc$w_length] = 0;
		}
	else
		{
		printf ("\nConversion function must present");
		return (CLI$_ABSENT);
		}

	return (SS$_NORMAL);
	}



/**************************************************************************

				    

***************************************************************************/

int DisplayError (	void *tptr,
					int ConsoleFlag,
					int LogFileFlag,
					int CondValue	)
	{
	char Msg[256];
	$DESCRIPTOR (MsgDesc, Msg);
	int MsgLen;
	int SysCallStatus;

	MsgLen = 0;
	SysCallStatus = sys$getmsg (CondValue, &MsgLen, &MsgDesc, 0x000F, 0);
	Msg[MsgLen] = '\0';
	printf ("%s\n", Msg);
	return (1);
	}

