 /** .  * uri.c: set of generic URI related routines   *  * Reference: RFC 2396  *1  * See Copyright for the status of this software.   *  * Daniel.Veillard@w3.org   */    #ifdef WIN32 #define INCLUDE_WINSOCK  #include "win32config.h" #else  #include "config.h"  #endif   #include <stdio.h> #include <string.h>    #include <libxml/xmlmemory.h>  #include <libxml/uri.h>    /*   * alpha    = lowalpha | upalpha  */ 5 #define IS_ALPHA(x) (IS_LOWALPHA(x) || IS_UPALPHA(x))      /*I  * lowalpha = "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | I  *            "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | /  *            "u" | "v" | "w" | "x" | "y" | "z"   */   5 #define IS_LOWALPHA(x) (((x) >= 'a') && ((x) <= 'z'))    /*H  * upalpha = "A" | "B" | "C" | "D" | "E" | "F" | "G" | "H" | "I" | "J" |H  *           "K" | "L" | "M" | "N" | "O" | "P" | "Q" | "R" | "S" | "T" |.  *           "U" | "V" | "W" | "X" | "Y" | "Z"  */ 4 #define IS_UPALPHA(x) (((x) >= 'A') && ((x) <= 'Z'))   /*D  * digit = "0" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9"  */   2 #define IS_DIGIT(x) (((x) >= '0') && ((x) <= '9'))   /*  * alphanum = alpha | digit   */   3 #define IS_ALPHANUM(x) (IS_ALPHA(x) || IS_DIGIT(x))    /*4  * hex = digit | "A" | "B" | "C" | "D" | "E" | "F" |2  *               "a" | "b" | "c" | "d" | "e" | "f"  */   G #define IS_HEX(x) ((IS_DIGIT(x)) || (((x) >= 'a') && ((x) <= 'f')) || \ $ 	    (((x) >= 'A') && ((x) <= 'F')))   /*=  * mark = "-" | "_" | "." | "!" | "~" | "*" | "'" | "(" | ")"   */   E #define IS_MARK(x) (((x) == '-') || ((x) == '_') || ((x) == '.') ||	\ F     ((x) == '!') || ((x) == '~') || ((x) == '*') || ((x) == '\'') ||	\!     ((x) == '(') || ((x) == ')'))      /*G  * reserved = ";" | "/" | "?" | ":" | "@" | "&" | "=" | "+" | "$" | ","   */   I #define IS_RESERVED(x) (((x) == ';') || ((x) == '/') || ((x) == '?') ||	\ I         ((x) == ':') || ((x) == '@') || ((x) == '&') || ((x) == '=') ||	\ . 	((x) == '+') || ((x) == '$') || ((x) == ','))   /*  * unreserved = alphanum | mark   */   7 #define IS_UNRESERVED(x) (IS_ALPHANUM(x) || IS_MARK(x))    /*  * escaped = "%" hex hex  */   > #define IS_ESCAPED(p) ((*(p) == '%') && (IS_HEX((p)[1])) &&		\ 	    (IS_HEX((p)[2])))   /*A  * uric_no_slash = unreserved | escaped | ";" | "?" | ":" | "@" | 5  *                        "&" | "=" | "+" | "$" | ","   */ I #define IS_URIC_NO_SLASH(p) ((IS_UNRESERVED(*(p))) || (IS_ESCAPED(p)) ||\ B 	        ((*(p) == ';')) || ((*(p) == '?')) || ((*(p) == ':')) ||\B 	        ((*(p) == '@')) || ((*(p) == '&')) || ((*(p) == '=')) ||\? 	        ((*(p) == '+')) || ((*(p) == '$')) || ((*(p) == ',')))    /*I  * pchar = unreserved | escaped | ":" | "@" | "&" | "=" | "+" | "$" | ","   */ B #define IS_PCHAR(p) ((IS_UNRESERVED(*(p))) || (IS_ESCAPED(p)) ||	\B 	        ((*(p) == ':')) || ((*(p) == '@')) || ((*(p) == '&')) ||\B 	        ((*(p) == '=')) || ((*(p) == '+')) || ((*(p) == '$')) ||\ 	        ((*(p) == ',')))    /*-  * rel_segment   = 1*( unreserved | escaped | <  *                 ";" | "@" | "&" | "=" | "+" | "$" | "," )  */   D #define IS_SEGMENT(p) ((IS_UNRESERVED(*(p))) || (IS_ESCAPED(p)) ||	\D           ((*(p) == ';')) || ((*(p) == '@')) || ((*(p) == '&')) ||	\= 	  ((*(p) == '=')) || ((*(p) == '+')) || ((*(p) == '$')) ||	\  	  ((*(p) == ',')))    /*6  * scheme = alpha *( alpha | digit | "+" | "-" | "." )  */   ; #define IS_SCHEME(x) ((IS_ALPHA(x)) || (IS_DIGIT(x)) ||			\ < 	              ((x) == '+') || ((x) == '-') || ((x) == '.'))   /*4  * reg_name = 1*( unreserved | escaped | "$" | "," |5  *                ";" | ":" | "@" | "&" | "=" | "+" )   */   E #define IS_REG_NAME(p) ((IS_UNRESERVED(*(p))) || (IS_ESCAPED(p)) ||	\ B        ((*(p) == '$')) || ((*(p) == ',')) || ((*(p) == ';')) ||		\B        ((*(p) == ':')) || ((*(p) == '@')) || ((*(p) == '&')) ||		\*        ((*(p) == '=')) || ((*(p) == '+')))   /*?  * userinfo = *( unreserved | escaped | ";" | ":" | "&" | "=" | )  *                      "+" | "$" | "," )   */ E #define IS_USERINFO(p) ((IS_UNRESERVED(*(p))) || (IS_ESCAPED(p)) ||	\ B        ((*(p) == ';')) || ((*(p) == ':')) || ((*(p) == '&')) ||		\B        ((*(p) == '=')) || ((*(p) == '+')) || ((*(p) == '$')) ||		\        ((*(p) == ',')))    /*)  * uric = reserved | unreserved | escaped   */   B #define IS_URIC(p) ((IS_UNRESERVED(*(p))) || (IS_ESCAPED(p)) ||		\! 	            (IS_RESERVED(*(p))))    /*6  * Skip to next pointer char, handle escaped sequences  */   + #define NEXT(p) ((*p == '%')? p += 3 : p++)    /*  * Productions from the spec.   *'  *    authority     = server | reg_name <  *    reg_name      = 1*( unreserved | escaped | "$" | "," |=  *                        ";" | ":" | "@" | "&" | "=" | "+" )   *-  * path          = [ abs_path | opaque_part ]   */    /**   * xmlCreateURI:  *!  * Simply creates an empty xmlURI   *5  * Returns the new structure or NULL in case of error   */ 	 xmlURIPtr  xmlCreateURI(void) {     xmlURIPtr ret;  0     ret = (xmlURIPtr) xmlMalloc(sizeof(xmlURI));     if (ret == NULL) {2 	fprintf(stderr, "xmlCreateURI: out of memory\n"); 	return(NULL);     } #     memset(ret, 0, sizeof(xmlURI));      return(ret); }    /**   * xmlSaveUri:  * @uri:  pointer to an xmlURI  *$  * Save the URI as an escaped string  *5  * Returns a new string (to be deallocated by caller)   */ 	 xmlChar *  xmlSaveUri(xmlURIPtr uri) {      xmlChar *ret = NULL;     const char *p;     int len;     int max;  "     if (uri == NULL) return(NULL);    
     max = 80; =     ret = (xmlChar *) xmlMalloc((max + 1) * sizeof(xmlChar));      if (ret == NULL) {0 	fprintf(stderr, "xmlSaveUri: out of memory\n"); 	return(NULL);     }      len = 0;       if (uri->scheme != NULL) { 	p = uri->scheme;  	while (*p != 0) { 	    if (len >= max) { 		max *= 2; A 		ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		if (ret == NULL) {5 		    fprintf(stderr, "xmlSaveUri: out of memory\n");  		    return(NULL);  		}  	    } 	    ret[len++] = *p++;  	} 	if (len >= max) { 	    max *= 2;D 	    ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar)); 	    if (ret == NULL) { 1 		fprintf(stderr, "xmlSaveUri: out of memory\n");  		return(NULL);  	    } 	} 	ret[len++] = ':';     }      if (uri->opaque != NULL) { 	p = uri->opaque;  	while (*p != 0) { 	    if (len + 3 >= max) { 		max *= 2; A 		ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		if (ret == NULL) {5 		    fprintf(stderr, "xmlSaveUri: out of memory\n");  		    return(NULL);  		}  	    }! 	    if ((IS_UNRESERVED(*(p))) || A 	        ((*(p) == ';')) || ((*(p) == '?')) || ((*(p) == ':')) || A 	        ((*(p) == '@')) || ((*(p) == '&')) || ((*(p) == '=')) || ? 	        ((*(p) == '+')) || ((*(p) == '$')) || ((*(p) == ',')))  		ret[len++] = *p++; 	    else { " 		int val = *(unsigned char *)p++;' 		int hi = val / 0x10, lo = val % 0x10;  		ret[len++] = '%'; + 		ret[len++] = hi + (hi > 9? 'A'-10 : '0'); + 		ret[len++] = lo + (lo > 9? 'A'-10 : '0');  	    } 	} 	if (len >= max) { 	    max *= 2;D 	    ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar)); 	    if (ret == NULL) { 1 		fprintf(stderr, "xmlSaveUri: out of memory\n");  		return(NULL);  	    } 	} 	ret[len++] = 0;     } else { 	if (uri->server != NULL) {  	    if (len + 3 >= max) { 		max *= 2; A 		ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		if (ret == NULL) {5 		    fprintf(stderr, "xmlSaveUri: out of memory\n");  		    return(NULL);  		}  	    } 	    ret[len++] = '/'; 	    ret[len++] = '/'; 	    if (uri->user != NULL) {  		p = uri->user; 		while (*p != 0) {  		    if (len + 3 >= max) {  			max *= 2;B 			ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar)); 			if (ret == NULL) { 6 			    fprintf(stderr, "xmlSaveUri: out of memory\n"); 			    return(NULL); 			} 		    } " 		    if ((IS_UNRESERVED(*(p))) ||; 			((*(p) == ';')) || ((*(p) == ':')) || ((*(p) == '&')) || ; 			((*(p) == '=')) || ((*(p) == '+')) || ((*(p) == '$')) ||  			((*(p) == ',')))  			ret[len++] = *p++;  		    else {# 			int val = *(unsigned char *)p++; ( 			int hi = val / 0x10, lo = val % 0x10; 			ret[len++] = '%';, 			ret[len++] = hi + (hi > 9? 'A'-10 : '0');, 			ret[len++] = lo + (lo > 9? 'A'-10 : '0'); 		    }  		}  		if (len + 3 >= max) {  		    max *= 2; E 		    ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		    if (ret == NULL) {2 			fprintf(stderr, "xmlSaveUri: out of memory\n"); 			return(NULL); 		    }  		}  		ret[len++] = '@';  	    } 	    p = uri->server;  	    while (*p != 0) { 		if (len >= max) {  		    max *= 2; E 		    ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		    if (ret == NULL) {2 			fprintf(stderr, "xmlSaveUri: out of memory\n"); 			return(NULL); 		    }  		}  		ret[len++] = *p++; 	    } 	    if (uri->port > 0) {  		if (len + 10 >= max) { 		    max *= 2; E 		    ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		    if (ret == NULL) {2 			fprintf(stderr, "xmlSaveUri: out of memory\n"); 			return(NULL); 		    }  		} 7 		len += sprintf((char *) &ret[len], ":%d", uri->port);  	    }% 	} else if (uri->authority != NULL) {  	    if (len + 3 >= max) { 		max *= 2; A 		ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		if (ret == NULL) {5 		    fprintf(stderr, "xmlSaveUri: out of memory\n");  		    return(NULL);  		}  	    } 	    ret[len++] = '/'; 	    ret[len++] = '/'; 	    p = uri->authority; 	    while (*p != 0) { 		if (len + 3 >= max) {  		    max *= 2; E 		    ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		    if (ret == NULL) {2 			fprintf(stderr, "xmlSaveUri: out of memory\n"); 			return(NULL); 		    }  		}  		if ((IS_UNRESERVED(*(p))) ||L                     ((*(p) == '$')) || ((*(p) == ',')) || ((*(p) == ';')) ||L                     ((*(p) == ':')) || ((*(p) == '@')) || ((*(p) == '&')) ||7                     ((*(p) == '=')) || ((*(p) == '+')))  		    ret[len++] = *p++; 		else {& 		    int val = *(unsigned char *)p++;+ 		    int hi = val / 0x10, lo = val % 0x10;  		    ret[len++] = '%'; / 		    ret[len++] = hi + (hi > 9? 'A'-10 : '0'); / 		    ret[len++] = lo + (lo > 9? 'A'-10 : '0');  		}  	    } 	} 	if (uri->path != NULL) {  	    p = uri->path;  	    while (*p != 0) { 		if (len + 3 >= max) {  		    max *= 2; E 		    ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		    if (ret == NULL) {2 			fprintf(stderr, "xmlSaveUri: out of memory\n"); 			return(NULL); 		    }  		} 1 		if ((IS_UNRESERVED(*(p))) || ((*(p) == '/')) || L                     ((*(p) == ';')) || ((*(p) == '@')) || ((*(p) == '&')) ||E 	            ((*(p) == '=')) || ((*(p) == '+')) || ((*(p) == '$')) ||  	            ((*(p) == ',')))  		    ret[len++] = *p++; 		else {& 		    int val = *(unsigned char *)p++;+ 		    int hi = val / 0x10, lo = val % 0x10;  		    ret[len++] = '%'; / 		    ret[len++] = hi + (hi > 9? 'A'-10 : '0'); / 		    ret[len++] = lo + (lo > 9? 'A'-10 : '0');  		}  	    } 	} 	if (uri->query != NULL) { 	    if (len + 3 >= max) { 		max *= 2; A 		ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		if (ret == NULL) {5 		    fprintf(stderr, "xmlSaveUri: out of memory\n");  		    return(NULL);  		}  	    } 	    ret[len++] = '?'; 	    p = uri->query; 	    while (*p != 0) { 		if (len + 3 >= max) {  		    max *= 2; E 		    ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		    if (ret == NULL) {2 			fprintf(stderr, "xmlSaveUri: out of memory\n"); 			return(NULL); 		    }  		} 4 		if ((IS_UNRESERVED(*(p))) || (IS_RESERVED(*(p))))  		    ret[len++] = *p++; 		else {& 		    int val = *(unsigned char *)p++;+ 		    int hi = val / 0x10, lo = val % 0x10;  		    ret[len++] = '%'; / 		    ret[len++] = hi + (hi > 9? 'A'-10 : '0'); / 		    ret[len++] = lo + (lo > 9? 'A'-10 : '0');  		}  	    } 	} 	if (uri->fragment != NULL) {  	    if (len + 3 >= max) { 		max *= 2; A 		ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		if (ret == NULL) {5 		    fprintf(stderr, "xmlSaveUri: out of memory\n");  		    return(NULL);  		}  	    } 	    ret[len++] = '#'; 	    p = uri->fragment;  	    while (*p != 0) { 		if (len + 3 >= max) {  		    max *= 2; E 		    ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar));  		    if (ret == NULL) {2 			fprintf(stderr, "xmlSaveUri: out of memory\n"); 			return(NULL); 		    }  		} 4 		if ((IS_UNRESERVED(*(p))) || (IS_RESERVED(*(p))))  		    ret[len++] = *p++; 		else {& 		    int val = *(unsigned char *)p++;+ 		    int hi = val / 0x10, lo = val % 0x10;  		    ret[len++] = '%'; / 		    ret[len++] = hi + (hi > 9? 'A'-10 : '0'); / 		    ret[len++] = lo + (lo > 9? 'A'-10 : '0');  		}  	    } 	} 	if (len >= max) { 	    max *= 2;D 	    ret = (xmlChar *) xmlRealloc(ret, (max + 1) * sizeof(xmlChar)); 	    if (ret == NULL) { 1 		fprintf(stderr, "xmlSaveUri: out of memory\n");  		return(NULL);  	    } 	} 	ret[len++] = 0;     }      return(ret); }    /**   * xmlPrintURI: #  * @stream:  a FILE* for the output   * @uri:  pointer to an xmlURI  *'  * Prints the URI in the stream @steam.   */  void* xmlPrintURI(FILE *stream, xmlURIPtr uri) {     xmlChar *out;        out = xmlSaveUri(uri);     if (out != NULL) { 	fprintf(stream, "%s", out); 	xmlFree(out);     }  }    /**   * xmlCleanURI:   * @uri:  pointer to an xmlURI  *1  * Make sure the xmlURI struct is free of content   */  void xmlCleanURI(xmlURIPtr uri) {     if (uri == NULL) return;  2     if (uri->scheme != NULL) xmlFree(uri->scheme);     uri->scheme = NULL; 2     if (uri->server != NULL) xmlFree(uri->server);     uri->server = NULL; .     if (uri->user != NULL) xmlFree(uri->user);     uri->user = NULL; .     if (uri->path != NULL) xmlFree(uri->path);     uri->path = NULL; 6     if (uri->fragment != NULL) xmlFree(uri->fragment);     uri->fragment = NULL; 2     if (uri->opaque != NULL) xmlFree(uri->opaque);     uri->opaque = NULL; 8     if (uri->authority != NULL) xmlFree(uri->authority);     uri->authority = NULL;0     if (uri->query != NULL) xmlFree(uri->query);     uri->query = NULL; }    /**   * xmlFreeURI:  * @uri:  pointer to an xmlURI  *  * Free up the xmlURI struct  */  void xmlFreeURI(xmlURIPtr uri) {      if (uri == NULL) return;  2     if (uri->scheme != NULL) xmlFree(uri->scheme);2     if (uri->server != NULL) xmlFree(uri->server);.     if (uri->user != NULL) xmlFree(uri->user);.     if (uri->path != NULL) xmlFree(uri->path);6     if (uri->fragment != NULL) xmlFree(uri->fragment);2     if (uri->opaque != NULL) xmlFree(uri->opaque);8     if (uri->authority != NULL) xmlFree(uri->authority);0     if (uri->query != NULL) xmlFree(uri->query);$     memset(uri, -1, sizeof(xmlURI));     xmlFree(uri);  }    /**   * xmlURIUnescapeString:   * @str:  the string to unescapeL  * @len:   the lenght in bytes to unescape (or <= 0 to indicate full string))  * @target:  optionnal destination buffer   *4  * Unescaping routine, does not do validity checks !I  * Output is direct unsigned char translation of %XX values (no encoding)   */  * Returns an copy of the string, but unescaped   */  char *> xmlURIUnescapeString(const char *str, int len, char *target) {     char *ret, *out;     const char *in;        if (str == NULL) 	return(NULL);$     if (len <= 0) len = strlen(str);     if (len <= 0) return(NULL);        if (target == NULL) { # 	ret = (char *) xmlMalloc(len + 1);  	if (ret == NULL) { > 	    fprintf(stderr, "xmlURIUnescapeString: out of memory\n"); 	    return(NULL); 	}
     } else 	ret = target;
     in = str;      out = ret;     while(len > 0) { 	if (*in == '%') {
 	    in++;' 	    if ((*in >= '0') && (*in <= '9'))   	        *out = (*in - '0');+ 	    else if ((*in >= 'a') && (*in <= 'f')) ! 	        *out = (*in - 'a') + 10; + 	    else if ((*in >= 'A') && (*in <= 'F')) ! 	        *out = (*in - 'A') + 10; 
 	    in++;' 	    if ((*in >= '0') && (*in <= '9'))  ( 	        *out = *out * 16 + (*in - '0');+ 	    else if ((*in >= 'a') && (*in <= 'f')) - 	        *out = *out * 16 + (*in - 'a') + 10; + 	    else if ((*in >= 'A') && (*in <= 'F')) - 	        *out = *out * 16 + (*in - 'A') + 10; 
 	    in++; 	    len -= 3; 	    out++; 	 	} else {  	    *out++ = *in++; 	    len--;  	}     } 
     *out = 0;      return(ret); }      /**   * xmlParseURIFragment: %  * @uri:  pointer to an URI structure *  * @str:  pointer to the string to analyze  *C  * Parse an URI fragment string and fills in the appropriate fields   * of the @uri structure.   *    * fragment = *uric   *  * Returns 0 or the error code  */  int 6 xmlParseURIFragment(xmlURIPtr uri, const char **str) {     const char *cur = *str;         if (str == NULL) return(-1);  #     while (IS_URIC(cur)) NEXT(cur);      if (uri != NULL) {3 	if (uri->fragment != NULL) xmlFree(uri->fragment); > 	uri->fragment = xmlURIUnescapeString(*str, cur - *str, NULL);     }      *str = cur;      return(0); }    /**   * xmlParseURIQuery:%  * @uri:  pointer to an URI structure *  * @str:  pointer to the string to analyze  *!  * Parse the query part of an URI   *    * query = *uric  *  * Returns 0 or the error code  */  int 3 xmlParseURIQuery(xmlURIPtr uri, const char **str) {      const char *cur = *str;         if (str == NULL) return(-1);  #     while (IS_URIC(cur)) NEXT(cur);      if (uri != NULL) {- 	if (uri->query != NULL) xmlFree(uri->query); ; 	uri->query = xmlURIUnescapeString(*str, cur - *str, NULL);      }      *str = cur;      return(0); }    /**   * xmlParseURIScheme: %  * @uri:  pointer to an URI structure *  * @str:  pointer to the string to analyze  *  * Parse an URI scheme  *  6  * scheme = alpha *( alpha | digit | "+" | "-" | "." )  *  * Returns 0 or the error code  */  int 4 xmlParseURIScheme(xmlURIPtr uri, const char **str) {     const char *cur;       if (str == NULL) 	return(-1);          cur = *str;      if (!IS_ALPHA(*cur)) 	return(2); 
     cur++;"     while (IS_SCHEME(*cur)) cur++;     if (uri != NULL) {/ 	if (uri->scheme != NULL) xmlFree(uri->scheme); N 	uri->scheme = xmlURIUnescapeString(*str, cur - *str, NULL); /* !!! strndup */     }      *str = cur;      return(0); }    /**   * xmlParseURIOpaquePart: %  * @uri:  pointer to an URI structure *  * @str:  pointer to the string to analyze  *  * Parse an URI opaque part   *  $  * opaque_part = uric_no_slash *uric  *  * Returns 0 or the error code  */  int 8 xmlParseURIOpaquePart(xmlURIPtr uri, const char **str) {     const char *cur;       if (str == NULL) 	return(-1);          cur = *str; !     if (!IS_URIC_NO_SLASH(cur)) {  	return(3);      }      NEXT(cur);#     while (IS_URIC(cur)) NEXT(cur);      if (uri != NULL) {/ 	if (uri->opaque != NULL) xmlFree(uri->opaque); < 	uri->opaque = xmlURIUnescapeString(*str, cur - *str, NULL);     }      *str = cur;      return(0); }    /**   * xmlParseURIServer: %  * @uri:  pointer to an URI structure *  * @str:  pointer to the string to analyze  *@  * Parse a server subpart of an URI, it's a finer grain analysis  * of the authority part.   *  0  * server        = [ [ userinfo "@" ] hostport ],  * userinfo      = *( unreserved | escaped |B  *                       ";" | ":" | "&" | "=" | "+" | "$" | "," )$  * hostport      = host [ ":" port ])  * host          = hostname | IPv4address 8  * hostname      = *( domainlabel "." ) toplabel [ "." ]C  * domainlabel   = alphanum | alphanum *( alphanum | "-" ) alphanum =  * toplabel      = alpha | alpha *( alphanum | "-" ) alphanum >  * IPv4address   = 1*digit "." 1*digit "." 1*digit "." 1*digit  * port          = *digit   *  * Returns 0 or the error code  */  int 4 xmlParseURIServer(xmlURIPtr uri, const char **str) {     const char *cur;     const char *host, *tmp;        if (str == NULL) 	return(-1);          cur = *str;        /*      * is there an userinfo ?       */ '     while (IS_USERINFO(cur)) NEXT(cur);      if (*cur == '@') { 	if (uri != NULL) { / 	    if (uri->user != NULL) xmlFree(uri->user); > 	    uri->user = xmlURIUnescapeString(*str, cur - *str, NULL); 	} 	cur++;      } else { 	if (uri != NULL) { / 	    if (uri->user != NULL) xmlFree(uri->user);  	    uri->user = NULL; 	}         cur = *str;      }      /*>      * host part of hostport can derive either an IPV4 addressE      * or an unresolved name. Check the IP first, it easier to detect       * errors if wrong one      */      host = cur;      if (IS_DIGIT(*cur)) { $         while(IS_DIGIT(*cur)) cur++; 	if (*cur != '.')  	    goto host_name; 	cur++;  	if (!IS_DIGIT(*cur))  	    goto host_name;$         while(IS_DIGIT(*cur)) cur++; 	if (*cur != '.')  	    goto host_name; 	cur++;  	if (!IS_DIGIT(*cur))  	    goto host_name;$         while(IS_DIGIT(*cur)) cur++; 	if (*cur != '.')  	    goto host_name; 	cur++;  	if (!IS_DIGIT(*cur))  	    goto host_name;$         while(IS_DIGIT(*cur)) cur++; 	if (uri != NULL) { 9 	    if (uri->authority != NULL) xmlFree(uri->authority);  	    uri->authority = NULL; 3 	    if (uri->server != NULL) xmlFree(uri->server); @ 	    uri->server = xmlURIUnescapeString(host, cur - host, NULL); 	} 	goto host_done;     } 
 host_name:     /*;      * the hostname production as-is is a parser nightmare.       * simplify it to :      * hostname = *( domainlabel "." ) domainlabel [ "." ]H      * and just make sure the last label starts with a non numeric char.      */      if (!IS_ALPHANUM(*cur))          return(6);     while (IS_ALPHANUM(*cur)) { ;         while ((IS_ALPHANUM(*cur)) || (*cur == '-')) cur++;  	if (*cur == '.')  	    cur++;      }      tmp = cur;
     tmp--;F     while (IS_ALPHANUM(*tmp) && (*tmp != '.') && (tmp >= host)) tmp--;
     tmp++;     if (!IS_ALPHA(*tmp))         return(7);     if (uri != NULL) {5 	if (uri->authority != NULL) xmlFree(uri->authority);  	uri->authority = NULL; / 	if (uri->server != NULL) xmlFree(uri->server); < 	uri->server = xmlURIUnescapeString(host, cur - host, NULL);     }   
 host_done:       /*.      * finish by checking for a port presence.      */      if (*cur == ':') {         cur++; 	if (IS_DIGIT(*cur)) { 	    if (uri != NULL)  	        uri->port = 0;  	    while (IS_DIGIT(*cur)) {  	        if (uri != NULL) 0 		    uri->port = uri->port * 10 + (*cur - '0'); 		cur++; 	    } 	}     }      *str = cur;      return(0); }	   /**   * xmlParseURIRelSegment: %  * @uri:  pointer to an URI structure *  * @str:  pointer to the string to analyze  *   * Parse an URI relative segment  *  C  * rel_segment = 1*( unreserved | escaped | ";" | "@" | "&" | "=" | -  *                          "+" | "$" | "," )   *  * Returns 0 or the error code  */  int 8 xmlParseURIRelSegment(xmlURIPtr uri, const char **str) {     const char *cur;       if (str == NULL) 	return(-1);          cur = *str;      if (!IS_SEGMENT(cur)) {  	return(3);      }      NEXT(cur);&     while (IS_SEGMENT(cur)) NEXT(cur);     if (uri != NULL) {+ 	if (uri->path != NULL) xmlFree(uri->path); : 	uri->path = xmlURIUnescapeString(*str, cur - *str, NULL);     }      *str = cur;      return(0); }    /**   * xmlParseURIPathSegments: %  * @uri:  pointer to an URI structure *  * @str:  pointer to the string to analyze)  * @slash:  should we add a leading slash   *$  * Parse an URI set of path segments  *  +  * path_segments = segment *( "/" segment ) (  * segment       = *pchar *( ";" param )  * param         = *pchar   *  * Returns 0 or the error code  */  int E xmlParseURIPathSegments(xmlURIPtr uri, const char **str, int slash) {      const char *cur;       if (str == NULL) 	return(-1);          cur = *str;        do {! 	while (IS_PCHAR(cur)) NEXT(cur);  	if (*cur == ';') {  	    cur++; % 	    while (IS_PCHAR(cur)) NEXT(cur);  	} 	if (*cur != '/') break; 	cur++;      } while (1);     if (uri != NULL) { 	int len, len2 = 0;  	char *path;   	/* 7 	 * Concat the set of path segments to the current path  	 */ 	len = cur - *str; 	if (slash)  	    len++;    	if (uri->path != NULL) {  	    len2 = strlen(uri->path); 	    len += len2;  	}+         path = (char *) xmlMalloc(len + 1);  	if (path == NULL) {A 	    fprintf(stderr, "xmlParseURIPathSegments: out of memory\n");  	    *str = cur; 	    return(-1); 	} 	if (uri->path != NULL) # 	    memcpy(path, uri->path, len2); 
 	if (slash) {  	    path[len2] = '/'; 	    len2++; 	} 	path[len2] = 0; 	if (cur - *str > 0)9 	    xmlURIUnescapeString(*str, cur - *str, &path[len2]);  	if (uri->path != NULL)  	    xmlFree(uri->path); 	uri->path = path;     }      *str = cur;      return(0); }    /**   * xmlParseURIAuthority:%  * @uri:  pointer to an URI structure *  * @str:  pointer to the string to analyze  *&  * Parse the authority part of an URI.  *     * authority = server | reg_name,  * server    = [ [ userinfo "@" ] hostport ]A  * reg_name  = 1*( unreserved | escaped | "$" | "," | ";" | ":" | 1  *                        "@" | "&" | "=" | "+" )   *C  * Note : this is completely ambiguous since reg_name is allowed to 5  *        use the full set of chars in use by server:   *0  *        3.2.1. Registry-based Naming Authority  *H  *        The structure of a registry-based naming authority is specificF  *        to the URI scheme, but constrained to the allowed characters%  *        for an authority component.   *  * Returns 0 or the error code  */  int 7 xmlParseURIAuthority(xmlURIPtr uri, const char **str) {      const char *cur;     int ret;       if (str == NULL) 	return(-1);          cur = *str;        /*0      * try first to parse it as a server string.      */ &     ret = xmlParseURIServer(uri, str);     if (ret == 0)          return(0);       /*#      * failed, fallback to reg_name       */      if (!IS_REG_NAME(cur)) { 	return(5);      }      NEXT(cur);'     while (IS_REG_NAME(cur)) NEXT(cur);      if (uri != NULL) {/ 	if (uri->server != NULL) xmlFree(uri->server);  	uri->server = NULL;+ 	if (uri->user != NULL) xmlFree(uri->user);  	uri->user = NULL;5 	if (uri->authority != NULL) xmlFree(uri->authority); ? 	uri->authority = xmlURIUnescapeString(*str, cur - *str, NULL);      }      *str = cur;      return(0); }    /**   * xmlParseURIHierPart: %  * @uri:  pointer to an URI structure *  * @str:  pointer to the string to analyze  *   * Parse an URI hirarchical part  *  4  * hier_part = ( net_path | abs_path ) [ "?" query ]   * abs_path = "/"  path_segments)  * net_path = "//" authority [ abs_path ]   *  * Returns 0 or the error code  */  int 6 xmlParseURIHierPart(xmlURIPtr uri, const char **str) {     int ret;     const char *cur;       if (str == NULL) 	return(-1);          cur = *str;   -     if ((cur[0] == '/') && (cur[1] == '/')) { 
 	cur += 2;' 	ret = xmlParseURIAuthority(uri, &cur);  	if (ret != 0) 	    return(ret);  	if (cur[0] == '/') {  	    cur++; 1 	    ret = xmlParseURIPathSegments(uri, &cur, 1);  	}     } else if (cur[0] == '/') {  	cur++; - 	ret = xmlParseURIPathSegments(uri, &cur, 1);      } else { 	return(4);      }      if (ret != 0) 
 	return(ret);      if (*cur == '?') { 	cur++; # 	ret = xmlParseURIQuery(uri, &cur);  	if (ret != 0) 	    return(ret);      }      *str = cur;      return(0); }    /**   * xmlParseAbsoluteURI: %  * @uri:  pointer to an URI structure *  * @str:  pointer to the string to analyze  *D  * Parse an URI reference string and fills in the appropriate fields  * of the @uri structure  *  9  * absoluteURI   = scheme ":" ( hier_part | opaque_part )   *  * Returns 0 or the error code  */  int 6 xmlParseAbsoluteURI(xmlURIPtr uri, const char **str) {     int ret;       if (str == NULL) 	return(-1);     &     ret = xmlParseURIScheme(uri, str);     if (ret != 0) return(ret);     if (**str != ':')  	return(1); 
     (*str)++;      if (**str == '/') ' 	return(xmlParseURIHierPart(uri, str)); ,     return(xmlParseURIOpaquePart(uri, str)); }    /**   * xmlParseRelativeURI: %  * @uri:  pointer to an URI structure *  * @str:  pointer to the string to analyze  *C  * Parse an relative URI string and fills in the appropriate fields   * of the @uri structure  *  A  * relativeURI = ( net_path | abs_path | rel_path ) [ "?" query ]    * abs_path = "/"  path_segments)  * net_path = "//" authority [ abs_path ] &  * rel_path = rel_segment [ abs_path ]  *  * Returns 0 or the error code  */  int 6 xmlParseRelativeURI(xmlURIPtr uri, const char **str) {     int ret = 0;     const char *cur;       if (str == NULL) 	return(-1);          cur = *str; -     if ((cur[0] == '/') && (cur[1] == '/')) { 
 	cur += 2;' 	ret = xmlParseURIAuthority(uri, &cur);  	if (ret != 0) 	    return(ret);  	if (cur[0] == '/') {  	    cur++; 1 	    ret = xmlParseURIPathSegments(uri, &cur, 1);  	}     } else if (cur[0] == '/') {  	cur++; - 	ret = xmlParseURIPathSegments(uri, &cur, 1); 0     } else if (cur[0] != '#' && cur[0] != '?') {( 	ret = xmlParseURIRelSegment(uri, &cur); 	if (ret != 0) 	    return(ret);  	if (cur[0] == '/') {  	    cur++; 1 	    ret = xmlParseURIPathSegments(uri, &cur, 1);  	}     }      if (ret != 0) 
 	return(ret);      if (*cur == '?') { 	cur++; # 	ret = xmlParseURIQuery(uri, &cur);  	if (ret != 0) 	    return(ret);      }      *str = cur;      return(ret); }    /**   * xmlParseURIReference:%  * @uri:  pointer to an URI structure   * @str:  the string to analyze   *D  * Parse an URI reference string and fills in the appropriate fields  * of the @uri structure  *  A  * URI-reference = [ absoluteURI | relativeURI ] [ "#" fragment ]   *  * Returns 0 or the error code  */  int 6 xmlParseURIReference(xmlURIPtr uri, const char *str) {     int ret;     const char *tmp = str;       if (str == NULL) 	return(-1);     xmlCleanURI(uri);        /*E      * Try first to parse aboslute refs, then fallback to relative if       * it fails.      */ )     ret = xmlParseAbsoluteURI(uri, &str);      if (ret != 0) {  	xmlCleanURI(uri); 	str = tmp; -         ret = xmlParseRelativeURI(uri, &str);      }      if (ret != 0) {  	xmlCleanURI(uri);
 	return(ret);      }        if (*str == '#') { 	str++; & 	ret = xmlParseURIFragment(uri, &str); 	if (ret != 0) return(ret);      }      if (*str != 0) { 	xmlCleanURI(uri); 	return(1);      }      return(0); }    /**   * xmlParseURI: #  * @str:  the URI string to analyze   *  * Parse an URI   *  A  * URI-reference = [ absoluteURI | relativeURI ] [ "#" fragment ]   *;  * Returns a newly build xmlURIPtr or NULL in case of error   */ 	 xmlURIPtr  xmlParseURI(const char *str) {     xmlURIPtr uri;     int ret;       if (str == NULL) 	return(NULL);     uri = xmlCreateURI();      if (uri != NULL) {& 	ret = xmlParseURIReference(uri, str);         if (ret) { 	    xmlFreeURI(uri);  	    return(NULL); 	}     }      return(uri); }    /**   * xmlNormalizeURIPath: %  * @path:  pointer to the path string   *5  * applies the 5 normalization steps to a path string I  * Normalization occurs directly on the string, no new allocation is done   *  * Returns 0 or an error code   */  int ! xmlNormalizeURIPath(char *path) {      int cur, out;        if (path == NULL)  	return(-1);     cur = 0;     out = 0;9     while ((path[cur] != 0) && (path[cur] != '/')) cur++;      if (path[cur] == 0)  	return(0);   B     /* we are positionned at the beginning of the first segment */
     cur++;     out = cur;       /*(      * Analyze each segment in sequence.      */      while (path[cur] != 0) { 	/* E 	 * c) All occurrences of "./", where "." is a complete path segment, * 	 *    are removed from the buffer string. 	 */4 	if ((path[cur] == '.') && (path[cur + 1] == '/')) { 	    cur += 2; 	    continue; 	}   	/* E 	 * d) If the buffer string ends with "." as a complete path segment,  	 *    that "." is removed.  	 */2 	if ((path[cur] == '.') && (path[cur + 1] == 0)) { 	    path[out] = 0;  	    break;  	}   	/* read the segment */ 1 	while ((path[cur] != 0) && (path[cur] != '/')) {  	    path[out++] = path[cur++];  	} 	path[out++] = path[cur];  	if (path[cur] != 0) { 	    cur++;  	}     }        cur = 0;     out = 0;9     while ((path[cur] != 0) && (path[cur] != '/')) cur++;      if (path[cur] == 0)  	return(0); B     /* we are positionned at the beginning of the first segment */
     cur++;     out = cur;     /*(      * Analyze each segment in sequence.      */      while (path[cur] != 0) { 	/* ? 	 * e) All occurrences of "<segment>/../", where <segment> is a D 	 *    complete path segment not equal to "..", are removed from theB 	 *    buffer string.  Removal of these path segments is performedB 	 *    iteratively, removing the leftmost matching pattern on each4 	 *    iteration, until no matching pattern remains. 	 */ 	if ((cur > 1) && (out > 1) &&4 	    (path[cur] == '/') && (path[cur + 1] == '.') &&8 	    (path[cur + 2] == '.') && (path[cur + 3] == '/') &&5 	    ((path[out] != '.') || (path[out - 1] != '.') ||   	     (path[out - 2] != '/'))) { 	    cur += 3; 	    out --;8 	    while ((out > 0) && (path[out] != '/')) { out --; } 	    path[out] = 0;              continue;  	}   	/* E 	 * f) If the buffer string ends with "<segment>/..", where <segment> 9 	 *    is a complete path segment not equal to "..", that ! 	 *    "<segment>/.." is removed.  	 */4 	if ((path[cur] == '/') && (path[cur + 1] == '.') &&6 	    (path[cur + 2] == '.') && (path[cur + 3] == 0) &&5 	    ((path[out] != '.') || (path[out - 1] != '.') ||   	     (path[out - 2] != '/'))) { 	    cur += 4; 	    out --;< 	    while ((out > 0) && (path[out - 1] != '/')) { out --; } 	    path[out] = 0;              continue;  	}         ( 	path[out++] = path[cur++]; /* / or 0 */     }      path[out] = 0;       /*F      * g) If the resulting buffer string still begins with one or more@      *    complete path segments of "..", then the reference is D      *    considered to be in error. Implementations may handle thisI      *    error by retaining these components in the resolved path (i.e., H      *    treating them as part of the final URI), by removing them fromG      *    the resolved path (i.e., discarding relative levels above the ;      *    root), or by avoiding traversal of the reference.       *+      * We discard them from the final path.       */      cur = 0;:     while ((path[cur] == '/') && (path[cur + 1] == '.') && 	   (path[cur + 2] == '.')) 
 	cur += 3;     if (cur != 0) { 	 	out = 0; 2 	while (path[cur] != 0) path[out++] = path[cur++]; 	path[out] = 0;      }      return(0); }    /**   * xmlBuildURI: 0  * @URI:  the URI instance found in the document  * @base:  the base value   *?  * Computes he final URI of the reference done by checking that ?  * the given URI is valid, and building the final URI using the ?  * base URI. This is processed according to section 5.2 of the    * RFC 2396   *6  * 5.2. Resolving Relative References to Absolute Form  *G  * Returns a new URI string (to be freed by the caller) or NULL in case   *         of error.  */ 	 xmlChar * 6 xmlBuildURI(const xmlChar *URI, const xmlChar *base) {     xmlChar *val = NULL;(     int ret, ret2, len, index, cur, out;     xmlURIPtr ref = NULL;      xmlURIPtr bas = NULL;      xmlURIPtr res = NULL;        /*L      * 1) The URI reference is parsed into the potential four components and;      *    fragment identifier, as described in Section 4.3.       *H      *    NOTE that a completely empty URI is treated by modern browsersH      *    as a reference to "." rather than as a synonym for the current'      *    URI.  Should we do that here?       */      if (URI == NULL)  
 	ret = -1;
     else { 	ref = xmlCreateURI(); 	if (ref == NULL)  	    goto done; 
 	if (*URI)9 	    ret = xmlParseURIReference(ref, (const char *) URI);  	else  	    ret = -1;     }      if (base == NULL)  	ret2 = -1; 
     else { 	bas = xmlCreateURI(); 	if (bas == NULL)  	    goto done; 7 	ret2 = xmlParseURIReference(bas, (const char *) base);      } "     if ((ret != 0) && (ret2 != 0)) 	goto done;      if (ret != 0) {  	/* % 	 * the base fragment must be ignored  	 */ 	if (bas->fragment != NULL) {  	    xmlFree(bas->fragment); 	    bas->fragment = NULL; 	} 	val = xmlSaveUri(bas);  	goto done;      }      if (ret2 != 0) { 	val = xmlSaveUri(ref);  	goto done;      }          /*G      * 2) If the path component is empty and the scheme, authority, and G      *    query components are undefined, then it is a reference to the K      *    current document and we are done.  Otherwise, the reference URI's K      *    query and fragment components are defined as found (or not found) G      *    within the URI reference and not inherited from the base URI.       *J      *    NOTE that in modern browsers, the parsing differs from the aboveH      *    in the following aspect:  the query component is allowed to beI      *    defined while still treating this as a reference to the current       *    document.       */      res = xmlCreateURI();      if (res == NULL) 	goto done; 7     if ((ref->scheme == NULL) && (ref->path == NULL) && 7 	((ref->authority == NULL) && (ref->server == NULL))) {  	if (bas->scheme != NULL) - 	    res->scheme = xmlMemStrdup(bas->scheme);  	if (bas->authority != NULL)3 	    res->authority = xmlMemStrdup(bas->authority);   	else if (bas->server != NULL) {- 	    res->server = xmlMemStrdup(bas->server);  	    if (bas->user != NULL) & 		res->user = xmlMemStrdup(bas->user); 	    res->port = bas->port;		  	} 	if (bas->path != NULL) ) 	    res->path = xmlMemStrdup(bas->path);  	if (ref->query != NULL)+ 	    res->query = xmlMemStrdup(ref->query);  	else if (bas->query != NULL) + 	    res->query = xmlMemStrdup(bas->query);  	if (ref->fragment != NULL) 1 	    res->fragment = xmlMemStrdup(ref->fragment); 
 	goto step_7;      }         if (ref->query != NULL) ' 	res->query = xmlMemStrdup(ref->query);      if (ref->fragment != NULL)- 	res->fragment = xmlMemStrdup(ref->fragment);        /*K      * 3) If the scheme component is defined, indicating that the reference L      *    starts with a scheme name, then the reference is interpreted as anG      *    absolute URI and we are done.  Otherwise, the reference URI's C      *    scheme is inherited from the base URI's scheme component.       */      if (ref->scheme != NULL) { 	val = xmlSaveUri(ref);  	goto done;      }      if (bas->scheme != NULL)) 	res->scheme = xmlMemStrdup(bas->scheme);        /*H      * 4) If the authority component is defined, then the reference is aG      *    network-path and we skip to step 7.  Otherwise, the reference D      *    URI's authority is inherited from the base URI's authorityL      *    component, which will also be undefined if the URI scheme does not%      *    use an authority component.       */ <     if ((ref->authority != NULL) || (ref->server != NULL)) { 	if (ref->authority != NULL)3 	    res->authority = xmlMemStrdup(ref->authority);  	else { - 	    res->server = xmlMemStrdup(ref->server);  	    if (ref->user != NULL) & 		res->user = xmlMemStrdup(ref->user);$             res->port = ref->port;		 	} 	if (ref->path != NULL) ) 	    res->path = xmlMemStrdup(ref->path); 
 	goto step_7;      }      if (bas->authority != NULL) / 	res->authority = xmlMemStrdup(bas->authority); #     else if (bas->server != NULL) { ) 	res->server = xmlMemStrdup(bas->server);  	if (bas->user != NULL) ) 	    res->user = xmlMemStrdup(bas->user);  	res->port = bas->port;		      }        /*I      * 5) If the path component begins with a slash character ("/"), then B      *    the reference is an absolute-path and we skip to step 7.      */ 7     if ((ref->path != NULL) && (ref->path[0] == '/')) { % 	res->path = xmlMemStrdup(ref->path); 
 	goto step_7;      }          /*H      * 6) If this step is reached, then we are resolving a relative-pathH      *    reference.  The relative path needs to be merged with the baseG      *    URI's path.  Although there are many ways to do this, we will B      *    describe a simple method using a separate string buffer.      *<      * Allocate a buffer large enough for the result string.      */       len = 2; /* extra / and 0 */     if (ref->path != NULL) 	len += strlen(ref->path);     if (bas->path != NULL) 	len += strlen(bas->path);(     res->path = (char *) xmlMalloc(len);     if (res->path == NULL) {1 	fprintf(stderr, "xmlBuildURI: out of memory\n");  	goto done;      }      res->path[0] = 0;        /*F      * a) All but the last segment of the base URI's path component isI      *    copied to the buffer.  In other words, any characters after the B      *    last (right-most) slash character, if any, are excluded.      */      cur = 0;     out = 0;     if (bas->path != NULL) { 	while (bas->path[cur] != 0) {= 	    while ((bas->path[cur] != 0) && (bas->path[cur] != '/'))  		cur++; 	    if (bas->path[cur] == 0)  		break;   	    cur++;  	    while (out < cur) {" 		res->path[out] = bas->path[out]; 		out++; 	    } 	}     }      res->path[out] = 0;        /*B      * b) The reference's path component is appended to the buffer      *    string.       */ 1     if (ref->path != NULL && ref->path[0] != 0) {  	index = 0;  	/* " 	 * Ensure the path includes a '/' 	 */) 	if ((out == 0) && (bas->server != NULL))  	    res->path[out++] = '/';  	while (ref->path[index] != 0) {+ 	    res->path[out++] = ref->path[index++];  	}     }      res->path[out] = 0;        /*9      * Steps c) to h) are really path normalization steps       */ #     xmlNormalizeURIPath(res->path);    step_7:        /*H      * 7) The resulting URI components, including any inherited from theG      *    base URI, are recombined to give the absolute form of the URI       *    reference.      */      val = xmlSaveUri(res);   done:      if (ref != NULL) 	xmlFreeURI(ref);      if (bas != NULL) 	xmlFreeURI(bas);      if (res != NULL) 	xmlFreeURI(res);      return(val); }     